@echo off
echo 
echo This sample requires a careful examination of the .DEF file (X86.def) to
echo understand what's going on. The .DEF file contains 5 different lex table
echo definitions. Together they comprise part of the definition for an
echo assembler.
echo 
echo The first four table definitions are for 1-line assembler command sets.
echo The syntax for these are:
echo 
echo .NAME name
echo 
echo which allows you to specify the name of the assembler file.
echo 
echo 
echo .PAGE length[,width]
echo 
echo which allows you to specify the length and width of the page for listings.
echo 
echo 
echo .SEG ["name"] [@address] [page] [para] [block] [stack] [resident] etc...
echo 
pause
echo usage is similar to the segment directives for the Microsoft assembler. The
echo point of doing the parameters as separate lex tables is that the 'main'
echo assembler table does not have to worry about recognizing the parameters as
echo tokens. Only when '.SEG' is recognized as the first token in a line, does
echo the assembler have to start tokenizing the line as a .SEG line. The program
echo switches to the .SEG lex table using LexChangeTable(), and proceeds to
echo process the line appropriately. At the end of the line, the program switches
echo back to the main lex table.
echo 
pause
echo 
echo Now we generate the .H files....
echo 
lexgen x86.def
echo 
pause
echo 
echo Note that five sets of .H files have been produced from the one .DEF file.
echo 
dir *.h

