/* MSGCNT.CMD - Program to count messages received 
    version 1.1, 12 June, 1995 by Elliott Goodman 

I run this from my LOG.CMD program, run nightly during
Lora's 'auto-maint' phase, the only time the logfile is free.
If you are going to use LOG.CMD to run it, place it as follows:

        say 'Door Tracker....'                   
        call Door_tracker                        
                                                 
        say "Running MSGCNT.CMD. Please wait...."
        call "d:\lora\lang\msgcnt.cmd"
                                                 
        say 'Remove routine....'                 
        call remove_stuff                        

Locate the two routines above and place it between them as
shown with correct drive/path info.

Feel free to modify as needed.
*/

/* trace ?a */

/* load if not already loaded */
if RxFuncQuery('SysLoadFuncs') then
do
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs
end

/* save directory info */
old_dir = directory()

/* modify as necessary */
call directory('D:\LORA\LANG')

/* initialize variables */
phrase1 = 'Tossing'
phrase2 = 'packet(s):'

in_name = 'lora.log'
out_name = 'MSGCOUNT.TXT'
toss_flag = 0
toss_pattern = '(Toss='
area_names = 0
temp_name = ' '
temp_count = 0
total_count = 0

/* remove previous Output file, if present */
call SysFileDelete(out_name)

drop messages.

/* Initialize Output file with date/time */
m_txt = 'Message Count v1.0 by Elliott Goodman'
call lineout out_name, m_txt
m_txt = '  '
call lineout out_name, m_txt
time_string = time('C')
date_string = date('N')
m_txt = 'Current time:' time_string || ',' date_string
call lineout out_name, m_txt
m_txt = 'Messages received yesterday'
call lineout out_name, m_txt
m_txt = '  '
call lineout out_name, m_txt

/* cycle thru LORA.LOG */
do until lines(in_name) = 0
    work_line = linein(in_name)

/* set further-work flag. This should avoid messing with
irrelevant lines and speed things up */

    if toss_flag = 0 then do
        j = wordpos(phrase1, work_line)
        if j \= 0 then
            toss_flag = 1
        end /* if toss_flag <> 1 */

    if toss_flag = 1 then do
        j = wordpos(phrase2, work_line)
        if j \= 0 then
            toss_flag = 0
        end /* if toss_flag = 1 */

/* found block of lines headed by 'Tossing */
    if toss_flag = 1 then do
/* break up line into elements */
        parse var work_line . . area_tag toss_count stuff
/* if line contains (Toss=xxxx) then work on it */
        if left(toss_count, 6) = '(Toss=' then do

/* remove trailing space, if present */
            toss_count = strip(toss_count)
/* remove leading '(Toss=' stuff */
            parse var toss_count (toss_pattern) toss_count
/* remove trailing ')' - should now be of form '000x' */
            toss_count = strip(toss_count, 'T', ')' )

/* search thru array for area tag and increment if found */
            found = 0
            do index = 1 to area_names
                if messages.index = area_tag then do
                    messages.index.count = messages.index.count + toss_count
                    found = 1
                    leave
                    end /* if */
                end /* do index = 1 to area_names */

/* area tag not found; add to array */
             if found = 0 then do
                 area_names = area_names + 1
                 messages.area_names = area_tag
                 messages.area_names.count = toss_count
                 end /* if found = 0 */
            end /* if left = (Toss */
        end /* if toss_flag = 1 */
    end /* do until lines() = 0 */

/* sort routine - not fast but it works */
swap = 1
do until swap = 0
    swap = 0
    do index = 1 to area_names -1
        t_index = index + 1
        if messages.t_index.count > messages.index.count then do
            temp_name = messages.index
            temp_count = messages.index.count
            messages.index = messages.t_index
            messages.index.count = messages.t_index.count
            messages.t_index = temp_name
            messages.t_index.count = temp_count
            swap = 1
            end /* if */
        end /* do */
    end /* do until */

do index = 1 to area_names                                    
/*   if messages.index.count > 999 then do                      
       temp = trunc(messages.index.count)                     
       thousands = temp % 1000                                
       temp = temp // 1000                                    
       select                                                 
         when temp = 0 then                                   
            temp = '000'                                      
         when temp < 10 then                                  
            temp = '00' || temp                               
         when temp < 100 then                                 
            temp = '0' || temp                                
         otherwise                                            
            nop                                               
         end                                                  
       messages.index.count.fmt = thousands || ',' || temp    
       end                                                    
   else                                                       
*/
       messages.index.count.fmt = trunc(messages.index.count) 
   end                                                        

/* Now output sorted results after formatting a little */             
do index = 1 to area_names                                            
   select
      when messages.index.count > 9999 then
         m_txt = space(messages.index,                                
            messages.index.count.fmt,(23-length(messages.index)),' ') 
      when messages.index.count > 999 then
         m_txt = space(messages.index,
            messages.index.count.fmt,(24-length(messages.index)),' ') 
      when messages.index.count > 99 then
         m_txt = space(messages.index,
            messages.index.count.fmt,(25-length(messages.index)),' ') 
      when messages.index.count > 9 then
         m_txt = space(messages.index,
            messages.index.count.fmt,(26-length(messages.index)),' ') 
      otherwise
         m_txt = space(messages.index,
            messages.index.count.fmt,(27-length(messages.index)),' ') 
      end
   call lineout out_name, m_txt                                       
   total_count = total_count + messages.index.count                   
   end                                                                

m_txt = '  '
call lineout out_name, m_txt

/* do some comma formatting with total_count */ 
temp = total_count                              
if temp > 999 then do                           
  thousands = temp % 1000                       
  temp = temp // 1000                           
  end                                           

if thousands \= 'THOUSANDS' then do                                                
   select                                                
     when temp = 0 then                                  
        temp = '000'                                     
     when temp < 10 then                                 
        temp = '00' || temp                              
     when temp < 100 then                                
        temp = '0' || temp                               
     otherwise                                           
        nop                                              
     end                                                 
   end

if thousands \= 'THOUSANDS' then                                                      
   total_count = thousands || ',' || temp 
else
   total_count = temp

m_txt = space('Total' total_count,19,' ')
call lineout out_name, m_txt

/* close files, return to starting directory, copy output to
bulletin file */
call lineout in_name
call lineout out_name
'@copy' out_name 'd:\lora\misc\BULLET6.BBS 1>NUL 2>&1' 
call directory(old_dir)
