/* MSGADJ.CMD -  version 1.0 October 29, 1996 */
/* Adjust MaxMsg in SysMsg.dat to reflect average weekly
    msg stats from Running.txt file.
This uses my MSGCNT.CMD and RUNNING.CMD programs' output
so you'll probably need them. But it'll show you how to
adjust SysMsg.Dat if that's all you're interested in.
Send netmail to Elliott Goodman 1:2004/102 if you have questions
or problems. */

/* load RexxUtil functions */                              
if RxFuncQuery('SysLoadFuncs') then                        
do                                                         
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs                                        
end                                                        


/* constants */
DataFile = "SYSMSG.DAT"   /* no drive/path since REN barfs with that */
SaveFile = "SYSMSGDT.BAK"
StatFile = "D:\LORA\LANG\RUNNING.TXT"
OutFile = "TEST.DAT"
ViewFile = "D:\LORA\LANG\1MSGADJ.TXT"
Target = "D:\LORA"
semname = "D:\MSGP.SEM" 
MaxMsgCount = 1575		/* for a max of 1600 */
MinMsgCount = 175		/* for a min of 200   */

'c:\sio\su 2 dcd'
if rc = 1 then do
   say "Carrier is detected - Someone online! Aborting..."
   call SysSleep 5
   exit
   end

if SemaphorePresent(semname) then do
   say "Messages being packed! Aborting...."
   call SysSleep 5
   exit
   end

if \SemaphorePresent(StatFile) then do
   say StatFile "not found!"
   exit
   end

call Directory(Target)
call SysFileDelete(SaveFile)	/* delete old save file */
call SysFileDelete(ViewFile)

/* open sysmsg.dat file, calculate number of records */
size = stream(DataFile, 'c', 'query size')
if size = '' then do
   say "File not found!"
   return 0
   end
records = size % 512
say "Number of records:" records

call lineout DataFile

/* retrieve all records from sysmsg.dat */
do count = 1 to records
  templine.count = charin(DataFile,, 512)
  end

call lineout DataFile

call SysSleep 3
/* save sysmsg.dat file to another name */
'@copy ' DataFile SaveFile

/* get echo number, echotag and max msg number for each echo */
/* convert max number to usable form */
do count = 1 to records
   workline = templine.count
   echonum1 = substr(workline, 71, 1)
   echonum2 = substr(workline, 72, 1)
   edata.count.echonum = (256 * x2d(c2x(echonum2))) + x2d(c2x(echonum1))
   echotag = substr(workline, 172, 32)
   echotag.count = strip(echotag, T, "0"x)
   max1 = substr(workline, 218, 1)
   max2 = substr(workline, 219, 1)
   edata.count.maxnum = (256 * x2d(c2x(max2))) + x2d(c2x(max1))
   end

/* read in data from Running.txt file */
index = 1
do while lines(StatFile) > 0
   workline = linein(StatFile)
   parse upper var workline StatTag Daily stuff
   if StatTag = "RUNNING" then iterate
   if StatTag = "CURRENT" then iterate
   if StatTag = "DAYS" then iterate
   if StatTag = "TOTAL" then iterate
   StatTag.index = StatTag
   Snum.index = Daily   
   index = index + 1
   end
call lineout StatFile
StatCount = index -1

say "StatCount:" StatCount
say ' '

/* calculate max msg number from Running.txt,
find corresponding number from Sysmsg.dat file
and adjust number to lie within max and min
while setting optimum number */
do count = 3 to records
   if edata.count.echonum = 19 then iterate
   flag = 0
   do index = 1 to StatCount
      if echotag.count \= StatTag.index then iterate
      flag = 1
      tfix = trunc(Snum.index * 7)
      tfix = min(MaxMsgCount, tfix, edata.count.maxnum)
      tfix = max(tfix, MinMsgCount)
      tfix = ((tfix % 25) * 25) + 25
      if left(echotag.count,3) = "OS2" then
         tfix = max(tfix, 400)
      m_txt = echotag.count tfix
      m_txt = space(m_txt, (30 - length(m_txt)), ' ')
      m_txt = translate(m_txt, '.', ' ')
      call lineout ViewFile, m_txt

/* convert to absolute numbers and put in reverse order
to match format of Sysmsg.dat file */
      test = d2x(tfix)
      len = length(test)
      if len > 2 then do
         last = x2c(right(test, 2))
         first = x2c(left(test, (len -2)))
         end
      else do
         first = "0"x
         last = x2c(test)
         end
      tover = last || first
/* write new number to memory object of Sysmsg.dat */
      templine.count = overlay(tover, templine.count, 218)
      leave
      end
   if flag = 0 then iterate
   end

call lineout ViewFile

/* actually write new Sysmsg.dat file */
do count = 1 to records
   dummy = charout(OutFile, templine.count)
   end

call charout(OutFile)
call SysFileDelete(DataFile)
call SysSleep 3
'@ren' OutFile DataFile
exit

/* test for presence of semaphore file */            
SemaphorePresent: Procedure                          
  return stream(arg(1), 'c', 'query exists') <> ''   
