(*$include:'SETDIR.INT'*)

Implementation of SETDIR;

(**********************************************************************)
(*                                                                    *)
(*    Implementation of Netware Directory Function Calls              *)
(*                                                                    *)
(**********************************************************************)

  Function net_directory_request:Integer [c,varying] ; external;

(**********************************************************************)
(*                                                                    *)
(*  Directory Function 19 : Allocate a Temporary Base                 *)
(*                                                                    *)
(**********************************************************************)

  Function  net_alloc_temp_base(* Drivename : char;
                                   Sourcebase : Integer;
                                   Const Path : Lstring;
                                   Var Newbase: Integer;
                                   Var mask   : Integer  *);
    Type
      req_type   = Record
                     size   [00] : Word;
                     func   [02] : Byte;
                     base   [03] : Byte;
                     drive  [04] : char;
                     path   [05] : Lstring(255);
                   End;
      reply_type = Record
                     size    [00] : Word;
                     base    [02] : Byte;
                     mask    [03] : Byte;
                   End;
    Var
      req   : req_type;
      reply : reply_type;
    Begin
      req.size:=sizeof(req)-2;
      reply.size:=sizeof(reply)-2;
      req.func:=19;
      req.base:=wrd(sourcebase);
      copylst(path,req.path);
      req.drive:=drivename;
      net_alloc_temp_base:=net_directory_request(ads reply,ads req);
      newbase:=ord(reply.base);
      mask:=ord(reply.mask);
    End; (* net_alloc_temp_base *)

END.  (* End of implementation of SETDIR *)
