unit misco4;
{$O+,V-,I+}

{$I DEFINES.INC}

interface
uses dos, crt, lgpllink,

{$IFDEF GTVID}
  gtvideo,
{$ENDIF}

{$IFDEF GTSTUB}
  gttocrt,
{$ENDIF}

  tiletran,

  ddlod, gtscott, globals, misc, emsalloc, strio, setgen;

procedure ReadObjs;
procedure WriteObjs;
procedure OpenFiles;
procedure WriteBases;
procedure WriteMdata;
procedure WriteTeams;

implementation

procedure bwrite(s: string);
begin;
 swrite(#13+'  ');
 while length(s)<70 do s:=s+' ';
 swrite(s);
end;

procedure Error(s: string);
begin;
 gtextcolor(15);
 gwriteln('');
 gwriteln(s);
 delay(5000);
 halt;
end;

procedure ReadObjs;
const
 numtoread=50;
type
 devarray=array[1..numtoread] of devicetype;
 daptr=^devarray;
var
 o: daptr;
 a: integer;
 objfile: file;
 numread: word;
begin;
 assign(objfile,'OBJECTS.DAT');
 reset(objfile,1);
 if filesize(objfile) mod sizeof(devicetype) <> 0 then
  error('Error - OBJECTS.DAT is corrupted!');

 close(objfile);
 reset(objfile,sizeof(devicetype));

 new(o);
 blockread(objfile,o^,1);
 numolist:=0;
 numread:=numtoread;
 while (numread=numtoread) do begin;
  blockread(objfile,o^,numtoread,numread);
  for a:=1 to numread do if (o^[a].num<>0) and (numolist<numobj) then begin;
   inc(numolist);
   objects^[numolist]:=o^[a];
  end;
 end;
 close(objfile);
 dispose(o);
end;

procedure WriteObjs;
var
 o: devicetype;
 a,b: integer;
 objfile: file of devicetype;
begin;
 assign(objfile,'OBJECTS.DAT');
 rewrite(objfile);
 fillchar(o,sizeof(o),0);
 b:=0;
 write(objfile,o);
 for a:=1 to numolist do if objactive(a) then begin;
  inc(b);
  write(objfile,objects^[a]);
 end;
 close(objfile);
end;

procedure blankbases;
var
 a: integer;
begin;
 fillchar(bases^,sizeof(bases^),0);
 for a:=1 to numbase do bases^[a].active:=false;
end;

procedure LoadStringDef;
var
 a: integer;
 b: longint;
 m: longint;
 ch1,ch2: char;
 s: string;
 stroffset: longint;
 bread: integer;
begin;
 bwrite('Loading String Definitions');
 seek(gamebin,0);
 blockread(gamebin,s,8);
 s[0]:=#7;
 val(s,stroffset,a);
 seek(gamebin,stroffset);
 blockread(gamebin,ch1,1);
 blockread(gamebin,ch2,1);

 blockread(gamebin,strdef_numindex,2);

 strdef_idxsize:=(strdef_numindex+1)*sizeof(idrec);
 strdef_idxstart:=filepos(gamebin);
 strdef_strstart:=strdef_idxsize+strdef_idxstart;

 m:=memavail;
 openstringcache;
 m:=m-memavail;
 strdefbytes:=m;
 numstrdef:=strdef_numindex;
end;

procedure AddTeleCode(act: telecodeaction; group: word; z1,x1,y1: word);
var
 a,b,c: integer;
 c1,c2,c3: integer;
 bad: boolean;
 count: word;
 p: array[1..maxpylonpress] of char;
 rollover: boolean;
begin;
 if numtcode>=maxtcode then exit;

 fillchar(p,sizeof(p),0);

 with maptable^.pylons[group] do
  if numpresses>0 then begin;

   if numpresses>=1 then
    p[1]:=buttonchars[(x1 mod numbuttons)+1];

   if numpresses>=2 then
    p[2]:=buttonchars[(y1 mod numbuttons)+1];

   if numpresses>=3 then
    p[3]:=buttonchars[((x1+y1) mod numbuttons)+1];

   if numpresses>=4 then
    p[4]:=buttonchars[((x1*2+y1) mod numbuttons)+1];

   if numpresses>=5 then
    p[5]:=buttonchars[((x1+y1*2) mod numbuttons)+1];

   count:=1;
   repeat;
    inc(count);
    bad:=false;
    for a:=1 to numtcode do
     if (not bad) and (telecodes[a].tag=tag) then begin;
      bad:=true;
      for b:=1 to maxpylonpress do
       if telecodes[a].press[b]<>p[b] then
        bad:=false;
     end;
    if bad then begin;
     rollover:=true;
     for a:=1 to numpresses do if rollover then begin;
      rollover:=false;
      c:=0;
      for b:=1 to numbuttons do
       if buttonchars[b]=p[a] then c:=b;
      inc(c);
      if c>numbuttons then begin;
       rollover:=true;
       c:=1;
      end;
      p[a]:=buttonchars[c];
     end;
     if rollover then p[1]:=buttonchars[1];
    end;
   until (not bad) or (count=250);
 end else
  bad:=false;

 if not bad then begin;
  inc(numtcode);
  with telecodes[numtcode] do begin;
   for a:=1 to maxpylonpress do press[a]:=p[a];
   x:=x1;
   y:=y1;
   z:=z1;
   action:=act;
   tag:=maptable^.pylons[group].tag;
  end;
 end;
end;

procedure maketelecodes;
var
 z,x,y: word;
begin;
 numtcode:=0;
 fillchar(telecodes,sizeof(telecodes),0);
 for z:=1 to maxmaps do
  if maptable^.maps[z].valid then
   for x:=1 to querymaxmapx(z) do
    for y:=1 to querymaxmapy(z) do
     with terrain[getmap(z,x,y)] do
      if ent=ePylon then
       AddTeleCode(tele_tport,evr,z,x,y);

 AddTeleCode(tele_tadsu,1,1,2,3);
 AddTeleCode(tele_xeboc,1,4,5,6);
end;

procedure SqrIt(var n: word);
begin;
 n:=n*n;
end;

procedure loaddevdef;
var
 devs: devdeftype;
 a,b: word;
 numread: word;
 devofs,devsize: longint;
 s: string;
 junk: integer;
begin;
 seek(gamebin,22);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,devofs,junk);
 seek(gamebin,43);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,devsize,junk);
 if (devsize mod sizeof(devdeftype))<>0 then error('Error - Fubar in dev def');
 devgood:=0;
 devfill:=0;
 devnil:=0;
 b:=0;
 seek(gamebin,devofs);
 for a:=1 to devsize div sizeof(devdeftype) do begin;
  blockread(gamebin,devs,sizeof(devdeftype));
  if (b<=numdev) then begin;
   if (b<>0) and (stu(devs.name)='NIL') and (devs.store=[]) and (ord(devs.devapp)=0) then begin;
    inc(devnil);
    devicedef[b]:=devicedef[0];
   end else begin;
    getmem(devicedef[b],sizeof(devdeftype));
    devicedef[b]^:=devs;
    devicedef[b]^.num:=b;
    inc(devgood);
   end;
   inc(b);
  end;
 end;

 if b<numdev then for a:=b to numdev do begin;
  devicedef[a]:=devicedef[0];
  inc(devfill);
 end;

 numkeymap:=0;
 for a:=1 to numdev do if (devicedef[a]^.devapp=pylonkey) and (numkeymap<maxkeymap) then begin;
  inc(numkeymap);
  keymap[numkeymap]:=a;
 end;
end;

procedure loaddevdefs;
begin;
 bwrite('Loading device definitions');
 devgood:=0;
 devfill:=0;
 devnil:=0;
 loaddevdef;
end;

procedure LoadGameDef;
var
 gddone: boolean;
 linepos: word;
 donemisc: boolean;
 donenpcfort: boolean;
 donegenobj: boolean;
 s: string;
 ofm: word;

procedure loadmisc;
var
 s,s2,s3,s4: string;
 done: boolean;
 a,n: integer;
begin;
 bwrite('Loading data set information');
 fillchar(dataset,sizeof(dataset),0);
 done:=false;
 n:=0;
 while (not done) do begin;
  inc(linepos);
  gamedef_readln(s);
  if s='&&&END' then begin;
   done:=true;
  end else begin;
   inc(n);
   with dataset do
    case n of
     2: dataset.name:=newstr(s);
     3: dataset.author:=newstr(s);
     4: val(s,dataset.sdtext.first,a);
     5: val(s,dataset.sdtext.last,a);
     6: dataset.prodname[1]:=newstr(s);
     7: dataset.prodname[2]:=newstr(s);
     8: dataset.prodname[3]:=newstr(s);
     9: egafortbad:=s;
     10: egatavern:=s;
     11: egabartalk:=s;
     12: egatadsu:=s;
     13: egatele1:=s;
     14: egatele2:=s;
     15: egafortatck:=s;
     16: egafortmm1:=s;
     17: egafortret:=s;
     18: egasurr:=s;
     19: dataset.hisstr:=newstr(s);
     20: dataset.herstr:=newstr(s);
     21: dataset.itsstr:=newstr(s);
     22: dataset.hestr:=newstr(s);
     23: dataset.shestr:=newstr(s);
     24: dataset.itstr:=newstr(s);
     25: dataset.mhimstr:=newstr(s);
     26: dataset.fhimstr:=newstr(s);
     27: dataset.ihimstr:=newstr(s);
     28: val(s,dataset.obtext.first,a);
     29: val(s,dataset.obtext.last,a);
     30: val(s,dataset.kelpreward,a);
     31: val(s,dataset.emwarpmine,a);
     32: dataset.charpic[male]:=s;
     33: dataset.charpic[female]:=s;
     34: dataset.charpic[other]:=s;
     35: val(s,dataset.moneybag,a);
    end;
  end;
 end;
 donemisc:=true;
end;

procedure pullints(s: string; var i1,i2,i3,i4: longint);
var
 junk: integer;
 s1: string;
begin;
 while (s<>'') and (s[1]=' ') do delete(s,1,1);
 while s[length(s)]=' ' do dec(s[0]);
 s:=s+'/';
 s1:=copy(s,1,pos('/',s)-1);
 delete(s,1,pos('/',s));
 val(s1,i1,junk);
 if pos('/',s)<>0 then begin;
  s1:=copy(s,1,pos('/',s)-1);
  delete(s,1,pos('/',s));
  val(s1,i2,junk);
 end;
 if pos('/',s)<>0 then begin;
  s1:=copy(s,1,pos('/',s)-1);
  delete(s,1,pos('/',s));
  val(s1,i3,junk);
 end;
 if pos('/',s)<>0 then begin;
  s1:=copy(s,1,pos('/',s)-1);
  delete(s,1,pos('/',s));
  val(s1,i4,junk);
 end;
end;

procedure loadgenobj;
var
 t1,t2,t3,t4,tstart,tend,cnvin,cnvout: longint;
 temp: genobjptr;
 done: boolean;
 current: word;
 junk: integer;
 iflist: ifptr;

function addentry(tag: word; ogtype: ogtypetype; tstart,tend: word): genobjptr;
begin;
 if numgenobj<maxgenobj then begin;
  inc(numgenobj);
  new(genobj[numgenobj]);
  genobj[numgenobj]^.tag:=tag;
  genobj[numgenobj]^.ogtype:=ogtype;
  genobj[numgenobj]^.tstart:=tstart;
  genobj[numgenobj]^.tend:=tend;
  genobj[numgenobj]^.iflist:=iflist;
  addentry:=genobj[numgenobj];
 end else begin;
  addentry:=nil;
 end;
 iflist:=nil;
end;

procedure addif(iftype: iftypetype; data: longint);
var
 current,temp: ifptr;
begin;
 if iflist=nil then begin;
  new(iflist);
  temp:=iflist;
 end else begin;
  current:=iflist;
  while (current^.next<>nil) do begin;
   current:=current^.next;
  end;
  new(temp);
  current^.next:=temp;
 end;
 temp^.next:=nil;
 temp^.iftype:=iftype;
 temp^.data:=data;
end;

begin;
 current:=0;
 numgenobj:=0;
 done:=false;
 iflist:=nil;
 while (not done) do begin;
  gamedef_readln(s);
  inc(linepos);
  if pos('TAG ',s)<>0 then begin;
   delete(s,1,4);
   val(s,current,junk);
  end else if pos('HEADER ',s)<>0 then begin;
   delete(s,1,7);
   pullints(s,tstart,tend,t1,t2);
   addentry(current,ogHeader,tstart,tend);
  end else if pos('FOOTER ',s)<>0 then begin;
   delete(s,1,7);
   pullints(s,tstart,tend,t1,t2);
   addentry(current,ogFooter,tstart,tend);
  end else if pos('RANDOM ',s)<>0 then begin;
   delete(s,1,7);
   pullints(s,tstart,tend,t1,t2);
   addentry(current,ogRandText,tstart,tend);
  end else if pos('CONVERT ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,cnvin,cnvout,tstart,tend);
   temp:=addentry(current,ogConvert,tstart,tend);
   temp^.cnvin:=cnvin;
   temp^.cnvout:=cnvout;
  end else if pos('ADDITEM ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,cnvin,cnvout,tstart,tend);
   temp:=addentry(current,ogAddItem,tstart,tend);
   temp^.cnvin:=cnvin;
   temp^.cnvout:=cnvout;
  end else if pos('REPLICATE ',s)<>0 then begin;
   delete(s,1,10);
   pullints(s,tstart,tend,t1,t2);
   temp:=addentry(current,ogreplicate,tstart,tend);
  end else if pos('FAIL ',s)<>0 then begin;
   delete(s,1,5);
   pullints(s,tstart,tend,t1,t2);
   temp:=addentry(current,ogfail,tstart,tend);
  end else if pos('IFTERRAIN ',s)<>0 then begin;
   delete(s,1,10);
   pullints(s,t1,t2,t3,t4);
   addif(ifTerrain,t1);
  end else if pos('IFNTERRAIN ',s)<>0 then begin;
   delete(S,1,11);
   pullints(s,t1,t2,t3,t4);
   addif(ifNTerrain,t1);
  end else if pos('IFQUEST ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(ifQuest,t1);
  end else if pos('IFNQUEST ',s)<>0 then begin;
   delete(s,1,9);
   pullints(s,t1,t2,t3,t4);
   addif(ifNQuest,t1);
  end else if pos('IFPURITRON ',s)<>0 then begin;
   delete(s,1,11);
   pullints(s,t1,t2,t3,t4);
   addif(ifPuritron,t1);
  end else if pos('IFNPURITRON ',s)<>0 then begin;
   delete(s,1,12);
   pullints(s,t1,t2,t3,t4);
   addif(ifNPuritron,t1);
  end else if pos('IFLEVEL ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(ifLevel,t1);
  end else if pos('IFNLEVEL ',s)<>0 then begin;
   delete(s,1,9);
   pullints(s,t1,t2,t3,t4);
   addif(ifNLevel,t1);
  end else if pos('IFEXPER ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(ifExper,t1);
  end else if pos('IFNEXPER ',s)<>0 then begin;
   delete(s,1,9);
   pullints(s,t1,t2,t3,t4);
   addif(ifNExper,t1);
  end else if pos('IFMINDIST ',s)<>0 then begin;
   delete(s,1,10);
   pullints(s,t1,t2,t3,t4);
   addif(ifMindist,t1);
  end else if pos('IFMAXDIST ',s)<>0 then begin;
   delete(s,1,10);
   pullints(s,t1,t2,t3,t4);
   addif(ifMaxdist,t1);
  end else if pos('IFTESTX ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(iftestx,t1);
  end else if pos('IFTESTY ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(iftesty,t1);
  end else if pos('IFTESTZ ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(iftestz,t1);
  end else if pos('IFNTESTX ',s)<>0 then begin;
   delete(s,1,9);
   pullints(s,t1,t2,t3,t4);
   addif(ifntestx,t1);
  end else if pos('IFNTESTY ',s)<>0 then begin;
   delete(s,1,9);
   pullints(s,t1,t2,t3,t4);
   addif(ifntesty,t1);
  end else if pos('IFNTESTZ ',s)<>0 then begin;
   delete(s,1,9);
   pullints(s,t1,t2,t3,t4);
   addif(ifntestz,t1);
  end else if pos('DOSPECIAL ',s)<>0 then begin;
   delete(s,1,10);
   s:=stu(trimstr(s));
   if s='LOKI' then begin;
    addif(ifDoLoki,0);
   end else if s='SERPINE' then begin;
    addif(ifDoSerpine,0);
   end;
  end else if pos('DOQUEST ',s)<>0 then begin;
   delete(s,1,8);
   pullints(s,t1,t2,t3,t4);
   addif(ifDoQuest,t1);
  end else if s='&&&END' then begin;
   donegenobj:=true;
   done:=true;
  end;
 end;
end;

procedure loadnpcfort;
var
 s: string;
begin;
 donenpcfort:=true;
 npcfortstart:=linepos;
 gamedef_readln(s);
 inc(linepos);
end;

begin;
 donemisc:=false;
 donenpcfort:=false;
 donegenobj:=false;
 linepos:=0;
 gddone:=false;
 while (not gddone) do begin;
  inc(linepos);
  gamedef_readln(s);
  s:=trimstr(s);
  if (s<>'') and (s[1]<>';') then begin;
   if s='&&&NPCFORT' then loadnpcfort;
   if s='&&&MISC' then loadmisc;
   if s='&&&GENOBJ' then loadgenobj;
   if s='&&&DONE' then gddone:=true;
  end;
 end;
 if not donenpcfort then  error('Err: could not load npcfort from GAME.DEF.');
 if not donemisc then     error('Err: could not load dataset from GAME.DEF.');
end;

procedure baddataset(later: boolean);
begin;
 sclrscr;
 swrite('Error! The Dataset file (GAME.DEF) was compiled for ');
 if later then swriteln('a later version') else swriteln('an earlier version');
 swriteln('of LOD. Please contact the author of that dataset for a new version or');
 swriteln('revert to original GAME.DEF file that is contained in LODxxxB.ZIP.');
 delay(8000);
 halt;
end;

procedure opengamedef;
var
 ofm: word;
 buf: array[1..1024] of byte;
 bread: word;
 f2: file;
 s: string[8];
 a,b: integer;
begin;
 bwrite('Reading Master Game Definition');
 assign(gamebin,'GAME.DEF');
 reset(gamebin,1);

 seek(gamebin,50);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,a,b);
 if a>compilerev then begin;
  baddataset(true);
 end else if a<compilerev then begin;
  if exist('STR'+wva(a)+'TO'+wva(compilerev)+'.PAT') then
   LoadStringPatch('STR'+wva(a)+'TO'+wva(compilerev)+'.PAT')
  else
   baddataset(False);
 end;

 gamedef_reset;
end;

{procedure fixmonsters;
var
 cz,cx,cy: byte;
 a: integer;
begin;
 findcity(1,cz,cx,cy);
 for a:=1 to nummondef do if MonsterRec(EAAddr(mondef[a])^).origz=255 then begin;
  MonsterRec(EAAddr(mondef[a])^).origz:=cz;
  MonsterRec(EAAddr(mondef[a])^).origx:=cx;
  MonsterRec(EAAddr(mondef[a])^).origy:=cy;
 end;
end;}

procedure loadcstr;
begin;
 bwrite('Loading combat string tables');
 getmem(groups,maptable^.combatgroup_count*sizeof(tcombatgroup));
 seek(gamebin,maptable^.combatgroup_start);
 blockread(gamebin,groups^,maptable^.combatgroup_count*sizeof(tcombatgroup));
end;

procedure loadmonster;
begin;
 bwrite('Loading monster index');
 nummondef:=maptable^.monindex_count;
 getmem(mondef,nummondef*sizeof(tmonindex));
 seek(gamebin,maptable^.monindex_start);
 blockread(gamebin,mondef^,nummondef*sizeof(tmonindex));
end;

procedure loadtalkindex;
begin;
 bwrite('Loading talk index');
 getmem(talkindex,maptable^.talkindex_count*sizeof(ttalkindexentry));
 seek(gamebin,maptable^.talkindex_start);
 blockread(gamebin,talkindex^,maptable^.talkindex_count*sizeof(ttalkindexentry));
end;

procedure loadmap(n: word);
var
 a: integer;
 s: string[10];
 mapofs: longint;
begin;
 seek(gamebin,8);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);
 seek(gamebin,mapofs);
 blockread(gamebin,maptable^,sizeof(maptable^));
end;

procedure loadterrain;
var
 a: integer;
 s: string[10];
 mapofs: longint;
begin;
 bwrite('Loading terrain definitions');
 seek(gamebin,15);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);
 seek(gamebin,mapofs);
 blockread(gamebin,terrain,sizeof(terrain));
 transetup;
end;

procedure loadquests;
var
 a: integer;
 s: string[10];
 mapofs: longint;
begin;
 bwrite('Loading quest definitions');
 seek(gamebin,57);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);
 seek(gamebin,mapofs);
 blockread(gamebin,quests,sizeof(quests));
end;

procedure loadlgpl;
var
 a: integer;
 s: string[10];
 lgplofs: longint;
begin;
 bwrite('Loading LGPL code');
 seek(gamebin,64);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,lgplofs,a);
 lgpl_load(gamebin,lgplofs);
end;

procedure loadgeneral;
var
 a: integer;
 s: string[10];
 fsize, mapofs: longint;
 bread: word;
begin;
 bwrite('Loading general data');

 seek(gamebin,29);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);

 seek(gamebin,36);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,fsize,a);
 if fsize>sizeof(general) then fsize:=sizeof(general);

 seek(gamebin,mapofs);
 blockread(gamebin,general,fsize,bread);
end;

procedure genpremap;
var
 a,c,d: word;
begin;
 for c:=1 to numterrain do begin;
  d:=c;
  for a:=1 to maxpmask do if (general.porig[a]=d) and (general.pnew[a]<>0) then d:=general.pnew[a];
  purmask[c]:=d;
 end;
end;

procedure OpenFiles;
var
 a,b: integer;
 u: usertype;
 o: devicetype;
 f: file;
 t: text;
 basfile: file of basearray;
 genfile: file of generaltype;
 objfile: file of devicetype;
 dayfile: file;
 teafile: file;
 pfile: file;
 s: string[80];
 cz,cx,cy: byte;
 uidx: file of useridxarray;
 clone: clonetype;
 cfile: file;
begin;
 if ((exist('USERS.DAT')) or (exist('OBJECTS.DAT')) or (exist('BASES.DAT')))
  and not exist('LVER500.DAT') then begin;
   swriteln('Datafiles on disk are not up to date!');
   swriteln('');
   swriteln('There is currently no upgrade procedure to upgrade pre-5.00 games to');
   swriteln('5.00 specifications. You MUST reset the game. You can do this by running');
   swriteln('RESET.EXE');
   swriteln('');
   swrite('Press any key to continue.');
   if sreadkey=' ' then ;
   halt;
 end;

 setgeneral;
 opengamedef;
 loadgeneral;
 loadterrain; {must be before gamedef because of terrain restrictions}
 loadgamedef;
 loadmap(1);
 loaddevdefs;
 loadquests;
 loadmonster;
 loadtalkindex;
 loadcstr;
 loadlgpl;

 if exist('LVER400.DAT') then delete_file('LVER400.DAT');
 assign(t,'LVER500.DAT');
 rewrite(t);
 writeln(t,'Version identification file. Do not delete');
 close(t);

 assign(userfile,'USERS.DAT');
 {$I-}
 reset(userfile);
 {$I+}
 if ioresult<>0 then begin;
  rewrite(userfile);
  fillchar(u,sizeof(u),0);
  u.realname:='Nil User';
  u.alias:='Nil User';
  for a:=0 to 255 do write(userfile,u);
  close(userfile);
  reset(userfile);
 end;

 bwrite('Reading Objects');
 if not exist('OBJECTS.DAT') then begin;
  assign(objfile,'OBJECTS.DAT');
  rewrite(objfile);
  fillchar(o,sizeof(o),0);
  write(objfile,o);
  close(objfile);
 end;
 readobjs;

 bwrite('Reading Fortresses');
 assign(basfile,'BASES.DAT');
 {$I-}
 reset(basfile);
 {$I+}
 if ioresult<>0 then begin;
  BlankBases;
  rewrite(basfile);
  write(basfile,bases^);
  close(basfile);
 end else begin;
  close(basfile);
  assign(f,'BASES.DAT');
  reset(f,1);
  if filesize(f)<>45000 then
   error('Error - BASES.DAT has been corrupted!');
  close(f);
  reset(basfile);
  read(basfile,bases^);
  close(basfile);
 end;

 assign(uidx,'USERIDX.DAT');
 {$I-}
 reset(uidx);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(useridx,sizeof(useridx),0);
  rewrite(uidx);
  write(uidx,useridx);
  close(uidx);
 end else begin;
  read(uidx,useridx);
  close(uidx);
 end;

 bwrite('Opening Clone File');
 assign(clonefile,'CLONES.DAT');
 {$I-}
 reset(clonefile);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(clone,sizeof(clone),0);
  clone.alive:=false;
  rewrite(clonefile);
  for a:=0 to 255 do write(clonefile,clone);
  close(clonefile);
  reset(clonefile);
 end;

 bwrite('Opening MData File');
 assign(cfile,'MDATA.DAT');
 {$I-}
 reset(cfile,1);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(mdata^,sizeof(mdatatype),0);
  rewrite(cfile,1);
  blockwrite(cfile,mdata^,sizeof(mdatatype));
  close(cfile);
 end else begin;
  if filesize(cfile)<>sizeof(mdatatype) then
   error('Error - MDATA.dat has been corrupted.');
  blockread(cfile,mdata^,sizeof(mdatatype));
  close(cfile);
 end;

 bwrite('Opening Team File');
 fillchar(EAAddr(teams)^,sizeof(teamarray),0);
 assign(teafile,'TEAMS.DAT');
 {$i-}
 reset(teafile,1);
 {$I+}
 if ioresult=0 then begin;
  if filesize(teafile)<>sizeof(teamarray) then
   error('Error - Teams.Dat has been corrupted.');
  EABlockRead(teafile,teams,sizeof(teamarray));
  close(teafile);
 end;

 maketelecodes;
 loadstringdef;
 genpremap;
 setpuractive;

 bwrite('Startup completed');
 snewline;
end;

procedure WriteTeams;
var
 teamfile: file;
begin;
 assign(teamfile,'TEAMS.DAT');
 rewrite(teamfile,1);
 EAblockwrite(teamfile,teams,sizeof(teamarray));
 close(teamfile);
end;

procedure WriteMdata;
var
 cfile: file;
begin;
 assign(cfile,'MDATA.DAT');
 rewrite(cfile,1);
 Blockwrite(cfile,mdata^,sizeof(mdatatype));
 close(cfile);
end;

procedure WriteBases;
var
 basfile: file;
begin;
 assign(basfile,'BASES.DAT');
 reset(basfile,1);
 blockwrite(basfile,bases^,sizeof(bases^));
 close(basfile);
end;

end.