unit messgio;

interface

const
 max_msg_lines=100;
 msys_open: boolean =false;
type
 message_rec=record
              From: string[35];
              m_to: string[35];
              subject: string[72];
              datetime: string[19];
              timesread: word;
              replyto: word;
              attribute: word;
              nextreply: word;
              lines: integer;
              text: array[1..max_msg_lines] of string[78];
             end;

 message_ptr = ^message_rec;

 index_rec=record
              From: string[35];
              m_to: string[35];
              subject: string[72];
              datetime: string[19];
              timesread: word;
              replyto: word;
              attribute: word;
              nextreply: word;
              lines: integer;
              addr: longint;
              len: word;
             end;

procedure open_msys;
procedure close_msys;
procedure Get_Message(msgnum: word; var mr: message_rec);
procedure Add_Message(var msgnum: word; var mr: message_rec);
procedure Get_Message_Header(msgnum: word; var mr: message_rec);
function find_highest_message: word;
procedure killmessage(mnum: word);

implementation

type
 mbuff=array[1..8192] of char;
 mbuffptr=^mbuff;
var
 idxfile: file of index_Rec;
 bdyfile: file;

procedure open_msys;
var
 tidx: index_rec;
begin;
 assign(idxfile,'MSGIDX.DAT');
 {$I-}
 reset(idxfile);
 {$I+}
 if ioresult<>0 then begin;
  rewrite(idxfile);
  reset(idxfile);
 end;
 assign(bdyfile,'MSGBDY.DAT');
 {$i-}
 reset(bdyfile,1);
 {$I+}
 if ioresult<>0 then begin;
  rewrite(bdyfile);
  reset(bdyfile,1);
 end;
 msys_open:=true;
end;

procedure close_msys;
begin;
 if msys_open<>true then exit;
 msys_open:=false;
 close(idxfile);
 close(bdyfile);
end;

procedure Get_Message(msgnum: word; var mr: message_rec);
const
 bufsize=512;
var
 idx: index_rec absolute mr;
 idxlen: word;
 a: word;
 junk: integer;

 buffer: array[1..bufsize] of char;
 bufpos: word;

begin;
 bufpos:=bufsize+1;
 seek(idxfile,msgnum-1);
 read(idxfile,idx);
 idxlen:=idx.len;
 mr.lines:=0;
 if idxlen>0 then begin;
  {$I-}
  seek(bdyfile,idx.addr);
  {$I+}
  if ioresult=0 then begin;
   a:=1;
   mr.lines:=1;
   mr.text[1]:='';
   while (a<=idxlen) and (mr.lines<max_msg_lines) do begin;
    inc(a);
    inc(bufpos);
    if (bufpos>bufsize) then begin;
     blockread(bdyfile,buffer,sizeof(buffer),junk);
     bufpos:=1;
    end;
    case buffer[bufpos] of
     #13: begin;
           inc(mr.lines);
           mr.text[mr.lines]:='';
          end;
     else mr.text[mr.lines]:=mr.text[mr.lines]+buffer[bufpos];
    end;
   end;
  end;
 end;
end;

procedure Add_Message(var msgnum: word; var mr: message_rec);
var
 idx: index_rec absolute mr;
 idxlen,idxaddr: longint;
 a,b: word;
 s: string;
begin;
 msgnum:=filesize(idxfile);
 idxaddr:=filesize(bdyfile);
 idxlen:=0;
 seek(bdyfile,idxaddr);

 for a:=1 to mr.lines do begin;
  s:=mr.text[a]+#13;
  blockwrite(bdyfile,s[1],length(s));
  idxlen:=idxlen+length(s);
 end;

 idx.addr:=idxaddr;
 idx.len:=idxlen;
 seek(idxfile,msgnum);
 write(idxfile,idx);

 inc(msgnum);
end;

procedure Get_Message_Header(msgnum: word; var mr: message_rec);
var
 idx: index_rec absolute mr;
begin;
 seek(idxfile,msgnum-1);
 read(idxfile,idx);
end;

function find_highest_message: word;
begin;
 find_highest_message:=filesize(idxfile);
end;

procedure killmessage(mnum: word);
var
 idx: index_rec;
begin;
 seek(idxfile,mnum-1);
 read(idxfile,idx);
 idx.m_to:='DELETED';
 idx.from:='DELETED';
 idx.addr:=0;
 idx.len:=0;
 seek(idxfile,mnum-1);
 write(idxfile,idx);
end;

end.