procedure DoVortexAdd(var o: devicetype);
var
 s: string;
 a,b: integer;
 done: boolean;
begin;
 done:=false;
 repeat;
  writeln;
  write("&BInsert which ammo cartridge into the cell (&F?&B=List) ? ");
  s:=upstr(readln());
  a:=atoi(s);
  if (s="?") or (s="L") then
    ListUserInv(user,false);
  elsif (a>0) & (a<=numudev) then
   dec(a);   (* because inventory is a zero-based array *)
   if user^.devices[a].num=0 then
    writeln("&CInsert what???");
   elsif user^.devices[a].devapp<>devapp_ammo then
    writeln("&CYou may only insert an ammo cartridge!");
   elsif (user^.devices[a].var1>vbatt_numammo()) then
    writeln("&CThe cell will not accept that energy type!");
   elsif (vbatt_ammoeff(user^.devices[a].var1)=0) then
    writeln("&CThe cell will not accept that energy type!");
   else
    writeln("&CEnergy transferred to cell.");
    o.var2:=o.var2+user^.devices[a].var2*vbatt_ammoeff(user^.devices[a].var1);
    nukedevice(user^.devices[a]);
    if o.var2>9999 then
     o.var2:=9999;
     writeln("&CMaximum cell capacity reached.");
    endif;
   endif;
  endif;
  if (s="") or (s="Q") then
    done:=true;
  endif;
 until done;
end dovortexadd;

procedure DoVortexDischarge(var o: devicetype);
var
 result: boolean;
begin;
 result:=checkyesno("&CWARNING! Discharge will empty cell! Continue (&FY&C/&FN&C) ? ");
 if result then
  writeln("&BCell discharged.");
  o.var2:=0;
 endif;
end dovortexdischarge;

procedure DoVortexView(var o: devicetype);
var
 a: integer;
begin;
 writeln;
 writeln("&BEnergy Cell Status:");
 writeln("&7    Vortex Energy units...............: &F",o.var2);
 for a:=1 to vbatt_numammo() do
  writeln("&7    Supplyable ",rpad(vbatt_ammoname(a),23,"."),": &F",
	ftoi(cond(vbatt_ammoeff(a)=0,0,o.var2/vbatt_ammoeff(a)*o.var1/100)));
 endfor;
end dovortexview;

procedure use_vortex(var o: devicetype);
var
 done: boolean;
begin;
 done:=false;
 repeat;
  writeln;
  write("&3Cell: &FA&3]dd, &FD&3]ischarge, &FV&3]iew, &FQ&3]uit ? &F");

  switch upcase(readkey()) of
    case 'A': writeln("Add.");
	      DoVortexAdd(o);
	      break;

    case 'D': writeln("Discharge.");
	      DoVortexDischarge(o);
	      break;

    case 'V': writeln("View.");
	      DoVortexView(o);
	      break;

    default:  writeln("Quit.");
	      done:=true;
	      break;
  end;
 until done;
end use_vortex;