/* NOTE:  Do not call the next three routines directly.  Use the macros
 * in handy.h, so that we can easily redefine everything to do tracking of
 * allocated hunks back to the original New to track down any memory leaks.
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <process.h>
#include "ntmem.h"

#define index   strchr
#define FALSE 0
#define TRUE 1

static void fatal( char * );
static char nomem[] = "Out of memory!\n";
static short nomemok = FALSE;


char *safemalloc( size_t size)
{
    char *ptr;

    ptr = malloc(size?size:1);	/* malloc(0) is NASTY on our system */
    if (ptr != Nullch)
	return ptr;
    else if (nomemok)
	return Nullch;
    else {
	fputs(nomem,stderr) FLUSH;
	exit(1);
    }
    /*NOTREACHED*/
}

/* paranoid version of realloc */

char *saferealloc(char *where, size_t size)
{
    char *ptr;

    if (!where)
	fatal("Null realloc");
    ptr = realloc(where,size?size:1);	/* realloc(0) is NASTY on our system */
    if (ptr != Nullch)
	return ptr;
    else if (nomemok)
	return Nullch;
    else {
	fputs(nomem,stderr) FLUSH;
	exit(1);
    }
    /*NOTREACHED*/
}

/* safe version of free */

void safefree(char *where)
{
    if (where) {
	free(where);
    }
}


void *memzero( char *pcszTarget, size_t lNumBytes )
{
    return( memset( pcszTarget, 0, lNumBytes ) );
}

/* Print an error message containing the string TEXT, then exit.  */

static void fatal(char *string)
{
	fprintf(stderr, "%s\n", string);
	exit(2);
}

