// pulled this out of gnu tar port for NT. The writer pulled it out of NT Perl.
// It's really getting around...

/* $Log: ntdir.c,v $
 * Revision 1.3  1993/09/16  01:10:14  ESullivan
 * Added an $Id $ section.
 *
 * Revision 1.2  1993/09/07  02:09:30  ESullivan
 * added a $Log area.
 *
 * Revision 1.1  1993/09/05  04:59:21  ESullivan
 * Initial revision
 * */

/*
 *  Copyright (c) 1993, Intergraph Corporation
 *
 *  You may distribute under the terms of either the GNU General Public
 *  License or the Artistic License, as specified in the perl README file.
 *
 *  Various Unix compatibility functions and NT specific functions.
 *
 *  Some of this code was derived from the MSDOS port(s) and the OS/2 port.
 *
 *  I pulled this out of the PERL NT port (the memory functions came
 *  from PERL itself (v 4.036).  Clark Williams of Intergraph wrote
 *  the original of this, and I apologize to him in advance for hacking
 *  it all up.  :-)
 *
 */
char ntdirver[] = "$Id: ntdir.c,v 1.3 1993/09/16 01:10:14 ESullivan Exp ESullivan $";
#if 0
#include "EXTERN.h"
#include "perl.h"
#endif /* 0 */
#include <fcntl.h>
#include <process.h>
#include <sys/stat.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "nt.h"

//
// These exist elsewhere in the PERL for NT code, but I have to
// redo them because I don't have the original.
//
#define index   strchr

static void fatal( char * );
static char nomem[] = "Out of memory!\n";
static short nomemok = FALSE;


//
// UNIX compatible directory access functions for NT
//

//
// File names are converted to lowercase if the
// CONVERT_TO_LOWER_CASE variable is defined.
//

#define CONVERT_TO_LOWER_CASE

#define PATHLEN 1024

//
// The idea here is to read all the directory names into a string table
// (separated by nulls) and when one of the other dir functions is called
// return the pointer to the current file name. 
//

DIR *
opendir(char *filename)
{
    DIR            *p;
    long            len;
    long            idx;
    char            scannamespc[PATHLEN];
    char	   *scanname = scannamespc;
    struct stat	    sbuf;
    WIN32_FIND_DATA FindData;
    HANDLE          fh;

    //
    // check to see if we\'ve got a directory
    //

    if (stat (filename, &sbuf) < 0 ||
	sbuf.st_mode & _S_IFDIR == 0) {
	return NULL;
    }

    //
    // Get us a DIR structure
    //

    Newz (1501, p, 1, DIR);
    if (p == NULL)
	return NULL;
    
    //
    // Create the search pattern
    //

    strcpy(scanname, filename);

    if (index("/\\", *(scanname + strlen(scanname) - 1)) == NULL)
	strcat(scanname, "/*");
    else
	strcat(scanname, "*");

    //
    // do the FindFirstFile call
    //

    fh = FindFirstFile (scanname, &FindData);
    if (fh == INVALID_HANDLE_VALUE) {
	return NULL;
    }

    //
    // now allocate the first part of the string table for the
    // filenames that we find.
    //

    idx = strlen(FindData.cFileName)+1;
    New (1502, p->start, idx, char);
    if (p->start == NULL) {
	fatal ("opendir: malloc failed!\n");
    }
    strcpy (p->start, FindData.cFileName);
    p->nfiles++;
    
    //
    // loop finding all the files that match the wildcard
    // (which should be all of them in this directory!).
    // the variable idx should point one past the null terminator
    // of the previous string found.
    //
    while (FindNextFile(fh, &FindData)) {
	len = strlen (FindData.cFileName);

	//
	// bump the string table size by enough for the
	// new name and it's null terminator 
	//

	Renew (p->start, idx+len+1, char);
	if (p->start == NULL) {
	    fatal ("opendir: malloc failed!\n");
	}
	strcpy(&p->start[idx], FindData.cFileName);
	p->nfiles++;
	idx += len+1;
    }
    FindClose(fh);
    p->size = idx;
    p->curr = p->start;
    return p;
}


//
// Readdir just returns the current string pointer and bumps the
// string pointer to the next entry.
//

struct direct  *
readdir(DIR *dirp)
{
    int         len;
    static int  dummy = 0;

    if (dirp->curr) {

	//
	// first set up the structure to return
	//

	len = strlen(dirp->curr);
	strcpy(dirp->dirstr.d_name, dirp->curr);
	dirp->dirstr.d_namlen = len;

	//
	// Fake inode
	//
	dirp->dirstr.d_ino = dummy++;

	//
	// Now set up for the next call to readdir
	//

	dirp->curr += len + 1;
	if (dirp->curr >= (dirp->start + dirp->size)) {
	    dirp->curr = NULL;
	}

	return &(dirp->dirstr);

    } else
	return NULL;
}

//
// Telldir returns the current string pointer position
//

long
telldir(DIR *dirp)
{
	return (long) dirp->curr;	/* ouch! pointer to long cast */
}

//
// Seekdir moves the string pointer to a previously saved position
// (Saved by telldir).

void
seekdir(DIR *dirp, long loc)
{
	dirp->curr = (char *) loc;	/* ouch! long to pointer cast */
}

//
// Rewinddir resets the string pointer to the start
//

void
rewinddir(DIR *dirp)
{
	dirp->curr = dirp->start;
}

//
// This just free\'s the memory allocated by opendir
//

void
closedir(DIR *dirp)
{
	Safefree(dirp->start);
	Safefree(dirp);
}


//
// These are memory allocation functions which came from PERL.
//

/* NOTE:  Do not call the next three routines directly.  Use the macros
 * in handy.h, so that we can easily redefine everything to do tracking of
 * allocated hunks back to the original New to track down any memory leaks.
 */

char *
safemalloc(size)
MEM_SIZE size;
{
    char *ptr;

    ptr = malloc(size?size:1);	/* malloc(0) is NASTY on our system */
    if (ptr != Nullch)
	return ptr;
    else if (nomemok)
	return Nullch;
    else {
	fputs(nomem,stderr) FLUSH;
	exit(1);
    }
    /*NOTREACHED*/
}

/* paranoid version of realloc */

char *
saferealloc(where,size)
char *where;
MEM_SIZE size;
{
    char *ptr;

    if (!where)
	fatal("Null realloc");
    ptr = realloc(where,size?size:1);	/* realloc(0) is NASTY on our system */
    if (ptr != Nullch)
	return ptr;
    else if (nomemok)
	return Nullch;
    else {
	fputs(nomem,stderr) FLUSH;
	exit(1);
    }
    /*NOTREACHED*/
}

/* safe version of free */

void
safefree(where)
char *where;
{
    if (where) {
	/*SUPPRESS 701*/
	free(where);
    }
}





void *memzero( char *pcszTarget, size_t lNumBytes )
{
    return( memset( pcszTarget, 0, lNumBytes ) );
}

/* Print an error message containing the string TEXT, then exit.  */

static void fatal(char *string)
{
	fprintf(stderr, "%s\n", string);
	exit(2);
}

/***** END OF FILE nt.c *****/

