#include "vars.h"
#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <signal.h>
#include <time.h>



// Uncomment for use with Cygnus X1's gold system
// #define USING_GOLD_STM

// UnComment for use with Sam's KBPERDAY mod
// #define KBPERDAY



extern foundany;
extern int numlock;
#define SETREC(f,i)  sh_lseek(f,((long) (i))*((long)sizeof(uploadsrec)),SEEK_SET);


// Max file size of any users file listing configuration
#define MAX_LISTING_SIZE (1000)


// This is the place the first file will be printed, which defaults to line
// 3, if you modify the file listing header, this will need to be changed
// depending on where the file will need to start after your modification
#define FIRST_FILE_POS (3)


// How far from the bottom that the side menu will be on the screen
// This is used because of people who don't set there screenlines up correctly
// It defines how far up from the users screenlines to put the menu
#define STOP_LIST 0

// Defines for searching
#define SR_MATCH      0
#define SR_DONTMATCH  1

#define SR_OR         1
#define SR_AND        0

#define SR_NEWER      0
#define SR_OLDER      1
#define SR_EQUAL      2


#ifdef __cplusplus
  #define WHEREX() _wherex()
  #define WHEREY() _wherey()
#else
  #define WHEREX() wherex()
  #define WHEREY() wherey()
#endif

// Defines for the sysop commands
#define SYSOP_DELETE 1
#define SYSOP_RENAME 2
#define SYSOP_MOVE   3


// Few global variables

char list_config[MAX_LISTING_SIZE];
int list_loaded;  // 1 through ? or -1 through ? for sysop defined choices


char far _on_[]="ON ";
char far _off_[] ="OFF";

struct listplus_config
{
  long fi, lssm, sent;

  // Side menu colors  (fore+(back<<4))
  int normal_highlight, normal_menu_item, current_highlight, current_menu_item;

  // Foreground only
  int tagged_color, file_num_color;

  // Color for 'found' text when searching
  int found_fore_color, found_back_color;

  // What file you are on, its color (fore+(back<<4))
  int current_file_color;

  // if set to 0, will use the users info, otherwise it will show up to
  // this variable, no more
  int max_screen_lines_to_show;

  // If users extended description setting is lower than this, it will force
  // this amount
  int show_at_least_extended;

  // Toggles
  unsigned int edit_enable        : 1;
  unsigned int request_file        : 1;
  unsigned int colorize_found_text : 1;
  unsigned int search_extended_on  : 1;

  unsigned int simple_search       : 1;
  unsigned int no_configuration    : 1;
  unsigned int check_exist         : 1;
                                   : 9;

  int forced_config;
} lp_config;

int lp_config_loaded;


void alt_nl(void)
/* This function performs a CR/LF sequence to move the cursor to the next
 * line.  If any end-of-line ANSI codes are set (such as changing back to
 * the default color) are specified, those are executed first.
 */
{
  if (endofline[0])
  {
    outstr(endofline);
    endofline[0] = 0;
  }
  outstr("\r\n");
}

void sysop_configure(void)
{
  int key, done=0, color;
  char s[201];

  if(!so())
    return;

  load_lp_config();



  while(!done && !hangup)
  {

    CLS();
    printfile("LPSYSOP");

    GOTO_XY(38, 2);
    setc(lp_config.normal_highlight);
    npr("%3d", lp_config.normal_highlight);

    GOTO_XY(77, 2);
    setc(lp_config.normal_menu_item);
    npr("%3d", lp_config.normal_menu_item);

    GOTO_XY(38, 3);
    setc(lp_config.current_highlight);
    npr("%3d", lp_config.current_highlight);

    GOTO_XY(77, 3);
    setc(lp_config.current_menu_item);
    npr("%3d", lp_config.current_menu_item);

    ansic(0);

    GOTO_XY(38, 6);
    npr_color("|%2d%2d", lp_config.tagged_color, lp_config.tagged_color);

    GOTO_XY(77, 6);
    npr_color("|%2d%2d", lp_config.file_num_color, lp_config.file_num_color);

    GOTO_XY(38, 7);
    npr_color("|%2d%2d", lp_config.found_fore_color, lp_config.found_fore_color);

    GOTO_XY(77, 7);
    npr_color("|%2d%2d", lp_config.found_back_color, lp_config.found_back_color);

    GOTO_XY(38, 8);
    setc(lp_config.current_file_color);
    npr_color("%3d", lp_config.current_file_color);


    GOTO_XY(38, 11);
    ansic(4);
    npr("%2d", lp_config.max_screen_lines_to_show);

    GOTO_XY(77, 11);
    ansic(4);
    npr("%2d", lp_config.show_at_least_extended);


    GOTO_XY(29, 14);
    ansic(4);
    npr("%s", lp_config.edit_enable ? _on_ : _off_);

    GOTO_XY(74, 14);
    ansic(4);
    npr("%s", lp_config.request_file ? _on_ : _off_);

    GOTO_XY(29, 15);
    ansic(4);
    npr("%s", lp_config.colorize_found_text ? _on_ : _off_);

    GOTO_XY(74, 15);
    ansic(4);
    npr("%s", lp_config.search_extended_on ? _on_ : _off_);

    GOTO_XY(29, 16);
    ansic(4);
    npr("%s", lp_config.simple_search ? _on_ : _off_);

    GOTO_XY(74, 16);
    ansic(4);
    npr("%s", !lp_config.no_configuration ? _on_ : _off_);

    GOTO_XY(29, 17);
    ansic(4);
    npr("%s", lp_config.check_exist ? _on_ : _off_);




    ansic(0);

    GOTO_XY(1, 19);

    ansic(1);
    outstr("Q-Quit ");
    mpl(1);
    key=onek("Q\rABCDEFGHIJKLMNOPRS");

    switch(key)
    {
      case 'Q':
      case '\r':
        done=1;
        break;


      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'I':
        color=SelectColor(2);
        if(color>0)
        {
          switch(key)
          {
            case 'A':
              lp_config.normal_highlight=color;
              break;
              
            case 'B':
              lp_config.normal_menu_item=color;
              break;

            case 'C':
              lp_config.current_highlight=color;
              break;

            case 'D':
              lp_config.current_menu_item=color;
              break;

            case 'I':
              lp_config.current_file_color=color;
              break;
          }
        }
        break;

      case 'E':
      case 'F':
      case 'G':
      case 'H':
        color=SelectColor(1);
        if(color>0)
        {
          switch(key)
          {
            case 'E':
              lp_config.tagged_color=color;
              break;
              
            case 'F':
              lp_config.file_num_color=color;
              break;

            case 'G':
              lp_config.found_fore_color=color;
              break;

            case 'H':
              lp_config.found_back_color=color;
              break;
          }
        }
        break;

      case 'J':
        outstr("Enter max amount of lines to show (0=disabled) ");
        mpl(2);
        input(s, 2);
        lp_config.max_screen_lines_to_show=atoi(s);
        break;

      case 'K':
        outstr("Enter minimum extended description lines to show ");
        mpl(2);
        input(s, 2);
        lp_config.show_at_least_extended=atoi(s);
        break;

      case 'L':
        lp_config.edit_enable =!lp_config.edit_enable;
        break;

      case 'M':
        lp_config.request_file=!lp_config.request_file;
        break;


      case 'N':
        lp_config.colorize_found_text=!lp_config.colorize_found_text;
        break;

      case 'O':
        lp_config.search_extended_on=!lp_config.search_extended_on;
        break;


      case 'P':
        lp_config.simple_search=!lp_config.simple_search;
        break;


      case 'R':
        outstr("Disable configurable listings? ");
        if(yn())
        {
          pl("Select a file that will be forced upon all users");
          pausescr();
          config_file_list();
          lp_config.forced_config=thisuser.list_config;
          lp_config.no_configuration=1;

        }
        else
          lp_config.no_configuration=0;
        break;

      case 'S':
        lp_config.check_exist=!lp_config.check_exist;
        break;

    }
  }
  save_lp_config();
  load_lp_config();
}


int SelectColor(int which)
{
  char ch,nc;

  helpl=36;
  nl();
  
  if (thisuser.sysstatus & sysstatus_color)
  {
    color_list();
    ansic(0);
    nl();
    prt(2, get_string(430));
    ch=onek("01234567");
    nc=ch-'0';

    if(which==2)
    {
      prt(2, get_string(431));
      ch=onek("01234567");
      nc=nc | ((ch-'0') << 4);
    }
  }
  else
  {
    nl();
    prt(5, get_string(432));
    if (yn()) {
      if ((thisuser.bwcolors[1] & 0x70) == 0)
        nc=0 | ((thisuser.bwcolors[1] & 0x07) << 4);
      else
        nc=(thisuser.bwcolors[1] & 0x70);
    }
    else
    {
      if ((thisuser.bwcolors[1] & 0x70) == 0)
        nc=0 | (thisuser.bwcolors[1] & 0x07);
      else
        nc=((thisuser.bwcolors[1] & 0x70) >> 4);
    }
  }

    prt(5, get_string(434));
    if (yn())
      nc |= 0x08;

  if(which==2)
  {
    prt(5, get_string(437));
    if (yn())
      nc |= 0x80;
  }

  nl();
  setc(nc);
  outstr(describe(nc));
  ansic(0);
  nl();


  prt(5, get_string(438));
  if(yn())
    return nc;
  return -1;
}


void colorize_foundtext(char *text, struct search_record *search_rec, int color)
{
  int size, x;
  char *temp, found_color[10], normal_color[10];
  char find[101];

  sprintf(found_color, "|%2d|%2d", lp_config.found_fore_color, lp_config.found_back_color);
  sprintf(normal_color, "|16|%2d", color);

  if(lp_config.colorize_found_text)
  {
    for(x=0; x<2; x++)
    {
      if(x==0)
        strcpy(find, search_rec->search1);
      else
        strcpy(find, search_rec->search2);

      temp=text;

      while(temp && find[0])
      {
        if((temp=strstr_nocase(temp, find))!=NULL)
        {
          // First move text over 6 places and insert 'found color'
          size=strlen(temp)+1;
          memmove(&temp[6], &temp[0], size);
          strncpy(temp, found_color, 6);

          // Now move to the end of the found text
          temp+=strlen(find)+6;
          size=strlen(temp)+1;

          // And move text over 6 places to make room for normal color
          memmove(&temp[6], &temp[0], size);
          strncpy(temp, normal_color, 6);

          // Get off of this find so we can find the next match
          ++temp;
        }
      }
    }
  }
}








void printtitle_plus(void)
{
  if(WHEREY() != 0 || WHEREX() != 0)
    CLS();

  // New title, inspired by Spotnick
  npr_color("|15|20  [%-40s] (%d files) Space to tag - ?=Help",
                   directories[udir[curdir].subnum].name, numf);
  EOL();
  nl();
  nl();

}

void print_searching(void)
{
  static char what_color=1;
  char *searching="....";

  if(WHEREY() !=0 || WHEREX() !=0)
    CLS();

  npr_color("|16|14Searching");
  npr_color("|%2d%s\r", (char) what_color, searching);
  ++what_color;
  if(what_color>15)
    what_color=1;
}

void catch_divide_by_zero(int x)
{
  if(x!=x)
    x=x;
  sysoplog("Caught divide by 0");
}

int listfiles_plus(int type)
{
  uploadsrec (*file_recs)[1];
  int file_handle[51], lines, max_lines, lines_left;
  int save_last_dir=0, save_first_file=0;
  char vert_pos[51];

  int first_file, amount;
  int file_pos=0, save_file_pos=0, menu_pos=0;
  int done=0, all_done=0;
  unsigned command;
  int redraw;

  int matches=0; // when a file passes the compare_criteria inc
  int had;
  int save_status=thisuser.sysstatus;

  int this_dir, also_this_dir;
  int scan_dir;
  int save_dir=curdir;
  int changedir=0;

  int file=-1, sysop_mode=0;
  char **menu_items;
  
  struct side_menu_colors smc;
  struct search_record search_rec;


  signal(SIGFPE, catch_divide_by_zero);


  helpl=800;
  tagging=0;



  load_lp_config();

  smc.normal_highlight  = lp_config.normal_highlight;
  smc.normal_menu_item  = lp_config.normal_menu_item;
  smc.current_highlight = lp_config.current_highlight;
  smc.current_menu_item = lp_config.current_menu_item;

  if(lp_config.no_configuration)
  {
    if(lp_config.forced_config!=list_loaded)
      load_list_config(lp_config.forced_config);

    if(!lp_config.forced_config)
      config_file_list();
  }
  else
  {
    if(thisuser.list_config!=list_loaded)
      load_list_config(thisuser.list_config);

    if(!thisuser.list_config)
      config_file_list();
  }

  
  if(!list_loaded)
    config_file_list();


  // Turn off topscreen info for this mod
  topdata=0;
  topscreen();


  CLS();

  menu_items=(char **)alloc_2d(20, 15, sizeof(char));
  if(!menu_items)
    return 0;

  strcpy(menu_items[0], "Next");
  strcpy(menu_items[1], "Prev");
  strcpy(menu_items[2], "Tag");
  strcpy(menu_items[3], "View");
  strcpy(menu_items[4], "Info");
  strcpy(menu_items[5], "Download");
  strcpy(menu_items[6], "Batch Menu");
  strcpy(menu_items[7], "+Dir");
  strcpy(menu_items[8], "-Dir");
  strcpy(menu_items[9], "Quit");
  strcpy(menu_items[10], "?");
  if(so())
  {
    strcpy(menu_items[11], "Sysop");
    menu_items[12][0]=0;
  }
  else
    menu_items[11][0]=0;




  (char *)file_recs=(char *)malloca((thisuser.screenlines+20)*sizeof(uploadsrec));
  if(!file_recs)
  {
    free_2d(menu_items);
    return 0;
  }
  memset(&search_rec, 0, sizeof(search_rec));

  search_rec.search_extended=lp_config.search_extended_on;

  tmp_disable_pause(1);

  if(type==LIST_DIR)  // Regular listfile
  {
    file_mask(search_rec.filemask1);
    search_rec.alldirs=THIS_DIR;
  }
  else if(type==SEARCH_ALL) // Search file
  {
    search_rec.alldirs=ALL_DIRS;
    if(!search_criteria(&search_rec))
    {
      tmp_disable_pause(0);
      tmp_disable_conf(0);

      thisuser.sysstatus = save_status;

      free(file_recs);
      free_2d(menu_items);
      return 0;
    }
  }
  else if(type==NSCAN_DIR) // new files
  {
    strcpy(search_rec.filemask1, "");
    search_rec.nscandate=nscandate;
    search_rec.alldirs=THIS_DIR;
  }
  else if(type==NSCAN_NSCAN) // New scan of dirs in NSCAN
  {
    search_rec.nscandate=nscandate;
    search_rec.alldirs=NSCAN_DIRS;
  }
  else
  {
    sysoplog("Undefined type in function listfiles_plus");
    tmp_disable_pause(0);
    tmp_disable_conf(0);

    thisuser.sysstatus = save_status;

    free(file_recs);
    free_2d(menu_items);
    return 0;
  }

  if(!search_rec.filemask1[0] && !search_rec.filemask2[0] &&
     !search_rec.nscandate && !search_rec.search1[0] && !search_rec.search2[0])
    all_done=1;


  if(search_rec.filemask1[0])
  {
    if (strchr(search_rec.filemask1,'.')==NULL)
      strcat(search_rec.filemask1,".*");
  }
  if(search_rec.filemask2[0])
  {
    if (strchr(search_rec.filemask2,'.')==NULL)
      strcat(search_rec.filemask2,".*");
  }

  align(search_rec.filemask1);
  align(search_rec.filemask2);

  if(lp_config.max_screen_lines_to_show)
  {
    max_lines = thisuser.screenlines-(4+STOP_LIST) > lp_config.max_screen_lines_to_show-(4+STOP_LIST) ?
                lp_config.max_screen_lines_to_show-(4+STOP_LIST) :
                thisuser.screenlines-(4+STOP_LIST);
  }
  else
    max_lines = thisuser.screenlines-(4+STOP_LIST);


  num_listed=0;
  for (this_dir=0; (this_dir<num_dirs) && (!hangup) && (udir[this_dir].subnum!=-1) && !all_done; this_dir++)
  {
    also_this_dir=udir[this_dir].subnum;
    scan_dir=0;

    checka(&all_done,&all_done);

    if(search_rec.alldirs==THIS_DIR)
    {
      if(this_dir==save_dir)
        scan_dir=1;
    }
    else // Either for NSCAN or all dirs
    {
      // This part checks to see if it is in the nscan
      if (qsc_n[also_this_dir/32]&(1L<<(also_this_dir%32)))
        scan_dir=1;

      // If we are searching all dirs, scan it..
      if(search_rec.alldirs==ALL_DIRS)
        scan_dir=1;


      // If we have a nscan date specified, lets check the file dates first...
      // and not even open it if it hasn't been changed
      if(search_rec.nscandate)
      {

        if ((dir_dates[udir[this_dir].subnum]) && (dir_dates[udir[this_dir].subnum]<nscandate) && search_rec.ns_flag==SR_NEWER)
        {
          scan_dir=0;

          curdir=this_dir;
          print_searching();
        }
      }
    }


    if(scan_dir)
    {
      curdir=this_dir;
      save_last_dir=this_dir;

      dliscan();


      num_listed=0;


      first_file=save_first_file=1;
      amount=0;
      done=0;
      matches=0;
      lines=0;


      while(!done && !hangup && !all_done)
      {

        if(!amount)
        {
          // Open files to read only while reading dir
          file=sh_open1(dlfn,O_RDONLY | O_BINARY);

          print_searching();
        }

        if(numf)
        {
          changedir=0;

          SETREC(file, first_file+amount);
          sh_read(file,(void *)file_recs[matches],sizeof(uploadsrec));



          if(compare_criteria(&search_rec, file_recs[matches]))
          {
            if(!matches)
              printtitle_plus();

            file_handle[matches]=first_file+amount;


            vert_pos[matches]=lines;

            lines_left=max_lines-lines;
            lines += printinfo_plus(file_recs[matches], file_handle[matches], check_batch_queue(file_recs[matches]->filename), lines_left, &search_rec);


            ++matches;  // Amount of files on screen
          }
          ++amount;


          if((lines+2 >=max_lines) || (numf < first_file+amount))
          {
            // Close it now, since we don't need it right now
            file=sh_close(file);

            if(matches)
            {
              int menu_done=0;

              file_pos=save_file_pos;
              drawfile(vert_pos[file_pos], file_handle[file_pos]);

              redraw=1;
              save_file_pos=0;

              while(!menu_done && !hangup)
              {
                command = side_menu(&menu_pos, redraw, menu_items, 2, max_lines+4, &smc);

                redraw=1;
                ansic(0);

                if(do_sysop_command(command))
                {
                  menu_done=1;
                  amount=lines=matches=0;
                  save_file_pos=file_pos;
                }


                switch(command)
                {
                  case '?':
                  case CO:
                    CLS();
                    tmp_disable_pause(0);
                    printfile("LISTPLUS.HLP");
                    pausescr();
                    tmp_disable_pause(1);

                    menu_done=1;
                    amount=lines=matches=0;
                    save_file_pos=file_pos;
                    break;

                  case COMMAND_DOWN:
                    undrawfile(vert_pos[file_pos], file_handle[file_pos]);
                    ++file_pos;
                    if(file_pos>=matches)
                      file_pos=0;
                    drawfile(vert_pos[file_pos], file_handle[file_pos]);
                    redraw=0;
                    break;

                  case COMMAND_UP:
                    undrawfile(vert_pos[file_pos], file_handle[file_pos]);
                    if(!file_pos)
                      file_pos=matches-1;
                    else
                      --file_pos;
                    drawfile(vert_pos[file_pos], file_handle[file_pos]);
                    redraw=0;
                    break;

                  case SPACE: // Add or remove batch queue
#ifdef KBPERDAY
                    kbbatch+=bytes_to_k(file_recs[file_pos]->numbytes);
#endif

                    if(find_batch_queue(file_recs[file_pos]->filename) > -1)
                    {
                      remove_batch(file_recs[file_pos]->filename);
                      redraw=0;
                    }
                    else if(!ratio_ok() && !sysop_mode)
                    {
                      menu_done=1;
                      amount=lines=matches=0;
                      save_file_pos=file_pos;
                      pausescr();
                    }
#ifdef USING_GOLD_STM
                    else if(!gold_ok(file_recs[file_pos]->numbytes) && !sysop_mode)
                    {
                      menu_done=1;
                      amount=lines=matches=0;
                      save_file_pos=file_pos;
                      CLS();
                      ansic(1);
                      pl("Not enough Gold");
                      pausescr();
                    }
#endif
                    else
                    {
                      char file[130];
                      redraw=0;


                      // If it is in the dir, check to make sure it exists
                      // before adding it, if it is on CD ROM, just add it
                      if (!(directories[udir[curdir].subnum].mask & mask_cdrom || sysop_mode) || sysop_mode)
                      {
                        strcpy(file, directories[udir[curdir].subnum].path);
                        strcat(file, file_recs[file_pos]->filename);
                        if(sysop_mode || exist(file))
                          add_batch(file_recs[file_pos]->filename, udir[curdir].subnum, file_recs[file_pos]->numbytes);
                        else if(lp_config.request_file)
                        {
                          menu_done=1;
                          amount=lines=matches=0;
                          request_file(file_recs[file_pos]->filename);
                        }
                      }
                      else
                        add_batch(file_recs[file_pos]->filename, udir[curdir].subnum, file_recs[file_pos]->numbytes);


                    }
#ifdef KBPERDAY
                    kbbatch-=bytes_to_k(file_recs[file_pos]->numbytes);
#endif
                    GOTO_XY(1, FIRST_FILE_POS+vert_pos[file_pos]);
                    npr_color("|%2d %c ", lp_config.tagged_color, check_batch_queue(file_recs[file_pos]->filename) ? '':' ');

                    break;

                  case EXECUTE:
                    switch(menu_pos)
                    {
                      case 0: // Next
                        save_first_file=first_file;
                        first_file+=amount;

                        if(first_file>numf)
                          done=1;

                        menu_done=1;
                        amount=lines=matches=0;
                        break;

                      case 1: // Prev
                        if(save_first_file>=first_file)
                        {
                          if(first_file>5)
                            first_file-=5;
                          else
                            first_file=1;
                        }
                        else
                          first_file=save_first_file;


                        if(this_dir!=save_last_dir)
                        {
                          this_dir=save_last_dir;
                          curdir=save_last_dir;
                        }

                        menu_done=1;
                        amount=lines=matches=0;
                        break;

                      case 2: // TAG file
#ifdef KBPERDAY
                        kbbatch+=bytes_to_k(file_recs[file_pos]->numbytes);
#endif
                        if(find_batch_queue(file_recs[file_pos]->filename) > -1)
                        {
                          remove_batch(file_recs[file_pos]->filename);
                          redraw=0;
                        }
                        else if(!ratio_ok() && !sysop_mode)
                        {
                          menu_done=1;
                          amount=lines=matches=0;
                          save_file_pos=file_pos;
                          pausescr();
                        }
#ifdef USING_GOLD_STM
                        else if(!gold_ok(file_recs[file_pos]->numbytes) && !sysop_mode)
                        {
                          menu_done=1;
                          amount=lines=matches=0;
                          save_file_pos=file_pos;
                          CLS();
                          ansic(1);
                          pl("Not enough Gold");
                          pausescr();
                        }
#endif
                        else
                        {
                          char file[130];
                          redraw=0;

                          // If it is in the dir, check to make sure it exists
                          // before adding it, if it is on CD ROM, just add it
                          if (!(directories[udir[curdir].subnum].mask & mask_cdrom) && !sysop_mode)
                          {
                            strcpy(file, directories[udir[curdir].subnum].path);
                            strcat(file, file_recs[file_pos]->filename);
                            if(exist(file))
                              add_batch(file_recs[file_pos]->filename, udir[curdir].subnum, file_recs[file_pos]->numbytes);
                            else if(lp_config.request_file)
                            {
                              menu_done=1;
                              amount=lines=matches=0;
                              request_file(file_recs[file_pos]->filename);
                            }
                          }
                          else
                            add_batch(file_recs[file_pos]->filename, udir[curdir].subnum, file_recs[file_pos]->numbytes);
                        }


#ifdef KBPERDAY
                        kbbatch-=bytes_to_k(file_recs[file_pos]->numbytes);
#endif
                        GOTO_XY(1, FIRST_FILE_POS+vert_pos[file_pos]);
                        npr_color("|%2d %c ", lp_config.tagged_color, check_batch_queue(file_recs[file_pos]->filename) ? '':' ');
                        break;


                      case 3: // View
                        if(!sysop_mode)
                        {
                          view_file(file_recs[file_pos]->filename);
                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        else
                        {
                          do_batch_sysop_command(SYSOP_DELETE, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }

                        break;


                      case 4: // Info

                        if(!sysop_mode)
                        {
                          show_fileinfo(file_recs[file_pos]);
                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        else
                        {
                          do_batch_sysop_command(SYSOP_RENAME, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }

                        break;

                      case 5: // Download or move batch files

                        if(!sysop_mode)
                        {
                          CLS();

                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;

                          if(!ratio_ok())
                          {
                            pausescr();
                          }
                          else
                          {
                            if(numbatchdl)
                            {
                              int x, i;
                              if(numbatch>numbatchdl)
                                outstr("1You have files tagged for upload and download\n\r");
                              outstr("1Download tagged files? (3[4Y3]es [N]o [B]i Tran) ");

                              x=onek("YNB\r");
                              switch(x)
                              {
                                case 'Y':
                                case 'y':
                                case '\r':
                                  batchdl(1);
                                  break;
                                case 'B':
                                case 'b':
                                  if (modem_flag & flag_as)
                                  {
                                    nl();
                                    pl(get_string(878));
                                    pl(get_string(879));
                                    pl(get_string(880));
                                    nl();
                                    prt(5,get_string(881));
                                    if (!yn())
                                      break;
                                  }
                                  nl();
                                  prt(5,get_string(877));
                                  had=yn();
                                  nl();

                                  i=get_protocol(xf_bi);
                                  if (i>0)
                                  {

                                    bibatch(had, externs[i-6].bibatchfn, externs[i-6].description);

                                    if (!had)
                                    {
                                      nl();
                                      outstr(get_string(782));
                                      npr_color("%-6.3f\r\n",ratio());
                                    }
                                    done=1;
                                  }
                                  break;
                                case 'N':
                                case 'n':
                                  download_plus(file_recs[file_pos]->filename);
                                  break;
                              }
                            }
                            else
                              download_plus(file_recs[file_pos]->filename);
                          }
                          dliscan();
                        }
                        else
                        {
                          do_batch_sysop_command(SYSOP_MOVE, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }

                        break;

                      case 6: // Batch Menu, or sysop configure

                        if(!sysop_mode)
                        {
                          CLS();
                          batchdl(0);
                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                          dliscan();
                        }
                        else
                        {
                          sysop_configure();

                          smc.normal_highlight  = lp_config.normal_highlight;
                          smc.normal_menu_item  = lp_config.normal_menu_item;
                          smc.current_highlight = lp_config.current_highlight;
                          smc.current_menu_item = lp_config.current_menu_item;



                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        break;

                      case 7: // +dir
                        menu_done=1;
                        amount=lines=matches=0;
                        first_file=1;

                        changedir=1;

                        if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
                        {
                          ++curdir;
                          ++this_dir;
                        }
                        else
                        {
                          curdir=0;
                          this_dir=0;
                        }
                        if(!type)
                          save_dir=curdir;
                        dliscan();

                        break;

                      case 8: // -dir
                        menu_done=1;
                        amount=lines=matches=0;
                        first_file=1;

                        changedir=-1;

                        if (curdir>0)
                        {
                          --curdir;
                          --this_dir;
                        }
                        else
                        {
                          while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
                            ++curdir;
                          this_dir=curdir;
                        }
                        if(!type)
                          save_dir=curdir;
                        dliscan();

                        break;

                      case 9: // Quit
                        menu_done=1;
                        done=1;
                        amount=lines=matches=0;
                        all_done=1;
                        break;

                      case 10: // ? Help
                        CLS();
                        tmp_disable_pause(0);
                        printfile("LISTPLUS.HLP");
                        pausescr();
                        tmp_disable_pause(1);


                        menu_done=1;
                        amount=lines=matches=0;
                        save_file_pos=file_pos;
                        break;

                      case 11: // Sysop

                        if(so() && !sysop_mode)
                        {
                          sysop_mode=1;

                          strcpy(menu_items[3], "Delete");
                          strcpy(menu_items[4], "Rename");
                          strcpy(menu_items[5], "Move");
                          strcpy(menu_items[6], "Config");
                          strcpy(menu_items[11], "Back");
                        }
                        else
                        {
                          sysop_mode=0;

                          strcpy(menu_items[3], "View");
                          strcpy(menu_items[4], "Info");
                          strcpy(menu_items[5], "Download");
                          strcpy(menu_items[6], "Batch Menu");
                          strcpy(menu_items[11], "Sysop");
                        }
                        outchr('\r');
                        EOL();

                        break;


                    }

                    break;

                  case GET_OUT:
                    menu_done=1;
                    done=1;
                    all_done=1;
                    amount=lines=matches=0;
                    break;

                }
              }
            }
            else
            {
              if(!changedir)
                done=1;  // If !matches
              else if(changedir==1)
              {
                if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
                  ++curdir;
                else
                  curdir=0;
                dliscan();

              }
              else
              {
                if (curdir>0)
                  --curdir;
                else
                {
                  while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
                    ++curdir;
                }
                dliscan();

              }
            }
          }
        }
        else
        {
          file=sh_close(file);

          if(!changedir)
            done=1;  // If !matches
          else if(changedir==1)
          {
            if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
              ++curdir;
            else
              curdir=0;
            dliscan();

          }
          else
          {
            if (curdir>0)
              --curdir;
            else
            {
              while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
                ++curdir;
            }
            dliscan();
          }
        }
      }
    }
  }

  if(file!=-1)
    file=sh_close(file);

  curdir=save_dir;

  ansic(0);
  GOTO_XY(1, thisuser.screenlines-3);
  nln(3);

  lines_listed=0;

  tmp_disable_pause(0);
  tmp_disable_conf(0);

  thisuser.sysstatus = save_status;

  free(file_recs);
  free_2d(menu_items);
  return(all_done);
}

void drawfile(int filepos, int filenum)
{
  GOTO_XY(4, filepos+FIRST_FILE_POS);
  setc(lp_config.current_file_color);
  npr_color("%3d0", filenum);
  
  // Don't waist time putting the cursor in a nice pos at slow speeds
  if(modem_speed>2400 || !using_modem)
    GOTO_XY(4, filepos+FIRST_FILE_POS);
  
}

void undrawfile(int filepos, int filenum)
{
  GOTO_XY(4, filepos+FIRST_FILE_POS);
  npr_color("|%2d%3d0", lp_config.file_num_color, filenum);
}


int add_batch(char *filename, int dn, long fs)
{
  double t;
  
  if(find_batch_queue(filename) > -1)
    return 0;
  
  if (numbatch>=MAX_BATCH) 
  {
    GOTO_XY(1, thisuser.screenlines-1);
    pl(get_string(900));
    pausescr();
  }
  else if(!ratio_ok())
  {
    pausescr();
  }
  else 
  {
    if (modem_speed)
      t=(12.656) / ((double) (modem_speed)) * ((double)(fs));
    else
      t=0.0;
    if (nsl()<=(batchtime + t)) 
    {
      GOTO_XY(1, thisuser.screenlines-1);
      pl(get_string(901));
      pausescr();
    } 
    else 
    {
      if (dn==-1) 
      {
        GOTO_XY(1, thisuser.screenlines-1);
        pl(get_string(902));
        pausescr();
      } 
      else 
      {
        batchtime += t;
        strcpy(batch[numbatch].filename,filename);
        batch[numbatch].dir=dn;
        batch[numbatch].time=t;
        batch[numbatch].sending=1;
        batch[numbatch].len=fs;
  
        numbatch++;
#ifdef KBPERDAY
        kbbatch+=bytes_to_k(fs);
#endif
        ++numbatchdl;
        
        return 1;
      }
    }
  }
  return 0;
}

void view_file(char *filename)
{
  char command[151];
  char temp[30];
  int i,abort,next,i1,file;
  uploadsrec u;

  CLS();

  strcpy(temp, filename);
  unalign(temp);

  if(exist("AVIEWCOM.EXE"))
  {
    // Remove -d to allow downloads, change options as desired
    // I use -i -b for irq and base address for multiline compatibility with
    // the use of non standard comm ports
    sprintf(command, "AVIEWCOM.EXE %s%s -a1 -d -i%d -b%x", directories[udir[curdir].subnum].path, temp, async_irq, base);
    do_external(command, 1);
  }
  else
  {
    dliscan();
    abort=0;
    next=0;
    i=recno(filename);
    do {
      if (i>0) {
        file=sh_open1(dlfn,O_RDONLY | O_BINARY);
        SETREC(file,i);
        sh_read(file,(void *)&u,sizeof(uploadsrec));

        file=sh_close(file);

        i1=list_arc_out(stripfn(u.filename),directories[udir[curdir].subnum].path);
        if (i1)
          abort=1;
        checka(&abort,&next);
        i=nrecno(filename,i);
      }
    } while ((i>0) && (!hangup) && (!abort));
    nl();
    pausescr();
  }
}



void download_plus(char *file)
{
  int dn;
  char s[81];
  
  strcpy(s, file);

  if (s[0]==0)
    return;
    
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  
  CLS();
  
  if (try_to_download(s,udir[curdir].subnum,0)==0) {
    nl();
    pl(get_string(789));
    nl();
    foundany=dn=0;
    while ((dn<num_dirs) && (udir[dn].subnum!=-1)) {
      if (try_to_download(s,udir[dn].subnum,1)<0)
        dn=100;
      else
        dn++;
    }
    if (!foundany) {
      pl(get_string(89));
      nl();
    }
  }
}

// This search criteria will only find a file if ALL fields are met
int compare_criteria(struct search_record *sr, uploadsrec *ur)
{
  char desc[181];
  char *ext_desc;
  int met=1;
  int first, second;
  
  first=second=1;

  if(strcmp(sr->filemask1, /* get_string(1310) */ "        .   ")!=0)
  {
    if(compare(sr->filemask1, ur->filename)==0)
    {
      switch(sr->fm1_flag)
      {
        case SR_MATCH:
          first=0;
          break;
        case SR_DONTMATCH:
          first=1;
          break;
      }
    }
    else
    {
      switch(sr->fm1_flag)
      {
        case SR_MATCH:
          first=1;
          break;
        case SR_DONTMATCH:
          first=0;
          break;
      }
    }
  }
  else
    first=-1;

  if(strcmp(sr->filemask2,  /* get_string(1310) */ "        .   ")!=0)
  {
    if(compare(sr->filemask2, ur->filename)==0)
    {
      switch(sr->fm2_flag)
      {
        case SR_MATCH:
          second=0;
          break;
        case SR_DONTMATCH:
          second=1;
          break;
      }
    }
    else
    {
      switch(sr->fm2_flag)
      {
        case SR_MATCH:
          second=1;
          break;
        case SR_DONTMATCH:
          second=0;
          break;
      }
    }
  }
  else
    second=-1;


  switch(sr->andor1)
  {
    case SR_AND:
      if(first<0 && second <0)
        break;

      if(first<0)
        first=1;
      if(second<0)
        second=1;

      if(first<=0 || second<=0)
        met=0;
      break;

    case SR_OR:
      if(first<0 && second <0)
        break;

      if(first<0)
        first=0;
      if(second<0)
        second=0;

      if(first<=0 && second<=0)
        met=0;
      break;
  }
    

  if(sr->nscandate)  
  {
    switch(sr->ns_flag)
    {
      case SR_NEWER:
        if(ur->daten<sr->nscandate)
          met=0;
        break;
      case SR_EQUAL:
      {
        long temp_daten;
        char temp[20];

        strcpy(temp, daten_to_date(sr->nscandate));
        temp_daten=date_to_daten(temp);

        if(ur->daten!=temp_daten)
          met=0;
        break;
      }
      case SR_OLDER:
        if(ur->daten>sr->nscandate)
          met=0;
        break;
    }
  }

  first=second=1;

  if(sr->search1[0])
  {
    int anyfound=0;
    
    strcpy(desc, ur->description);
    strupr(desc);
    if(strstr(desc, sr->search1)!=NULL)
      anyfound=1;
      
    // Search the filename also for the text, or comment out...  
    // if you don't want to search the filename for the text given
    if(strstr(ur->filename, sr->search1)!=NULL)
      anyfound=1;

  
    if(sr->search_extended && anyfound==0)
    {
      ext_desc=read_extended_description(ur->filename);

      if(ext_desc)
      {
        if(strstr_nocase(ext_desc, sr->search1)!=NULL)
          anyfound=1;
        free(ext_desc);
      }
    }
    


    switch(sr->search1_flag)
    {
      case SR_MATCH:
        if(!anyfound)
          first=0;
        break;
      case SR_DONTMATCH:
        if(anyfound)
          first=0;
        break;
    }
  }
  else
    first=-1;

  if(sr->search2[0])
  {
    int anyfound=0;
    
    strcpy(desc, ur->description);
    strupr(desc);
    if(strstr(desc, sr->search2)!=NULL)
      anyfound=1;
      
    // Search the filename also for the text, or comment out...  
    if(strstr(ur->filename, sr->search2)!=NULL)
      anyfound=1;
      
  
    if(sr->search_extended && anyfound==0)
    {
      ext_desc=read_extended_description(ur->filename);

      if(ext_desc)
      {
        if(strstr_nocase(ext_desc, sr->search2)!=NULL)
          anyfound=1;
        free(ext_desc);
      }
    }
    

    switch(sr->search2_flag)
    {
      case SR_MATCH:
        if(!anyfound)
          second=0;
        break;
      case SR_DONTMATCH:
        if(anyfound)
          second=0;
        break;
    }
  }
  else
    second=-1;


  switch(sr->andor2)
  {
    case SR_AND:
      if(first<0 && second <0)
        break;

      if(first<0)
        first=1;
      if(second<0)
        second=1;

      if(first<=0 || second<=0)
        met=0;
      break;

    case SR_OR:
      if(first<0 && second <0)
        break;

      if(first<0)
        first=0;
      if(second<0)
        second=0;

      if(first<=0 && second<=0)
        met=0;
      break;
  }
      
  return(met);
}
  
    


void request_file(char *filename)
{
  char message[101];

  CLS();
  nl();

  printfile("REQPLUS");

  ansic(2);
  npr_color("Send Request for file? ");

  if(ny())
  {
    sprintf(message, "%s is requesting file %s", thisuser.name, filename);
    ssm(1, 0, message);
    pl("File request sent");
  }
  else
    pl("File request NOT sent");

}

void check_listplus(void)
{
  ansic(1);
  outstr("Use listplus file tagging? ");

  if(ny())
    thisuser.use_internal_tag=0;
  else
    thisuser.use_internal_tag=1;

}

int ok_listplus(void)
{
  if(okansi() && !(thisuser.sysstatus & sysstatus_no_tag) && !thisuser.use_internal_tag && !x_only)
    return 1;

  return 0;
}

#ifdef USING_GOLD_STM
int gold_ok(long bytes)
{
  int xx;
  float totalgold;

  xx=0;
  totalgold=0;

  while(xx<numbatch && !hangup)
  {
    totalgold+=((float)(bytes_to_k(batch[xx].len))*goldsys.download)/10;
    ++xx;
  }

  float cost=((float)(bytes_to_k(bytes))*goldsys.download)/10;

  if (thisuser.gold < cost+totalgold || (thisuser.gold < 1))
    return 0;

  return 1;
}
#endif




void chrcat(char *s1, char s2)
{
  int size=strlen(s1);
  s1[size]=s2;
  s1[size+1]=0;
}



// Return the amount of lines that were printed
int printinfo_plus(uploadsrec *u, int filenum, int marked, int LinesLeft, struct search_record *search_rec)
{
  char kilo[10], temp[151], temp_size[5], filename[13], ext[4];
  char *listing;
  char *str;
  int cur=0;
  char command[30];
  int force_size, size_size;

  int ch=0, chars_this_line=0, in_ansi=0, numl=0, cpos=0, will_fit=78;
  int cur_color=14;
  int char_printed=0;

  int daysold;
  long TimeNow, DiffTime;

  listing=(char *)malloca(MAX_LISTING_SIZE);
  if(!listing)
    return 0;




  // Extract out filename and extention
  strcpy(filename, u->filename);
  str=strchr(filename, '.');
  str[0]=0;
  ++str;
  strcpy(ext, str);
  strip_string(filename);
  strip_string(ext);


  sprintf(kilo, "%ldk", (long)bytes_to_k(u->numbytes));
  if (!(directories[udir[curdir].subnum].mask & mask_cdrom))
  {
    char file[101];
    strcpy(file, directories[udir[curdir].subnum].path);
    strcat(file, u->filename);

    if(lp_config.check_exist)
    {
      if (!exist(file))
        strcpy(kilo,"N/A");
    }
  }

  TimeNow=time(NULL);
  DiffTime=difftime(TimeNow, u->daten);
  daysold=DiffTime/SECONDS_PER_DAY;



  sprintf(listing, "|%2d %c |%2d%3d ", lp_config.tagged_color, marked ? '' : ' ', lp_config.file_num_color, filenum);
  while(list_config[cur])
  {
    if(list_config[cur]!='|')
    {
      chrcat(listing, list_config[cur]);
      ++cur;
    }
    else
    {
      ++cur;
      strncpy(command, list_config+cur, 2);
      command[2]=0;
      cur+=2;

      strupr(command);

      // Check for a size specifier
      if(isdigit(list_config[cur]))
      {
        if(isdigit(list_config[cur+1]))
        {
          strncpy(temp_size, list_config+cur, 2);
          temp_size[2]=0;
          force_size=atoi(temp_size);
          size_size=2;

          cur+=2;
        }
        else
        {
          strncpy(temp_size, list_config+cur, 1);
          temp_size[1]=0;
          force_size=atoi(temp_size);
          size_size=1;

          cur++;

        }
      }
      else if(list_config[cur]=='-')
      {
        if(isdigit(list_config[cur+1]))
        {
          strncpy(temp_size, list_config+cur, 2);
          temp_size[2]=0;
          force_size=atoi(temp_size);
          size_size=2;

          cur+=2;
        }
        else
        {
          force_size=150;
          size_size=0;
        }
      }
      else
      {
        force_size=150;
        size_size=0;
      }




      if(!strcmp(command, "FN"))  // Filename
      {
        strncpy(temp, filename, force_size > -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
        if(search_rec)
          colorize_foundtext(temp, search_rec, cur_color);
      }
      else if(!strcmp(command, "EX"))  // Extension
      {
        strncpy(temp, ext, force_size > -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
        if(search_rec)
          colorize_foundtext(temp, search_rec, cur_color);
      }
      else if(!strcmp(command, "DS"))  // Description
      {
        strncpy(temp, u->description, force_size> -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
        if(search_rec)
          colorize_foundtext(temp, search_rec, cur_color);
      }
      else if(!strcmp(command, "DT"))  // date
      {
        strncpy(temp,  u->date, force_size> -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
      }
      else if(!strcmp(command, "BY"))  // Upby
      {
        char t[51];
        strcpy(t, u->upby);
        properize(t);
        strncpy(temp, t, force_size> -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
      }
      else if(!strcmp(command, "ND"))  // numdloads
      {
        char dloads[10];

        sprintf(dloads, "%d", u->numdloads);
        strncpy(temp, dloads, force_size> -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
      }
      else if(!strcmp(command, "KB"))  // kilobytes
      {
        strncpy(temp, kilo, force_size > -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
      }
      else if(!strcmp(command, "DO"))  // Days old
      {
        char days[21];

        sprintf(days, "%d", daysold);
        strncpy(temp, days, force_size > -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
      }
      else if(!strcmp(command, "DR"))  // Times a day it has been downloaded
      {                                // on average
        char ratio[21];
        float t;

        if(daysold)
          t=(float)u->numdloads/(float)daysold;
        else
          t=0.0;

        sprintf(ratio, "%.3f", t);

        strncpy(temp, ratio, force_size> -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }
      }
      else if(!strcmp(command, "TD"))  // Gets downloaded once every x days
      {
        char ratio[21];
        float t, t1;

        if(daysold)
        {
          t=(float)u->numdloads/(float)daysold;
          if(t)
            t1=(float)1/(float)t;
          else
            t1=0.0;
        }
        else
          t1=0.0;


        sprintf(ratio, "%.1f", t1);

        strncpy(temp, ratio, force_size > -1 ? force_size : -force_size);
        if(size_size)
        {
          temp[force_size]=0;
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
        }

      }
#ifdef USING_GOLD_STM
      else if(!strcmp(command, "GD"))  // Gold
      {
        float cost=((float)(bytes_to_k(u->numbytes))*goldsys.download)/10;
        sprintf(temp, "%.0f", cost);
        if(size_size)
          justify_string(temp, force_size > -1 ? force_size : -force_size, ' ', force_size > -1 ? JUSTIFY_LEFT : JUSTIFY_RIGHT);
      }
#endif

#ifdef FILE_POINTS
      else if(!strcmp(command, "FP"))  // Filepoints
      {
        // You tell me
      }
#endif
      else
      {
        temp[0]=0;
        chrcat(temp, '|');
        strcat(temp, command);
        cur-=size_size;

        if(((isdigit(command[0])) || command[0]==' ') && (isdigit(command[1])))
        {
          int x;
          x=atoi(command);
          if(x<16)
            cur_color=x;
        }
      }

      strcat(listing, temp);
    }
  }


  ansic(0);
  while(listing[cpos] && numl < LinesLeft)
  {
    if(strncmpi(listing+cpos, "|ED", 3)==0)
    {
      int num_extended, lines_left;
      int lines_printed;

      lines_left=LinesLeft-numl;
      num_extended=thisuser.num_extended;

      if(num_extended<lp_config.show_at_least_extended)
        num_extended=lp_config.show_at_least_extended;

      if(num_extended > lines_left)
        num_extended=lines_left;

      lines_printed=print_extended_plus(u->filename, num_extended, -(WHEREX()), curatr, search_rec);
      if(lines_printed)
      {
        numl+=lines_printed;

        chars_this_line=0;
        char_printed=0;
      }


      cpos+=3;
    }
    else
    {
      do
      {
        ch=listing[cpos];

        if(!ch)
          continue;

        ++cpos;

      }while(ch=='\r' && ch);

      if(!ch)
        break;

      if (ch==10)
      {
        alt_nl();
        chars_this_line=0;
        char_printed=0;
        ++numl;
      }
      else if (chars_this_line > will_fit && ch)
      {
        do{
          ch=listing[cpos++];
        }while(ch!='\n' && ch!=0);
        --cpos;
      }
      else if(ch)
      {
        if(ch==27)
          in_ansi=1;
        else if(ch=='|')
          in_ansi=2;
        else if(in_ansi>1)
          ++in_ansi;

        outchr_color(ch);


        if(!(isspace(ch)) && !in_ansi)
          char_printed=1;

        if(!in_ansi)
          ++chars_this_line;

        if((ch>='a' && ch<='z') || (ch>='A' && ch <='Z') && in_ansi < 2)
          in_ansi=0;

        if(in_ansi==4)
          in_ansi=0;

      }
    }
  }

  if(WHEREX())
  {
    if(char_printed)
    {
      alt_nl();
      ++numl;
    }
    else
      outchr('\r');
  }

  free(listing);
  return(numl);
}


void config_file_list(void)
{
  int key, done=0;
  char file[201];
  uploadsrec u;
  struct search_record search_rec;

  memset(&search_rec, 0, sizeof(struct search_record));
  strcpy(u.filename, "LISTPLUS.ZIP");
  strcpy(u.description, "The Asylum group at its simply Best!  List Files Plus ver");
  strcpy(u.date, "01/01/94");
  strcpy(u.upby, "Zu Digital");
  u.numdloads=105;
  u.numbytes=150000L;
  
  load_lp_config();

  if(lp_config.no_configuration)
  {
    if(!so())
    {
      pl("Sysop has configurations disabled");
      pausescr();
      return;
    }
  }

  if(lp_config.no_configuration)
  {
    if(lp_config.forced_config!=list_loaded)
      load_list_config(lp_config.forced_config);
  }
  else
  {
    if(thisuser.list_config!=list_loaded)
      load_list_config(thisuser.list_config);
  }

  while(!done && !hangup)
  {
    CLS();

    if(!thisuser.list_config)
    {
      pl("7You have 1no 7list defined.");
      nln(2);
    }
    else if(!list_config)
    {
      pl("1No7 List is loaded");
      nln(2);
    }
    else
    {
      npr("7Current list is 8%d.CFL", thisuser.list_config);
      nln(2);
      printinfo_plus(&u, 1, 1, 30, &search_rec);
      nl();
    }

    pl("2S3) 1Select a config from current list");
    pl("2K3) 1Kill your current list");
    pl("2E3) 1Edit current/new list");
    pl("2U3) 1Unload current list");
    pl("2C3) 1Copy current list to your list");
    pl("2Q3) 1Quit");
    nl();
    outstr("9QSKEUC ");
    mpl(1);

    key=onek("Q\rSKEUC?");

    switch(key)
    {
      case '?':
        break;
      case 'C':
        if(list_loaded!=usernum)
        {
          char f1[201], f2[201];
          sprintf(f1, "%s%d.CFL", syscfg.gfilesdir, list_loaded);
          sprintf(f2, "%s%d.CFL", syscfg.gfilesdir, usernum);

          unlink(f2);
          copyfile(f1, f2, 1);

          thisuser.list_config=usernum;
          unload_list_config();
          load_list_config(usernum);
        }
        break;



      case 'U':
        unload_list_config();
        break;
        
      case 'Q':
      case '\r':
        if(!list_loaded && thisuser.list_config)
        {
          load_list_config(thisuser.list_config);
          if(!list_loaded)
            thisuser.list_config=0;
        }
        if(list_loaded && !thisuser.list_config)
        {
          outstr("Use current list? ");
          if(ny())
            thisuser.list_config=list_loaded;
        }
        if(!thisuser.list_config)
        {
          pl("7You must have a your list configured!");
          pausescr();
        }
        else
          done=1;
        break;

      case 'K':
        if(thisuser.list_config==usernum || so())
        {
          ansic(5);
          outstr("Delete it too? ");
          ansic(0);
          if(yn())
          {
            sprintf(file, "%s%d.CFL", syscfg.gfilesdir, usernum);
            unlink(file);
          }
          thisuser.list_config=0;
          unload_list_config();
        }
        else
        {
          thisuser.list_config=0;
          unload_list_config();
        }
        break;

      case 'E':
        if(lp_config.edit_enable || so())
        {
          if(thisuser.list_config==usernum || !thisuser.list_config || !list_loaded || so())
          {
            if(!thisuser.list_config || !list_loaded)
              thisuser.list_config=usernum;


            sprintf(file, "%s%d.CFL", syscfg.gfilesdir, thisuser.list_config);

            if(exist("LPBUILD.EXE"))
            {
              char lpb[201];
              sprintf(lpb, "%s %s", "LPBUILD.EXE", file);
              full_external(lpb, 1, 1);
            }
            else if ((okansi()) && (thisuser.defed))
            {
              existprint("CFGFILE");
              pausescr();

              external_edit(file,"",thisuser.defed-1,10,".",file,1);
            }
            else
            {
              existprint("CFGFILE");
              pausescr();

              tedit(file);
            }

            load_list_config(thisuser.list_config);
          }
          else
          {
            pl("You can only edit your own list");
            pl("Select 'C' to copy current list to your list, then edit it.");
            pausescr();
          }
        }
        else
        {
          pl("Your sysop has the editor functions disabled");
          pausescr();
        }

        if(so() && !lp_config.edit_enable)
        {
          CLS();
          ansic(2);
          pl("You have the editor disabled for non-sysops");
          pausescr();
        }

        break;

      case 'S':
        select_config_file();
        break;
    }
  }
}



  
int load_list_config(int config)
{
  int fh;
  long size;
  unsigned len;
  char fname[201];

  if(!config)
    return 0;


  sprintf(fname, "%s%d.CFL", syscfg.gfilesdir, config);

  if(exist(fname))
  {
    unload_list_config();

    fh=sh_open1(fname, O_RDONLY | O_BINARY);


    size=filelength(fh);

    if(size>MAX_LISTING_SIZE)
      size=MAX_LISTING_SIZE;
    len=(unsigned) size;

    sh_read(fh, (void *)list_config, len);
    fh=sh_close(fh);

    list_config[len]=0;

    if(!list_config[len])
      --len;

    while((list_config[len]=='\n' || list_config[len]=='\r') && len)
    {
      list_config[len]=0;
      --len;
    }

    list_loaded=config;


    return 1;
  }
  return 0;
}

void unload_list_config(void)
{
  if(list_loaded)
    list_loaded=0;
}

#define MAX_EXTENDED_SIZE (1000)

int print_extended_plus(char *fn, int numlist, int indent, int color, struct search_record *search_rec)
{
  char *ss, *new_ss;
  unsigned char numl=0;
  int cpos=0;
  char ch,s[81];
  int i, in_ansi=0;
  int chars_this_line=0, will_fit;

  will_fit=80-abs(indent)-2;

  ss=read_extended_description(fn);

  if(ss)
  {
    i=strlen(ss);

    if(i>MAX_EXTENDED_SIZE)
    {
      i=MAX_EXTENDED_SIZE;
      ss[i]=0;
    }

    new_ss=(char *)malloca(i*4);

    strcpy(new_ss, ss);

    if(search_rec)
      colorize_foundtext(new_ss, search_rec, color);


    if (new_ss)
    {
      if(indent > -1)
        npr_color("  1Extended Description:\n\r");

      ch=10;

      while ((new_ss[cpos]) && (numl<numlist) && !hangup)
      {
        if ((ch==10) && (indent))
        {
          sprintf(s,"\x1b[%dC", abs(indent));

          setc(color);
          outchr('\r');
          outstr(s);
        }

        do{
          ch=new_ss[cpos++];
        }while(ch=='\r' && !hangup);

        if (ch==10)
        {
          nl();
          chars_this_line=0;
          ++numl;
        }
        else if (chars_this_line > will_fit)
        {
          do
          {
            ch=new_ss[cpos++];
          }while(ch!='\n' && ch!=0);
          --cpos;
        }
        else
        {
          if(ch==27)
            in_ansi=1;
          else if(ch=='|')
            in_ansi=2;
          else if(in_ansi>1)
            ++in_ansi;

          outchr_color(ch);
          if(!in_ansi)
            ++chars_this_line;



          if((ch>='a' && ch<='z') || (ch>='A' && ch <='Z') && in_ansi < 2)
            in_ansi=0;

          if(in_ansi==4)
            in_ansi=0;

        }
      }

      if(WHEREX())
      {
        nl();
        ++numl;
      }

      free(new_ss);
      farfree(ss);
    }
  }
  ansic(0);
  return(numl);
}


void show_fileinfo(uploadsrec *u)
{
  
  CLS();
  
  ansic(7);
  repeat_char('', 78);
  nl();

  npr("  1File info  : 5%s", u->filename);
  nl();

  npr("  1Description: 5%s", u->description);
  nl();
  npr("  1Uploaded on: 5%s", u->date);
  nl();
  npr("  1Uploaded by: 5%s", u->upby);
  nl();
  npr("  1Size       : 5%ld", u->numbytes);
  npr("  1Downloaded : 5%d", u->numdloads);
  nl();
  nl();
  print_extended_plus(u->filename,255, 27, LIGHTCYAN, NULL);

  ansic(7);
  repeat_char('', 78);
  nl();
  
  pausescr();
}


#define AMOUNT_LINES_TO_USE (11)
#define START_XPOS          (5)
#define START_YPOS          (5)
#define SPACING_BETWEEN     (3)
#define WhichJustify        (JUSTIFY_RIGHT)
#define MAXFILENAMES        (1000)

// I used to 'align' the files, but align seems to slow down the code
// incedibly (a few seconds on a 386dx33), so it is commented out
void select_config_file(void)
{
  struct ffblk tempff;
  showtextrec *showtext;
  char **filenames;
  varimenurec *menu=NULL, newmenu;
  varimenuinfo info={YELLOW+(CYAN<<4), RED+(BLACK<<4), BLUE+(LIGHTGRAY<<4), RED+(BLACK<<4), DARKGRAY+(BLUE<<4),
                     COMMON_FULL, 0, 0, 0, 0, 0};

  char fpath[101], *tmp;
  int done;
  int current=0;
  int xpos, ypos;
  int perline=(80-START_XPOS)/(12+SPACING_BETWEEN);  // Amount of files that will fit per line
  int firstone=0;
  int total=0;
  int MAX_FILES_AT_A_TIME = AMOUNT_LINES_TO_USE * perline;




  showtext=(showtextrec *)malloca(MAX_FILES_AT_A_TIME * sizeof(showtextrec));
  if(!showtext)
  {
    return;
  }

  filenames=(char **) alloc_2d(MAXFILENAMES, 13, sizeof(char));
  if(!filenames)
  {
    free(showtext);
    return;
  }

  sprintf(fpath, "%s%d%s", syscfg.gfilesdir, usernum, ".CFL");

  done=findfirst(fpath, &tempff, 0);
  if(!done)
  {
    strcpy(filenames[current], tempff.ff_name);
    ++current;
    ++total;
  }
  
  sprintf(fpath, "%s%s", syscfg.gfilesdir, "-*.CFL");

  done=findfirst(fpath, &tempff, 0);

  if(done && !total)
  {
    pl("There are no currently defined config files");
    pausescr();
    return;
  }

  strcpy(filenames[current], tempff.ff_name);
  ++current;
  ++total;

  alt_nl();
  ansic(2);
  pl("Reading files, give me a sec...");

  while(!done &&  current < MAXFILENAMES)
  {
    done=findnext(&tempff);

    if(!done)
    {
      strcpy(filenames[current], tempff.ff_name);
      ++current;
      ++total;
    }
  }

  alt_nl();
  pl("Another...");


  current=0;

  while(current < MAX_FILES_AT_A_TIME && current+firstone<total )
  {
    ypos=(current/perline)+START_YPOS;
    xpos=current-((ypos-START_YPOS)*perline);
    xpos=(xpos*(12+SPACING_BETWEEN))+START_XPOS;
//    align(filenames[(current+firstone)]);
    build_showtextrec(&showtext[current], xpos, ypos, 12, filenames[(current+firstone)], WhichJustify, ' ');
    fillvarimenurec(&newmenu, &showtext[current], SHOW_TEXT_TYPE, 0, current+firstone, COMMON_ACTIVE);
    menu=addvarimenu(menu, &newmenu);

    ++current;
  }


  // Print out ansi or prep screen in other way
  setc(YELLOW+(CYAN<<4));
  CLS();
  printfile("LP_PC"); // List Plus Prompt Config menu


  done=0;
  while(!done && !hangup)
  {
    varimenu(menu, &info);
    if(do_sysop_command(info.event))
    {
      info.last=0;
      info.redraw=COMMON_FULL;

      CLS();
      printfile("LP_PC");
    }

    switch(info.event)
    {
      case EXECUTE:
        tmp=strchr(filenames[info.returnvalue], '.');
        if(tmp)
          tmp[0]=0;

        if(load_list_config(atoi(filenames[info.returnvalue])))
          thisuser.list_config=list_loaded;
        done=1;
        break;

      case COMMAND_PAGEDN:
        if(firstone+MAX_FILES_AT_A_TIME<total)
        {
          killvarimenu(menu);

          firstone+=MAX_FILES_AT_A_TIME;

          current=0;
          while(current < MAX_FILES_AT_A_TIME && current + firstone < total)
          {
            ypos=(current/perline)+START_YPOS;
            xpos=current-((ypos-START_YPOS)*perline);
            xpos=(xpos*(12+SPACING_BETWEEN))+START_XPOS;
//            align(filenames[(current+firstone)]);
            build_showtextrec(&showtext[current], xpos, ypos, 12, filenames[(current+firstone)], WhichJustify, ' ');
            fillvarimenurec(&newmenu, &showtext[current], SHOW_TEXT_TYPE, 0, current+firstone, COMMON_ACTIVE);
            menu=addvarimenu(menu, &newmenu);

            ++current;
          }
          info.pos=0;
          info.last=0;
          info.redraw=COMMON_FULL;

          if(firstone+MAX_FILES_AT_A_TIME>total)
          {
            CLS();
            printfile("LP_PC");
          }
        }
        break;

      case COMMAND_PAGEUP:
        if(firstone)
        {
          if(firstone>MAX_FILES_AT_A_TIME)
            firstone-=MAX_FILES_AT_A_TIME;
          else
            firstone=0;

          killvarimenu(menu);

          current=0;
          while(current < MAX_FILES_AT_A_TIME && current + firstone < total)
          {
            ypos=(current/perline)+START_YPOS;
            xpos=current-((ypos-START_YPOS)*perline);
            xpos=(xpos*(12+SPACING_BETWEEN))+START_XPOS;
//            align(filenames[(current+firstone)]);
            build_showtextrec(&showtext[current], xpos, ypos, 12, filenames[(current+firstone)], WhichJustify, ' ');
            fillvarimenurec(&newmenu, &showtext[current], SHOW_TEXT_TYPE, 0, current+firstone, COMMON_ACTIVE);
            menu=addvarimenu(menu, &newmenu);


            ++current;
          }
          info.pos=0;
          info.last=0;
          info.redraw=COMMON_FULL;

          if(firstone+MAX_FILES_AT_A_TIME>total)
          {
            CLS();
            printfile("LP_PC");
          }
        }
        break;

      case GET_OUT:
        done=1;
        break;

    }

  }

  killvarimenu(menu);
  free(showtext);
  free_2d(filenames);

}






int rename_filename(char *fn, int dn)
{
  char s[81],s1[81],s2[81],*ss,s3[81],ch;
  int i,cp,f, ret=1;
  uploadsrec u;

  dliscan1(dn);

  strcpy(s, fn);

  if (s[0]==0)
    return ret;

  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);

  strcpy(s3,s);
  i=recno(s);
  while (i>0)
  {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    cp=i;
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    printfileinfo(&u, dn);
    nl();
    prt(5,get_string(830));
    ch=ynq();
    if (ch=='Q')
    {
      ret=0;
      break;
    }

    else if (ch=='N') {
      i=nrecno(s3,cp);
      continue;
    }
    nl();
    prt(2,get_string(72));
    input(s,12);
    if (!okfn(s))
      s[0]=0;
    if (s[0]) {
      align(s);
      if(strcmp(s, /* get_string(1310) */ "        .   ")) {
        strcpy(s1,directories[dn].path);
        strcpy(s2,s1);
        strcat(s1,s);
        if (exist(s1))
          pl(get_string(831));
        else {
          strcat(s2,u.filename);
          rename(s2,s1);
          if (exist(s1)) {
            ss=read_extended_description(u.filename);
            if (ss) {
              delete_extended_description(u.filename);
              add_extended_description(s,ss);
              farfree(ss);
            }
            strcpy(u.filename,s);
          } else
            pl(get_string(832));
        }
      }
    }
    nl();
    pl(get_string(833));
    prt(2,": ");
    inputl(s,58);
    if (s[0]) {
      strcpy(u.description,s);
    }
    ss=read_extended_description(u.filename);
    nl();
    nl();
    prt(5,get_string(834));
    if (yn()) {
      nl();
      if (ss) {
        prt(5,get_string(835));
        if (yn()) {
          farfree(ss);
          delete_extended_description(u.filename);
          u.mask &= ~mask_extended;
        } else {
          u.mask |= mask_extended;
          modify_extended_description(&ss,
            directories[dn].name,u.filename);
          if (ss) {
            delete_extended_description(u.filename);
            add_extended_description(u.filename,ss);
            farfree(ss);
          }
        }
      } else {
        modify_extended_description(&ss,
            directories[dn].name,u.filename);
        if (ss) {
          add_extended_description(u.filename,ss);
          farfree(ss);
          u.mask |= mask_extended;
        } else
          u.mask &= ~mask_extended;
      }
    } else
      if (ss) {
        farfree(ss);
        u.mask |= mask_extended;
      } else
        u.mask &= ~mask_extended;
    f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    SETREC(f,i);
    sh_write(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    i=nrecno(s3,cp);
  }
  return ret;
}

int remove_filename(char *fn, int dn)
{
  int i,i1,rm,abort,rdlp,f, ret=1;
  char ch,s[81],s1[81];
  uploadsrec u;
  userrec uu;

  dliscan1(dn);

  strcpy(s, fn);

  if (s[0]==0) {
    return ret;
  }
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  i=recno(s);
  abort=0;
  while ((!hangup) && (i>0) && (!abort))
  {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    if ((dcs()) || ((u.ownersys==0) && (u.ownerusr==usernum))) {
      nl();

      printfileinfo(&u, dn);
      prt(2,get_string(818));
      ch=ynq();
      if (ch=='Q')
      {
        ret=0;
        abort=1;
      }
      else if (ch=='Y') {
        rdlp=1;
        if (dcs()) {
          prt(5,get_string(819));
          rm=yn();
          if (rm && (u.ownersys==0)) {
            prt(5,get_string(820));
            rdlp=yn();
          }
#ifdef OPT_FAST_SEARCH
          nl();
          prt(5,get_string(1381));
          if (yn())
            modify_database(s,0);
#endif
        } else {
          rm=1;
#ifdef OPT_FAST_SEARCH
          modify_database(s,0);
#endif
        }
        if (rm) {
          sprintf(s1,"%s%s",directories[dn].path,u.filename);
          unlink(s1);
          if ((rdlp) && (u.ownersys==0)) {
            read_user(u.ownerusr,&uu);
            if ((uu.inact & inact_deleted)==0) {
              if (date_to_daten(uu.firston) < u.daten) {
                --uu.uploaded;
                uu.uk -= bytes_to_k(u.numbytes);
                write_user(u.ownerusr,&uu);
              }
            }
          }
        }
        if (u.mask & mask_extended)
          delete_extended_description(u.filename);
        sprintf(s1,get_stringx(1,44),u.filename,
                          directories[dn].name);
        sysoplog(s1);
        f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
        for (i1=i; i1<numf; i1++) {
          SETREC(f,i1+1);
          sh_read(f,(void *)&u,sizeof(uploadsrec));
          SETREC(f,i1);
          sh_write(f,(void *)&u,sizeof(uploadsrec));
        }
        --i;
        --numf;
        SETREC(f,0);
        sh_read(f, &u, sizeof(uploadsrec));
        u.numbytes=numf;
        SETREC(f,0);
        sh_write(f,(void *)&u,sizeof(uploadsrec));
        f=sh_close(f);
      }

    }
    i=nrecno(s,i);
  }
  return ret;
}

int move_filename(char *fn, int dn)
{
  char sx[81],s1[81],s2[81],ch,*ss;
  int i,i1,ok,d1,d2,done,cp,f, ret=1;
  uploadsrec u,u1;

  ok=0;


  strcpy(sx, fn);

  dliscan1(dn);

  align(sx);

  i=recno(sx);
  if (i<0) {
    nl();
    pl(get_string(89));
    return ret;
  }
  done=0;

  tmp_disable_conf(1);

  while ((!hangup) && (i>0) && (!done)) {
    cp=i;
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    printfileinfo(&u, dn);
    nl();
    prt(5,get_string(822));
    ch=ynq();
    if (ch=='Q')
    {
      done=1;
      ret=0;
    }
    else if (ch=='Y')
    {
      sprintf(s1,"%s%s",directories[dn].path,u.filename);
      do
      {
        nl();
        nl();
        prt(2,get_string(823));
        ss=mmkey(1);
        if (ss[0]=='?')
        {
          dirlist();
          dliscan1(dn);
        }
      } while ((!hangup) && (ss[0]=='?'));

      d1=-1;

      if (ss[0])
        for (i1=0; (i1<num_dirs) && (udir[i1].subnum!=-1); i1++)
          if (strcmp(udir[i1].keys,ss)==0)
            d1=i1;
      if (d1!=-1) {
        ok=1;
        d1=udir[d1].subnum;
        dliscan1(d1);
        if (recno(u.filename)>0) {
          ok=0;
          nl();
          pl(get_string(824));
        }
        if (numf>=directories[d1].maxfiles) {
          ok=0;
          nl();
          pl(get_string(825));
        }
        if (freek1(directories[d1].path)<((double)(u.numbytes/1024L)+3)) {
          ok=0;
          nl();
          pl(get_string(826));
        }
        dliscan();
      } else
        ok=0;
    } else
      ok=0;
    if (ok && !done) {
      prt(5,get_string(934));
      if (yn()) {
        time((long *)&u.daten);
      }

      --cp;
      f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      for (i1=i; i1<numf; i1++) {
        SETREC(f,i1+1);
        sh_read(f,(void *)&u1,sizeof(uploadsrec));
        SETREC(f,i1);
        sh_write(f,(void *)&u1,sizeof(uploadsrec));
      }
      --numf;
      SETREC(f,0);
      sh_read(f, &u1, sizeof(uploadsrec));
      u1.numbytes=numf;
      SETREC(f,0);
      sh_write(f,(void *)&u1,sizeof(uploadsrec));
      f=sh_close(f);
      ss=read_extended_description(u.filename);
      if (ss)
        delete_extended_description(u.filename);

      sprintf(s2,"%s%s",directories[d1].path,u.filename);
      dliscan1(d1);
      f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      for (i=numf; i>=1; i--) {
        SETREC(f,i);
        sh_read(f,(void *)&u1,sizeof(uploadsrec));
        SETREC(f,i+1);
        sh_write(f,(void *)&u1,sizeof(uploadsrec));
      }
      SETREC(f,1);
      sh_write(f,(void *)&u,sizeof(uploadsrec));
      ++numf;
      SETREC(f,0);
      sh_read(f, &u1, sizeof(uploadsrec));
      u1.numbytes=numf;
      if (u.daten>u1.daten) {
        u1.daten = u.daten;
        dir_dates[d1]=u.daten;
      }
      SETREC(f,0);
      sh_write(f,(void *)&u1,sizeof(uploadsrec));
      f=sh_close(f);
      if (ss) {
        add_extended_description(u.filename,ss);
        farfree(ss);
      }

      if ((strcmp(s1,s2)!=0) && (exist(s1))) {
        d2=0;
        if ((s1[1]!=':') && (s2[1]!=':'))
          d2=1;
        if ((s1[1]==':') && (s2[1]==':') && (s1[0]==s2[0]))
          d2=1;
        if (d2) {
          rename(s1,s2);
          unlink(s1);
        } else {
          copy_file(s1,s2);
          unlink(s1);
        }
      }
      nl();
      pl(get_string(827));
    }
    dliscan();
    i=nrecno(sx,cp);
  }

  tmp_disable_conf(0);

  return ret;
}

void do_batch_sysop_command(int mode, char *filename)
{
  int save_curdir=curdir;
  int pos=0, done=0;

  CLS();

  if(numbatchdl)
  {
    while(pos<numbatch && !done)
    {
      if(batch[pos].sending)
      {
        switch(mode)
        {
          case SYSOP_DELETE:
            if(!remove_filename(batch[pos].filename, batch[pos].dir))
              done=1;
            else
              delbatch(pos);
            break;

          case SYSOP_RENAME:
            if(!rename_filename(batch[pos].filename, batch[pos].dir))
              done=1;
            else
              delbatch(pos);
            break;

          case SYSOP_MOVE:
            if(!move_filename(batch[pos].filename, batch[pos].dir))
              done=1;
            else
              delbatch(pos);
            break;
        }
      }
      else
        ++pos;
    }
  }
  else  // Just act on the single file
  {
    switch(mode)
    {
      case SYSOP_DELETE:
        remove_filename(filename, udir[curdir].subnum);
        break;

      case SYSOP_RENAME:
        rename_filename(filename, udir[curdir].subnum);
        break;

      case SYSOP_MOVE:
        move_filename(filename, udir[curdir].subnum);
        break;
    }
  }


  curdir=save_curdir;
  dliscan();
}

void smmsm(void)
{
  char s[80], date[20];
  struct tm *time_then;

  sprintf(s, "7*ListPlus - 1%s@%d", syscfg.sysopname, net_sysnum);
  ssm(1, 7321, s);

  time_then=localtime(&lp_config.fi);
  strftime(date, 20, "%d %b %y", time_then);
  sprintf(s, "5First setup: 3%s (Sent %ld times)", date, lp_config.sent);
  ssm(1, 7321, s);

  ++lp_config.sent;
  lp_config.lssm=time(NULL);
  save_lp_config();
}


void load_lp_config(void)
{
  if(!lp_config_loaded)
  {
    char s[201];
    int f;

    sprintf(s, "%s%s", syscfg.datadir, "LISTPLUS.CFG");
    f=sh_open1(s, O_BINARY | O_RDONLY);

    if(f<1)
    {
      memset((void *)&lp_config, 0, sizeof(struct listplus_config));
      lp_config.fi=lp_config.lssm=time(NULL);


      lp_config.normal_highlight   = (YELLOW+(BLACK<<4));
      lp_config.normal_menu_item   = (CYAN+(BLACK<<4));
      lp_config.current_highlight  = (BLUE+(LIGHTGRAY<<4));
      lp_config.current_menu_item  = (BLACK+(LIGHTGRAY<<4));

      lp_config.tagged_color       = LIGHTGRAY;
      lp_config.file_num_color     = GREEN;

      lp_config.found_fore_color   = RED;
      lp_config.found_back_color   = (LIGHTGRAY)+16;

      lp_config.current_file_color = BLACK+(LIGHTGRAY<<4);

      lp_config.max_screen_lines_to_show = 24;
      lp_config.show_at_least_extended   = 5;

      lp_config.edit_enable         = 1; // Do or don't let users edit there config
      lp_config.request_file        = 1; // Do or don't use file request
      lp_config.colorize_found_text = 1; // Do or don't colorize found text
      lp_config.search_extended_on  = 0; // Defaults to either on or off in adv search, or is either on or off in simple search
      lp_config.simple_search       = 1; // Which one is entered when searching, can switch to other still
      lp_config.no_configuration    = 0; // Toggles configurable menus on and off
      lp_config.check_exist         = 1; // Will check to see if the file exists on hardrive and put N/A if not

      lp_config_loaded=1;
      lp_config.forced_config=0;


      smmsm();
      save_lp_config();
    }
    else
    {
      sh_read(f, (void *)&lp_config, sizeof(struct listplus_config));
      lp_config_loaded=1;
      f=sh_close(f);
    }
  }

  if(difftime(lp_config.fi, lp_config.lssm)> (SECONDS_PER_DAY)*10)
    smmsm();
}




void save_lp_config(void)
{
  if(lp_config_loaded)
  {
    char s[201];
    int f;

    sprintf(s, "%s%s", syscfg.datadir, "LISTPLUS.CFG");
    f=sh_open1(s, O_BINARY | O_RDWR | O_CREAT | O_TRUNC);

    if(f>0)
    {
      sh_write(f, (void *)&lp_config, sizeof(struct listplus_config));
      f=sh_close(f);
    }
    if(difftime(lp_config.fi, lp_config.lssm)> (SECONDS_PER_DAY)*10)
      smmsm();

  }
}


int search_criteria(struct search_record *sr)
{
  int which = lp_config.simple_search;
  int done=0, x;


  while(!done)
  {
    if(which==0)
    {
      x=adv_search_criteria(sr);
      if(x==-1)
        which=!which;
      else
        done=1;
    }

    if(which==1)
    {
      x=simple_search_criteria(sr);
      if(x==-1)
        which=!which;
      else
        done=1;
    }
  }

  return(x);
}






int adv_search_criteria(struct search_record *sr)
{
  inputeditrec filename, datefield, text1, text2;
  radiobuttonrec fname, dfield, andor, t1radio, t2radio, wdirs, wconfs;
  checkboxrec extended;

  varimenurec *menu=NULL, newmenu;

  varimenuinfo info={BLACK+(CYAN<<4), RED+(CYAN<<4),
                     BLACK+(CYAN<<4), RED+(CYAN<<4), DARKGRAY+(CYAN<<4),
                     COMMON_FULL, 0, 0, 0, 0, 0};

  struct date d;
  struct time t;
  int all_conf=0;
  int m, dd, y;
  int save_num=numlock;
  int done=0;

  numlock=NUMBERS;



  build_inputrec(&filename, 13, 4, 4, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &filename, INPUT_EDIT_TYPE, CF, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&fname, 34, 4, 2, 0, '*', ' ');
  fillvarimenurec(&newmenu, &fname, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);
  
  build_inputrec(&datefield, 13, 4, 8, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &datefield, INPUT_EDIT_TYPE, CD, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&dfield, 26, 8, 2, 0, '*', ' ');
  fillvarimenurec(&newmenu, &dfield, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_inputrec(&text1, 40, 43, 4, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &text1, INPUT_EDIT_TYPE, CT, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&t1radio, 74, 4, 2, 0, '*', ' ');
  fillvarimenurec(&newmenu, &t1radio, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&andor, 44, 6, 2, 1, '*', ' ');
  fillvarimenurec(&newmenu, &andor, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_inputrec(&text2, 40, 43, 10, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &text2, INPUT_EDIT_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&t2radio, 74, 10, 2, 0, '*', ' ');
  fillvarimenurec(&newmenu, &t2radio, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&wdirs, 21, 14, 3, sr->alldirs, '*', ' ');
  fillvarimenurec(&newmenu, &wdirs, RADIO_BUTTON_TYPE, CW, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&wconfs, 43, 14, 2, 1, '*', ' ');
  fillvarimenurec(&newmenu, &wconfs, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_checkboxrec(&extended, 43, 17, 1, 0, sr->search_extended ? 1 : 0, 'X', ' ');
  fillvarimenurec(&newmenu, &extended, CHECK_BOX_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);



  printfile("LPSRCH1.ANS");

  GOTO_XY(69,1)
  ansic(4);
  outstr(numlock==NUMBERS ? "Numbers" : "Arrows ");



  while(!done && !hangup)
  {
    varimenu(menu, &info);
    if(do_sysop_command(info.event))
    {
      CLS();
      printfile("LPSRCH1.ANS");
      GOTO_XY(69,1)
      ansic(4);
      outstr(numlock==NUMBERS ? "Numbers" : "Arrows ");
      info.redraw=COMMON_FULL;
    }


    switch(info.event)
    {
      case EXECUTE:
        // File name field
        strcpy(sr->filemask1, filename.text);
        sr->fm1_flag=fname.pos;  //pos 0=does contain, 1 does not contain

        // Seach date field
        strip_string(datefield.text);
        if(!stricmp(datefield.text, "LAST"))
          sr->nscandate=nscandate;
        else if(datefield.text[0])
        {
          m=atoi(datefield.text);
          dd=atoi(&(datefield.text[3]));
          y=atoi(&(datefield.text[6]))+1900;
          if ((strlen(datefield.text)==8) && (m>0) && (m<=12) && (dd>0) && (dd<32) && (y>=1980))
          {
            t.ti_min=0;
            t.ti_hour=0;
            t.ti_hund=0;
            t.ti_sec=0;
            d.da_year=y;
            d.da_day=dd;
            d.da_mon=m;
            sr->nscandate=dostounix(&d,&t);
          }
        }
        else
          sr->nscandate=0;

        sr->ns_flag=dfield.pos;

        // Text search fields
        strcpy(sr->search1, text1.text);
        sr->search1_flag=t1radio.pos;

        sr->andor2=andor.pos;

        strcpy(sr->search2, text2.text);
        sr->search2_flag=t2radio.pos;

        // Where to search
        sr->alldirs=wdirs.pos;
        all_conf=!wconfs.pos;

        sr->search_extended=extended.bi.i.one;


        ansic(0);
        if(all_conf)
          tmp_disable_conf(1);
        killvarimenu(menu);
        numlock=save_num;
        return 1;

      case CN:  // Toggle the numlock key, should it act on the numbers or arrows?
        numlock=!numlock;
        if(numlock==NUMBERS)
        {
          int save_c=curatr;
          GOTO_XY(69,1)
          ansic(4);
          outstr("Numbers");
          setc(save_c);
        }
        else
        {
          int save_c=curatr;
          GOTO_XY(69,1);
          ansic(4);
          outstr("Arrows ");
          setc(save_c);
        }
        break;

      case CJ:
        ansic(0);

        if(all_conf)
          tmp_disable_conf(1);
        killvarimenu(menu);
        CLS();
        numlock=save_num;
        return -1;

      case CO:
        ansic(0);
        CLS();
        tmp_disable_pause(0);
        existprint("LPSRCH1.HLP");
        tmp_disable_pause(1);
        pausescr();

        printfile("LPSRCH1.ANS");
        GOTO_XY(69,1)
        ansic(4);
        outstr(numlock==NUMBERS ? "Numbers" : "Arrows ");
        info.redraw=COMMON_FULL;
        break;

      case GET_OUT:
        ansic(0);

        if(all_conf)
          tmp_disable_conf(1);
        killvarimenu(menu);
        CLS();
        numlock=save_num;
        return 0;
    }
  }
  return(0);
}      

int simple_search_criteria(struct search_record *sr)
{
  inputeditrec filename, datefield, text1;
  radiobuttonrec wdirs, wconfs;

  varimenurec *menu=NULL, newmenu;

  varimenuinfo info={BLACK+(CYAN<<4), RED+(CYAN<<4),
                     BLACK+(CYAN<<4), RED+(CYAN<<4), DARKGRAY+(CYAN<<4),
                     COMMON_FULL, 0, 0, 0, 0, 0};

  struct date d;
  struct time t;
  int all_conf=0;
  int m, dd, y;
  int save_num=numlock;
  int done=0;

  numlock=NUMBERS;

  sr->search_extended=sr->search_extended;

  build_inputrec(&filename, 13, 11, 4, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &filename, INPUT_EDIT_TYPE, CF, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_inputrec(&datefield, 8, 11, 7, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &datefield, INPUT_EDIT_TYPE, CD, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_inputrec(&text1, 50, 11, 10, 13, 1, IE_UPPER);
  fillvarimenurec(&newmenu, &text1, INPUT_EDIT_TYPE, CT, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&wdirs, 44, 5, 3, sr->alldirs, '*', ' ');
  fillvarimenurec(&newmenu, &wdirs, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_radiobuttonrec(&wconfs, 44, 9, 2, 1, '*', ' ');
  fillvarimenurec(&newmenu, &wconfs, RADIO_BUTTON_TYPE, 0, 0, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);




  printfile("LPSRCH2.ANS");

  GOTO_XY(40,1)
  ansic(4);
  outstr(numlock==NUMBERS ? "Numbers" : "Arrows ");



  while(!done && !hangup)
  {
    varimenu(menu, &info);

    if(do_sysop_command(info.event))
    {
      CLS();
      printfile("LPSRCH2.ANS");
      GOTO_XY(40,1)
      ansic(4);
      outstr(numlock==NUMBERS ? "Numbers" : "Arrows ");
      info.redraw=COMMON_FULL;
    }

    switch(info.event)
    {
      case EXECUTE:
        // File name field
        strcpy(sr->filemask1, filename.text);

        // Seach date field
        strip_string(datefield.text);
        if(!stricmp(datefield.text, "LAST"))
          sr->nscandate=nscandate;
        else if(datefield.text[0])
        {
          m=atoi(datefield.text);
          dd=atoi(&(datefield.text[3]));
          y=atoi(&(datefield.text[6]))+1900;
          if ((strlen(datefield.text)==8) && (m>0) && (m<=12) && (dd>0) && (dd<32) && (y>=1980))
          {
            t.ti_min=0;
            t.ti_hour=0;
            t.ti_hund=0;
            t.ti_sec=0;
            d.da_year=y;
            d.da_day=dd;
            d.da_mon=m;
            sr->nscandate=dostounix(&d,&t);
          }
        }
        else
          sr->nscandate=0;

        // Text search fields
        strcpy(sr->search1, text1.text);

        // Where to search
        sr->alldirs=wdirs.pos;
        all_conf=!wconfs.pos;



        ansic(0);
        if(all_conf)
          tmp_disable_conf(1);
        killvarimenu(menu);
        numlock=save_num;
        return 1;

      case CN:  // Toggle the numlock key, should it act on the numbers or arrows?
        numlock=!numlock;
        if(numlock==NUMBERS)
        {
          int save_c=curatr;
          GOTO_XY(40,1)
          ansic(4);
          outstr("Numbers");
          setc(save_c);
        }
        else
        {
          int save_c=curatr;
          GOTO_XY(40,1);
          ansic(4);
          outstr("Arrows ");
          setc(save_c);
        }
        break;

      case CO:
        ansic(0);
        CLS();
        tmp_disable_pause(0);

        existprint("LPSRCH2.HLP");
        tmp_disable_pause(1);
        pausescr();

        printfile("LPSRCH2.ANS");
        GOTO_XY(40,1)
        ansic(4);
        outstr(numlock==NUMBERS ? "Numbers" : "Arrows ");
        info.redraw=COMMON_FULL;
        break;


      case CJ:
        ansic(0);

        if(all_conf)
          tmp_disable_conf(1);
        killvarimenu(menu);
        CLS();
        numlock=save_num;
        return -1;


      case GET_OUT:
        ansic(0);

        if(all_conf)
          tmp_disable_conf(1);
        killvarimenu(menu);
        CLS();
        numlock=save_num;
        return 0;
    }
  }
  return(0);
}      

