#if !defined(WINEXT_H)
#define WINEXT_H

#if defined(__cplusplus)
extern "C" {
#endif // __cplusplus

//
// WINEXT.H - additional windows definitions
//
// Version 1.0  03/21/89  Copyright (C) 1989,90,91,92 Lantern Coroporation.
// Author: Edward Hutchins
// Status: Freeware
// Revisions:
// 06/06/90 modified HUGE to LARGE to preserve compatibility with math.h
//          also nested windows.h include to prevent modifications on the
//          actual source file - Ed.
// 10/01/90 added CONST and CONSTP,NP,LP,HP and a few comments - Ed.
// 08/28/91 added EXPORT and SEGMENT - Ed.
// 10/28/91 added DLLEXP - Ed.
// 11/02/91 posted on Compuserve - Ed.
// 11/09/91 added REGISTER - Ed.
// 11/19/91 added ATOM pointer types - Ed.
// 01/02/92 fixed to work with win31 beta II - Ed.
// 01/03/92 added #define STRICT before #include <windows.h> - Ed.
// 01/03/92 #included <windowsx.h> - Ed.
// 02/26/92 added check for NOSTRICT - Ed.
// 02/29/92 added the neat macro wrappers BEGINMACRO and ENDMACRO - Ed.
//

//
// include WINDOWS.H, if needed
//

#if !defined(WINDOWS_H)
	#if defined(NULL)
		#undef NULL
	#endif
	#if !defined(NOSTRICT)
		#define STRICT
	#endif
	#include <windows.h>
	#include <windowsx.h>
	#if !defined(NULL)
		#define NULL 0
	#endif
	#define WINDOWS_H
#endif // WINDOWS_H

//
// extra data types and defines
//

#define LARGE huge
// CDECL now lives in windows.h
#define CONST const
#define HNULL NULL
#define LPNULL NULL

typedef char        CHAR;
typedef int         INT;
typedef float       FLOAT;
typedef double      DOUBLE;
typedef long double LDOUBLE;

// extend the string type
typedef CHAR LARGE *HPSTR;
typedef CONST CHAR LARGE *HPCSTR;

// useful macros for typedefing pointers to objects
#define npointerdef(o) typedef o NEAR * NP ## o
#define lpointerdef(o) typedef o FAR * LP ## o
#define hpointerdef(o) typedef o LARGE * HP ## o
#define pointerdef(o) npointerdef(o); lpointerdef(o); hpointerdef(o)

// define the different kinds of pointers to things
pointerdef( BOOL );
npointerdef( BYTE ); hpointerdef( BYTE );
pointerdef( CHAR );
npointerdef( INT ); hpointerdef( INT );
pointerdef( UINT );
npointerdef( WORD ); hpointerdef( WORD );
npointerdef( LONG ); hpointerdef( LONG );
npointerdef( DWORD ); hpointerdef( DWORD );
pointerdef( FLOAT );
pointerdef( DOUBLE );
pointerdef( LDOUBLE );
npointerdef( HANDLE ); hpointerdef( HANDLE );
npointerdef( VOID ); hpointerdef( VOID );
pointerdef( ATOM );

// common pointers to handles
pointerdef( HANDLE );
pointerdef( HWND );
pointerdef( HDC );

// these are here for compatibility - use NPVOID etc...
typedef VOID NEAR *NPMEM;
typedef VOID FAR *LPMEM;

// WNDPROC function pointer now lives in windows.h

//
// scope protocol definitions
//

#define GLOBAL      // GLOBAL
#define LOCAL       static
#define IMPORT      extern
#define FROM(where) // FROM where
#define PROTO       // PROTOTYPE

// misc stuff
#define REGISTER register
#define EXPORT _export
#define SEGMENT _segment
#define VOLATILE volatile

// multi-line statement grouping macros (fixes if {}; else problem)
#define BEGINMACRO do{
#define ENDMACRO }while(0)

// sizeof array
#define sizeofarray(x) (sizeof(x)/sizeof((x)[0]))

#if defined(__cplusplus)
}
#endif // __cplusplus

// c++ class export type
#if defined(__DLL__)
#define DLLEXP EXPORT
#else
#define DLLEXP LARGE
#endif

#endif // WINEXT_H
