@echo off
rem $Id: lwp_chk.bat 1.1 95/03/21 22:50:52 frotz Exp $
rem $Source: h:/prod/lwp/patches/rcs/lwp_chk.bat $
rem $Locker:  $

echo.
echo.	%0:  LAN WorkPlace installation checker.
echo.	(C) Copyright 1995 Novell, Inc.  All Rights Reserved.
echo.

rem
rem NOTE:  This batch file expects at least 280 bytes of free environment space.
rem
rem ASSUMPTION: \WINDOWS and \NET are on the same drive.
rem             (Shouldn't be harmful if they are on different drives.)
rem

rem
rem ALGORITHM:
rem	[0] Handle command line parameters.
rem	[1] Make sure the Environment is big enough.
rem	[2] Create support batch files.
rem	[3] Find specific named files for the current collection on the PATH.
rem	[4] Make sure that the file found is where we expect it and not
rem	    upstream from where we expect it (for multiple versions of
rem	    LAN WorkPlace).
rem	[5] Post notices for files that were found in non-standard places.
rem	[6] Remove the support batch files.

rem
rem NOTE: Certain lines have the redirection symbols (greater-than
rem	  and double-greater-than) close to the end of the text.
rem	  Other lines have this moved off to the end of the line
rem	  for readability.  This is by design.  Those lines that
rem	  are less than readable are that way to avoid problems in
rem	  processing by COMMAND.COM (or your current shell).
rem
rem	  DO NOT CHANGE THESE LINES.
rem

rem
rem VARIABLES:
rem	_DRIVE	\NET directory tree drive.  Default: C:
rem	_FILE	Current file to find on path.
rem	_MSG	Message displayed when file is found.
rem	_VRSN	Product Version (if we can determine it).
rem	_PATH	Path where %_FILE% should be found.
rem	_PTH	Path where %_FILE% was actually found.
rem	_FOUND	Flag indicating that the file has been found.
rem	_TYPE	Type of file that we're looking for.
rem

set me=%0
if  (%1)==()	echo Recursing: %me% 3 A B C D L K T W X I BAT P 
if  (%1)==()	%me% 3 A B C D L K T W X I BAT P 
if  (%1)==(-h)	goto USAGE
if  (%1)==(-H)	goto USAGE
if  (%1)==(-?)	goto USAGE
if  (%1)==(/h)	goto USAGE
if  (%1)==(/H)	goto USAGE
if  (%1)==(/?)	goto USAGE
if  (%1)==(?)	goto USAGE

set _msg=00000
set _drive=1234567890123456789012345678901234567890> nul
set _file=1234567890123456789012345678901234567890> nul
set _pth=1234567890123456789012345678901234567890> nul
set _vrsn=1234567890123456789012345678901234567890> nul
set _path=1234567890123456789012345678901234567890> nul
if  (%_drive%)==(1234567890123456789012345678901234567890)	set _msg=10000
if  (%_file%)==(1234567890123456789012345678901234567890)	set _msg=11000
if  (%_pth%)==(1234567890123456789012345678901234567890)	set _msg=11100
if  (%_path%)==(1234567890123456789012345678901234567890)	set _msg=11110
if  (%_vrsn%)==(1234567890123456789012345678901234567890)	set _msg=11111
if  (%_msg%)==(11111) goto BEGIN
goto ENVIRONMENT




:USAGE
echo usage:
echo %me% [-h] [drive:] [3] [A] [B] [C] [D] [L] [K] [T] [W] [X] [I] [P] [BAT]
echo where:
echo    -h	- Displays this screen
echo	drive:	- the drive letter where \NET\BIN was installed on.
echo	3	- 3270 support identification
echo	A	- DOS application identification
echo	B	- WWW Browser identification
echo	C	- NFS Client support identification
echo	D	- Serial support identification
echo	L	- NLM identification
echo	K	- Toolkit identification
echo	T	- Protocol Stack identification
echo	W	- Windows support identification
echo	V	- VLM / NETX / IPXODI / LSL 
echo	X	- X/Server support identification
echo	I	- .INI or .CFG identification
echo	BAT	- Standard network batch identification
echo	P	- patch signature identification
echo.
echo Invoke %me% with one or more of the parameters to identify the
echo current version information for selected modules.
echo.
echo NOTE: %me% calls LWP_LOG.BAT.  This file must be on the path (or in
echo the current directory).
goto END




:ENVIRONMENT
rem
rem	We're in trouble.  Post an error and quit.
rem
if  (%_msg%)==()      echo ERROR: You have less than 11 bytes of free environment space.
if  (%_msg%)==(00000) echo ERROR: You have less than 70 bytes of free environment space.
if  (%_msg%)==(10000) echo ERROR: You have less than 130 bytes of free environment space.
if  (%_msg%)==(11000) echo ERROR: You have less than 180 bytes of free environment space.
if  (%_msg%)==(11100) echo ERROR: You have less than 230 bytes of free environment space.
if  (%_msg%)==(11110) echo ERROR: You have less than 280 bytes of free environment space.
echo SUGGESTION: Make sure that you have at least 2048 bytes of environment space.
echo For example: CONFIG.SYS: SHELL=C:\COMMAND.COM /E:2048 /P
goto end




:BEGIN
rem
rem	Undo the environment size check...
rem
set _drive=
set _file=
set _pth=
set _vrsn=
set _path=
set _found=
set _type=
set _msg=

rem
rem	Make sure that we handle our [potentially] recursive call correctly.
rem
if  exist %1\nul	set _drive=%1
if  exist %1\nul	shift
if  (%1)==()		echo Recursing: %me% 3 A B C D L K T W X I BAT P
if  (%1)==()		%me% 3 A B C D L K T W X I BAT P
if  (%_drive%)==()	set _drive=C:
if  exist %temp%\lwp.log	del %temp%\lwp.log




echo %me%: Temporarily creating %temp%\_LWPFIND.BAT
rem
rem	Create _LWPFIND.BAT.  (Find the file on the PATH)
rem
echo set _found=>%temp%\_lwpfind.bat
echo :top						>>%temp%\_lwpfind.bat
echo if  (%%1)==()		goto end		>>%temp%\_lwpfind.bat
echo if  exist %%1\%%_file%%	goto found		>>%temp%\_lwpfind.bat
echo shift						>>%temp%\_lwpfind.bat
echo goto top						>>%temp%\_lwpfind.bat
echo :found						>>%temp%\_lwpfind.bat
echo set _pth=%%1>>%temp%\_lwpfind.bat
echo call lwp_log.bat %%1 %%_file%%			>>%temp%\_lwpfind.bat
echo set _found=1>>%temp%\_lwpfind.bat
echo shift						>>%temp%\_lwpfind.bat
echo goto top						>>%temp%\_lwpfind.bat
echo :end						>>%temp%\_lwpfind.bat
echo if  (%%_found%%)==() call lwp_log.bat %%_drive%%%%_path%% %%_file%%>>%temp%\_lwpfind.bat




echo %me%: Temporarily creating %temp%\_LWPFILE.BAT
rem
rem	Create _LWPFILE.BAT.  (Handle indirection for PATH)
rem
echo set _file=%%1>%temp%\_lwpfile.bat
echo set _path=%%2>>%temp%\_lwpfile.bat
echo set _msg=LAN WorkPlace >>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(3) set _msg=%%_msg%%%%_vrsn%% 3270 support file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(A) set _msg=%%_msg%%%%_vrsn%% file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(B) set _msg=%%_msg%%%%_vrsn%% WWW Browser file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(C) set _msg=%%_msg%%%%_vrsn%% NFS Client support file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(D) set _msg=%%_msg%%%%_vrsn%% Serial support file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(L) set _msg=%%_msg%%%%_vrsn%% NLM file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(K) set _msg=%%_msg%%%%_vrsn%% Toolkit file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(T) set _msg=%%_msg%%%%_vrsn%% Protocol Stack file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(W) set _msg=%%_msg%%%%_vrsn%% Windows support file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(X) set _msg=%%_msg%%%%_vrsn%% X/Server support file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(I) set _msg=%%_msg%%%%_vrsn%% .INI / .CFG file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(BAT) set _msg=%%_msg%%%%_vrsn%% batch file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(P) set _msg=%%_msg%%%%_vrsn%% patch signature file found:>>%temp%\_lwpfile.bat
echo if  (%%_type%%)==(0) set _msg=>>%temp%\_lwpfile.bat
echo call %temp%\_lwpfind.bat %%path%%>>%temp%\_lwpfile.bat




echo %me%: Determining installed LAN WorkPlace product version.
rem
rem	Determine LAN WorkPlace product version...
rem
set _vrsn=5
set _type=0
call %temp%\_lwpfile.bat LWPLPR.DRV	\NET\BIN
if  (%_found%)==()	set _vrsn=4.2




:TOP
if  (%1)==()	goto VIEWLOG
set _type=%1
if  (%_type%)==(3)	goto TN3270
if  (%_type%)==(a)	set _type=A
if  (%_type%)==(b)	set _type=B
if  (%_type%)==(c)	set _type=C
if  (%_type%)==(d)	set _type=D
if  (%_type%)==(l)	set _type=L
if  (%_type%)==(k)	set _type=K
if  (%_type%)==(t)	set _type=T
if  (%_type%)==(v)	set _type=V
if  (%_type%)==(w)	set _type=W
if  (%_type%)==(x)	set _type=X
if  (%_type%)==(i)	set _type=I
if  (%_type%)==(bat)	set _type=BAT
if  (%_type%)==(p)	set _type=P

if  (%_type%)==(3)	goto TN3270
if  (%_type%)==(A)	goto A
if  (%_type%)==(B)	goto B
if  (%_type%)==(C)	goto C
if  (%_type%)==(D)	goto D
if  (%_type%)==(L)	goto L
if  (%_type%)==(K)	goto K
if  (%_type%)==(T)	goto T
if  (%_type%)==(V)	goto V
if  (%_type%)==(W)	goto W
if  (%_type%)==(X)	goto X
if  (%_type%)==(I)	goto I
if  (%_type%)==(BAT)	goto BAT
if  (%_type%)==(P)	goto P
echo %me%: Unknown option [%1].  Try:  %me% -H
shift
goto TOP




:A
rem
rem	Check the DOS applications
rem
call %temp%\_lwpfile.bat FTP.EXE	\NET\BIN
call %temp%\_lwpfile.bat LPR.EXE	\NET\BIN
call %temp%\_lwpfile.bat RCP.EXE	\NET\BIN
call %temp%\_lwpfile.bat REXEC.EXE	\NET\BIN
call %temp%\_lwpfile.bat RPR.EXE	\NET\BIN
call %temp%\_lwpfile.bat RSH.EXE	\NET\BIN
call %temp%\_lwpfile.bat TELAPI.EXE	\NET\BIN
call %temp%\_lwpfile.bat TNVT220.EXE	\NET\BIN
call %temp%\_lwpfile.bat XPC.EXE	\NET\BIN
shift
goto TOP



:W
rem
rem	Check the Windows Support .DLLs
rem
call %temp%\_lwpfile.bat TELNET.DLL	\NET\BIN
call %temp%\_lwpfile.bat TERMAPI.DLL	\NET\BIN
call %temp%\_lwpfile.bat WDOSFS.DLL	\NET\BIN
call %temp%\_lwpfile.bat WFTPFS.DLL	\NET\BIN
call %temp%\_lwpfile.bat FS.DLL		\NET\BIN
call %temp%\_lwpfile.bat LWPICON.DLL	\NET\BIN
call %temp%\_lwpfile.bat LWPUTIL.DLL	\NET\BIN
call %temp%\_lwpfile.bat PRESENTR.EXE	\NET\BIN
call %temp%\_lwpfile.bat RESOLVIP.EXE	\NET\BIN
call %temp%\_lwpfile.bat SERVEFTP.EXE	\NET\BIN
call %temp%\_lwpfile.bat RAPFILER.EXE	\NET\BIN
shift
goto TOP



:B
rem
rem	Check for the WWW Browser
rem
call %temp%\_lwpfile.bat NETSCAPE.EXE	\NET\BROWSER
shift
goto TOP


:D
rem
rem	Check the Dialer Support...
rem
call %temp%\_lwpfile.bat ASYNC.DLL				\NET\BIN
call %temp%\_lwpfile.bat MDMAPI.DLL				\NET\BIN
call %temp%\_lwpfile.bat SLPAPI.DLL				\NET\BIN
call %temp%\_lwpfile.bat DIALER.EXE				\NET\BIN
call %temp%\_lwpfile.bat AIOMDMS.MDC				\NET\HSTACC
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat SLIP_PPP.COM	\NET\BIN
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat NESL.COM	\NWCLIENT
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat NCOMX.COM	\NWCLIENT
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat NWREMOTE.COM	\NWCLIENT
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat CONFIG.EXE	\NET\BIN
shift
goto TOP




:T
rem
rem	Check the Protocol Stack files
rem
call %temp%\_lwpfile.bat IPTUNNEL.EXE	\NET\BIN
call %temp%\_lwpfile.bat LWPCON.EXE	\NET\BIN
call %temp%\_lwpfile.bat NOVASYNC.EXE	\NET\BIN
call %temp%\_lwpfile.bat PING.EXE	\NET\BIN
call %temp%\_lwpfile.bat TCPIP.EXE	\NET\BIN
call %temp%\_lwpfile.bat RFCNBIOS.EXE	\NET\BIN
call %temp%\_lwpfile.bat SNMP.EXE	\NET\BIN
call %temp%\_lwpfile.bat VTCPIP.386	\NET\BIN
call %temp%\_lwpfile.bat WINSOCK.DLL	\NET\BIN
call %temp%\_lwpfile.bat WLIBSOCK.DLL	\NET\BIN
rem
rem	Just fall through to include the NetWare Client stuff as well.
rem



:V
rem
rem	VLM Support Files
rem
call %temp%\_lwpfile.bat LSL.COM	\NWCLIENT
call %temp%\_lwpfile.bat IPXODI.COM	\NWCLIENT
call %temp%\_lwpfile.bat VLM.EXE	\NWCLIENT
call %temp%\_lwpfile.bat NEXT.EXE	\NWCLIENT
shift
goto TOP




:TN3270
rem
rem	Check the LAN WorkPlace 3270 support 
rem
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat ATMAPI.DLL	\NET\TN3270
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WTEMUL.DLL	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WTKEY.DLL	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WTLIB.DLL	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WTSESS.DLL	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WTSNDRCV.DLL	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WTTRANS.DLL	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat WT3270.EXE	\NET\BIN
shift
goto TOP



:C
rem
rem	Check the LAN WorkPlace NFS Client support 
rem
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat ETHDEV.LWP	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat ETHDEV.LWP	\NFSCLNT
shift
goto TOP




:I
rem
rem	Check the LAN WorkPlace .INI and .CFG file locations
rem
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat LWP.INI	\WINDOWS
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat LWP.INI	\NET\HSTACC
			call %temp%\_lwpfile.bat NET.CFG	\NWCLIENT
			call %temp%\_lwpfile.bat SYSTEM.INI	\WINDOWS
			call %temp%\_lwpfile.bat WIN.INI	\WINDOWS
shift
goto TOP




:BAT
rem
rem	Check for batch files
rem
if  (%_vrsn%)==(5)	call %temp%\_lwpfile.bat STARTNET.BAT	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat LANWP.BAT	\NET\BIN
if  (%_vrsn%)==(4.2)	call %temp%\_lwpfile.bat LANWP.BAT	\
shift
goto TOP



:P
rem
rem	Check for patches:
rem
call %temp%\_lwpfile.bat LWP42T.TXT	\NET\BIN
call %temp%\_lwpfile.bat LWP42A.TXT	\NET\BIN
call %temp%\_lwpfile.bat LWP42W.TXT	\NET\BIN
call %temp%\_lwpfile.bat LWP42D.TXT	\NET\BIN
call %temp%\_lwpfile.bat LWP423.TXT	\NET\BIN
call %temp%\_lwpfile.bat LWP413.TXT	\NET\BIN
shift
goto TOP




:X
rem
rem	Look for X/Server.
rem
call %temp%\_lwpfile.bat X.EXE	\NET\BIN
shift
goto TOP




rem
rem	Sections not currently supported.
rem
:L
:K
shift
goto TOP




:VIEWLOG
if  (%visual%)==()	if  exist %temp%\lwp.log	edit %temp%\lwp.log
if  not (%visual%)==()	if  exist %temp%\lwp.log	%visual% %temp%\lwp.log
echo.
if      exist %temp%\lwp.log	echo %me%: Log file is located at: %temp%\lwp.log
if  not exist %temp%\lwp.log	echo %me%: No files found.




:END
rem
rem	Clean up the environment and exit.
rem
set _found=
set _type=
set _drive=
set _file=
set _path=
set _pth=
set _msg=
set _vrsn=
rem if  exist %temp%\_lwpfind.bat	del %temp%\_lwpfind.bat
rem if  exist %temp%\_lwpfile.bat	del %temp%\_lwpfile.bat
echo %me%: Done.
set me=
