'
'
'                    Ŀ
'                       LensCAD Version 1.0  
'                       Copyright c1993      
'                       James M. Michael     
'                       P.O. Box 941124      
'                       Atlanta, GA 30314    
'                    
'
'This source code is provided on an AS IS basis for personal use only.
'ANY other use of this code is in violation of the copyright. Don't even
'think of using this in a commercial product without getting written
'authorization first. You may alter this code as you see fit for your
'personal use and such hacking is encouraged. I have tried to include
'code that will enrage even the most laid back hacker, including the
'dreaded GOTO command. This program was created for designing multilens
'optical systems and is written in QB45. If you want to use this program 
'to design an optical system which employs mirrors, you will have to 
'figure out how to make it work. This program has a minimal amount of 
'comments. It should be easy to figure out how it works.  Since the 
'program is offered free of charge for personal use, there is no support
'offered. If you need more information or if you find the program useful
'and choose to support it, you may send $20 in US funds for the latest
'version of the code alond with additional technical information and 
'references. There is no way to guarantee that the source code document 
'you are currently reading has not been corrupted. 
'
'
'Begin Code Segment: Declare some subs


DECLARE SUB matrixcalc ()
DECLARE SUB setoption ()
DECLARE SUB menu ()
DECLARE SUB changecolors ()
DECLARE SUB makereport ()
DECLARE SUB setinput ()
DECLARE SUB optionmenu ()
DECLARE SUB savestuff ()
DECLARE SUB setcurv ()
DECLARE SUB setindex ()
DECLARE SUB review ()
DECLARE SUB matassign ()
DECLARE SUB getstuff ()
DECLARE SUB lensindex ()
DECLARE SUB lensspace ()
DECLARE SUB lensthick ()
DECLARE SUB spaceindex ()
DECLARE SUB setinindex ()
DECLARE SUB setoutindex ()
CLEAR , , 3000                 'set stack size to 3000
CLS
LOCATE 10, 1
INPUT " Do you wish to use the old data(y/n) :", y$    'if yes better have a file
IF UCASE$(y$) = "Y" THEN
    yes = 1
    INPUT "File from which to retrieve data: ", filename$     'it better exist or you will crash
    CLS
    LOCATE 15, 15
    PRINT "Searching..."
    OPEN filename$ FOR INPUT AS #1
    INPUT #1, ne, nm, nr, nd, nn, colors, nvm
    CLOSE #1
ELSE
    CLS
    yes = 0
    LOCATE 10, 10
    INPUT "How many lens elements: ", ne          ' ne is the number of lens elements
    nr = ne * 2                                   ' nr is the number of surfaces
    nd = ne * 2 - 1                               ' nd is the number of distances
    nn = ne * 2 + 1                               ' nn is the number of indices of refraction
    nm = ne * 4 - 1                               ' nm is the number of matrices
END IF
DIM SHARED r(nr, 0 TO 100) AS DOUBLE              'dimension some arrays
DIM SHARED d(nd, 0 TO 100) AS DOUBLE
DIM SHARED rinc(nr) AS SINGLE
DIM SHARED dinc(nd) AS SINGLE
DIM SHARED rpts(nr) AS INTEGER
DIM SHARED dpts(nd) AS INTEGER
DIM SHARED m(nm, 2, 2) AS DOUBLE
DIM SHARED p(nm, 2, 2) AS DOUBLE
DIM SHARED inmatrix(2) AS DOUBLE
DIM SHARED outmatrix(2) AS DOUBLE
DIM SHARED rpt(nr) AS INTEGER
DIM SHARED dpt(nd) AS INTEGER
DIM SHARED n1(0 TO nn - 1) AS DOUBLE
DIM SHARED rr(nr) AS DOUBLE
DIM SHARED dd(nd) AS DOUBLE
DIM SHARED mn(3) AS INTEGER
CLS
IF yes = 0 THEN
    FOR i = 1 TO nr
        rpts(i) = 1
    NEXT i
    FOR i = 1 TO nd
        dpts(i) = 1
    NEXT i

    LOCATE 10, 1
    PRINT "     You have four options to look at the effects of changes"
    PRINT "     of parameters on lens designs. You may look at one"
    PRINT "     parameter over 100 points and up to 3 wavelengths, 2"
    PRINT "     parameters over 10 points each and up to 3 wavelengths,"
    PRINT "     or 3 parameters over 10 points each and up to 3 wavelengths."
    PRINT "     You may also keep all parameters constant and look at up to"
    PRINT "     3 wavelengths."
    PRINT ""
    PRINT ""
    PRINT "Press a key to begin."
    DO WHILE INKEY$ = "": LOOP
    CLS
    LOCATE 10, 5
    PRINT "Choose Option:"
    LOCATE 12, 1
    PRINT "0> Make all parameters constant"
    PRINT "1> Look at one parameter over 100 points"
    PRINT "2> Vary two parameters over 10 points each"
    PRINT "3> Look at three parameters over 10 points each"
    PRINT ""
    INPUT "Choice: ", nvm
    CALL setoption
    CLS
    LOCATE 10, 5
100 PRINT "You may choose up to 3 wavelengths of light."
    LOCATE 11, 5
    INPUT "Number of wavelengths to use: ", colors
    IF colors > 3 OR colors < 1 THEN GOTO 100
END IF
DIM SHARED lambda(3) AS DOUBLE
IF yes = 0 THEN
FOR i = 1 TO colors
200 CLS
    LOCATE 10, 1
    PRINT "Choose a color or enter your own wavelength:"
    PRINT ""
    PRINT "1> RED"
    PRINT "2> YELLOW"
    PRINT "3> BLUE"
    PRINT "4> Enter Wavelength"
    PRINT ""
    INPUT "Choice: ", c
    SELECT CASE c
        CASE 1
            lambda(i) = 656.3 * 10 ^ -9
        CASE 2
            lambda(i) = 589.3 * 10 ^ -9
        CASE 3
            lambda(i) = 486.1 * 10 ^ -9
        CASE 4
            INPUT "Wavelength (meters): ", lambda(i)
        CASE ELSE
            GOTO 200
    END SELECT
NEXT i
END IF
DIM SHARED n(0 TO nn, colors) AS DOUBLE
FOR i = 1 TO colors
    IF n(0, i) = 0 THEN n(0, i) = 1.0003
    IF n(nn - 1, i) = 0 THEN n(nn - 1, i) = 1.0003
NEXT i
IF UCASE$(y$) = "Y" THEN CALL getstuff
CALL menu

SUB changecolors
CLS
LOCATE 10, 1
PRINT "If you change data here you must reenter all index of refraction"
PRINT "data. Enter c to continue with data change. Press another key to"
PRINT "abort data change."
PRINT ""
DO
test$ = INKEY$
LOOP WHILE UCASE$(test$) = ""
IF UCASE$(test$) = "C" THEN
    CLS
    LOCATE 10, 5
300 PRINT "You may choose up to 3 wavelengths of light."
    LOCATE 11, 5
    INPUT "Number of wavelengths to use: ", colors
    IF colors > 3 OR colors < 1 THEN GOTO 300
    FOR i = 1 TO colors
400     CLS
        LOCATE 10, 1
        PRINT "Choose a color or enter your own wavelength:"
        PRINT ""
        PRINT "1> RED"
        PRINT "2> YELLOW"
        PRINT "3> BLUE"
        PRINT "4> Enter Wavelength"
        PRINT ""
        INPUT "Choice: ", c
        SELECT CASE c
            CASE 1
                lambda(i) = 656.3 * 10 ^ -9
            CASE 2
                lambda(i) = 589.3 * 10 ^ -9
            CASE 3
                lambda(i) = 486.1 * 10 ^ -9
            CASE 4
                INPUT "Wavelength (meters): ", lambda(i)
            CASE ELSE
                GOTO 400
        END SELECT
    NEXT i
END IF
END SUB

SUB getstuff
SHARED ne, nm, nr, nd, nn, colors, nvm, filename$
OPEN filename$ FOR INPUT AS #1
INPUT #1, ne, nm, nr, nd, nn, colors, nvm
FOR i = 1 TO nr
    INPUT #1, rpts(i)
    FOR j = 0 TO rpts(i) - 1
        INPUT #1, r(i, j)
    NEXT j
NEXT i
FOR i = 1 TO nd
    INPUT #1, dpts(i)
    FOR j = 0 TO dpts(i) - 1
        INPUT #1, d(i, j)
    NEXT j
NEXT i
FOR i = 0 TO nn - 1
    FOR j = 1 TO colors
        INPUT #1, n(i, j)
    NEXT j
NEXT i
FOR i = 1 TO colors
    INPUT #1, lambda(i)
NEXT i
CLOSE #1
END SUB

SUB lensindex
CLS
SHARED colors, ne
LOCATE 10, 1
DO WHILE we < 1 OR we > ne
    INPUT "Which element: ", we
LOOP
wn = 2 * we - 1
PRINT "Choose glass type:"
PRINT ""
PRINT ""
PRINT "1> BK 7"
PRINT "2> SF 11"
PRINT "3> LaSF 9"
PRINT "4> OTHER"
PRINT ""
1000 INPUT "Choice: ", n
SELECT CASE n
    CASE 1
        a0 = 2.2718929#
        a1 = -1.0108077# * 10 ^ -2
        a2 = 1.0592509# * 10 ^ -2
        a3 = 2.0816965# * 10 ^ -4
        a4 = -7.6472538# * 10 ^ -6
        a5 = 4.9240991# * 10 ^ -7
    CASE 2
        a0 = 3.0539614#
        a1 = -1.1580432# * 10 ^ -2
        a2 = 3.9199816# * 10 ^ -2
        a3 = 2.9462812# * 10 ^ -3
        a4 = -2.0371019# * 10 ^ -4
        a5 = 2.7633569# * 10 ^ -5
    CASE 3
        a0 = 3.305183#
        a1 = -1.3857059# * 10 ^ -2
        a2 = 3.5921736# * 10 ^ -2
        a3 = 2.6740381# * 10 ^ -3
        a4 = -1.9764177# * 10 ^ -4
        a5 = 1.9381052# * 10 ^ -5
    CASE 4
        FOR i = 1 TO colors
            CLS
            LOCATE 10, 5
            PRINT "Enter index of refraction at "; lambda(i); " meters:"; : INPUT "", n(wn, i)
        NEXT i
    CASE ELSE
        CALL lensindex
END SELECT
IF n < 4 THEN
    FOR i = 1 TO colors
        L = lambda(i) * 10 ^ 6
        n(wn, i) = SQR(a0 + a1 * L * L + a2 / (L * L) + a3 * (L ^ -4) + a4 * (L ^ -6) + a5 * (L ^ -8))
    NEXT i
END IF
END SUB

SUB lensspace
CLS
SHARED ne
LOCATE 10, 1
DO WHILE we > ne OR we < 1
    INPUT "Greatest element number adjoining space: ", we
LOOP
wd = we * 2 - 2
IF dpts(wd) = 1 THEN INPUT "Distance: ", d(wd, 0)
IF dpts(wd) > 1 THEN
    INPUT "Distance range (low,high): ", d(wd, 0), d(wd, dpts(wd) - 1)
    dinc(wd) = (d(wd, dpts(wd) - 1) - d(wd, 0)) / (dpts(wd) - 1)
    FOR i = 1 TO dpts(wd) - 2
        d(wd, i) = d(wd, i - 1) + dinc(wd)
    NEXT i
END IF
END SUB

SUB lensthick
CLS
SHARED ne
LOCATE 10, 1
DO WHILE we > ne OR we < 1
    INPUT "Which element: ", we
LOOP
wd = we * 2 - 1
IF dpts(wd) = 1 THEN INPUT "Thickness: ", d(wd, 0)
IF dpts(wd) > 1 THEN
    INPUT "Thickness range (low,high): ", d(wd, 0), d(wd, dpts(wd) - 1)
    dinc(wd) = (d(wd, dpts(wd) - 1) - d(wd, 0)) / (dpts(wd) - 1)
    FOR i = 1 TO dpts(wd) - 2
        d(wd, i) = d(wd, i - 1) + dinc(wd)
    NEXT i
END IF
END SUB

SUB makereport
SHARED ne, nm, nr, nd, nn, colors
INPUT "File to write report to: ", filename$
OPEN filename$ FOR OUTPUT AS #3
INPUT "Title of Report: ", title$
PRINT #3, title$
PRINT #3, " "
FOR i = 1 TO nr
    PRINT #3, "Curvature Range "; i; "="; r(i, 0); " to "; r(i, rpts(i) - 1)
NEXT i
FOR i = 1 TO nd STEP 2
        PRINT #3, "Thickness Range Element "; (i + 1) / 2; "="; d(i, 0); " to "; d(i, dpts(i) - 1)
NEXT i
FOR i = 2 TO nd - 1 STEP 2
    PRINT #3, "Space Element "; (i + 2) / 2; " to "; ((i + 2) / 2) - 1; "="; d(i, 0); " to "; d(i, dpts(i) - 1)
NEXT i
FOR i = 1 TO ne
    FOR j = 1 TO colors
        PRINT #3, "Element "; i; " Index at "; lambda(j); " meters ="; n(i * 2 - 1, j)
    NEXT j
NEXT i
FOR i = 0 TO nn - 3 STEP 2
    PRINT #3, "Index before element "; (i + 2) / 2; "="; n(i, 1)
NEXT i
PRINT #3, "Index after element "; ne; "="; n(nn - 1, 1)
CLOSE #3
END SUB

SUB matassign
IF inmatrix(1) = 0 AND inmatrix(2) = 0 THEN CALL setinput
SHARED nm, colors, nvm, nd, nr, nn
CLS
LOCATE 10
INPUT "File to store output: ", outfile$
OPEN outfile$ FOR OUTPUT AS #1
FOR i = 1 TO nr
    rr(i) = r(i, 0)
NEXT i
FOR i = 1 TO nd
    IF d(i, 0) = 0 THEN d(i, 0) = .000001   'Some separation of elements required
    dd(i) = d(i, 0)
NEXT i
FOR ni = 0 TO colors - 1
    FOR i = 0 TO nn - 1
        IF n(i, 1) = 0 THEN
            CLS
            LOCATE 10
            PRINT "Fatal Error. Index of Refraction N("; i; ")=0"
            PRINT "Press a key to change index and continue..."
            DO WHILE INKEY$ = ""
            LOOP
            CALL setindex
        END IF
        n1(i) = n(i, 1 + ni)
    NEXT i
    IF nvm = 0 THEN CALL matrixcalc
    IF nvm = 1 THEN
        FOR ii = 0 TO 100
        FOR jj = 1 TO nm STEP 2
            wr = (jj + 1) / 2
            wd = (jj - 1) / 2
            wn = wd
            IF rpts(wr) > 1 THEN
                rr(wr) = r(wr, ii)
                WRITE #1, lambda(1 + ni), rr(wr)
            ELSEIF dpts(wd) > 1 THEN
                dd(wd) = d(wd, ii)
                WRITE #1, lambda(ni + 1), dd(wd)
            END IF
        NEXT jj
        CALL matrixcalc
    NEXT ii
ELSEIF nvm = 2 THEN
    FOR i = 0 TO 10
        FOR j = 0 TO 10
            count = 1
            FOR k = 1 TO nm STEP 2
                wr = (k + 1) / 2
                wd = (k - 1) / 2
                IF rpts(wr) > 1 THEN
                    SELECT CASE count
                        CASE 1
                            rr(wr) = r(wr, j)
                            WRITE #1, lambda(ni + 1), rr(wr)
                            count = count + 1
                        CASE 2
                            rr(wr) = r(wr, i)
                            WRITE #1, lambda(ni + 1), rr(wr)
                    END SELECT
                END IF
                IF dpts(wd) > 1 THEN
                    SELECT CASE count
                        CASE 1
                            dd(wd) = d(wd, j)
                            WRITE #1, lambda(ni + 1), dd(wd)
                            count = count + 1
                        CASE 2
                            dd(wd) = d(wd, i)
                            WRITE #1, lambda(ni + 1), dd(wd)
                    END SELECT
                END IF
            NEXT k
            CALL matrixcalc
        NEXT j
    NEXT i
ELSEIF nvm = 3 THEN
    FOR ii = 0 TO 10
        FOR jj = 0 TO 10
            FOR kk = 0 TO 10
                count = 1
                FOR k = 1 TO nm STEP 2
                    wr = (k + 1) / 2
                    wd = (k - 1) / 2
                    IF rpts(wr) > 1 THEN
                        SELECT CASE count
                            CASE 1
                                rr(wr) = r(wr, kk)
                                WRITE #1, lambda(ni + 1), rr(wr)
                                count = count + 1
                            CASE 2
                                rr(wr) = r(wr, jj)
                                WRITE #1, lambda(ni + 1), rr(wr)
                                count = count + 1
                            CASE 3
                                rr(wr) = r(wr, ii)
                                WRITE #1, lambda(ni + 1), rr(wr)
                        END SELECT
                    END IF
                    IF dpts(wd) > 1 THEN
                        SELECT CASE count
                            CASE 1
                                dd(wd) = d(wd, kk)
                                WRITE #1, lambda(ni + 1), dd(wd)
                                count = count + 1
                            CASE 2
                                dd(wd) = d(wd, jj)
                                WRITE #1, lambda(ni + 1), dd(wd)
                                count = count + 1
                            CASE 3
                                dd(wd) = d(wd, ii)
                                WRITE #1, lambda(ni + 1), dd(wd)
                        END SELECT
                    END IF
                NEXT k
                CALL matrixcalc
            NEXT kk
        NEXT jj
    NEXT ii
END IF
NEXT ni
CLOSE #1
END SUB

SUB matrixcalc
SHARED nm, nn, focaldist
k = 0
FOR i = 1 TO nm STEP 2
    m(i, 1, 2) = (n1(i - k) - n1(i - k - 1)) / rr(i - k)
    k = k + 1
    m(i, 1, 1) = 1
    m(i, 2, 1) = 0
    m(i, 2, 2) = 1
NEXT i
FOR j = 2 TO nm - 1 STEP 2
    m(j, 2, 1) = (-dd(j / 2)) / n1(j / 2)
    m(j, 1, 1) = 1
    m(j, 1, 2) = 0
    m(j, 2, 2) = 1
NEXT j
FOR i = 1 TO 2
    FOR j = 1 TO 2
        p(1, i, j) = m(1, i, j)
    NEXT j
NEXT i
FOR i = 2 TO nm
    p(i, 1, 1) = m(i, 1, 1) * p(i - 1, 1, 1) + m(i, 1, 2) * p(i - 1, 2, 1)
    p(i, 1, 2) = m(i, 1, 1) * p(i - 1, 1, 2) + m(i, 1, 2) * p(i - 1, 2, 2)
    p(i, 2, 1) = m(i, 2, 1) * p(i - 1, 1, 1) + m(i, 2, 2) * p(i - 1, 2, 1)
    p(i, 2, 2) = m(i, 2, 1) * p(i - 1, 1, 2) + m(i, 2, 2) * p(i - 1, 2, 2)
NEXT i
CLS
LOCATE 10, 1
FOR i = 1 TO 2
    FOR j = 1 TO 2
        PRINT "System("; i; ","; j; ")="; p(nm, i, j)
    NEXT j
NEXT i
PRINT "Determinant of system matrix="; p(nm, 1, 1) * p(nm, 2, 2) - p(nm, 2, 1) * p(nm, 1, 2)
outmatrix(1) = p(nm, 1, 1) * inmatrix(1) + p(nm, 1, 2) * inmatrix(2)
outmatrix(2) = p(nm, 2, 1) * inmatrix(1) + p(nm, 2, 2) * inmatrix(2)
focaldist = outmatrix(2) / outmatrix(1)
WRITE #1, focaldist
END SUB

SUB menu
CLS
LOCATE 4, 1
PRINT "         Main Menu:"
PRINT "         "
PRINT "         1> Set Curvature"
PRINT "         2> Set Element Thickness"
PRINT "         3> Set Element Spacing"
PRINT "         4> Set Index of Refraction"
PRINT "         5> Review Design Parameters"
PRINT "         6> Calculate Focal Distance"
PRINT "         7> Change Options"
PRINT "         8> Save Design Parameters"
PRINT "         9> Set Input To System"
PRINT "        10> Change Wavelength Size or Number"
PRINT "        11> Make Report on Current Design "
PRINT "        12> Quit "
PRINT "         "
INPUT "         Selection: ", s
SELECT CASE s
    CASE 1
        CALL setcurv
        CALL menu
    CASE 2
        CALL lensthick
        CALL menu
    CASE 3
        CALL lensspace
        CALL menu
    CASE 4
        CALL setindex
        CALL menu
    CASE 5
        CALL review
        CALL menu
    CASE 6
        CALL matassign
        CALL menu
    CASE 7
        CALL optionmenu
        CALL menu
    CASE 8
        CALL savestuff
        CALL menu
    CASE 9
        CALL setinput
        CALL menu
    CASE 10
        CALL changecolors
        CALL menu
    CASE 11
        CALL makereport
        CALL menu
    CASE 12
        END
    CASE ELSE
        CALL menu
END SELECT
END SUB

SUB optionmenu
CLS
SHARED nvm
LOCATE 10, 1
PRINT "Choose Option:"
PRINT " "
PRINT "0> Make all parameters constant"
PRINT "1> Look at one parameter over 100 points"
PRINT "2> Vary two parameters over 10 points each"
PRINT "3> Look at three parameters over 10 points each"
PRINT ""
INPUT "Choice: ", nvm
IF nvm > 3 OR nvm < 0 THEN CALL optionmenu
CALL setoption
END SUB

SUB review
SHARED ne, colors, nn, nvm
CLS
PRINT "The index or refraction of the medium before element 1 is "; n(0, 1)
PRINT "The index of refraction of the medium after element "; ne; " is "; n(nn - 1, 1)
PRINT "The number of variable parameters is set at "; nvm
FOR i = 1 TO ne
    LOCATE 5, 1
    PRINT "Element #"; i
    PRINT "Curvature range surface 1="; r(i * 2 - 1, 0); " to "; r(i * 2 - 1, rpts(i * 2 - 1) - 1)
    PRINT "Increment="; rinc(i * 2 - 1)
    PRINT "Curvature range surface 2="; r(i * 2, 0); " to "; r(i * 2, rpts(i * 2) - 1)
    PRINT "Increment="; rinc(i * 2)
    PRINT ""
    PRINT "Thickness range="; d(i * 2 - 1, 0); " to "; d(i * 2 - 1, dpts(i * 2 - 1) - 1)
    PRINT "Increment="; dinc(i * 2 - 1)
    FOR j = 1 TO colors
        PRINT "N("; lambda(j); ")="; n(2 * i - 1, j)
    NEXT j
    PRINT " "
    PRINT "Press a key for next parameter..."
    DO WHILE INKEY$ = "": LOOP
    CLS
    IF i < ne THEN
        LOCATE 5, 1
        PRINT "Space range between elements "; i; " and "; i + 1; "="; d(i * 2, 0); " to "; d(i * 2, dpts(i * 2) - 1)
        PRINT "Increment="; dinc(i * 2)
        PRINT "N="; n(2 * i, 1)
        PRINT ""
        PRINT "Press a key..."
        DO WHILE INKEY$ = ""
        LOOP
        CLS
    END IF
NEXT i
END SUB

SUB savestuff
SHARED ne, nm, nr, nd, nn, colors, nvm
INPUT "Name of file in which to store data: ", filename$
OPEN filename$ FOR OUTPUT AS #1
WRITE #1, ne, nm, nr, nd, nn, colors, nvm
FOR i = 1 TO nr
    WRITE #1, rpts(i)
    FOR j = 0 TO rpts(i) - 1
        WRITE #1, r(i, j)
    NEXT j
NEXT i
FOR i = 1 TO nd
    WRITE #1, dpts(i)
    FOR j = 0 TO dpts(i) - 1
        WRITE #1, d(i, j)
    NEXT j
NEXT i
FOR i = 0 TO nn - 1
    FOR j = 1 TO colors
        WRITE #1, n(i, j)
    NEXT j
NEXT i
FOR i = 1 TO colors
    WRITE #1, lambda(i)
NEXT i
CLOSE #1
END SUB

SUB setcurv
CLS
LOCATE 10, 1
SHARED ne
DO WHILE we > ne OR we < 1
    INPUT "Which element: ", we
LOOP
DO WHILE ws > 2 OR ws < 1
INPUT "Which surface: ", ws
LOOP
wr = we * 2 - 2 + ws
IF rpts(wr) = 1 THEN INPUT "Curvature: ", r(wr, 0)
IF rpts(wr) > 1 THEN
    INPUT "Curvature range (low,high): ", r(wr, 0), r(wr, rpts(wr) - 1)
    rinc(wr) = (r(wr, rpts(wr) - 1) - r(wr, 0)) / (rpts(wr) - 1)
    FOR i = 1 TO rpts(wr) - 2
        r(wr, i) = r(wr, i - 1) + rinc(wr)
    NEXT i
END IF
END SUB

SUB setdistance
CLS
LOCATE 10, 1
PRINT "Choose distance to set:"
PRINT ""
PRINT "1> Lens thickness"
PRINT "2> Lens spacing"
PRINT ""
INPUT "Choice: ", n
IF n = 1 THEN CALL lensthick
IF n = 2 THEN CALL lensspace
END SUB

SUB setindex
CLS
LOCATE 10, 1
PRINT "Choose index to set:"
PRINT ""
PRINT "1> Lens element"
PRINT "2> Lens spacing"
PRINT "3> Input"
PRINT "4> Output"
PRINT ""
INPUT "Choice: ", m
IF m = 1 THEN CALL lensindex
IF m = 2 THEN CALL spaceindex
IF m = 3 THEN CALL setinindex
IF m = 4 THEN CALL setoutindex
IF m > 4 OR m < 1 THEN CALL setindex
END SUB

SUB setinindex
SHARED colors
CLS
LOCATE 10, 1
PRINT "Choose medium at input:"
PRINT ""
PRINT "1> Air"
PRINT "2> Vacuum"
PRINT "3> Water"
PRINT "4> Other"
PRINT ""
INPUT "Choice: ", L
SELECT CASE L
    CASE 1
        n = 1.0003
    CASE 2
        n = 1!
    CASE 3
        n = 4 / 3
    CASE 4
        INPUT "Index of refraction: ", n
    CASE ELSE
        CALL setinindex
END SELECT
FOR i = 1 TO colors
    n(0, i) = n
NEXT i
END SUB

SUB setinput
CLS
LOCATE 10, 1
INPUT "Angle ray to subtend with optical axis (radians): ", gamma
INPUT "Height above axis (meters): ", h
inmatrix(1) = n(0, 1) * gamma
inmatrix(2) = h
END SUB

SUB setoption
SHARED nvm, ne, nr, nd
FOR i = 1 TO nr
    rpts(i) = 1
NEXT i
FOR i = 1 TO nd
    dpts(i) = 1
NEXT i
IF nvm = 0 THEN EXIT SUB
FOR i = 1 TO nvm
    c = 0
    we = 0
    ws = 0
    CLS
    PRINT ""
    LOCATE 10
    PRINT "Select Parameter To Vary:"
    PRINT ""
    PRINT "     1> Curvature"
    PRINT "     2> Element Thickness"
    PRINT "     3> Element Spacing"
    PRINT " "
    INPUT "Choice: ", c
    SELECT CASE c
        CASE 1
            CLS
            LOCATE 10
            DO WHILE we > ne OR we < 1
                INPUT "Which element: ", we
            LOOP
            DO WHILE ws > 2 OR ws < 1
                INPUT "Which surface (1 or 2):", ws
            LOOP
            wr = we * 2 - 2 + ws
            mn(i) = wr * 2 - 1
            IF nvm = 1 THEN rpts(wr) = 101
            IF nvm = 2 THEN rpts(wr) = 11
            IF nvm = 3 THEN rpts(wr) = 11
            INPUT "Curvature range (low,high)", r(wr, 0), r(wr, rpts(wr) - 1)
            rinc(wr) = (r(wr, rpts(wr) - 1) - r(wr, 0)) / (rpts(wr) - 1)
            FOR j = 1 TO rpts(wr) - 2
                r(wr, j) = r(wr, j - 1) + rinc(wr)
            NEXT j
        CASE 2
            CLS
            LOCATE 10
            we = 0
            DO WHILE we > ne OR we < 1
            INPUT "Thickness of which element: ", we
            LOOP
            wd = we * 2 - 1
            mn(i) = 2 * wd
            IF nvm = 1 THEN dpts(wd) = 101
            IF nvm = 2 THEN dpts(wd) = 11
            IF nvm = 3 THEN dpts(wd) = 11
            INPUT "Thickness Range (low,high): ", d(wd, 0), d(wd, dpts(wd) - 1)
            dinc(wd) = (d(wd, dpts(wd) - 1) - d(wd, 0)) / (dpts(wd) - 1)
            FOR j = 1 TO dpts(wd) - 2
                d(wd, j) = d(wd, j - 1) + dinc(wd)
            NEXT j
        CASE 3
            CLS
            LOCATE 10
            we = 0
            DO WHILE we < 1 OR we > ne
                INPUT "Highest number element adjoining this space: ", we
            LOOP
            wd = 2 * we - 2
            mn(i) = wd * 2
            IF nvm = 1 THEN dpts(wd) = 101
            IF nvm = 2 THEN dpts(wd) = 11
            IF nvm = 3 THEN dpts(wd) = 11
            INPUT "Distance Range (low,high): ", d(wd, 0), d(wd, dpts(wd) - 1)
            dinc(wd) = (d(wd, dpts(wd) - 1) - d(wd, 0)) / (dpts(wd) - 1)
            FOR j = 1 TO dpts(wd) - 2
                d(wd, j) = d(wd, j - 1) + dinc(wd)
            NEXT j
        CASE ELSE
            CALL optionmenu
    END SELECT
NEXT i
END SUB

SUB setoutindex
SHARED colors, nn
CLS
LOCATE 10, 1
PRINT "Choose medium at output:"
PRINT ""
PRINT "1> Air"
PRINT "2> Vacuum"
PRINT "3> Water"
PRINT "4> Other"
PRINT ""
INPUT "Choice: ", L
SELECT CASE L
    CASE 1
        n = 1.0003
    CASE 2
        n = 1!
    CASE 3
        n = 4 / 3
    CASE 4
        INPUT "Index of refraction: ", n
    CASE ELSE
        CALL setoutindex
END SELECT
FOR i = 1 TO colors
    n(nn - 1, i) = n
NEXT i
END SUB

SUB spaceindex
SHARED colors, ne
CLS
LOCATE 10, 1
DO WHILE we > ne OR we < 1
INPUT "Greatest element number adjoining space: ", we
LOOP
wn = 2 * we - 2
CLS
LOCATE 10
PRINT "     Choose medium: "
PRINT " "
PRINT "     1> Air"
PRINT "     2> Vacuum"
PRINT "     3> Water"
PRINT "     4> Other"
PRINT ""
INPUT "     Choice: ", L
SELECT CASE L
    CASE 1
        n = 1.0003
    CASE 2
        n = 1!
    CASE 3
        n = 4 / 3
    CASE 4
        INPUT "Index of refraction: ", n
    CASE ELSE
        RETURN
END SELECT
FOR i = 1 TO colors
    n(wn, i) = n
NEXT i
END SUB

