VERSION 2.00
Begin Form Sample 
   Caption         =   "LED Display Sample Program"
   ClientHeight    =   5436
   ClientLeft      =   852
   ClientTop       =   2148
   ClientWidth     =   7380
   Height          =   5904
   Left            =   780
   LinkTopic       =   "Sample"
   ScaleHeight     =   453
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   615
   Top             =   1752
   Width           =   7524
   Begin CommandButton Command13 
      Caption         =   "Italics ON/OFF"
      Height          =   375
      Left            =   3516
      TabIndex        =   14
      Top             =   4884
      Width           =   3735
   End
   Begin CommandButton Command12 
      Caption         =   "Clear Display"
      Height          =   255
      Left            =   168
      TabIndex        =   13
      Top             =   5028
      Width           =   2175
   End
   Begin CommandButton Command11 
      Caption         =   "Cycle Some Colors"
      Height          =   375
      Left            =   3516
      TabIndex        =   12
      Top             =   4416
      Width           =   3735
   End
   Begin CommandButton Command9 
      Caption         =   "Set Left/Right Justify"
      Height          =   372
      Left            =   168
      TabIndex        =   9
      Top             =   3072
      Width           =   2172
   End
   Begin Frame Frame1 
      Caption         =   "Enter Text Numeric"
      Height          =   1095
      Left            =   108
      TabIndex        =   8
      Top             =   1884
      Width           =   3015
      Begin TextBox Text1 
         Height          =   375
         Left            =   240
         TabIndex        =   11
         Top             =   360
         Width           =   1815
      End
      Begin CommandButton Command10 
         Caption         =   "OK"
         Height          =   255
         Left            =   2160
         TabIndex        =   10
         Top             =   720
         Width           =   735
      End
   End
   Begin CommandButton Command8 
      Caption         =   "Leading Zeros"
      Height          =   375
      Left            =   3516
      TabIndex        =   7
      Top             =   1908
      Width           =   3735
   End
   Begin CommandButton Command7 
      Caption         =   "Number of Digits"
      Height          =   375
      Left            =   3516
      TabIndex        =   6
      Top             =   2412
      Width           =   3735
   End
   Begin CommandButton Command6 
      Caption         =   "Digit Height"
      Height          =   375
      Left            =   3516
      TabIndex        =   5
      Top             =   2916
      Width           =   3735
   End
   Begin CommandButton Command5 
      Caption         =   "Reset Counter"
      Height          =   255
      Left            =   192
      TabIndex        =   4
      Top             =   4692
      Width           =   2175
   End
   Begin CommandButton Command4 
      Caption         =   "Toggle Unlit Semgent State"
      Height          =   375
      Left            =   3516
      TabIndex        =   3
      Top             =   3924
      Width           =   3735
   End
   Begin CommandButton Command3 
      Caption         =   "Stop Counter"
      Height          =   255
      Left            =   180
      TabIndex        =   2
      Top             =   4344
      Width           =   2175
   End
   Begin Timer Timer1 
      Left            =   -12
      Top             =   -72
   End
   Begin CommandButton Command2 
      Caption         =   "Scroll Mode"
      Height          =   375
      Left            =   3504
      TabIndex        =   1
      Top             =   3420
      Width           =   3735
   End
   Begin CommandButton Command1 
      Caption         =   "Start Counter"
      Height          =   255
      Left            =   180
      TabIndex        =   0
      Top             =   3996
      Width           =   2175
   End
   Begin LedDisp LedDisplay1 
      DigitHeight     =   38
      Digits          =   6
      Height          =   1632
      Italic          =   1  'True
      LeadingZeros    =   0
      Left            =   60
      Mode            =   0  'Non-Scroll
      TextColor       =   &H0000FF00&
      TextEntry       =   1  'Right
      Top             =   144
      UnlitSegments   =   1  'On
      Width           =   7176
   End
End
Dim gCount As Integer
Dim gColor(10) As Long

Sub Command1_Click ()
    timer1.Interval = 1000
End Sub

Sub Command10_Click ()
    LedDisplay1.Text = Text1.Text
End Sub

Sub Command11_Click ()
    Static tNdx As Integer

    LedDisplay1.TextColor = gColor(tNdx)
    tNdx = (tNdx + 1) Mod 10
End Sub

Sub Command12_Click ()
    LedDisplay1.Action = 1
End Sub

Sub Command13_Click ()
    Dim cState As Integer

    cState = LedDisplay1.Italic
    cState = (cState + 1) Mod 2
    LedDisplay1.Italic = cState
End Sub

Sub Command2_Click ()
    Dim strState As String
    Dim nState As Integer

    strState = "Off"
    nState = LedDisplay1.Mode
    nState = (nState + 1) Mod 2
    
    On Error GoTo BadMode
    LedDisplay1.Mode = nState
    
    ' reset the counter, clear the display
    LedDisplay1.Action = 1
    gCount = 0

    If (LedDisplay1.Mode = 1) Then strState = "On"
    Command2.Caption = "Scroll Mode Is " & strState
    Exit Sub

BadMode:
    MsgBox "Illegal Mode, Error " & Err
    Resume Next
End Sub

Sub Command3_Click ()
    timer1.Interval = 0
End Sub

Sub Command4_Click ()
    Dim nState As Integer

    nState = LedDisplay1.UnlitSegments
    If (nState) Then nState = 0 Else nState = 1

    LedDisplay1.UnlitSegments = nState
End Sub

Sub Command5_Click ()
    gCount = 0
    LedDisplay1.Number = gCount
End Sub

Sub Command6_Click ()
    Dim nDHt As Integer

    nDHt = LedDisplay1.DigitHeight
    LedDisplay1.DigitHeight = (nDHt Mod 100) + 25
End Sub

Sub Command7_Click ()
    Dim nDigits As Integer

    nDigits = LedDisplay1.Digits

    nDigits = ((nDigits - 1) Mod 8) + 2
    LedDisplay1.Digits = nDigits
    Command7.Caption = "Number of Digits-" & nDigits
End Sub

Sub Command8_Click ()
    Dim nLZ As Integer
    Dim nDigs As Integer

    nDigs = LedDisplay1.Digits + 1
    nLZ = LedDisplay1.LeadingZeros
    nLZ = (nLZ + 1) Mod nDigs

    On Error GoTo BadZero
    LedDisplay1.LeadingZeros = nLZ
    Command8.Caption = "Leading Zeros-" & LedDisplay1.LeadingZeros
    Exit Sub

BadZero:
    MsgBox "Can't Set Leading Zeroes When Scrolling. Error #" & Err
    Resume Next
End Sub

Sub Command9_Click ()
    Dim nState As Integer

    nState = LedDisplay1.TextEntry
    nState = (nState + 1) Mod 2
    LedDisplay1.TextEntry = nState
End Sub

Sub Form_Load ()
    timer1.Interval = 1000
    Me.Left = (Screen.Width - Me.Width) / 2
    Me.Top = (Screen.Height - Me.Height) / 2
    
    gColor(0) = &HFF00&
    gColor(1) = &HFF0000
    gColor(2) = &HFF&
    gColor(3) = &HFFFF00
    gColor(4) = &HFF00FF
    gColor(5) = &HFF&
    gColor(6) = &HFFFFFF
    gColor(7) = &HFFFF&
    gColor(8) = &H80FF&
    gColor(9) = &HC0C0C0

End Sub

Sub Timer1_Timer ()
    gCount = gCount + 1
    LedDisplay1.Number = gCount
End Sub

