unit Test;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Rasdial, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    RasDial1: TRasDial;
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    Label1: TLabel;
    TelNum: TEdit;
    Label2: TLabel;
    EntryName: TComboBox;
    PBook: TEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    RASDial2: TMenuItem;
    Disabled1: TMenuItem;
    Dial1: TMenuItem;
    Hangup1: TMenuItem;
    Active1: TMenuItem;
    N1: TMenuItem;
    PhoneBook1: TMenuItem;
    User: TEdit;
    Pword: TEdit;
    Dmain: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    OpenDlg: TOpenDialog;
    Edit1: TMenuItem;
    Clear1: TMenuItem;
    procedure RasDial1StateChange(Sender: TObject; Error: Longint);
    procedure Button1Click(Sender: TObject);
    procedure RasDial1Disconnected(Sender: TObject; Error: Longint);
    procedure RasDial1Connected(Sender: TObject; Error: Longint);
    procedure Button2Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Active1Click(Sender: TObject);
    procedure Disabled1Click(Sender: TObject);
    procedure PhoneBook1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.RasDial1StateChange(Sender: TObject; Error: Longint);
const
    StateMsg = 'Status: ';
begin
    if Error = 0 Then
    begin
        Case RASDial1.ConnState of
        RASCS_OpenPort:
            Memo1.Lines.Add(StateMsg + 'Opening Port');
        RASCS_PortOpened:
            Memo1.Lines.Add(StateMsg + 'Port Opened');
        RASCS_ConnectDevice:
            Memo1.Lines.Add(StateMsg + 'Using Device: ' + RASDial1.DeviceName + ' - ' +
                RASDial1.DeviceType);
        RASCS_DeviceConnected:
            Memo1.Lines.Add(StateMsg + 'Device is connected');
        RASCS_AllDevicesConnected:
            Memo1.Lines.Add(StateMsg + 'All Required Devices Connected');
        RASCS_Authenticate:
            Memo1.Lines.Add(StateMsg + 'Validating User/Password/Domain');
        RASCS_AuthNotify:
            Memo1.Lines.Add(StateMsg + 'Authentication Notification');
        RASCS_AuthCallBack:
            Memo1.Lines.Add(StateMsg + 'Auth Call Back');
        RASCS_AuthProject:
            Memo1.Lines.Add(StateMsg + 'Project');
        RASCS_AuthLinkSpeed:
            Memo1.Lines.Add(StateMsg + 'Calculating Link speed');
        RASCS_AuthAck:
            Memo1.Lines.Add(StateMsg + 'Auth acknowledged');
        RASCS_ReAuthenticate:
            Memo1.Lines.Add(StateMsg + 'ReAuthenticating');
        RASCS_Authenticated:
            Memo1.Lines.Add(StateMsg + 'Login Authenticated');
        RASCS_PrepareforCallBack:
            Memo1.Lines.Add(StateMsg + 'Preparing for CallBack');
        RASCS_WaitForModemReset:
            Memo1.Lines.Add(StateMsg + 'Waiting for Modem Reset');
        RASCS_WaitForCallBack:
            Memo1.Lines.Add(StateMsg + 'Waiting for CallBack');
        end;
    end else
    begin
        Memo1.Lines.Add('Error has occured : ');
        Memo1.Lines.Add(RASDial1.GetErrorDesc(Error));
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
Var
    Err : Longint;
begin
    if EntryName.Text <> '' then
    begin
        RASDial1.BookEntry := EntryName.Text;
        memo1.lines.add('Dialing... ' + EntryName.Text);
    end else
    begin
        RASDial1.PhoneNumber := TelNum.Text;
        memo1.lines.add('Dialing... ' + TelNum.Text);
    end;
    RASDial1.UserId := User.Text;
    RAsDial1.Password := Pword.Text;
    RASDial1.DomainName := Dmain.Text;
    Err := RASDial1.Dial;
    if Err > 0 Then
    begin
        Memo1.lines.add(IntToStr(Err));
        Memo1.Lines.add(RASDial1.GetErrorDesc(Err));
    end;
end;

procedure TForm1.RasDial1Disconnected(Sender: TObject; Error: Longint);
begin
    Memo1.Lines.add('On Disconnected Event called');
    RASDial1.Hangup;
end;

procedure TForm1.RasDial1Connected(Sender: TObject; Error: Longint);
begin
    Memo1.Lines.add('On Connected Event called');
end;

procedure TForm1.Button2Click(Sender: TObject);
var
    Err: Longint;
begin
    if RASDial1.Active Then
    begin
        if RASDial1.InUse Then
        begin
            Memo1.Lines.Add('Hangup Requested');
            Err := RASDial1.Hangup;
            if Err <> RAS_SUCCESS Then
            begin
                Memo1.lines.add(IntToStr(Err));
                Memo1.Lines.add(RASDial1.GetErrorDesc(Err));
            end;
        end;
    end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
    if RASDial1.Active then
        if RASDial1.InUse Then
            RasDial1.Hangup;
    Close;
end;

procedure TForm1.Active1Click(Sender: TObject);
begin
    RASDial1.Active := True;
    Active1.Checked := True;
    Disabled1.Checked  := False;
    User.Text := RASDial1.UserId;
    Pword.Text := RAsDial1.Password;
    Dmain.Text := RASDial1.DomainName;
    Memo1.Lines.Add( 'RASDial Active');
end;

procedure TForm1.Disabled1Click(Sender: TObject);
begin
    RASDial1.Active := False;
    Disabled1.Checked := True;
    Active1.Checked := False;
    Memo1.Lines.Add( 'RASDial Disabled');
end;

procedure TForm1.PhoneBook1Click(Sender: TObject);
var
    Entries: TStringList;
    Err: Longint;
begin
    if OpenDlg.Execute Then
    begin
        PBook.Text := OpenDlg.FileName;
        Entries := TStringList.Create;
        Err := RASDial1.GetBookEntries(Entries, pBook.Text);
        if Err > 0 Then
            Memo1.Lines.Add(RASDial1.GetErrorDesc(Err));
        EntryName.Items.Clear;
        EntryName.Items.AddStrings(Entries);
        Entries.Free;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    Disabled1Click(self);
end;

procedure TForm1.Clear1Click(Sender: TObject);
begin
    Memo1.Clear;
end;

end.
