


    'CALC.BAS - calculator
    'Requires Liberty BASIC 0.9c
    'Copyright 1993, Shoptalk Systems

    'With Liberty BASIC 0.9c, it is possible to overrun
    'the calculator on slower machines, so wait until
    'each next button produces its result before
    'clicking the next button.  In the registered version,
    'each mouse action or button-click is buffered, so
    'you can click on buttons as fast as you like,
    'and the calculator will not lose anything while
    'catching up.

    'The version 1.0 version of this program takes
    'advantage of some of the special features of that
    'system to give a slicker appearance.

    button #calc, " 0 ", [button0], LL, 5, 4
    button #calc, " . ", [buttonPoint], LL, 40, 4
    button #calc, " = ", [buttonEquals], LL, 75, 4
    button #calc, "CLR", [buttonClear], LL, 110, 4
    button #calc, " 1 ", [button1], LL, 5, 30
    button #calc, " 2 ", [button2], LL, 40, 30
    button #calc, " 3 ", [button3], LL, 75, 30
    button #calc, " / ", [buttonDivide], LL, 110, 30
    button #calc, " 4 ", [button4], LL, 5, 58
    button #calc, " 5 ", [button5], LL, 40, 58
    button #calc, " 6 ", [button6], LL, 75, 58
    button #calc, " X ", [buttonMultiply], LL, 110, 58
    button #calc, " 7 ", [button7], LL, 5, 86
    button #calc, " 8 ", [button8], LL, 40, 86
    button #calc, " 9 ", [button9], LL, 75, 86
    button #calc, " - ", [buttonSubtract], LL, 110, 86
    button #calc, "Info", [info], LL, 5, 114
    button #calc, " + ", [buttonAdd], LL, 110, 114
    WindowWidth = 172
    WindowHeight = 280
    open "Calculator" for graphics as #calc
    print #calc, "font helv 9 24"

    ' set display$ up as two spaces
    display$ = "? "
    ' set up a shortcut for printing the entry line only
    blanks$ = "\" + chr$(13) + chr$(13) + chr$(13) + chr$(13) + " "


[mainLoop]  ' wait for a button to be pressed

    input r$
    goto [mainLoop]


[display]  ' update the entire display

    buffer$ = chr$(13)
    for i = 6 to 2 step -2
        buffer$ = buffer$ + " " + word$(lines$, i - 1) + " " + word$(lines$, i) + "                 " + chr$(13)
    next i
    print #calc, "cls"
    print #calc, "\" + buffer$ + "                   "
    gosub [displayEntry]
    print #calc, "flush"

  return


[displayEntry]  ' display the current entry line only

    print #calc, "place 0 0"
    print #calc, blanks$ + display$
    print #calc, "flush"

  return


[button0]  ' 0 was pressed

    display$ = display$ + "0"
    gosub [displayEntry]
    goto [mainLoop]

[button1]  ' 1 was pressed

    display$ = display$ + "1"
    gosub [displayEntry]
    goto [mainLoop]

[button2]  ' 2 was pressed

    display$ = display$ + "2"
    gosub [displayEntry]
    goto [mainLoop]

[button3]  ' 3 was pressed

    display$ = display$ + "3"
    gosub [displayEntry]
    goto [mainLoop]

[button4]  ' 4 was pressed

    display$ = display$ + "4"
    gosub [displayEntry]
    goto [mainLoop]

[button5]  ' 5 was pressed

    display$ = display$ + "5"
    gosub [displayEntry]
    goto [mainLoop]

[button6]  ' 6 was pressed

    display$ = display$ + "6"
    gosub [displayEntry]
    goto [mainLoop]

[button7]  ' 7 was pressed

    display$ = display$ + "7"
    gosub [displayEntry]
    goto [mainLoop]

[button8]  ' 8 was pressed

    display$ = display$ + "8"
    gosub [displayEntry]
    goto [mainLoop]

[button9]  ' 9 was pressed

    display$ = display$ + "9"
    gosub [displayEntry]
    goto [mainLoop]


[buttonPoint]  ' the decimal point button was pressed

    ' only allow one decimal point per entry
    if instr(display$, ".") > 0 then [mainLoop]

    display$ = display$ + "."
    gosub [displayEntry]
    goto [mainLoop]


[buttonClear]  ' the CLR button was pressed, clear the entry

    display$ = "? "
    gosub [display]
    goto [mainLoop]


[buttonAdd]  ' the + button was pressed

    if len(display$) = 2 then display$ = "+ " : gosub [displayEntry] : goto [mainLoop]
    gosub [resolvePending]
    display$ = "+ "
    gosub [display]
    goto [mainLoop]


[buttonSubtract]  ' the - button was pressed

    if len(display$) = 2 then display$ = "- " : gosub [displayEntry] : goto [mainLoop]
    gosub [resolvePending]
    display$ = "- "
    gosub [display]
    goto [mainLoop]


[buttonMultiply]  ' the X button was pressed

    if len(display$) = 2 then display$ = "X " : gosub [displayEntry] : goto [mainLoop]
    gosub [resolvePending]
    display$ = "X "
    gosub [display]
    goto [mainLoop]


[buttonDivide]

    if len(display$) = 2 then display$ = "/ " : gosub [displayEntry] : goto [mainLoop]
    gosub [resolvePending]
    display$ = "/ "
    gosub [display]
    goto [mainLoop]


[buttonEquals]  ' the = button was pressed

    if len(display$) = 2 then display$ = "= " : gosub [displayEntry] : goto [mainLoop]
    gosub [resolvePending]
    display$ = "? "
    gosub [display]
    goto [mainLoop]


[resolvePending]

    'take the bottom-most two items and perform the appropriate
    'operation (if any)

    first = val(word$(lines$, 2))
    second = val(word$(display$, 2))
    op$ = left$(display$, 1)

    lines$ = display$ + " " + lines$

    if op$ = "+" then lines$ = "= " + str$(first + second) + " " + lines$ : return
    if op$ = "-" then lines$ = "= " + str$(first - second) + " " + lines$ : return
    if op$ = "X" then lines$ = "= " + str$(first * second) + " " + lines$ : return
    if op$ = "/" then lines$ = "= " + str$(first / second) + " " + lines$ : return
    if op$ = "=" or op$ = "?" then lines$ = "= " + str$(second) + " " + lines$ : return

  return

[info]

    notice "About Calc"  + chr$(13) + "Calc, a Liberty BASIC Application"
    goto [mainLoop]

