    ' CHECKBOX.BAS
    ' This code demonstrates how to use checkboxes in your
    ' Liberty BASIC programs

    ' no main text mode window, please
    nomainwin

    ' list all the controls for our dialog box window
    button #1, " &Ok ", [quit], UL, 120, 90
    checkbox #1.cb, "I am a checkbox", [set], [reset], 10, 10, 130, 20
    button #1, " Set ", [set], UL, 10, 50
    button #1, " Reset ", [reset], UL, 50, 50
    textbox #1.text, 10, 90, 100, 24

    ' set the size for our window
    WindowWidth = 180
    WindowHeight = 160

    ' open the window
    open "Checkbox test" for dialog as #1

    ' intercept the close message and goto [quit]
    print #1, "trapclose [quit]"


[inputLoop]    ' this is where we sit idle, waiting for the user to click

    input r$ 
    stop

[set]    ' the user clicked on the Set button, set the checkbox

    print #1.cb, "set"
    goto [readCb]


[reset]    ' the user clicked on the Reset button, clear the checkbox
    print #1.cb, "reset"
    goto [readCb]


[readCb]    ' set the contents of the textbox

    ' query the checkbox for its state
    print #1.cb, "value?"
    input #1.cb, t$

    ' set the contents of our textbox
    print #1.text, "I am "; t$

    goto [inputLoop]


[quit]    ' check to see if we should quit

    confirm "Do you want to quit?"; answer$
    if answer$ <> "yes" then [inputLoop]

    close #1
    end
