  /**********************************************************************/
  /*									*/
  /*                                                                    */
  /* This routine converts HP Laserjet Series II Code to .BMP (windows) */
  /* It was written in may 1993 by					*/
  /*     								*/
  /*		David Schlesinger					*/
  /*									*/
  /* It is distributed and copyrighted by 				*/
  /*									*/
  /*				TIER ZWO VERLAG				*/
  /*				Auf dem Steinchen 22			*/
  /*				5300 Bonn 1  (from 1.7.93: 53127 Bonn)	*/
  /*				GERMANY					*/
  /*  ----------------------------------------------------------------- */
  /*									*/
  /*  It may be freely distributed as long this heading is not changed! */
  /*  If You add code or change parts of the code, please append Your	*/
  /*  name and increase the version number!				*/
  /*									*/
  /*									*/
  /*			==   VERSION 1.0   ==				*/
  /*									*/
  /*  ----------------------------------------------------------------- */
  /*									*/
  /*  If You have written a program that should be distributed as	*/
  /*  SHAREWARE with ISBN - or as a commercial program			*/
  /*  please feel free to send a DISK, a DISCRIBTION, and Your price-	*/
  /*  suggestions to:	TIER ZWO VERLAG, address above.			*/
  /*									*/
  /*  We also publish books (only in german)!				*/
  /*  									*/
  /*  Feel free to send us Your questions and suggestions!		*/
  /*									*/
  /**********************************************************************/

#include    <stdio.h>
#include    <stdlib.h>
#include    <ctype.h>
#include    <string.h>

  const dpi=100,fak=3,printing=0;
  FILE  *eing,*ausg;
  unsigned int x,y,z,y3,y1,x1,z1,i,k,l,length,m,n;
  long int test;
  int ESC=27,pos,posc,j,zeilpos;
  char zeile[2400];
  unsigned char drzeile[3][100];
  unsigned char zeich[20],*name,*name2,*name3,drpos,nulli,volli,c,c1,c2,c3,*ch;





  main (int argc,char *argv[])

{
	char *input,*output;
	int ana;

	name2="8x1300.ref";
	printf ("Laserjet Series II -> .bmp converter   by David Schlesinger\n");

	if (printing)printf ("crgc:%d argv[1]:%s argv[2]:%s\n",argc,argv[1],argv[2]);

	if ((int)argc!=3) {printf("usage: la2bmp input.ext output.ext\n");return -1; }
	input=argv[1];
	output=argv[2];


	printf ("name of file to be analyzed: %s\n",input);


	if (!(eing=fopen (name2,"r"))) {printf("Cannot open file(%s)!\n",name2);return -1;}

	if (!(ausg=fopen (output,"w"))) {printf("Cannot open file(%s)!\n",output);return -1;}



	for (j=1; j<=62;j++)   /* the 8x1300.ref file holds the header!!*/
	   {
	    c=fgetc(eing);
	    fputc (c,ausg);
	   }
	 fclose (eing);
			       /* header completely transferred, now let's
				  start analyzing...*/





	if (!(eing=fopen (input,"r"))) {printf("Cannot open file (%s)!\n",input);return -1;}


	/* definitionen: */

	length=3900;x=0;y=0;x1=0;y1=0;y3=0;      /*length=3900 * 300 dpi =13 inches!     */
	nulli=0;volli=255;test=0;drpos=0;        /* resolution of .bmp : 100 dpi => 1:3  */
						 /* test shows number of actually written*/
						 /* lines-necessary because of truncation*/
						 /* drpos=0-2 to do 1:3 transfer	 */
						 /* nulli,volli to fill bitmap	  	 */


	ana=suche_daten();         /* suche_daten () analyzing routine, see below*/

	if (ana==50&&printing) printf("File starts as it should!\n");

	while (1)

	{
	ana=suche_daten();

	if (ana==-1) {printf ("Error reported!!\n");goto endf;}
	if (ana==50) {if (printing) printf ("Analyze nearly finished..\n");
		      fuelle_zeilen(y1,length);
		      goto end;}
	if (ana==100) {printf ("End Of File ohne ESC E!!\n");goto endf;}

	if (ana==8) {
			fuelle_zeilen(y1,y); /* fills row to y pos...*/
			uebertragen(x,z);    /* passes code from printerfile to drzeile[drpos][]*/

		    }

	}





end:
	if (printing){
			printf("Analyze finished!\n");
			printf("%d rows written!\n",test);
		     }

	while (test<1300)        /* if truncation lead to less rows...*/
	 fuelle_zeilen (0,fak);



	printf("Finished!\n");
endf:	fclose (ausg);
	return 0;
}



int suche_daten ()
{

 int rel,jj,j1,j2;

schleife:	   while (fgetc(eing)!=ESC) {}          /*wait for ESC*/

			  c=fgetc(eing);
			  if (c=='E') return 50;
			  if (c!='*')goto schleife;
			  c=fgetc(eing);
			  c1=fgetc(eing);

			  if (c=='r'&& c1=='B') return 5;
			  if (c=='r') {
					c2=fgetc(eing);
					if (c2!='A') {
							printf("Error: After ESC*r # no 'A' found!\n");
							return -1;
						     }

					if (c1=='1') return 4;
					x=0;y=0;
					return 4;
				      }

			  if (c=='p') {
					z=0;jj=1,rel=0;j=0;

					if (c1=='-') {jj=-1;rel=1;c1=fgetc(eing);}
					if (c1=='+') {rel=1;c1=fgetc(eing);}

					for (i=1;i<10;++i)
					{
					j1=c1-48;
					if (j1<0||j1>9) {
							printf("Error: character after ESC*p.%d. not readible!\n",j1+48);
							return -1;
							}

					j=10*j;
					j=j+j1*jj;

					c1=fgetc(eing);
					if (c1=='X'&& rel==0)   {
								 x=j;return 6;
								}
					if (c1=='Y'&& rel==0)   {
								 y=j;return 7;
								}
					if (c1=='X'&& rel!=0)   {
								 x=x+j;return 6;
								}
					if (c1=='Y'&& rel!=0)   {
								 y=y+j;return 7;
								}

					}
				      }
			  if (c=='b') {
					z=0;j=0;

					for (i=1;i<10;++i)
					{
					j1=c1-48;
					if (j1<0||j1>9){
							printf ("Error: character after ESC*b.%d. not readible!\n",j1+48);
							printf ("Xpos: %d Ypos: %d \n",x,y);
							return -1;
						       }

					j=10*j;
					j=j+j1;

					c1=fgetc(eing);
					if (c1=='W') {z=j;return 8;}

					}

				       }
			 if (fgetc(eing)==EOF) return 100;

			 goto schleife;
}

fuelle_zeilen (a,b)
int a,b;

{

  if (a>=b) return -1;
  if (printing) printf ("Fills printer-rows %d - %d ...\n",a,b);

	if (zeilpos&&zeilpos<2399){
				for(i=zeilpos;i<2400;i++)zeile[i]=1;

				printzeile();  /* printzeile () transfers the code and does 1:3 conversion..*/
			    }
	for (i=0;i<2400;i++) zeile[i]=1;

	for (i=a;i<b-1;i++) printzeile ();

	y1=b;

return 1;
}

uebertragen(a,menge)
int a,menge;
{
  unsigned char ze[300];



 for (i=0;i<menge;i++) ze[i]=fgetc(eing);



			       /* zeily=0 :row finished */

		if (y1<=y)  {
				for (i=zeilpos;i<2400;i++)zeile[i]=1;
				if (printing) printf("y1<y: line ready to print!\n");
				printzeile();
			     }

 if (printing) printf("%d bytes at xpos %d ypos %d..\n",menge,a,y);



		for (i=zeilpos;i<x;i++)zeile[i]=1;
		     zeilpos=x;

		for (i=0;i<menge;i++)
		  {

		   zeile[zeilpos++]=((ze[i]&128)/128)^1;


		   zeile[zeilpos++]=((ze[i]&64)/64)^1;


		   zeile[zeilpos++]=((ze[i]&32)/32)^1;


		   zeile[zeilpos++]=((ze[i]&16)/16)^1;


		   zeile[zeilpos++]=((ze[i]&8)/8)^1;


		   zeile[zeilpos++]=((ze[i]&4)/4)^1;


		   zeile[zeilpos++]=((ze[i]&2)/2)^1;


		   zeile[zeilpos++]=(ze[i]&1)^1;


		  }

		y++;y1=y;



 return 1;

}

printzeile()
{
 int counter,zp,ii;
 char bits;

 zeilpos=0;  /*reset current printposition in line...*/
 zp=0;

	       /*  This must be changed in case of other relations

		   than 1:3 !!!!!
	       */

for (counter=0;counter<dpi;counter++)
 {
 bits=128*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=64*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=32*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=16*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=8*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=4*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=2*(zeile[zp++]&zeile[zp++]&zeile[zp++]);
 bits+=zeile[zp++]&zeile[zp++]&zeile[zp++];


 drzeile[drpos][counter]=bits;

}
 if (y3<y-1) {                                                          /* 3 lines are joint via OR - because of negative logic */
									/* AND must be used....*/
		if (test>=length/fak) {drpos=0;return -2;}

		for (ii=0;ii<dpi;ii++) {
					if (drpos==0) fputc(drzeile[0][ii],ausg);
					if (drpos==1) fputc(drzeile[0][ii]&drzeile[1][ii],ausg);
					if (drpos==2) fputc(drzeile[0][ii]&drzeile[1][ii]&drzeile[2][ii],ausg);

				       }
				   /*    fputc(volli,ausg);fputc(volli,ausg);      */   /* this line can be necessary at other resolutions, see below..! */
		if (printing)printf("Row %d transmitted because of jump >1!!\n",test);
		test++;
		y3=y;
		drpos=0;
		return 2;
		}


 drpos++;
 if (drpos==fak) {
		   drpos=0;                                /* see above: 3 lines are joined to give one...*/
		   if (test>=length/fak) return -2;

		   for (ii=0;ii<dpi;ii++) fputc (drzeile[0][ii]&drzeile[1][ii]&drzeile[2][ii],ausg);
	       /*		  fputc(volli,ausg);if (test!=1299)fputc(volli,ausg);           */   /* This line can be necessary at other resolutions...*/
		   if (printing) printf("Row %d transmitted!\n",test);
		   test++;
		 }


 y3=y;
return 1;
}