/*************************************************/
/*    rxlarc.cmd    SubFunctions for Larc.cmd    */
/*************************************************/
parse arg funcy, argA, argB, argC, argD, argE, argF, argG, argH, argI, argJ, argK, argL, argM, argN
   if funcy='CHARS' then retWert=A_CharsSUBR()
   else do
      call rxLarcInitSUBR
      select
         when funcy='ATTRIB'   then    call AttribFileSUBR
         when funcy='FIND'     then retWert=FindSUBR( argA, argB)
         when funcy='FINDZIP'  then address 'CMD' '@start /F /C rxLarc FINDZIP2'
         when funcy='FINDZIP2' then retWert=FindzipSUBR()
         when funcy='LARCINIT' then retWert=LarcinitSUBR( argA)
         when funcy='MENU'     then retWert=MenuF2SUBR()
         when funcy='OBJECT'   then    call ObjectWpsSUBR
         when funcy='RXANSWER' then retWert=rxanswerPROC( argA, argB, argC, argD)
         when funcy='SPACE'    then    call SpaceFreeSUBR
         when funcy='COPY00'   then retWert=copyMoveSUBR00('COPY')
         when funcy='MOVE00'   then retWert=copyMoveSUBR00('MOVE')
         when funcy='COPY01'   then retWert=copySUBR01()
         when funcy='COPY10'   then retWert=copySUBR10()
         when funcy='COPY11'   then retWert=copySUBR11()
         when funcy='DEL0'     then retWert=deleteSUBR0()
         when funcy='DEL1'     then retWert=deleteSUBR1()
         when funcy='MOVE01'   then retWert=moveSUBR01()
         when funcy='MOVE10'   then    call putMessageAskPROC 'not yet implemented, try F5 and then F8!'
         when funcy='MOVE11'   then    call putMessageAskPROC 'not yet implemented, try F5 and then F8!'
         otherwise NOP
      end
   end
return retWert

LarcinitSUBR:
   arg LarcScreenLines
   if rxfuncquery('SysLoadFuncs')=1 then do; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"; call SysLoadFuncs; end
   oldCmdQueue = 'OLD_CMD_Q'
   new_Q = rxqueue('create', oldCmdQueue) ; if new_Q <> oldCmdQueue then rc = rxqueue('delete', new_Q)
   call value 'PROMPT', '$R$S$T$S[$P]$S', 'OS2ENVIRONMENT'
   parse value SysTextScreenSize() with zeile spalte
   if zeile<>LarcScreenLines | spalte<>80 then do
      address 'CMD' '@mode con1 co80,'||LarcScreenLines
      parse value SysTextScreenSize() with zeile spalte
   end
return zeile

putMessageAskPROC: procedure expose zeile spalte Ansi.
   parse arg thisMessage
   call setLastLineSUBR
   call charout ,thisMessage ||Ansi.norm
   antw = translate( SysGetKey('NoEcho'))
   if antw='00'x | antw='E0'x then antw = antw || SysGetKey('NoEcho')
   call setLastLineSUBR
return antw

setLastLineSUBR:
   call SysCurState 'off'
   call SysCurPos zeile, 0
   call charout , copies(' ',79)||Ansi.norm
   call SysCurPos zeile, 0
   call SysCurState 'on'
return 0

displayFilesSUBR:
   parse arg cmd
   if FR.selected.0>zeile-3 then call SysCls
   else call SysCurPos zeile-(FR.selected.0+3),0
   do 2 ;  call charout ,left(' ', spalte) ; end
   do i=1 to FR.selected.0 ; call charout ,left('   'cmd  FR.selected.i, spalte) ; end
   call charout ,left(' ', spalte)
return 0

goDirPROC: procedure
   parse arg neuDir
   if right( neuDir, 2)<>':\' then neuDir = strip( neuDir, 'T', '\')
   call directory neuDir
return 0

stripStar_BsPROC: procedure
   arg file
   file = strip(file,'T','*')
   file = strip(file,'T','\')
return file

parseFileStringSUBR:
   parse arg selString
   u=0 ; allString=''
   do while selString <>''
      u=u+1
      parse var selString FR.selected.u '#' selString
      allString = allString FR.selected.u
      selString = strip( selString)
   end
   FR.selected.0 =u
return allString

rxLarcInitSUBR:
   KB.A_leftK ='009B'x
   KB.A_rghtK ='009D'x
   KB.C_bkspK ='7F'x
   KB.C_delK  ='E093'x
   KB.C_downK ='E091'x
   KB.C_endeK ='E075'x
   KB.C_homek ='E077'x
   KB.C_leftK ='E073'x
   KB.C_pgdnK ='E076'x
   KB.C_pgupK ='E084'x
   KB.C_rghtK ='E074'x
   KB.C_upK   ='E08D'x
   KB.F5      ='003F'x
   KB.F6      ='0040'x
   KB.S_F2    ='0055'x
   KB.S_F7    ='005A'x
   KB.bkspK   ='08'x
   KB.delK    ='E053'x
   KB.downK   ='E050'x
   KB.endeK   ='E04F'x
   KB.escpK   ='1B'x
   KB.homek   ='E047'x
   KB.insK    ='E052'x
   KB.leftK   ='E04B'x
   KB.pgdnK   ='E051'x
   KB.pgupK   ='E049'x
   KB.retnK   ='0D'x
   KB.rghtK   ='E04D'x
   KB.spceK   ='20'x
   KB.tabK    ='09'x
   KB.upK     ='E048'x
   Ansi.norm    ='1B'x||'[37;40m'
   Ansi.mark    ='1B'x||'[37;41m'
   Ansi.attribute='1B'x||'[32;40m'
   EscReturnSTR = ' ? ESC/Return'
   parse value SysTextScreenSize() with zeile spalte
   zeile = zeile-1
   retWert=0
return 0

A_CharsSUBR:
   s = argA
   Backspace='08'x;
   select
      when s='0081'x then s='0'
      when s='0078'x then s='1'
      when s='0079'x then s='2'
      when s='007A'x then s='3'
      when s='007B'x then s='4'
      when s='007C'x then s='5'
      when s='007D'x then s='6'
      when s='007E'x then s='7'
      when s='007F'x then s='8'
      when s='0080'x then s='9'
      when s='001E'x then s='A'
      when s='0030'x then s='B'
      when s='002E'x then s='C'
      when s='0020'x then s='D'
      when s='0012'x then s='E'
      when s='0021'x then s='F'
      when s='0022'x then s='G'
      when s='0023'x then s='H'
      when s='0017'x then s='I'
      when s='0024'x then s='J'
      when s='0025'x then s='K'
      when s='0026'x then s='L'
      when s='0032'x then s='M'
      when s='0031'x then s='N'
      when s='0018'x then s='O'
      when s='0019'x then s='P'
      when s='0010'x then s='Q'
      when s='0013'x then s='R'
      when s='001F'x then s='S'
      when s='0014'x then s='T'
      when s='0016'x then s='U'
      when s='002F'x then s='V'
      when s='0011'x then s='W'
      when s='002D'x then s='X'
      when s='0015'x then s='Y'
      when s='002C'x then s='Z'
      when s='0035'x then s='_'
      when s='0034'x then s='.'
      when s='000E'x then s=Backspace
      when s=Backspace then s=Backspace
      otherwise s =''
   end
return s

AttribFileSUBR:
   selectedFilesSTRING=argA
   call parseFileStringSUBR selectedFilesSTRING
   call SysCls
   say
   do i=1 to FR.selected.0
      FR.selected.i = strip(FR.selected.i,'T','\')
      call SysFileTree FR.selected.i, 'fund.', 'B'
      Ans = ''
      if pos('H', word(fund.1,4))>0 then Ans = Ansi.attribute
      if pos('R', word(fund.1,4))>0 then Ans = Ansi.attribute
      if pos('S', word(fund.1,4))>0 then Ans = Ansi.attribute
      say Ans||substr(fund.1,20) Ansi.norm
   end
   say
   say '           A  archive Bit'
   say '            D  directory  (No set/unset)' ||Ansi.attribute
   say '             H  hidden'
   say '              R  read only'
   say '               S  system'                 ||Ansi.norm
   say '                -  unset all'
   say
   call charout, '   ?   Esc/A '||Ansi.attribute||'HRS'||Ansi.norm ||'-' Ansi.attribute ' '
   antw = rxanswerPROC()
   call charout, Ansi.norm
   antw = translate( strip(antw))
   call SysCls
   say
   newAttr =''
   if antw <>'' then do
      if pos('A', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      newAttr = newAttr||'*'                          /*  DirectoryBit */
      if pos('H', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      if pos('R', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      if pos('S', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      call SysCls
      say
      setAttrBOOL=0
      do i=1 to FR.selected.0
         call SysFileTree FR.selected.i, 'fund.', 'B', '*****', newAttr
         if pos('H',word(fund.1,4))>0 |pos('R',word(fund.1,4))>0 |pos('S',word(fund.1,4))>0 then do
            say Ansi.attribute||substr(fund.1,20) Ansi.norm
            setAttrBOOL=1
         end
      end
      say
      if setAttrBOOL then do
         say ' ...press a key'
         call SysGetKey('NoEcho')
      end
   end
return 0

MenuF2SUBR:
   outTxt             =argA
   thisPathLarcMnuFILE=argB
   eingabe            =argC
   pathCurfileN       =argD
   currD.0            =argE
   currD.1            =argF
   selectedFilesSTR.0 =argG
   selectedFilesSTR.1 =argH
   archivFile.0       =argI
   archivFile.1       =argJ
   noHistoryBOOL =1
   menu. =0
   input =0
   tempfile.0 =0
   MnuFile= filespec('N',thisPathLarcMnuFILE)
   MnuFile= stream(MnuFile,'C','query exists')
   if eingabe=KB.S_F2 |MnuFile=''
      then MnuFile =stream(thisPathLarcMnuFILE,'C','query exists')
   if MnuFile<>'' then do
      m=0  ;n=0
      do while lines( MnuFile)
         liny = linein(MnuFile)
         if left(liny,1)=' ' |left(liny,1)=KB.tabK then do
            liny=strip(liny)
            if liny<>'' then do
               n=n+1
               menu.m.n=liny
               menu.m.0=n
            end
         end
         else do
            m=m+1
            n=0
            queue liny
         end
      end
      call stream MnuFile, 'C', 'Close'
      ret = rlist( ,'S', 1, 0, ' ? ESCAPE/RETURN to execute some of this Larc-Menu!' )
      parse var ret one Nr
      if one=1 & Nr<m+1 then do
         side=0
         do p=1 to menu.Nr.0
            outTxt=rxexec( outTxt,,
                           1,,
                           1,,
                           a_execOpt,,
                           1,,
                           menu.Nr.p,,
                           pathCurfileN,,
                           currD.0,,
                           currD.1,,
                           side,,
                           '',,
                           '',,
                           selectedFilesSTR.0,,
                           selectedFilesSTR.1,,
                           archivFile.0,,
                           archivFile.1,,
                           'L',,
                           noHistoryBOOL)
         end
      end
   end
return outTxt

ObjectWpsSUBR:                  /*   Larc a_F6 makeWpsObject    */
   DrvPathName= argA
   WpsName    = argB
   Params     = argC
   if WpsName= '' then do
      lastBS = lastpos('\',DrvPathName)
      WpsName= substr( DrvPathName, lastBS+1, lastpos('.',DrvPathName)-(lastBS+1) )
      first  = translate(left(WpsName,1))
      WpsName= overlay( first, WpsName)
   end
   if Params<>'' then setup=Params
   else do
      Ext = Translate(right(DrvPathName,4))
      If (Ext <> '.EXE') & (Ext <> '.CMD') & (Ext <> '.COM') & (Ext <> '.BAT') then do
         call putMessageAskPROC ' ERROR:  WpsObject only *.EXE *.Bat *.CMD  Files!'
         RETURN 0
      end
      if pos(':\', DrvPathName )<> 2 then do
         call putMessageAskPROC ' ERROR:  Give me Drv:\Path\Name!'
         RETURN 0
      end
      lastBS = lastpos('\',DrvPathName)
      setup = ';EXENAME='||DrvPathName||';STARTUPDIR='||left(DrvPathName, lastBS-1)
   end
   call SysCls
   say;say; say; say '   WpsName:'; say '"'WpsName'"'
   say;say; say; say '   setupString:' ; say '"'setup'"'
   say;say; say; call charout ,'   Esc\Return  Create WpsObject?  '
   if SysGetKey('NoEcho')=d2c(13) then do
      ret=SysCreateObject( "WPProgram", WpsName, "<WP_DESKTOP>", setup, "f")
      if ret=1 then say 'Success!'
               else say "ERROR: already an object with same name on WPS?"
      '@pause'
   end
return 0

rxanswerPROC: procedure expose KB.
   parse arg Message, Suggestion, overstrikeBOOL, firstCurPos
   parse value SysTextScreenSize() with zeile spalte
   zeile = zeile-1
   parse value SysCurPos() with firstRow firstCol
   antwort = Suggestion
   antw.0  = length( antwort)
   do i=1 to antw.0; antw.i= substr( antwort,i,1); end
   if overstrikeBOOL <>1        then overstrikeBOOL =0
   if datatype(firstCurPos,'W') then charN = firstCurPos ; else charN = 1
   if      charN > antw.0+1     then charN = antw.0+1
   else if charN < 1            then charN = 1
   do until chary=KB.retnK | chary=KB.escpK
      lenMess =length( Message)
      do until lenMess+antw.0 <= lenScreen
         lenScreen = ((zeile+1) * spalte)-((firstRow*spalte)+firstCol+1)
         if lenScreen < lenMess+antw.0 then do
            firstRow = firstRow -1
            lenScreen = ((zeile+1) * spalte)-((firstRow*spalte)+firstCol+1)
            call SysCurPos zeile, 0
            say
         end
      end
      antwort ='' ; do i=1 to antw.0; antwort=antwort||antw.i; end
      call SysCurPos firstRow, firstCol
      call charout ,Message||antwort||copies(' ',lenScreen-(lenMess+antw.0))
      scr =(firstRow*spalte)+firstCol+lenMess+charN-1
      call SysCurPos scr%spalte, scr//spalte
      call SysCurState 'On'
      chary = SysGetKey('NoEcho')
      if chary='E0'x|chary='00'x then chary =chary||SysGetKey('NoEcho')
      call SysCurState 'Off'
      select
         when chary = KB.retnK then NOP
         when chary = KB.escpK then antwort=''
         when chary = KB.leftK then
            if charN>1 then charN = charN -1
         when chary = KB.rghtK then
            if charN <= antw.0 then charN=charN+1
         when chary = KB.homek|chary=KB.C_homek|chary=KB.A_leftK
            then charN = 1
         when chary = KB.endeK|chary=KB.C_endeK|chary=KB.A_rghtK
            then charN = antw.0+1
         when chary = KB.insK then do
               if overstrikeBOOL then overstrikeBOOL=0
               else overstrikeBOOL=1
         end
         when chary=KB.C_leftK then do
               do i= charN-2 to 1 by -1; if antw.i = ' ' then leave i;end
               if i<1 then charN=1; else charN=i
         end
         when chary=KB.C_rghtK then do
               do i=charN+2 to antw.0; if antw.i= ' ' then leave i;end
               if i>antw.0 then charN = antw.0+1
               else charN = i
         end
         when chary=KB.upK then do
               charN = charN - spalte
               if charN < 1 then charN = 1
         end
         when chary=KB.downK then do
               charN = charN + spalte
               if charN > antw.0 then charN = antw.0 +1
         end
         when chary=KB.delK then do
            if charN <= antw.0 then do
               do j=charN to antw.0 ; h=j+1; antw.j=antw.h; end
               antw.0 = antw.0-1
            end
         end
         when chary=KB.C_delK then do
            if charN <= antw.0 then do y=1 to antw.0
               if charN>antw.0 then leave y
               do j=charN to antw.0 ; h=j+1; antw.j=antw.h; end
               antw.0 = antw.0-1
               if antw.charN='20'x then leave y
            end
         end
         when chary = KB.bkspK then do
            if charN > 1 then do
               charN = charN-1
               do j=charN to antw.0; h=j+1; antw.j=antw.h; end
               antw.0 = antw.0 -1
            end
         end
         when chary = KB.C_bkspK then do
            do y=1 to antw.0
               if charN=1 then leave y
               charN = charN-1
               antw.0 = antw.0 -1
               if antw.charN==' ' then do
                  do j=charN to antw.0; h=j+1; antw.j=antw.h; end
                  leave y
               end
               do j=charN to antw.0; h=j+1; antw.j=antw.h; end
            end
         end
         when overstrikeBOOL=0 then do
               chary = right( chary,1)
               antw.0 = antw.0+1; h = antw.0+1; antw.h = ' '
               do j=antw.0 to charN+1 by -1; h=j-1; antw.j=antw.h; end
               antw.charN = chary
               charN = charN + 1
         end
         when overstrikeBOOL=1 then do
               chary = right( chary,1)
               antw.charN = chary
               call charout, antw.charN
               if charN > antw.0 then antw.0=charN
               charN = charN + 1
         end
         otherwise NOP
      end /* select */
   end
   call SysCurPos firstRow, firstCol
   call charout , Message||antwort
return antwort

SpaceFreeSUBR:
   parse value SysDriveInfo( left(directory(),2)) with drv free ges label
   retWert = '  ' drv format((free%1024)/1000,4,3) 'kB free   'format((ges%1024)/1000,4,3) 'kB total'
return retWert

copyMoveSUBR00:
   arg commando
   copiedBOOL=0 ; allBOOL=0 ; stopBOOL=0 ; nothingFile.0 =0
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   if BOOL_renCopyMoveSUBR00() then do i=1 to Fcopy.0
      if stopBOOL then leave i
      call SysFileTree strip( Fcopy.i,'T','\'), 'cfund.', 'B', '*****', '**---'
      call SysFileTree strip( copyF.i,'T','\'), 'fundc.', 'B', '*****', '**---'
      if BOOL_acceptOverwriteSUBR00( fundc.0, Fcopy.i) then do
         if commando='COPY' then do
            if right( Fcopy.i,1)<>'\' then do
               address 'CMD' 'copy "'||Fcopy.i||'" "'||copyF.i||'"'
               call ErrorStopSUBR RC
            end
            else do
               call SysMkDir strip( copyF.i ,'T','\')
               address 'CMD' 'xcopy "'||Fcopy.i||'*" "'||copyF.i||'*" /S /E /V /H /T /R /O'
               if RC>1 then call ErrorStopSUBR RC
            end
         end
         else if commando='MOVE' then do
            if fundc.0=0 & left(FR.currD.side,2)=left(copyF.i,2) then do
               address 'CMD' 'move "'||strip( Fcopy.i, 'T', '\')||'" "'||substr( strip( copyF.i, 'T','\'),3)||'"'
               call ErrorStopSUBR RC
            end
            else do
               if right(Fcopy.i,1)<>'\' then do
                  address 'CMD' 'copy "'||Fcopy.i||'" "'||copyF.i||'"'
               end
               else do
                  call SysMkDir strip( copyF.i ,'T','\')
                  address 'CMD' 'xcopy' Fcopy.i||'*' copyF.i||'* /S /E /V /H /T /R /O'
               end
               if RC>1 then call ErrorStopSUBR RC
               else call proveDeleteSUBR00 RC, Fcopy.i, copyF.i
            end
         end
         copiedBOOL=1
      end
   end
   if stopBOOL & nothingFile.0>0 then do
      say ; say ; say '  STOP: '
      do i=1 to nothingFile.0 ; say '  No' commando 'done with: ' nothingFile.i ; end ; say
   end
return copiedBOOL

BOOL_renCopyMoveSUBR00:
   if FR.selected.0>zeile-3 then call SysCls
   else call SysCurPos zeile-(FR.selected.0+3),0
   do 2 ;  call charout ,left(' ', spalte) ; end
   do i=1 to FR.selected.0
      Fcopy.i = FR.selected.i
      copyF.i = FR.currD.opposide|| FR.selected.i
      if right( Fcopy.i,1)='\' then st= '*' ; else st=''
      call charout , right(FR.currD.side,18)||left( Fcopy.i||st,16)||'-->>  '||left( copyF.i||st,spalte-40)
   end
   call charout ,left(' ', spalte)
   Fcopy.0 = FR.selected.0
   if Fcopy.0 >1 then do
      antw =putMessageAskPROC( EscReturnSTR||'  ' Ansi.mark commando' ')
           if antw = KB.retnK                      then antw =1
      else if commando ='MOVE' & antw    =KB.F6  then antw =1
      else if commando ='COPY' & copyF.1 =KB.F5  then antw =1
      else                                            antw =0
   end
   else do
      call SysCurPos zeile, 0
      copyF.1 =rxanswerPROC( ' ? Esc\Return  'commando' to: ', strip( copyF.1, 'T','\'), 0, 0, length(copyF.1)+1)
      if copyF.1 = '' then antw =0
      else do
         antw = 1
         copyF.1 = strip( copyF.1)
         copyF.1 = strip( copyF.1, 'T','*')
         copyF.1 = strip( copyF.1, 'T','\')
         if pos( ':', copyF.1 )=2
            then NOP
         else if pos( translate(substr( FR.currD.side,3)), translate( copyF.1)) =1
            then copyF.1 = left(FR.currD.side,2) ||copyF.1
         else if pos('\', copyF.1)<>1
            then copyF.1 = FR.currD.side ||copyF.1
         if right( Fcopy.1,1) ='\' then copyF.1 = copyF.1||'\'
      end
      call SysCurPos zeile, 0
      call charout , left(' ', 79)
   end
return antw

BOOL_acceptOverwriteSUBR00:
   parse arg fundc_0, Fcopy.i
   antw =1
   if allBOOL=0 & fundc_0 >0 then do
      say
      if right( Fcopy.i,1)='\' then do
         call SysFileTree  Fcopy.i||'*', 'cfund.', 'FS', '*****', '**---'
         z=0 ; say ; wegLen =length( FR.currD.side)+1
         do j=1 to cfund.0
            cfund.j = word( cfund.j, 5)
            call SysFileTree  FR.currD.opposide||substr( cfund.j, wegLen), 'fundy.', 'F', '*****', '**---'
            if fundy.0>0 then do
               z=z+1
               fundc.z =word( fundy.1,5)
               say '     ?  overwrite: ' left(fundc.z, 50)
            end
         end
      end
      else do
         do j=1 to fundc.0
            fundc.j = word( fundc.j,5)
            say '     ?  overwrite: ' left(fundc.j, 50)
         end
      end
      say
      if z>0 then do
         antw = putMessageAskPROC( EscReturnSTR||'/[S]top/[A]ll  ' Ansi.mark ' really? ' Ansi.norm)
         call SysCurPos zeile, 0 ; call charout , left(' ', 79)
      end
      else antw=KB.retnK
      if antw =KB.retnK                       then antw =1
      else if commando = 'MOVE' & antw = KB.F6 then antw =1
      else if commando = 'COPY' & antw = KB.F5 then antw =1
      else if antw ='A' then do  ;  allBOOL=1 ;      antw =1 ; end
      else do
         if antw ='S' then stopBOOL=1
         antw =0
         nothingFile.0 =nothingFile.0+1
         h =nothingFile.0
         nothingFile.h = Fcopy.i||st
      end
   end
   else if commando='MOVE' & left(FR.currD.side,2)<>left(copyF.i,2) then do
      if right( Fcopy.i,1)='\' then do
         call SysFileTree  Fcopy.i||'*', 'cfund.', 'FS', '*****', '**---'
         do j=1 to cfund.0
            cfund.j = word( cfund.j, 5)
         end
      end
   end
return antw

proveDeleteSUBR00:
   parse arg RCode, deletefile, provefile
   if RCode>0 then do
      if RCode=1 & right(deletefile,1)= '\' then do
         call SysFileTree strip( provefile,'T','\'), 'fundc.', 'DO'
         if fundc.0=1 then call SysRmDir strip( deletefile,'T','\')
      end
      else say Ansi.mark' ERROR: 'RC Ansi.norm
   end
   else if right( deletefile, 1)='\' then do
      do j=1 to cfund.0
         ret = SysFileDelete( cfund.j)
         say ' -rxLarc- MoveDel:  'cfund.j
      end
      call SysFileTree deletefile||'*', 'cfund.', 'DS', '*****', '-+---'
      do j=cfund.0 to 1 by -1 ; call SysRmDir word( cfund.j,5) ; end
      call SysRmDir strip( deletefile,'T','\')
   end
   else do
      copdatime = stream( provefile,'C','query datetime')
      FRsdatime = stream( deletefile,'C','query datetime')
      if copdatime = FRsdatime then do
         copnam = stream( provefile,'C','query exists')
         FRsnam = stream( deletefile,'C','query exists')
         if FRsnam <> copnam then do
            call SysFileDelete FRsnam
            delPOS = pos( translate(deletefile), translate(FRsnam))
            if delPOS>2 then FRsnam = insert( ' "',FRsnam, delPOS-1)
            say ' -rxLarc- MoveDel:  'FRsnam'"'
         end
      end
   end
return 0

ErrorStopSUBR:
   arg RCode
   if RCode<>0 then do
      antw = putMessageAskPROC(' ? ESCAPE/[S]top ' Ansi.mark 'ERROR:' RCode Ansi.norm)
      call SysCurPos zeile, 0 ; call charout , left(' ', 79)
      if antw ='S' then do
         stopBOOL=1
         allBOOL=1
         antw =0
         nothingFile.0 =nothingFile.0+1
         h =nothingFile.0
         nothingFile.h = Fcopy.i||st
      end
      else antw=1
   end
return 0

copySUBR01:
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='\' then FR.selected.i = FR.selected.i || '*'
   end
   call displayFilesSUBR ' arch '
   antw = putMessageAskPROC( EscReturnSTR||'/1-9 (1-9 UpPath)  pack to: 'FR.archivFile.opposide'   ? ')
   if antw = KB.retnK then antw = 0
   if datatype(antw,'W') then do
      call setlocal
      do antw ; 'cd.. 2>nul';end
      xcurrdir = directory()
      lenxc = length( strip(xcurrdir,'T','\'))+2
      files = ''
      rekursivBOOL =0
      do i=1 to FR.selected.0
         copiedBOOL=1
         if right(FR.selected.i,2)='\*' then rekursivBOOL =1
         files = files substr( FR.currD.side||FR.selected.i, lenxc)
         if length( files)>700 then do
            if rekursivBOOL then call execSUBR ARC_packRecursiv1.opposide FR.archivFile.opposide files
            else                 call execSUBR ARC_packFile1.opposide FR.archivFile.opposide files
            rekursivBOOL = 0
         end
      end
      if files <>'' then do
         if rekursivBOOL then call execSUBR ARC_packRecursiv1.opposide FR.archivFile.opposide files
         else                 call execSUBR ARC_packFile1.opposide FR.archivFile.opposide files
      end
      call endlocal
   end
return copiedBOOL

copySUBR10:
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   call displayFilesSUBR ' exArc '
   call goDirPROC FR.currD.opposide
   z =0
   copiedBOOL=0
   do i=1 to FR.selected.0
      existfile = stream( FR.selected.i, 'C','query exists')
      if existfile <>'' then call charout , Ansi.mark||left(' ?  overwrite:  'existfile ,spalte-1)||Ansi.norm||' '
   end
   antw = putMessageAskPROC( EscReturnSTR||'=withPath/0=noPath  extrakt to: 'FR.currD.opposide '? ')
   if antw = KB.retnK then antw = 1
   if datatype( antw, 'W') = 1 then do
      files = ''
      do i=1 to FR.selected.0
         copiedBOOL=1
         files = files FR.selected.i
         if length( files)>700 then do
            if antw > 0 then ARC_extractPathFile1.side  FR.archivFile.side files
            else             ARC_extractNoPthFile1.side FR.archivFile.side files
            if RC>0 then '@pause'
            files = ''
         end
      end
      if files <>'' then do
         if antw > 0 then ARC_extractPathFile1.side  FR.archivFile.side files
         else             ARC_extractNoPthFile1.side FR.archivFile.side files
         if RC>0 then '@pause'
      end
   end
   call goDirPROC FR.currD.side
return copiedBOOL

Inits_CopyMoveSUBR:
   selectedFilesSTRING =argA
   FR.currD.side=argB
   FR.currD.opposide=argC
   FR.archivFile.side=argD
   FR.archivFile.opposide=argE
   ARC_extractNoPthFile1.side=argF
   ARC_extractNoPthFile1.opposide=argG
   ARC_extractPathFile1.side=argH
   ARC_extractPathFile1.opposide=argI
   ARC_packFile1.side=argJ
   ARC_packFile1.opposide=argK
   ARC_packRecursiv1.side=argL
   ARC_packRecursiv1.opposide=argM
   ARC_moPaFi1.opposide =argN
   copiedBOOL =0
return 0

copySUBR11:
   call Inits_CopyMoveSUBR
   selectedFilesSTRING =parseFileStringSUBR( selectedFilesSTRING)
   tempDir = SysTempFileName( FR.currD.opposide||'????Larc.tmp')
   call SysMkDir tempDir
   neuDir = directory( tempDir)
   if neuDir=tempDir then do
      call displayFilesSUBR ' move '
      antw = putMessageAskPROC( EscReturnSTR||'   extrakt-pack to: 'FR.ArchivFile.opposide' ? ')
      if antw=KB.retnK then do
         if word(ARC_packFile1.opposide,1 )<>'echo' then do
            copiedBOOL = 1
            ARC_extractPathFile1.side FR.archivFile.side selectedFilesSTRING
            if RC>0 then 'pause'
            ARC_packFile1.opposide FR.archivFile.opposide selectedFilesSTRING
            if RC>0 then 'pause'
            ret = SysFileTree( tempDir'\*' , 'fund.', 'FS', '*-***', '-----')
            do i=fund.0 to 1 by -1; fund.i= word(fund.i,words(fund.i)); call SysFileDelete fund.i; end
            ret = SysFileTree( tempDir'\*' , 'fund.', 'DS', '*+***', '*+---')
            do i=fund.0 to 1 by -1; fund.i= word(fund.i,words(fund.i));call directory fund.i; call directory '..' ; ret =SysRmDir( filespec('N',fund.i)) ; end
         end
      end; else say ARC_packFile1.opposide
   end ;   else say '  -rxLarc- ERROR:  TempDirectory'
   call goDirPROC FR.currD.side
   call SysRmDir tempDir
return copiedBOOL

deleteSUBR0:
   selectedFilesSTRING=argA
   call parseFileStringSUBR selectedFilesSTRING
   allBOOL=0
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='\' then FR.selected.i = FR.selected.i || '*'
   end
   call displayFilesSUBR ' del '
   deletedBOOL=0
   if KB.retnK=putMessageAskPROC( Ansi.mark||EscReturnSTR||'  delete Files ?!?    ') then do
      deletedBOOL=1
      do i=FR.selected.0 to 1 by -1
         if right( FR.selected.i,1)<>'*' then call SysFileDelete FR.selected.i
         else do
            call SysFileTree FR.selected.i, 'fund.', 'BS', '*****', '-*---'
            FR.selected.i = strip( FR.selected.i,'T','*')
            FR.selected.i = strip( FR.selected.i,'T','\')
            if fund.0 > 0 then do
               call SysCls ; say ; say
               do j=fund.0 to 1 by -1
                  parse var fund.j a b c attr.j fund.j
                  fund.j = strip(fund.j)
                  if pos('D', attr.j)=2 then NOP
                  else say '   ' fund.j
               end
               say
               if \allBOOL then do
                  antw =putMessageAskPROC( EscReturnSTR||'/[S]top/[A]ll  ' Ansi.mark 'delete?  really? ')
                  if antw='A'| antw='a' then do
                     antw =KB.retnK
                     allBOOL=1
                  end
               end
               if antw =KB.retnK then do
                  deldir.0 = 0
                  do j= 1 to fund.0
                     if pos('D', attr.j)=2 then do
                        deldir.0 = deldir.0 +1
                        h = deldir.0
                        deldir.h = fund.j
                     end
                     else call SysFileDelete fund.j
                  end
                  do j=deldir.0 to 1 by -1
                     call SysRmDir deldir.j
                  end
                  call SysRmDir FR.selected.i
               end
            end
            else call SysRmDir FR.selected.i
         end
      end
   end
return deletedBOOL

deleteSUBR1:
   selectedFilesSTRING=argA
   FR.archivFile.side=argB
   ARC_DelFil1.side=argC
   call parseFileStringSUBR selectedFilesSTRING
   call displayFilesSUBR ' del '
   deletedBOOL=0
   files = ''
   if KB.retnK=putMessageAskPROC( Ansi.mark||EscReturnSTR||'  delete Files ?!?    ') then do
      do i=1 to FR.selected.0
         deletedBOOL=1
         files = files FR.selected.i
         if length( files)>700 then call execSUBR ARC_DelFil1.side FR.archivFile.side files
      end
      if files <>'' then call execSUBR ARC_DelFil1.side FR.archivFile.side files
   end
return deletedBOOL

moveSUBR01:
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='\' then FR.selected.i = FR.selected.i || '*'
   end
   call displayFilesSUBR ' move-arch '
   antw = putMessageAskPROC( EscReturnSTR||'/1-9 (1-9 UpPath)  pack to: 'FR.archivFile.opposide'   ? ')
   if antw = KB.retnK then antw = 0
   if datatype( antw, 'W') = 1 then do
      call setlocal
      copiedBOOL=1
      do antw ; 'cd.. 2>nul';end
      xcurrdir = directory()
      lenxc = length( strip(xcurrdir,'T','\'))+2
      files = ''
      do i=1 to FR.selected.0
         files = files substr( FR.currD.side||FR.selected.i, lenxc)
         if length( files)>700 then call execSUBR ARC_moPaFi1.opposide FR.archivFile.opposide files
      end
      if files <>'' then call execSUBR ARC_moPaFi1.opposide FR.archivFile.opposide files
      call endlocal
   end
return copiedBOOL

execSUBR:
   parse arg dothis
   address 'CMD' dothis
   if RC>0 then '@pause'
   files = ''
return 0

LarcBB2_SUBR:
   parse source . . thisRexx
   larc_bb2FILE = filespec('D',thisRexx) ||filespec( 'P',thisRexx)||'larc.bb2'
   nrecord = strip( linein( larc_bb2FILE))
   ARC_ext.0 =0
   do while lines( larc_bb2FILE)
      do i=1 to nrecord
         do until firstByte <> ';'
            liny = linein( larc_bb2FILE)
            firstByte = left( liny,1)
            if lines(larc_bb2FILE)=0 then do
               call stream larc_bb2FILE, 'C', 'CLOSE'
               RETURN 0
            end
         end
         liny =strip( liny,'T')
         if liny=='' then liny='@echo  -LARC- Function not found: '
         select
            when i=2 then do
               ARC_ext.0 =ARC_ext.0+1
               Nr = ARC_ext.0
               ARC_ext.Nr    =liny
            end
            when i=4 then  ARC_listAF.Nr =liny
            when i=15 then ARC_AStrng.Nr =liny
            when i=16 then ARC_Estrng.Nr =liny
            when i=21 then ARC_nameNr.Nr =liny +1
            when i=22 then ARC_ex2pip.Nr =liny
            otherwise NOP
         end
      end
   end
return 0

FindSUBR:
   parse arg goDirBOOL, Message
   if goDirBOOL<>1 then goDirBOOL =0
   suchy = strip( directory(),'T','\')||'\*'
   call setLastLineSUBR
   suchy = rxanswerPROC('  Find Files: ',suchy,0,length(suchy))
   suchy = strip( suchy)
   call setLastLineSUBR
   if suchy<>'' then do
      call SysFileTree suchy, 'key.', 'FSO'
      ret =rListgoSUBR('  F3 view  F4 edit   'Message, 'S')
   end
return retFile

FindzipSUBR:
   suchy = strip( directory(),'T','\')||'\*'
   suchy = rxanswerPROC('  Find Files & <ZIP>\Files     FileSpec: ',suchy,0,length(suchy)+1)
   suchy = strip( suchy)
   call setLastLineSUBR
   if suchy<>'' then do
      call goDirPROC filespec('D',suchy)||filespec('P',suchy)
      suchy = substr( suchy, lastpos('\', suchy)+1 )
      suchy = strip( suchy)
      say directory()'> dir' suchy
      call SysFileTree suchy, 'key.', 'FSO'
      do i=1 to key.0 ; pipe.i = 'type' ; end
      call LarcBB2_SUBR
      k=key.0
      do i=1 to ARC_ext.0
         call SysFileTree '*.'||ARC_ext.i, 'fund.', 'FSO'
         do j=1 to fund.0
            address 'CMD' ARC_listAF.i fund.j suchy '| rxqueue'
            say '  file find "'suchy'"  in:' fund.j
            do z= 1 to queued()
               parse pull vdkey
               if pos( ARC_AStrng.i, vdkey)>0 then leave z
            end
            listAnfBOOL=0; EndBOOL=0
            do while queued() > 0
               parse pull vdkey
               if words( vdkey)=1 then do ; parse pull wkey ; vdkey = vdkey wkey ; end
               if pos( ARC_Estrng.i, vdkey)>0 then EndBOOL=1
               else if EndBOOL=0 then do
                  file = translate( word( vdkey, ARC_nameNr.i), '\', '/', '\')
                  k = k + 1
                  key.k  = fund.j ' 'file
                  pipe.k = ARC_ex2pip.i
               end
            end
         end
      end
      key.0=k
      do until command.0=0
         goDirBOOL=1
         ret=rListgoSUBR( ' ? ESC/Return    select one: Larc    more: Text find with grep', 'M')
         parse var ret command.0 ret
         if      command.0=1 then call Larc retFile
         else if command.0>1 then do
            do i=1 to command.0
               k= strip( word(ret,i))
               command.i = pipe.k key.k
            end
            tmpFile = SysTempFileName('C:\???found.TXT')
            commandz ='| grep.exe -1 -hin -e "" >>'tmpFile
            gropt.0 ='Help for GNU-Grep:'
            gropt.1 ='  grep -<n> -[chilnqsvwx] -e "text"'
            gropt.2 ='   -<n> <n>um lines context'
            gropt.3 ='   -h   No file names'
            gropt.4 ='   -i   ignore case'
            gropt.5 ='   -n   number of line'
            gropt.6 ='   -v   only no-match-lines'
            gropt.7 ='   -w   only when match is a word'
            gropt.8=''
            gropt.9=''
            k=command.0
            gropt.10= ''
            gropt.11= k' files  -  last selected:'
            gropt.12= command.k '| ...Your commands...'
            gropt.13=''
            gropt.14=''
            gropt.15=''
            gropt.16=' ? ESC/Return     give: -e "text"'
            gropt.17=''
            call SysCls ; do i=0 to 17 ; say gropt.i ; end
            commandz = rxanswerPROC( '<pipe> [fileZIP] <file> ',commandz,0,length(commandz)-18 )
            if commandz <>'' then do
               call SysCls
               do i=1 to command.0
                  address 'CMD' command.i commandz
                  say left('  -rxLarc-  processed:' command.i, spalte-1)
                  if RC=0 & pos( '>>'||tmpFile, commandz)>0 then do
                     call lineout tmpFile, ' '
                     call lineout tmpFile, left( word(command.i, words(command.i))' ', spalte-1, '-')
                     call lineout tmpFile, 'start "rlist" /F /C "' command.i '|rlist"'
                     call lineout tmpFile, ' '
                     call lineout tmpFile, ' '
                     call lineout tmpFile
                  end
               end
               call beep 1111, 111
               if stream( tmpFile, 'C', 'query exists')<>'' then address 'CMD' 'start /PM epm.exe /h /o' tmpFile
            end
         end
      end
   end
return 0

rListgoSUBR:
   parse arg Message, single
   ret=0
   do queued() ; pull some ; end
   do i=1 to key.0 ; queue key.i ; end
   ret = rlist( ,single, 1, 0, Message)
   if goDirBOOL & word(ret, 1)=1 then do
      k=word(ret,2)
      retFile = strip( key.k)
      neuDir = word( retFile,1)
      neuDir=  filespec( 'D', neuDir)|| strip( filespec('P',neuDir),'T','\')
      call directory neuDir
   end
return ret


