/****************************************************************************/
/*   rList.cmd   OS/2-Rexx         Usage:  rList file.txt                   */
/*   RexxLister            needs in PATH:  rxExec rxLarc clipb sortl tedit  */
/****************************************************************************/
    F4editFile ='tedit.exe'
Alt_F4editFile ='start /PM Epm.exe /h /o'
Alt_F3listFile ='start /C /F Less.exe'
Alt_Return     ='start /f /c'
binEditFile    ='start /PM sedit.exe'
/************************ F1 online - Help **********************************/
hlp.1 =' rList - Help ͻ'
hlp.2 ='       F1    - help                Ctrl-q      - prev.listed    '
hlp.3 ='       F2    - save marks          Ctrl-h      - hex 10 chars   '
hlp.4 ='       F3    - view file*          Ctrl-k      - compare Pos.   '
hlp.5 ='       F4    - edit file*          Ctrl-l      - line fit       '
hlp.6 ='   Alt-F3    - alternate view      Ctrl-n      - list prev.file '
hlp.7 ='   Alt-F4    - alternate edit      Ctrl-o      - shell          '
hlp.8 ='  Ctrl-F4    - edit act file       Ctrl-t      - Tabs convert   '
hlp.9 ='       F7    - find                Ctrl-INSERT - marked to clip '
hlp.10='  Ctrl-F7    - mark findings        Alt-INSERT - clip to shell  '
hlp.11='   Alt-F8    - history (shell)      Alt-<word> - go 1.word-line '
hlp.12='       F11   - clear marks              <num>  - go to line     '
hlp.13='  + -  F12   - (un)mark all       SPACE INSERT - (un)mark Line  '
hlp.14='  Ctrl-F12   - reverse mark          UP DOWN   - up   down      '
hlp.15='  Ctrl-r     - reverse sort    LEFT Alt-RIGHT  - left right     '
hlp.16='  Ctrl-f     - float   sort        Ctrl-RETURN - execute line   '
hlp.17='  Ctrl-g     - GerDate sort             RETURN - select & Quit  '
hlp.18='  Ctrl-u     - USADate sort             ESCAPE - Quit           '
hlp.19='    sort: at 1.char of screen                                   '
hlp.20='   *file: is 1.word of screen    -2-binary: hex<20x|empty=FFx   '
hlp.21=' Esc to exit ͼ'
hlp.0 =21
/****************************************************************************/
/*   As a Menu-RexxFunction use rList:                                                   */
/*   a) Give a file and get a selected line                                 */
/*         selected =rList('c:\autoexec.bat','S')                           */
/*         if word(selected,1)=1 then Line_Number = word(selected,2)        */
/*   b) Take a RexxQueue:                                                   */
/*         do i=1 to all_Lines.0 ; queue line.i; end                        */
/*         selected = rList()                                               */
/*         do i=1 to word(selected,1); h=i+1; sel.i=word( selected,h); end  */
/*  Fido:  Ralph Ulrich@2:2468/5103.23    or  Ralph Ulrich@2:2468/9911.31   */
/****************************************************************************/
parse arg infile, SingleMulti, sbs, ScrollBOOL, MessageSTRING
      if SingleMulti='s'|SingleMulti='S' then multiSelectBOOL=0
         else multiSelectBOOL=1
      if datatype(sbs,'W')=0 then sbs=1 ; else if sbs<0 then sbs=1
      if ScrollBOOL<>0 then ScrollBOOL=1
      call _qListInits
      SIGNAL on HALT name CleanUpMARKE
      binFileBOOL=0 ; tabsBOOL=0 ;tabsConvBOOL=0
      infile = strip(infile)
      if infile <> '' then do
         thisfile = stream( infile, 'C', 'query exists')
         if thisfile = '' then do
            call SysFileTree infile||'*', 'datfund.', 'FO'
            if datfund.0 > 0 then infile = datfund.1
         end
         else infile = thisfile
         Ext = translate(right(infile,4))
         if pos(Ext,'.EXE_.ZIP_.ARJ_.DLL_.RAR_')>0 then binFileBOOL=1
         ret = stream( infile, 'C', 'OPEN READ')
         if abbrev( ret, 'NOTREADY', 8)  then do
            if MessageSTRING<>'' then do
               call putMessageAskSUBR 0, MessageSTRING
               say
            end
            call putMessageAskSUBR 1, '  -rList-   ERROR File open:  "'infile'"'
            SIGNAL nothingMARKE
         end
         i = 0
         do while lines( infile)
            i= i+1
            key.i = linein( infile)
            if \binFileBOOL then do
               firstchar = left(key.i,1)
               if firstchar ='09'x then tabsConvBOOL =1
               else if firstchar <'09'x then binFileBOOL=1
               else if i=zeile then call preView
            end
            else do
               call charin infile,1,0
               gesamt = stream( infile, 'C', 'query size')
               inByte = 120
               this = (gesamt % inByte)
               i=0
               do this
                  some = charin(infile,,inByte)
                  i=i+2 ; j=i-1
                  parse var some hkey.j 61 hkey.i
               end
               some = charin(infile,,(gesamt // inByte))
               do until some='' ; i=i+1; parse var some hkey.i 61 some ; end
               hkey.0=i
               infileBOOL = 1
            end
         end
         key.0 = i
         call stream infile, 'C', 'Close'
      end
      else do
         i = 0
         infile = 'Pipe'
         do while lines()
            i = i + 1
            parse value linein() with key.i
            if length( key.i)=0 then i = i -1
            else if \binFileBOOL then do
               firstchar = left(key.i,1)
               if firstchar ='09'x then tabsConvBOOL =1
               else if firstchar <'09'x then binFileBOOL=1
               else if i = zeile then call preView
            end
         end
         if i = 0 then do
            infile = 'rxQueue'
            do while queued()>0
               i = i + 1
               parse pull key.i
               if \binFileBOOL then do
                  firstchar = left(key.i,1)
                  if firstchar ='09'x then tabsConvBOOL =1
                  else if firstchar <'09'x then binFileBOOL=1
                  else if i = zeile then call preView
               end
            end
         end
         key.0 = i
      end
      if binFileBOOL then call binConvertSUBR
      else if tabsConvBOOL then call tabsConvertSUBR
      call oldCurSUBR
      selected = qListSUBR( infile, multiSelectBOOL, sbs, ScrollBOOL, MessageSTRING )
nothingMARKE:
return selected

LineFitSUBR:
   if binFileBOOL       then RETURN 0
   if infile ='rxQueue' then RETURN 0
                          /* Since a rxQueue is a Menu LineFit is bad! */
   call tabsConvertSUBR
   call SysCurState 'off'
   call SysCurPos zeile, 0
   call charout ,copies(' ',12) '<- Line fit  '
   call SysCurPos zeile, 0
   do i=1 to key.0 ; hkey.i = key.i ; end
   z=0
   do i=1 to key.0
      call charout , ' 'i'20202020200D'x
      do until hkey.i=''
         z=z+1
         parse var hkey.i key.z +(spalte) hkey.i
      end
   end
   key.0=z
   drop hkey.
   call SysCurState 'on'
return 0

tabsConvertSUBR:
   if binFileBOOL then RETURN 0
   if tabsBOOL    then RETURN 0
   tabsBOOL=1
   call SysCurPos zeile, 0
   call charout ,copies(' ',22) ' <- Tabs conv '
   call SysCurPos zeile, 0
   do i=1 to key.0
      call charout , ' 'i'20202020200D'x
      tabpos = pos('09'x, key.i)
      do while tabpos > 0
         key.i = overlay(' ', key.i, tabpos)
         key.i = insert(' ', key.i, tabpos, 7, ' ')
         tabpos = pos('09'x, key.i)
      end
   end
return 0

oldCurSUBR:
   last=1
   if infile<>'rxQueue' & infile<>'Pipe' then lastposBOOL=1
   else lastposBOOL=0
   oldCurQueue = 'OLD_CURPOS_Q'
   new_Q = rxqueue('create', oldCurQueue)
   if new_Q <> oldCurQueue then rc = rxqueue('delete', new_Q)
   old_q = rxqueue("set", oldCurQueue )
   z=0
   do i=1 to queued()
      parse pull filePosy
      parse var filePosy oldPosy this
      if lastposBOOL then do
         if infile=this then last=oldPosy
         else if i<25 then do
            queue filePosy
            if oldPosy <= key.0 then do
               z=z+1
               oldPos.z = oldPosy
            end
         end
      end
      else if i<25 then do
         queue filePosy
         if oldPosy <= key.0 then do
            z=z+1
            oldPos.z = oldPosy
         end
      end
   end
   oldPos.0 =z
   call rxqueue "set", old_q
   if last>key.0 then last=1
return 0

binConvertSUBR:
   if infileBOOL<>1 then infileBOOL=0
   call SysCurPos zeile, 0
   call charout ,copies(' ',42) '<- binary convert '
   call SysCurPos zeile, 0
   if \infileBOOL then do
      do i=1 to key.0 ; hkey.i = key.i ; end
      hkey.0 = key.0
   end
   z=0
   do i=1 to hkey.0
     /*  call charout , ' 'i'20202020200D'x    */
      z=z+2 ; y = z-1
      key.y = translate( hkey.i, '00000000000000001', xrange('00'x,'1F'x),'1')
      key.z = translate( hkey.i, '0123456789ABCDEF0123456789ABCDEF', xrange('00'x,'FE'x),'_')
      key.z =  key.z||'-2-'
      if z=zeile | z=zeile+1 then call preView
   end
   key.0 = z
   drop hkey.
return 0

preView:
   if MessageSTRING='' then do
      call SysCurPos 0, 0
      call charout stderr, ansi_list
      do s= 1 to zeile; call charout, substr(key.s, sbs, spalte) ; end
      call SysCurPos zeile, 0
      call charout , ansi_mark ' ' infile ' '
   end
return
                  /******************************************************/
                  /* Returns:  MehrfachWahl= totalNr Nr.1 Nr.2          */
qListSUBR:        /******************************************************/
      parse Arg infile, multiSelectBOOL, sbs, ScrollBOOL, MessageSTRING
      do i = (key.0+1) to (key.0 +zeile) ; key.i ='' ; end
      call SysCurState 'off'
      if key.0<zeile | MessageSTRING<>'' then do
         AnfzBOOL =1
         Anfz = zeile-key.0
         if Anfz < 1 then Anfz =1
         if key.0<zeile-3 & ScrollBOOL then do key.0+1 ; say ; end
         call SysCurPos Anfz-1,0
         if MessageSTRING ='' then
              AnfzMessage = ansi_message right( ' 'infile ,spalte-17,'*') copies('*',14)||' '
         else AnfzMessage = ansi_message left( MessageSTRING, spalte-1)
         call charout , AnfzMessage
      end
      else AnfzBOOL=0
      infoLine = left('F1 Help',10) || right(infile,25) || right(key.0,5)
      pageScroll = zeile-(1+Anfz)
      eingabe='FIRST'
      curs=0
EingabeMARKE:
      Do until eingabe= KB_retnK | eingabe=KB_escpK
         neuScreenBOOL=1
         infoLineBOOL =1
         select
/*         Down */ /*       Up  */
            when eingabe = KB_upK then do
               cursSpalt =0
               if curs > 0 then do
                  curs = curs - 1; neuScreenBOOL=0
               end
               else if last < 2 then do
                  neuScreenBOOL=0
               end
               else last = last - 1
            end
            when eingabe = KB_downK then do
               cursSpalt =0
               if curs < (zeile -(1+Anfz)) then do
                   curs = curs + 1 ; neuScreenBOOL=0
               end
               else if last > key.0 - (zeile-Anfz) then do
                  neuScreenBOOL=0
               end
               else last = last +1
               if curs+last > key.0 then curs = key.0-last
            end
            when eingabe = KB_C_downK | eingabe=KB_A_pgdnK then do
               cursSpalt =0
               curs = zeile -(1+Anfz) ;  neuScreenBOOL=0
               if curs+last > key.0 then curs = key.0-last
            end
            when eingabe = KB_C_upK | eingabe=KB_A_pgupK then do
               cursSpalt =0
               curs = 0;  neuScreenBOOL=0
            end
            when eingabe = KB_leftK|eingabe = KB_C_leftK|eingabe = KB_A_leftK then do
               cursSpalt =0
               if eingabe = KB_C_leftK then sbs = sbs - 40
               else if eingabe = KB_A_leftK then sbs = sbs - 1
               else sbs = sbs - 10
               if sbs < 1 then sbs = 1
            end
            when eingabe = KB_rghtK|eingabe = KB_C_rghtK |eingabe = KB_A_rghtK then do
               cursSpalt =0
               if eingabe = KB_C_rghtK then sbs = sbs + 40
               else if eingabe = KB_A_rghtK then sbs = sbs + 1
               else sbs = sbs + 10
            end
            when eingabe = KB_pgupK then do
               cursSpalt =0
               curs = (zeile-Anfz)%2
               if last =1 then curs =0
               else last=last -pageScroll
               if last < 1 then last =1
            end
            when eingabe = KB_pgdnK then do
               cursSpalt =0
               curs = (zeile-Anfz)%2
               if last+zeile-Anfz >key.0 then curs =key.0-last
               else last=last +pageScroll
               if last+curs >key.0 then curs =key.0-last
            end
            when eingabe=KB_C_homek |eingabe=KB_C_pgupK |eingabe=KB_homek then do
               cursSpalt =0
               curs = 0;  last = 1
               if eingabe=KB_C_homek then sbs=1
            end
            when eingabe=KB_C_endeK |eingabe=KB_C_pgdnK |eingabe=KB_endeK then do
               cursSpalt =0
               last = key.0 +1 - (zeile-Anfz)
               if last<1 then last=1
               curs = key.0-last
            end
            when eingabe =KB_spceK|eingabe = KB_insK then do     /* LeerTaste -- markieren */
               cursSpalt =0
               call SysCurPos curs+Anfz, 0
               now = last + curs
               if now <= Key.0 then do
                  if AnsiKey.now <> ansi_mark then do
                     AnsiKey.now = ansi_mark
                     if \multiSelectBOOL then markedN=now
                     else markedN = markedN+1
                  end
                  else do
                     AnsiKey.now = ansi_list
                     if \multiSelectBOOL then markedN=0
                     else markedN = markedN-1
                  end
                  if curs+Anfz < (zeile-1) then do
                     if last+curs<key.0 then curs = curs + 1
                     neuScreenBOOL=0
                  end
                  else if last+curs<key.0 then last =last+1
                  if \multiSelectBOOL then do i = 1 to key.0
                     if i<>now & AnsiKey.i=ansi_mark then do
                        AnsiKey.i =ansi_list
                        neuScreenBOOL =1
                     end
                  end
                  if \neuScreenBOOL then call charout, AnsiKey.now||left( substr(key.now, sbs), spalte)
               end
            end
            when eingabe = KB_F2 then do
               saveFile = SysTempFileName( strip( directory(),'T','\')||'\???.tmp')
               call SysCurPos zeile, 0
               call charout stderr, ansi_mark
               saveFile = rxLarc( 'RXANSWER', markedN' marked lines to file: ', saveFile)
               saveFile = strip(saveFile)
               if length(saveFile)>0 then do
                  sav = 0
                  do i= 1 to key.0
                     if AnsiKey.i = ansi_mark then do
                        sav = sav +1
                        if lineout( saveFile, key.i)>0 then do
                           call putMessageAskSUBR 0, sav-1' lines saved, ERROR writing to "'saveFile'" '
                           leave i
                        end
                     end
                  end
                  if sav > 0 then call stream saveFile, 'C', 'Close'
                  else if sav = 0 then call putMessageAskSUBR 0, sav' lines saved - mark some lines! '
               end
            end
   /*       F3  a_F3  */
            when eingabe=KB_F3|eingabe=KB_A_F3 then do
               now = last + curs
               liny = key.now
               file = getLineFilePROC( liny)
               if file <> '' then do
                  call setLastLineSUBR
                  if eingabe=KB_A_F3 then address 'CMD' Alt_F3listFile file
                  else do
                     call rlist file,'M',1,0
                     ScreenText = SysTextScreenRead(0,0, zeile*spalte)
                  end
               end
            end
   /*        F4 a_F4  */
            when eingabe=KB_F4|eingabe=KB_A_F4 then do
               now = last + curs
               liny = key.now
               file = getLineFilePROC( liny)
               if file <> '' then do
                  call setLastLineSUBR
                  if eingabe=KB_A_F4 then address 'CMD' Alt_F4editFile file
                  else                    address 'CMD' F4editFile file
               end
            end
            when eingabe = KB_C_F4 then do
               if infile<>'Pipe' & infile<>'rxQueue' then do
                  call setLastLineSUBR
                  if binFileBOOL then address 'CMD' binEditFile infile '-b'
                  else                address 'CMD' Alt_F4editFile infile
               end
            end
            when eingabe = KB_F1 then do
               call SysCurState 'OFF'
               call charout stderr, ansi_F1_Help
               do i =1 to hlp.0
                  call SysCurPos i, 7
                  call charout, hlp.i
               end
               call SysGetKey 'NoEcho'
               call SysCurState 'ON'
            end
            when eingabe=KB_S_F7|eingabe=KB_A_F7|eingabe=KB_F7 then do
               if eingabe<>KB_S_F7 then do
                  call SysCurPos zeile, 0
                  call charout stderr, ansi_find
                  suchT = rxLarc( 'RXANSWER', ' Search-String: ', suchT)
                  suchT = translate( strip( suchT))
               end
               if suchT <> '' then do
                  if suchT=oldsuchT then do
                     now = last + curs
                     suby  = cursSpalt +sbs +1
                     do i= now to key.0
                        sTpos = pos( suchT, translate(substr(key.i, suby)))
                        sTpos = sTpos + suby -1
                        if sTpos>suby then do
                           suby  = 1
                           sbs=1
                           do while sTpos >spalte
                              sbs = sbs+10
                              sTpos = sTpos-10
                           end
                           cursSpalt = sTpos-1
                           last = i; curs = 0;
                           leave i
                        end
                        suby  = 1
                     end
                  end
                  else do
                     strfirstBOOL=1
                     oldsuchT =suchT
                     z=0
                     do i= 1 to key.0
                        sTpos = pos( suchT, translate(key.i))
                        if sTpos>0 then do
                           z=z+1
                           AnsiKey.i = ansi_find
                           if strfirstBOOL then do
                              strfirstBOOL =0
                              sbs=1
                              do while sTpos >spalte-5
                                 sbs = sbs+10
                                 sTpos = sTpos-10
                              end
                              cursSpalt= sTpos-1
                              last = i; curs = 0;
                           end
                        end
                     end
                     call putMessageAskSUBR 0, left('  mark: Ctrl-F7  next: Shift-F7       'z' lines  "'suchT'"', spalte-2)
                  end
               end
            end
            when eingabe = KB_C_F7 then do
               if multiSelectBOOL then do
                  markedN =0
                  do i=1 to key.0
                     if AnsiKey.i = ansi_find then do
                        AnsiKey.i = ansi_mark
                        markedN=markedN+1
                     end
                     else if AnsiKey.i = ansi_mark then markedN=markedN+1
                  end
               end
            end
            when multiSelectBOOL & eingabe = '+' then do
               do i=1 to key.0
                  AnsiKey.i = ansi_mark
               end
               markedN=key.0
            end
            when eingabe = KB_F11 then do
               do i=1 to key.0
                  if AnsiKey.i = ansi_mark then do
                     AnsiKey.i = ansi_list
                  end
               end
               markedN =0
            end
            when eingabe = KB_F12 | eingabe='-' then do
               do i=1 to key.0
                  AnsiKey.i = ansi_list
               end
               markedN=0
            end
            when eingabe = KB_C_F12 then do
               markedN=0
               if multiSelectBOOL then do i=1 to key.0
                  if AnsiKey.i = ansi_mark then AnsiKey.i=ansi_list
                  else do
                     AnsiKey.i=ansi_mark
                     markedN= markedN+1
                  end
               end
            end
            when eingabe=KB_C_insK then do
               call setLastLineSUBR
               if markedN<1 then do
                  now = curs+last
                  this = key.now ; this = translate(this, ' ','|&')
                  if this <> '' then address 'CMD' '@echo 'this' | clipb -ae'
               end
               else do
                  saveFile = SysTempFileName( 'C:\???rlist.tmp')
                  do i=1 to key.0
                     if AnsiKey.i=ansi_mark then call lineout saveFile, key.i
                  end
                  call stream saveFile, 'C', 'Close'
                  address 'CMD' '@type' saveFile '| clipb -ae'
                  call SysFileDelete saveFile
               end
               if key.0<zeile-1 then do
                  call SysCurPos 0,0
                  call charout , screenText
               end
            end
            when eingabe= KB_A_insK then do
               now = last+curs
/* outTxt, firstReturnBOOL, directExeBOOL,
   A_execOpt, cmdShortBOOL, command,
   pathCurfileN, currD.0, currD.1,
   side, C_numDir_0.0, C_numDir_0.1,
   selectedFilesSTR.0, selectedFilesSTR.1, archivFile.0,
   archivFile.1, timeit, noHistoryBOOL
*/
               screenText = rxexec( screenText,,
                                    1,,
                                    0,,
                                    Alt_Return,,
                                    0,,
                                    KB_A_insK,,
                                    key.now,,
                                    directory() ||'\',,
                                    directory() ||'\' )
               if screenText=KB_F10 then SIGNAL CleanUpMARKE
               else if now < key.0 then last=last+1
            end
            when eingabe= KB_A_F8 then do
               now = last+curs
               screenText = rxexec( screenText,,
                                    1,,
                                    1,,
                                    Alt_Return,,
                                    0,,
                                    KB_A_F8,,
                                    key.now,,
                                    directory() ||'\',,
                                    directory() ||'\' )
               if screenText=KB_F10 then SIGNAL CleanUpMARKE
            end
/*           c_RETURN  */
            when eingabe = KB_C_retnK then do
               now = last+curs
               screenText = rxexec( screenText,,
                                    1,,
                                    0,,
                                    Alt_Return,,
                                    0,,
                                    key.now,,
                                    key.now,,
                                    directory() ||'\',,
                                    directory() ||'\' )
               if screenText=KB_F10 then SIGNAL CleanUpMARKE
               else if curs < zeile-1 then curs = curs+1
            end
/*           KB_C_L KB_C_T   */
            when eingabe = KB_C_E then call LSet
            when eingabe = KB_C_L then call LineFitSUBR
            when eingabe = KB_C_T then call tabsConvertSUBR
/*           s_F3 c_O                 */
            when eingabe =KB_S_F3 |eingabe =KB_C_O then do
               now = last+curs
               screenText = rxexec( screenText,,
                                    0,,
                                    0,,
                                    Alt_Return,,
                                    0,,
                                    '',,
                                    key.now,,
                                    directory() ||'\',,
                                    directory() ||'\' )
               if screenText=KB_F10 then SIGNAL CleanUpMARKE
            end
            when eingabe = KB_C_Q then do
               old_q = rxqueue("set", oldCurQueue )
               z=0
               do queued()
                  parse pull some
                  z=z+1
                  parse var some this file.z
                  queue some
               end
               call rxqueue 'set', old_q
               do i=1 to z ; queue 'start /C /F rlist' file.i ; end
               if z>0 then do
                  ret = rlist(,'S',12,0,'? ESC/Return   rlist a file!   Ctrl-RETURN  start /C /F rlist!')
                  parse var ret some this
                  if some=1 then call rlist file.this,'M',1,0
               end
            end
            when eingabe = KB_C_H then do
               if cursSpalt< spalte+10 then do
                  now = last+curs
                  if binFileBOOL then do
                     if right(key.now,3)='-2-' then do
                        now = now-1
                        if curs>0 then curs = curs-1
                     end
                     next = now+1
                  end
                  call SysCurPos curs+Anfz, 0
                  if cursSpalt>0 then call charout, ansi_list||substr(key.now,sbs,cursSpalt)
                  call charout, ansi_find||substr(key.now,sbs+cursSpalt,10)||ansi_list
                  hexy=''
                  decy=''
                  do i=0 to 9
                     if i=5 then do
                        hexy=hexy' '
                        decy=decy' '
                     end
                     if \binFileBOOL then do
                        hexy=hexy c2x( substr(key.now,sbs+i+cursSpalt,1))
                        decy=decy c2d( substr(key.now,sbs+i+cursSpalt,1))
                     end
                     else do
                        chary = substr(key.next,sbs+i,1)
                        if chary='_'|chary==' ' then chary = substr(key.now,sbs+i+cursSpalt,1)
                        else chary = x2c( substr(key.now,sbs+i+cursSpalt,1) || chary )
                        hexy=hexy c2x( chary)
                        decy=decy c2d( chary)
                     end
                  end
                  call putMessageAskSUBR 0,hexy'   'decy
                  neuScreenBOOL=0
                  cursSpalt = cursSpalt+10
                  if cursSpalt+2 > spalte then do
                     cursSpalt=cursSpalt-10
                     sbs = sbs+10
                  end
               end
            end
            when eingabe=KB_C_N then do
               file = ''
               old_q = rxqueue("set", oldCurQueue )
               if queued()>0 then do
                  parse pull some
                  parse var some this file
                  queue some
               end
               call rxqueue "set", old_q
               if file <> '' then call rlist file,'M',1,0
            end
            when eingabe=KB_C_F|eingabe=KB_C_G|eingabe=KB_C_R|eingabe=KB_C_U then do
                    if eingabe=KB_C_F then sorty = '-F -R'
               else if eingabe=KB_C_G then sorty = '-G -R'
               else if eingabe=KB_C_R then sorty = '-R'
               else if eingabe=KB_C_U then sorty = '-U -R'
               spalty = sbs + cursSpalt
               spalty = '-'||spalty
               if infile='Pipe' | binFileBOOL then do
                  call putMessageAskSUBR 0,'No sort on Pipe/binary! '
               end
               else if infile<>'rxQueue' then do
                  call setLastLineSUBR
                  address 'CMD' 'start "sortl 'filespec('N',infile) spalty sorty'" /C "sortl.exe' infile spalty sorty '| rlist.cmd"'
                  call putMessageAskSUBR 0,'  started:    sortl 'filespec('N',infile) spalty sorty
               end
               else do
                  call setLastLineSUBR
                  saveFile = SysTempFileName( 'C:\???rlist.tmp')
                  do i=1 to key.0
                     call lineout saveFile, key.i
                  end
                  call stream saveFile, 'C', 'Close'
                  address 'CMD' 'sortl' saveFile spalty sorty '|rlist'
                  call SysFileDelete saveFile
               end
            end
            when eingabe = KB_C_K then do
               if datatype(oldPos.1,'W')=1 then do
                  some = last
                  if oldPos.1<key.0 then last = oldPos.1
                  do i=2 to oldPos.0 ; h= i-1 ; oldPos.h=oldPos.i; end
                  h=oldPos.0
                  oldPos.h =some
                  curs =0
               end
            end
            when left( eingabe,1)='00'x then do          /*  vor letztes!  */
               suchy =A_CharsSUBR(eingabe)
               if suchy <>'' then do
                  eingabe = goFileSuchSUBR( suchy)
                  if eingabe = KB_retnK then signal CleanUpMARKE
                  else signal EingabeMARKE
               end
               else  neuScreenBOOL=0
            end
            when pos( eingabe, '0123456789')>0 then do
               goLineNum = goLineNum || eingabe
               if goLineNum > key.0 then goLineNum=eingabe
               if goLineNum < key.0 then do
                  last = goLineNum
                  curs = 0
               end
            end
            when eingabe ='FIRST' then NOP
            otherwise neuScreenBOOL=0
         end  /* select */
         call SysCurState 'OFF'
         if neuScreenBOOL then call paintScreenSUBR
         if infoLineBOOL then do
            call SysCurPos zeile, 0
            call charout , ansi_message || right( infoLine ||right(curs+last,5) ||right(sbs,5), spalte-1 ) || ansi_norm
            if markedN > 0 then do
               call SysCurPos zeile, 0
               if multiSelectBOOL then call charout , ansi_mark ' Return selects 'markedN' lines 'ansi_norm
               else call charout , ansi_mark ' Return selects line 'markedN  ansi_norm
            end
         end
         call SysCurPos curs+Anfz ,cursSpalt
         call SysCurState 'ON'
         eingabe = SysGetKey('NoEcho')
         if eingabe ='E0'x|eingabe ='00'x then eingabe =eingabe||SysGetKey('NoEcho')
      End  /*  until Escape F10 */
      if infile<>'rxQueue' & infile<>'Pipe' then do
         old_q = rxqueue("set", oldCurQueue )
         push last||' '||infile
         call rxqueue "set", old_q
      end
CleanUpMARKE:
      if eingabe=KB_retnK then wahl=returnStringSUBR()
      else wahl=0
      call SysCurPos zeile-1 , 0
      now = last+zeile-(1+Anfz)
      call charout ,ansi_message||substr(key.now,sbs, spalte)
      call charout ,ansi_norm||copies(' ', spalte-1)
      call SysCurPos zeile, 0
return wahl

paintScreenSUBR:
   if AnfzBOOL then do
      call SysCurPos Anfz-1,0
      call charout , AnfzMessage
   end
   else call SysCurPos Anfz ,0
   call charout stderr, ansi_list
   AnsiCurrent = ansi_list
   do now = last to (last + zeile -(1+Anfz))
      if AnsiKey.now <> AnsiCurrent then AnsiCurrent = AnsiKey.now
      else AnsiCurrent=''
      call charout, AnsiCurrent||substr(key.now, sbs, spalte)
   end
return 0

setLastLineSUBR:
   call SysCurState 'off'
   call SysCurPos zeile, 0
   call charout , copies(' ',79)||ansi_norm
   call SysCurPos zeile, 0
return 0

putMessageAskSUBR:
   parse arg askBOOL, thisMessage
   call setLastLineSUBR
   call charout , ansi_ask
   call charout , ' 'thisMessage ||ansi_norm
   if askBOOL then do
      antw = translate( SysGetKey('NoEcho'))
      if antw='00'x | antw='E0'x then antw = antw || SysGetKey('NoEcho')
   end
   else infoLineBOOL=0
return antw

returnStringSUBR:
    wahl = ''; anz=0
    do w = 1 to key.0
       if AnsiKey.w = ansi_mark then do
          wahl = wahl w
          anz = anz+1
       end
    end
    if wahl='' & key.0>0 then do; anz=1; wahl=' '||last+curs; end
    wahl = anz||wahl
return wahl

setLastLineSUBR:
   call SysCurState 'off'
   call SysCurPos zeile, 0
   call charout , copies(' ',79)||ansi_norm
   call SysCurPos zeile-1, spalte-1
   call SysCurState 'on'
return 0

getLineFilePROC: procedure expose sbs cursSpalt
   arg liny
   suby=1
   do i=sbs+cursSpalt to 1 by -1
      if substr( liny,i,1)==' ' then do
         suby =i ; leave i
      end
   end
   if suby>1 then liny=substr(liny,suby)
   file = ''
   wordN = words( liny)
   do i= 1 to wordN
      if i>20 then leave i
      pathpos = pos(':\', word(liny, i))-1
      if pathpos>0 then wordy = substr( word(liny,i), pathpos)
      else wordy = word(liny,i)
      file = stream( wordy, 'C', 'query exists')
      if pos('*', file)>0 then file =''
      if file <>'' then leave i
   end
return file

A_CharsSUBR:
   parse arg a_chary
   KB_bkspK='08'x;
   select
         when left(a_chary,1)='E0'x then a_chary=''
         when a_chary>'1F'x   then a_chary=translate(a_chary)
         when a_chary='0081'x then a_chary='0'
         when a_chary='0078'x then a_chary='1'
         when a_chary='0079'x then a_chary='2'
         when a_chary='007A'x then a_chary='3'
         when a_chary='007B'x then a_chary='4'
         when a_chary='007C'x then a_chary='5'
         when a_chary='007D'x then a_chary='6'
         when a_chary='007E'x then a_chary='7'
         when a_chary='007F'x then a_chary='8'
         when a_chary='0080'x then a_chary='9'
         when a_chary='001E'x then a_chary='A'
         when a_chary='0030'x then a_chary='B'
         when a_chary='002E'x then a_chary='C'
         when a_chary='0020'x then a_chary='D'
         when a_chary='0012'x then a_chary='E'
         when a_chary='0021'x then a_chary='F'
         when a_chary='0022'x then a_chary='G'
         when a_chary='0023'x then a_chary='H'
         when a_chary='0017'x then a_chary='I'
         when a_chary='0024'x then a_chary='J'
         when a_chary='0025'x then a_chary='K'
         when a_chary='0026'x then a_chary='L'
         when a_chary='0032'x then a_chary='M'
         when a_chary='0031'x then a_chary='N'
         when a_chary='0018'x then a_chary='O'
         when a_chary='0019'x then a_chary='P'
         when a_chary='0010'x then a_chary='Q'
         when a_chary='0013'x then a_chary='R'
         when a_chary='001F'x then a_chary='S'
         when a_chary='0014'x then a_chary='T'
         when a_chary='0016'x then a_chary='U'
         when a_chary='002F'x then a_chary='V'
         when a_chary='0011'x then a_chary='W'
         when a_chary='002D'x then a_chary='X'
         when a_chary='0015'x then a_chary='Y'
         when a_chary='002C'x then a_chary='Z'
         when a_chary='0033'x then a_chary=','
         when a_chary='0034'x then a_chary='.'
         when a_chary='0035'x then a_chary='-'
         when a_chary='001B'x then a_chary='+'
         when a_chary='002B'x then a_chary='#'
         when a_chary='000E'x then a_chary=KB_bkspK
         when a_chary=KB_bkspK then NOP
         otherwise a_chary=''
   end
return a_chary

goFileSuchSUBR:
   parse arg suchy
   suchFile=''
   suchFPos=0
   lensuchF= 0
   firstsuchBOOL =1
   do until suchy == ''             /* == wegen ' ' */
      beepyBOOL=1
      now = last+curs
      if suchy=KB_bkspK then do
         if lensuchF>0 then do
            lensuchF = lensuchF-1
            suchFile=left(suchFile,lensuchF)
         end
         beepyBOOL=0
      end
      else do
         suchFile= suchFile||suchy
         call SysCurPos zeile, 0
         call charout stderr, ansi_mark right(suchFile,spalte-16 ) ansi_norm right(curs+last, 8) right(sbs,3)
         do i=now to key.0
            hkey = strip(substr( key.i,sbs ))
            hkey = strip(hkey, 'L','/')
            hkey = strip(hkey, 'L','*')
            hkey = strip(hkey, 'L','(')
            hkey = strip(hkey, 'L','=')
            hkey = strip(hkey, 'L','\')
            hkey = strip(hkey, 'L','-')
            hkey = strip(hkey, 'L',':')
            hkey = strip(hkey, 'L',';')
            hkey = strip(hkey, 'L','+')
            hkey = strip(hkey, 'L','&')
            hkey = strip(hkey, 'L','%')
            hkey = strip(hkey, 'L','"')
/*          hkey = translate( translate( hkey), ' ', xrange('00'x,'2F'x)||':;<>=?'||xrange('8B'x,'FF'x) ) */
            hkey = strip( hkey )
            posy = pos(suchFile, translate( hkey ))
            if posy=1 then do
               suchFPos = pos( suchFile, translate(substr(key.i,sbs)))-1
               beepyBOOL=0
               curs  = 0
               last  = i
               call SysCurState 'off'
               call paintScreenSUBR
               leave i
            end
         end
      end
      lenSuchF = length(suchFile)
      if beepyBOOL then do
         if lenSuchF>0 then do
            lenSuchF=lenSuchF-1
            suchFile = left(suchFile, lenSuchF)
         end
         call beep 999,55
      end
      call SysCurPos zeile, 0
      call charout stderr, ansi_mark right(suchFile,spalte-16 ) ansi_norm right(curs+last, 8) right(sbs,3)
      spaltyPos = suchFPos+lenSuchF-1
      if spaltyPos<0 then spaltyPos=0
      call SysCurPos curs+Anfz , spaltyPos
      call SysCurState 'on'
      newsuchy = SysGetKey('NoEcho')
      if newsuchy='00'x |newsuchy='E0'x then newsuchy= newsuchy||SysGetKey('NoEcho')
      suchy =A_CharsSUBR( newsuchy)
   end
return newsuchy

_qListInits:
   KB_A_F3    ='006A'x
   KB_A_F4    ='006B'x
   KB_A_F7    ='006E'x
   KB_A_F8    ='006F'x
   KB_A_insK  ='00A2'x
   KB_A_leftK ='009B'x
   KB_A_pgdnK ='00A1'x
   KB_A_pgupK ='0099'x
   KB_A_rghtK ='009D'x
   KB_C_F12   ='008A'x
   KB_C_F4    ='0061'x
   KB_C_F7    ='0064'x
   KB_C_E     ='05'x   /*    KB_C_D      ='04'x    */
   KB_C_F     ='06'x
   KB_C_G     ='07'x
   KB_C_H     ='08'x
   KB_C_K     ='0B'x
   KB_C_L     ='0C'x
   KB_C_N     ='0E'x
   KB_C_O     ='0F'x
   KB_C_Q     ='11'x
   KB_C_R     ='12'x
   KB_C_T     ='14'x
   KB_C_U     ='15'x   /* KB_C_Z     ='1A'x */
   KB_C_downK ='E091'x
   KB_C_endeK ='E075'x
   KB_C_homek ='E077'x
   KB_C_insK  ='E092'x
   KB_C_leftK ='E073'x
   KB_C_pgdnK ='E076'x
   KB_C_pgupK ='E084'x
   KB_C_retnK ='0A'x
   KB_C_rghtK ='E074'x
   KB_C_upK   ='E08D'x
   KB_F1      ='003B'x
   KB_F2      ='003C'x
   KB_F3      ='003D'x
   KB_F4      ='003E'x
   KB_F7      ='0041'x
   KB_F8      ='0042'x
   KB_F9      ='0043'x
   KB_F10     ='0044'x
   KB_F11     ='0085'x
   KB_F12     ='0086'x
   KB_S_F3    ='0056'x
   KB_S_F7    ='005A'x
   KB_downK   ='E050'x
   KB_endeK   ='E04F'x
   KB_escpK   ='1B'x
   KB_homek   ='E047'x
   KB_insK    ='E052'x
   KB_leftK   ='E04B'x
   KB_pgdnK   ='E051'x
   KB_pgupK   ='E049'x
   KB_retnK   ='0D'x
   KB_rghtK   ='E04D'x
   KB_spceK   ='20'x
   KB_upK     ='E048'x
   ansi_norm    ='1B'x||'[0m';
   ansi_list    ='1B'x||'[30;46m'
   ansi_find    ='1B'x||'[31;47m'
   ansi_F1_Help ='1B'x||'[32;40m'
   ansi_message ='1B'x||'[36;44m'
   ansi_mark    ='1B'x||'[37;41m'
   ansi_ask     ='1B'x||'[37;40m'
   /* ansi_BlueRed ='1B'x||'[34;41m' */
   /* ansi_GreyBlue='1B'x||'[37;44m' */
   /* ansi_norm    ='1B'x||'[37;40m' */
   if rxfuncquery('SysLoadFuncs')=1 then do; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"; call SysLoadFuncs; end
   parse value SysTextScreenSize() with zeile spalte
   zeile = zeile -1
   screenText =SysTextScreenRead(0,0, zeile*spalte)
   eingFeld  = "               "
   goLineNum =''
   suchT     =''
   cursSpalt =0
   Anfz      =0
   selected  =0
   AnsiKey.  =ansi_list
   markedN   =0
return 0

