/*  rxlarc.cmd:  SubFunctions for Larc.cmd    */
parse arg funcy, zeile, argA, argB, argC, argD, argE, argF, argG, argH, argI, argJ, argK, argL, argM, argN
   if funcy<>'CHARS' then call rxLarcInitSUBR
   retWert=0 
   select
      when funcy='CHARS'  then retWert=A_CharsSUBR()
      when funcy='DEL0'   then retWert=deleteSUBR0()
      when funcy='DEL1'   then retWert=deleteSUBR1()
      when funcy='MENU'   then retWert=MenuF2SUBR()
      when funcy='FIND'   then retWert=FindSUBR()
      when funcy='COPY00' then retWert=copySUBR00( 'COPY') 
      when funcy='MOVE00' then retWert=copySUBR00( 'MOVE') 
      when funcy='COPY01' then retWert=copySUBR01()
      when funcy='COPY10' then retWert=copySUBR10()
      when funcy='COPY11' then retWert=copySUBR11()
      when funcy='MOVE01' then retWert=moveSUBR01()
      when funcy='MOVE10' then call putMessageAskPROC 'not yet implemented, try F5 and then F8!'
      when funcy='MOVE11' then call putMessageAskPROC 'not yet implemented, try F5 and then F8!'
      when funcy='DIRS'   then call DirsSUBR
      when funcy='OBJECT' then call WpsObjectSUBR
      when funcy='ATTRIB' then call AttribFileSUBR
      otherwise NOP
   end
return retWert

A_CharsSUBR:
   s = argA
   Backspace_Key='08'x;
   select
         when s='0081'x then s='0'
         when s='0078'x then s='1'   
         when s='0079'x then s='2'   
         when s='007A'x then s='3'   
         when s='007B'x then s='4'   
         when s='007C'x then s='5'   
         when s='007D'x then s='6'   
         when s='007E'x then s='7'   
         when s='007F'x then s='8'   
         when s='0080'x then s='9'   
         when s='001E'x then s='A'
         when s='0030'x then s='B'
         when s='002E'x then s='C'
         when s='0020'x then s='D'
         when s='0012'x then s='E'
         when s='0021'x then s='F'
         when s='0022'x then s='G'
         when s='0023'x then s='H'
         when s='0017'x then s='I'
         when s='0024'x then s='J'
         when s='0025'x then s='K'
         when s='0026'x then s='L'
         when s='0032'x then s='M'
         when s='0031'x then s='N'
         when s='0018'x then s='O'
         when s='0019'x then s='P'
         when s='0010'x then s='Q'
         when s='0013'x then s='R'
         when s='001F'x then s='S'
         when s='0014'x then s='T'
         when s='0016'x then s='U'
         when s='002F'x then s='V'
         when s='0011'x then s='W'
         when s='002D'x then s='X'
         when s='0015'x then s='Y'
         when s='002C'x then s='Z'
         when s='0035'x then s='_'
         when s='0034'x then s='.'
         when s='000E'x then s=Backspace_Key
         when s=Backspace_Key then s=Backspace_Key
         otherwise s =''
   end
return s

rxLarcInitSUBR:
      Backspace_Key='08'x;
      Esc_KEY      ='1B'x;      Return_KEY   ='0D'x;
      Space_KEY    ='20'x;     Insert_KEY = 'E052'x;
      Up_KEY       ='E048'x;    Down_KEY     ='E050'x;
      c_Up_KEY     ='E08D'x;    c_Down_KEY   ='E091'x;
      Left_KEY     ='E04B'x;    Right_KEY    ='E04D'x;
      c_Left_KEY   ='E073'x;    c_Right_KEY  ='E074'x;
      PgUp_KEY     ='E049'x;    PgDown_KEY   ='E051'x;
      c_PgUp_KEY   ='E084'x;    c_PgDown_KEY ='E076'x;
      Home_KEY     ='E047'x;    Ende_KEY     ='E04F'x;
      c_Home_KEY   ='E077'x;    c_Ende_KEY   ='E075'x;
      F1_KEY       ='003B'x;    
      F2_KEY       ='003C'x; s_F2_Key ='0055'x;
      F3_KEY       ='003D'x;
      a_F3_KEY     ='006A'x;
      F4_KEY       ='003E'x;
      a_F4_KEY     ='006B'x;
      F7_KEY       ='0041'x;    c_F7_KEY     ='0064'x;
      s_F7_KEY     ='005A'x;    a_F7_KEY     ='006E'x;
      F8_KEY       ='0042'x;    F9_KEY       ='0043'x;
      F10_KEY      ='0044'x;    F11_KEY      ='0085'x;
      F12_KEY      ='0086'x;
      c_W_KEY      ='17'x;    Tab_KEY     ='09'x;
      Ansi.norm    ='1B'x||'[37;40m'
      Ansi.list    ='1B'x||'[37;40m'
      Ansi.mark    ='1B'x||'[37;41m'
      Ansi.F1_Help ='1B'x||'[30;43m'
      Ansi.ask     ='1B'x||'[37;40m'
      Ansi.message ='1B'x||'[36;44m';
return 0

displayExistingSUBR:
   z =0
   do i=1 to FR.selected.0
      if right( FR.selected.i,1)='*' then do
         call SysFileTree FR.selected.i, 'fund.', 'FSO'
         do j=1 to fund.0
            existfile = stream( copy2file.z, 'C','query exists')
            if existfile <>'' then say Ansi.mark||' Existing: 'existfile||Ansi.norm
         end
      end
      else do
         existfile = stream( copy2file.z, 'C','query exists')
         if existfile <>'' then say Ansi.mark||' Existing: 'existfile||Ansi.norm
      end
   end
   say
return 0

copySUBR00:
   arg commando
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   copiedBOOL=0 
   if commando='MOVE' & FR.selected.0=1 & right(FR.selected.i,1)='\' & left(FR.currD.side,2)=left(FR.currD.opposide,2) then do
      Fcopy.1 = strip( FR.selected.1,'T','\')
      copyF.1 = substr(FR.currD.opposide,3)||Fcopy.1
/*    say right( Fcopy.1, 32) '-->>' copyF.1 */
      call SysCurPos zeile, 0 
      copyF.1 =rxAnswer(' ? Esc/Return  MOVE to: ', copyF.1, 0, 1, length(copyF.1))
      if copyF.1 <> '' then do
         address 'CMD' 'MOVE' '"'Fcopy.1'"' '"'copyF.1'"'
         if RC>0 then call putMessageAskPROC Ansi.mark RC' ERROR moving ' Fcopy.1 Ansi.norm
         else copiedBOOL =1
      end
      RETURN copiedBOOL
   end
   else do 
      call SysCls ; say ; say FR.currD.side '-->>' ; say
      z=0 ; delBOOL=0 ; allBOOL=0 ; wegLen=length( FR.currD.side)+1
      do i=1 to FR.selected.0
         if right(FR.selected.i,1)='\' then do 
            call SysFileTree FR.selected.i||'*', 'fund.', 'FOS', '*****'
            do j=1 to fund.0
               z=z+1
               Fcopy.z = fund.j
               copyF.z = FR.currD.opposide ||substr( fund.j, wegLen)
            end
            say right( FR.selected.i||'*', 32) '-->>' FR.currD.opposide||FR.selected.i||'*'
         end
         else do 
            z=z+1
            Fcopy.z = FR.selected.i
            copyF.z = FR.currD.opposide||FR.selected.i
            say right( Fcopy.z,32) '-->>' copyF.z
         end
      end
      Fcopy.0 =z
      copyF.0 =z
   end
   if Fcopy.0=1 & right(FR.selected.i,1)<>'\' then do
      call SysCurPos zeile, 0 
      copyF.1 =rxAnswer( ' ? Esc\Return  'commando' to: ', copyF.1, 0, 1, length(copyF.1))
      if copyF.1 <> '' then do
         antw=Return_KEY
         if pos('\', copyF.1)=0 then copyF.1= FR.currD.side||copyF.1
      end
      else antw =0
   end
   else antw =putMessageAskPROC( ' ? Esc\Return  ' Ansi.mark commando' ')
   if commando='MOVE' then do
      if left( copyF.1,3)=left(FR.currD.side,3) then do
         delBOOL =0 ; commando ='MOVE'
         do z=1 to copyF.0
            copyF.z = substr( copyF.z, 3)
         end
      end
      else do 
         delBOOL =1 ; commando ='COPY' 
      end
   end
   if antw = Return_KEY then do 
      copiedBOOL=1
      do i=1 to FR.selected.0
         if right(FR.selected.i,1)='\' then do 
            call SysMkDir FR.currD.opposide||strip( FR.selected.i ,'T','\')
            call SysFileTree FR.selected.i||'*', 'fund.', 'DOS', '*****'
            do j=1 to fund.0 ; call SysMkDir FR.currD.opposide||substr( fund.j, wegLen) ; end
         end
      end
      do i=1 to Fcopy.0
         existfile = stream( copyF.i,'C','query exists')
         if existfile <>'' & allBOOL=0 then do 
            antw =putMessageAskPROC( ' ? Esc/Return/Stop/All  ' Ansi.mark 'overwrite: 'existfile' ')
            if antw ='S' then leave i
            if antw ='A' then do ; allBOOL=1 ; antw =Return_KEY ; end
            if commando = 'MOVE' then do
               commando = 'COPY'
               delBOOL =1
            end
            call SysCurPos zeile-1, 0
         end
         else antw =Return_Key
         if antw =Return_Key then do
            address 'CMD' commando '"'Fcopy.i'" "'copyF.i'"'
            if RC>0 then do
               antw = putMessageAskPROC(' ? Esc/Return  ' Ansi.mark 'ERROR 'RC commando Fcopy.i )
               if antw<> Return_KEY then RETURN 0
            end
            else if delBOOL then call proveDeletePROC RC, Fcopy.i, copyF.i
         end
      end
      if delBOOL then do i=1 to FR.selected.0
         if right(FR.selected.i,1)='\' then do 
            call SysFileTree FR.selected.i||'*', 'fund.', 'DOS', '*****', '-+---'
            do j=fund.0 to 1 by -1 ; call SysRmDir fund.j ; end
            call SysRmDir strip( FR.selected.i ,'T','\')
         end
      end
   end
return copiedBOOL

proveDeletePROC: procedure expose Ansi.
   arg retCode, deletefile, provefile
   if retCode>0 then call putMessageAskPROC Ansi.mark||' ERROR: 'retCode
   else do
      copdatime = stream( provefile,'C','query datetime')
      FRsdatime = stream( deletefile,'C','query datetime')
      if copdatime = FRsdatime then do
         copnam = stream( provefile,'C','query exists')
         FRsnam = stream( deletefile,'C','query exists')
         if FRsnam <> copnam then call SysFileDelete deletefile
      end
   end
return 0

stripStar_BsPROC: procedure
   arg file
   file = strip(file,'T','*')
   file = strip(file,'T','\')
return file

moveSUBR01:
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='\' then FR.selected.i = FR.selected.i || '*' 
   end
   call displayFilesSUBR
   antw = putMessageAskPROC( ' ? Esc\Return\1-9 (1-9 UpPath)  pack to: 'FR.archivFile.opposide'   ? ')
   if antw = Return_KEY then antw = 0
   if datatype( antw, 'W') = 1 then do
      call setlocal
      copiedBOOL=1
      do antw ; 'cd.. 2>nul';end
      xcurrdir = directory()
      lenxc = length( strip(xcurrdir,'T','\'))+2
      files = ''
      rekursivBOOL =0
      do i=1 to FR.selected.0
         files = files substr( FR.currD.side||FR.selected.i, lenxc)
      end
      AP.moPaFi1.opposide FR.archivFile.opposide files
      if RC>0 then 'pause'
      call endlocal
   end
return copiedBOOL

Inits_CopyMoveSUBR:
   selectedFilesSTRING =argA
   FR.currD.side=argB
   FR.currD.opposide=argC
   FR.archivFile.side=argD
   FR.archivFile.opposide=argE
   AP.extractNoPthFile1.side=argF
   AP.extractNoPthFile1.opposide=argG
   AP.extractPathFile1.side=argH
   AP.extractPathFile1.opposide=argI
   AP.packFile1.side=argJ
   AP.packFile1.opposide=argK
   AP.packRecursiv1.side=argL
   AP.packRecursiv1.opposide=argM
   AP.moPaFi1.opposide =argN
   copiedBOOL =0
return 0

parseFileStringSUBR:
   parse arg selString
   i=0 ; allString=''
   do while selString <>''
      i=i+1
      parse var selString FR.selected.i '#' selString
      allString = allString FR.selected.i
      selString = strip( selString)
   end
   FR.selected.0 =i
return allString

displayFilesSUBR:
   call SysCls
   say
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='*' then attentionStr.i ='   <DIR>  ' ; else attentionStr.i ='          '
      say attentionStr.i FR.selected.i
   end
   say
return 0

copySUBR01:
   call Inits_CopyMoveSUBR
   call parseFileStringSUBR selectedFilesSTRING
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='\' then FR.selected.i = FR.selected.i || '*' 
   end
   call displayFilesSUBR
   antw = putMessageAskPROC( ' ? Esc\Return\1-9 (1-9 UpPath)  pack to: 'FR.archivFile.opposide'   ? ')
   if antw = Return_KEY then antw = 0
   if datatype( antw, 'W') = 1 then do
      call setlocal
      copiedBOOL=1
      do antw ; 'cd.. 2>nul';end
      xcurrdir = directory()
      lenxc = length( strip(xcurrdir,'T','\'))+2
      files = ''
      rekursivBOOL =0
      do i=1 to FR.selected.0
         files = files substr( FR.currD.side||FR.selected.i, lenxc)
         if right(files,2)='\*' then rekursivBOOL=1
      end
      if rekursivBOOL then AP.packRecursiv1.opposide FR.archivFile.opposide files
      else AP.packFile1.opposide FR.archivFile.opposide files
      if RC>0 then 'pause'
      call endlocal
   end
return copiedBOOL

copySUBR10:
   call Inits_CopyMoveSUBR
   selectedFilesSTRING =parseFileStringSUBR( selectedFilesSTRING)
   call displayFilesSUBR
   call displayExistingSUBR
   antw = putMessageAskPROC( ' ? Esc\1(with PathNames)\0   extrakt to: 'FR.currD.opposide'   ? ')
   if antw = Return_KEY then antw = 1
   if datatype( antw, 'W') = 1 then do
      call setlocal
      copiedBOOL=1
      call directory strip(FR.currD.opposide,'T','\')
      copiedBOOL = 1
      if antw > 0 then AP.extractPathFile1.side  FR.archivFile.side selectedFilesSTRING
      else             AP.extractNoPthFile1.side FR.archivFile.side selectedFilesSTRING
      if RC>0 then 'pause'
      call endlocal
   end
return copiedBOOL

copySUBR11:
   call Inits_CopyMoveSUBR
   selectedFilesSTRING =parseFileStringSUBR( selectedFilesSTRING)
   call displayFilesSUBR
   tempDir = SysTempFileName( FR.currD.opposide||'????Larc.tmp')
   call SysMkDir tempDir
   neuDir = directory( tempDir)
   if neuDir=tempDir then do
      antw = putMessageAskPROC( ' ? Esc\1(with PathNames)\0   extrakt-pack to: 'FR.ArchivFile.opposide'   ? ')
      if antw = Return_KEY then antw = 1
      if word(AP.packFile1.opposide,1 )<>'echo' then do
         if datatype( antw, 'W') = 1 then do
            copiedBOOL = 1
            if antw > 0 then AP.extractPathFile1.side FR.archivFile.side selectedFilesSTRING
            else             AP.extractNoPthFile1.side FR.archivFile.side selectedFilesSTRING
            if RC>0 then 'pause'
            AP.packFile1.opposide FR.archivFile.opposide selectedFilesSTRING
            if RC>0 then 'pause'
            ret = SysFileTree( tempDir'\*' , 'fund.', 'FS', '*-***', '-----')
            do i=fund.0 to 1 by -1; fund.i= word(fund.i,words(fund.i)); call SysFileDelete fund.i; end
            ret = SysFileTree( tempDir'\*' , 'fund.', 'DS', '*+***', '*+---')
            do i=fund.0 to 1 by -1; fund.i= word(fund.i,words(fund.i));call directory fund.i; call directory '..' ; ret =SysRmDir( filespec('N',fund.i)) ; end
         end
      end
      else say AP.packFile1.opposide
   end
   else say 'ERROR: TempDirectory'
   call goDirPROC FR.currD.opposide
   call SysRmDir tempDir
   call goDirPROC FR.currD.side
return copiedBOOL

AttribFileSUBR:
   selectedFilesSTRING=argA
   call parseFileStringSUBR selectedFilesSTRING
   call SysCls
   do i=1 to FR.selected.0
      FR.selected.i = strip(FR.selected.i,'T','\')
      call SysFileTree FR.selected.i, 'fund.', 'B'
      say fund.1
   end
   say
   say '                              A = archive Bit'
   say '                               D = directory  (No set/unset)'
   say '                                H = hidden'
   say '                                 R = read only'
   say '                                  S = system'
   antw = rxanswer(" ? Esc/A,H,R,S/- (-unset all) ")
   antw = translate( strip(antw))
   say
   newAttr =''
   if antw <>'' then do
      if pos('A', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      newAttr = newAttr||'*'                          /*  DirectoryBit */
      if pos('H', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      if pos('R', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      if pos('S', antw)>0 then newAttr = newAttr||'+'
      else newAttr = newAttr||'-'
      do i=1 to FR.selected.0
         call SysFileTree FR.selected.i, 'fund.', 'B', '*****', newAttr
         say fund.1
      end
   end
   else do
      say ; say ; say'        OK, nothing'
   end
   call SysSleep 2
return 0

deleteSUBR0:
   selectedFilesSTRING=argA
   call parseFileStringSUBR selectedFilesSTRING
   do i=1 to FR.selected.0
      if right(FR.selected.i,1)='\' then FR.selected.i = FR.selected.i || '*' 
   end
   call displayFilesSUBR
   deletedBOOL=0
   if Return_Key=putMessageAskPROC( Ansi.mark||'  ? Esc/Return  delete Files ?!?    ') then do
      say ; deletedBOOL=1
      do i=FR.selected.0 to 1 by -1
         if right( FR.selected.i,1)='*' then do
            call SysFileTree FR.selected.i, 'fund.', 'BS', '*****', '-*---'
            FR.selected.i = strip( FR.selected.i,'T','*')
            FR.selected.i = strip( FR.selected.i,'T','\')
            if fund.0 > 0 then do
               call SysCls
               do j=fund.0 to 1 by -1
                  say fund.j
               end
               say
               if Return_Key=putMessageAskPROC( '   'Ansi.mark||'  ? Esc/Return  delete all?  really?  ') then do
                  deldir.0 = 0
                  do j=fund.0 to 1 by -1
                     parse var fund.j a b c attr file
                     file =strip(file)
                     if pos('D', attr)=2 then do
                        deldir.0 = deldir.0 +1
                        h = deldir.0
                        deldir.h = file
                     end
                     else call SysFileDelete file
                  end
                  do j=1 to deldir.0
                     call SysRmDir deldir.j
                  end
                  do j=deldir.0 to 1 by -1
                     call SysRmDir deldir.j
                  end
                  call SysRmDir FR.selected.i
               end
            end
            else call SysRmDir FR.selected.i
         end
         else do
            call SysFileDelete FR.selected.i
         end
      end
   end
return deletedBOOL

deleteSUBR1:
   selectedFilesSTRING=argA
   FR.archivFile.side=argB
   AP.DelFil1.side=argC
   selectedFilesSTRING = parseFileStringSUBR( selectedFilesSTRING)
   call displayFilesSUBR
   deletedBOOL=0
   if Return_Key=putMessageAskPROC( Ansi.mark||'  ? Esc/Return  delete Files ?!?    ') then do
      deletedBOOL=1
      AP.DelFil1.side FR.archivFile.side selectedFilesSTRING
      if RC>0 then 'pause'
   end
return deletedBOOL

goDirPROC: procedure
   parse arg neuDir
   if right( neuDir, 2)<>':\' then neuDir = strip( neuDir, 'T', '\')
   call directory neuDir
return 0

putMessageAskPROC: procedure expose zeile Ansi.
   parse arg thisMessage
   call setLastLineSUBR
   call charout ,thisMessage ||Ansi.norm
   antw = translate( SysGetKey('NoEcho'))
return antw

setLastLineSUBR:
   call SysCurState 'off'
   call SysCurPos zeile, 0
   call charout , copies(' ',79)||Ansi.norm
   call SysCurPos zeile, 0
   call SysCurState 'on'
return 0

FindSUBR:
   retFile=0
   suchy = directory()'\*'
   suchy = rxAnswer('  Find Files   FileSpec: ', suchy,0,0, length(suchy)+1)
   if suchy<>'' then do
      do queued() ; pull some ; end
      call SysFileTree suchy, 'key.', 'FS'
      do i=1 to key.0 ; queue key.i ; end
      ret = rlist( ,'S', 41)
      if word(ret,1)=1 then do
         k=word(ret,2)
         retFile= word(key.k, words(key.k))
         neuDir=  filespec( 'D', retFile)|| filespec( 'P', retFile)
         retFile= filespec( 'N', retFile)
         call directory strip(neuDir,'T','\')
      end
   end
return retFile

DirsSUBR:
   currDir = directory()
   lenVorDir = lastpos('\', currDir)
   vorDir = substr(currDir, 1, lenVorDir-1)
   lenVorVorDir = lastpos('\', vorDir)
   liny.0 = 0
   call rekursivVerzPROC 1, lenVorVorDir, lenVorVorDir +1
   call directory currDir
   h=liny.0;  gesByte = word(liny.h,1)
   j=0 ;  key.0 =liny.0
   do i=liny.0 to 1 by -1
      j= j+1; key.j = liny.i
      queue key.j
   end
   drop liny.
   ret  = rlist( ,'S')
   if word(ret,1)=1 then do
      r = word(ret,2)
      if r < key.0+1 then do
         verz = word( key.r, words( key.r))
         call directory verz
      end
   end
return 0

rekursivVerzPROC: procedure expose Option ByteOpt liny.
   arg level,lenVorDir, vorDel
   currDir = directory()
   lencurrDir = lastpos('\', currDir)
   beforeDirs = liny.0
   call SysFileTree '*' , 'vfund.', 'DO', '*****'
   do j=1 to vfund.0
      call directory vfund.j
      call rekursivVerzPROC level+1, lencurrDir, vorDel
   end
   if vfund.0 > 0 then call directory currDir
   liny.0 = liny.0 + 1  ; h = liny.0
   currV   = substr( currV, vorDel)
   lenVDir = lastpos('\', currDir)
   currV   = substr(currDir,lenVDir+1)
   liny.h  = copies(' ',((level-1)*3)) currV
   if length(liny.h)<50 then liny.h = left( liny.h,50) currDir
   else liny.h = liny.h currDir
return 0

MenuF2SUBR:
   FR.currD.side            =argA
   FR.currD.opposide        =argB
   FR.nam.side.curfileN     =argC
   selectedFilesSTRside     =parseFileStringSUBR(argD)
   selectedFilesSTRopposide =parseFileStringSUBR(argE)
   thisPathLarcMnuFILE      =argF
   eingabe                  =argG
   screenText               =argH
   FR.archivFile.side       =argI
   FR.archivFile.opposide   =argJ
   tempfile.0 =0
   menu. =0
   input =0
   MnuFile= filespec('N',thisPathLarcMnuFILE)
   MnuFile= stream(MnuFile,'C','query exists')
   if eingabe=s_F2_Key |MnuFile='' then
      MnuFile =stream(thisPathLarcMnuFILE,'C','query exists')
   if MnuFile<>'' then do
      m=0  ;n=0
      do while lines( MnuFile)
         liny = linein(MnuFile)
         if left(liny,1)=' ' |left(liny,1)=Tab_KEY then do
            liny=strip(liny)
            if liny<>'' then do
               n=n+1
               menu.m.n=liny
               menu.m.0=n
            end
         end
         else do
            m=m+1
            n=0
            queue liny
         end
      end
      call stream MnuFile, 'C', 'Close'
      ret = rlist( ,'S')
      parse var ret one Nr
      if one='1' & Nr<m+1 then do
         call SysCurPos 0,0
         call charout , screenText
         taggedBOOL=0
         do p=1 to menu.Nr.0
            nach =menu.Nr.p
            menu.Nr.p =''
            insPos = pos('!', nach)
            do while nach<>''
               if insPos>1 then do 
                  if taggedBOOL then call taggedAllSUBR left(nach,insPos-1)
                  else menu.Nr.p = menu.Nr.p||left(nach,insPos-1)
               end
               if insPos>0 then chary = substr(nach,insPos,2)
               else chary =''
               select
                  when chary='!f'|chary='!F' then do
                      if taggedBOOL then call taggedAllSUBR FR.currD.side||FR.nam.side.curfileN
                      else menu.Nr.p = menu.Nr.p||FR.currD.side||FR.nam.side.curfileN
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!p' then do
                      if taggedBOOL then call taggedAllSUBR strip(FR.currD.side,'T','\')
                      else menu.Nr.p = menu.Nr.p||strip(FR.currD.side,'T','\')
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!P' then do
                      if taggedBOOL then call taggedAllSUBR strip(FR.currD.opposide,'T','\')
                      else menu.Nr.p = menu.Nr.p||strip(FR.currD.opposide,'T','\')
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!s' then do
                      if taggedBOOL then call taggedAllSUBR FR.currD.side
                      else menu.Nr.p = menu.Nr.p||FR.currD.side
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!S' then do
                      if taggedBOOL then call taggedAllSUBR FR.currD.opposide
                      else menu.Nr.p = menu.Nr.p||FR.currD.opposide
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!z' then do
                      if taggedBOOL then call taggedAllSUBR FR.archivFile.side
                      else menu.Nr.p = menu.Nr.p||FR.archivFile.side
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!Z' then do
                      if taggedBOOL then call taggedAllSUBR FR.archivFile.opposide
                      else menu.Nr.p = menu.Nr.p||FR.archivFile.opposide
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!n' then do
                      nach = substr(nach, insPos+2)
                  end
                  when chary='!@' then do
                      tempfile.0 = tempfile.0+1
                      h= tempfile.0
                      call parseFileStringSUBR argD
                      tempDir = value( 'TEMP',, 'OS2ENVIRONMENT')
                      if tempDir = '' then tempDir = value( 'TMP',, 'OS2ENVIRONMENT')
                      if tempDir = '' then tempDir = 'C:'
                      tempDir = strip( tempDir,'T','\')
                      tempfile.h = SysTempFileName( tempDir||'\?_F2Larc.???')
                      do i=1 to FR.selected.0
                         call lineout tempfile.h, FR.selected.i
                      end
                      call lineout tempfile.h
                      if taggedBOOL then call taggedAllSUBR tempfile.h
                      else menu.Nr.p = menu.Nr.p||tempfile.h
                      nach = substr(nach, insPos+2)
                  end
                  when chary='!y' |chary='!Y' then do
                      call parseFileStringSUBR argD
                      if taggedBOOL then call taggedAllSUBR 'ALL_TAGGED_Y'
                      else do
                         taggedBOOL =1          
                         do t=1 to FR.selected.0
                            lpos = lastpos('.', FR.selected.t)
                            if lpos>1 then curfileNoExt = substr(FR.selected.t,1,lpos-1)
                            else curfileNoExt = FR.selected.t
                            menu.Nr.p.tagged.t=menu.Nr.p||curfileNoExt
                            menu.Nr.p.tagged.0=t
                         end
                      end
                      nach = substr(nach, insPos+2)
                  end
                  when chary='!t' then do
                      call parseFileStringSUBR argD
                      if taggedBOOL then call taggedAllSUBR 'ALL_TAGGED'
                      else do
                         taggedBOOL =1          
                         do t=1 to FR.selected.0
                            menu.Nr.p.tagged.0=t
                            menu.Nr.p.tagged.t=menu.Nr.p||FR.selected.t
                         end
                      end
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!l' then do
                      if taggedBOOL then call taggedAllSUBR strip(selectedFilesSTRside)
                      else menu.Nr.p = menu.Nr.p||strip(selectedFilesSTRside)
                      nach = substr(nach, insPos+2)
                  end
                  when chary=='!L' then do
                      if taggedBOOL then call taggedAllSUBR strip(selectedFilesSTRopposide)
                      else menu.Nr.p = menu.Nr.p||strip(selectedFilesSTRopposide)
                      nach = substr(nach, insPos+2)
                  end
                  when chary='!i'|chary='!I' then do
                      input = input +1
                      call SysCurPos zeile, 0
                      antw = rxanswer(input'. Input: ')
                      if taggedBOOL then call taggedAllSUBR antw
                      else menu.Nr.p = menu.Nr.p||antw
                      nach = substr(nach, insPos+2)
                  end
                  when chary='!x'|chary='!X' then do
                      lpos = lastpos('.',FR.nam.side.curfileN)
                      if lpos>1 then curfileNoExt = substr(FR.nam.side.curfileN,1,lpos-1)
                      else curfileNoExt = FR.nam.side.curfileN
                      if taggedBOOL then call taggedAllSUBR curfileNoExt
                      else menu.Nr.p = menu.Nr.p||curfileNoExt
                      nach = substr(nach, insPos+2)
                  end
                  when left(chary,1)='!' then do
                      if taggedBOOL then call taggedAllSUBR FR.nam.side.curfileN
                      else menu.Nr.p = menu.Nr.p||FR.nam.side.curfileN
                      nach = substr(nach, insPos+1)
                  end
                  otherwise do
                      if taggedBOOL then call taggedAllSUBR nach
                      else menu.Nr.p = menu.Nr.p||nach
                      nach =''
                  end
               end
               insPos = pos('!', nach)
            end
            if taggedBOOL=0 then do
               RetCode =CommandLineSUBR( 'cmd /C', menu.Nr.p)
               if RetCode>0 then say ' ReturnCode: 'RetCode
            end
            else do
               taggedBOOL=0
               do t=1 to menu.Nr.p.tagged.0
                  RetCode =CommandLineSUBR( 'cmd /C', menu.Nr.p.tagged.t)
                  if RetCode>0 then say ' ReturnCode: 'RetCode
               end
            end
         end
         do h=1 to tempfile.0 ; call SysFileDelete tempfile.h ; end
         screenText = SysTextScreenRead(0,0, zeile*80)
      end
   end
return screenText

taggedAllSUBR:
   parse arg next
   if next = 'ALL_TAGGED' then do t=1 to FR.selected.0
      menu.Nr.p.tagged.t =menu.Nr.p.tagged.t||FR.selected.t
   end
   else if next = 'ALL_TAGGED_Y' then do t=1 to FR.selected.0
      lpos = lastpos('.', FR.selected.t)
      if lpos>1 then curfileNoExt = substr(FR.selected.t,1,lpos-1)
      else curfileNoExt = FR.selected.t
      menu.Nr.p.tagged.t =menu.Nr.p.tagged.t ||curfileNoExt
   end
   else do t=1 to menu.Nr.p.tagged.0
      menu.Nr.p.tagged.t = menu.Nr.p.tagged.t||next
   end
return 0

CommandLineSUBR:
   parse arg startyOpt, commando
   commando = strip(commando)
   cmdBC = translate(commando)
   if pos(': ', cmdBC)=2 |pos('CD ',cmdBC )=1 |pos('CD\',cmdBC)=1 |pos('CD.',cmdBC)=1 then do
      address 'CMD' commando
   end
   else do
      address 'CMD' startyOpt commando
   end
   RetCode=RC
return RetCode

WpsObjectSUBR:                  /*   Larc a_F6 makeWpsObject    */
   DrvPathName= argA
   WpsName    = argB
   Params     = argC
   if WpsName= '' then do
      lastBS = lastpos('\',DrvPathName)
      WpsName= substr( DrvPathName, lastBS+1, lastpos('.',DrvPathName)-(lastBS+1) )
      first  = translate(left(WpsName,1))
      WpsName= overlay( first, WpsName)
   end
   if Params<>'' then setup=Params
   else do
      Ext = Translate(right(DrvPathName,4))
      If (Ext <> '.EXE') & (Ext <> '.CMD') & (Ext <> '.COM') & (Ext <> '.BAT') then do
         call putMessageAskPROC ' ERROR:  WpsObject only *.EXE *.Bat *.CMD  Files!'
         RETURN 0
      end
      if pos(':\', DrvPathName )<> 2 then do
         call putMessageAskPROC ' ERROR:  Give me Drv:\Path\Name!'
         RETURN 0
      end
      lastBS = lastpos('\',DrvPathName)
      setup = ';EXENAME='||DrvPathName||';STARTUPDIR='||left(DrvPathName, lastBS-1)
   end
   call SysCls
   say;say; say; say '   WpsName:'; say '"'WpsName'"'
   say;say; say; say '   setupString:' ; say '"'setup'"'
   say;say; say; call charout ,'   Esc\Return  Create WpsObject?  '
   if SysGetKey('NoEcho')=d2c(13) then do
      ret=SysCreateObject( "WPProgram", WpsName, "<WP_DESKTOP>", setup, "f")
      if ret=1 then say 'Succes!'
               else say "ERROR: already an object with same name on WPS?"
      '@pause'
   end
return 0


