/*   OS/2-Rexx  TextSearch in SubDirs&Zips by Ralph Ulrich
 *              grepz <some words to search>
 *    Example:  grepz.exe take it easy
 *              Finds "take it easy" in subDirectories & zipFiles!
 *       Note:  GREPZ creates findT.cmd / starts findT / Epm shows Found.txt!
 *      Needs:  EPM.exe   (OS/2)
 *              TEDIT.exe (OS/2)
 *              GREP.exe  (GNU)    - Edit Path to Grep.exe!
 *              UNZIP.exe (GNU)    - Edit Path to Unzip.exe!
 */
unziLIST='unzip.exe -Z -1'              /* ToDo:          more Archivers    */
unziPIPE='unzip.exe -pqaa'              /* unzip to Screen piping to grep   */
startOpt='start /C /B'                  /* background start findT.cmd       */
                                        /* Directory where to put outFiles  */
FileDir = value('TEMP', ,'OS2ENVIRONMENT')||'\'
subBOOL =1                              /* 1=SubDirsGrep  0=no subDirs      */
ZipBOOL =1                              /* ZipBOOL=0  no search zipFiles    */
DelBOOL =1                              /* DelBool=0      not del findT.cmd */
GrepOpt ='grep.exe -1 -hin'             /* GNU-GREP       options           */
notTextFiles='_.HLP_.INI_.ARC_.ARJ_.LHA_.LZH_.RAR_.TPU_.IMG_.OBJ_.RES_.DAT_.COM_.EXE_.ICO_.INF_.GIF_.BMP_.MET_.COM_.DLL_.LIB_.ADD_.DMD_.OVL_.CPS_.MID_.FON_'
                                        /* Files with these Extensions will not be searched! */
gropt.1 ='  grep.exe [-[[AB] ]<n>] [-[CEFGVchilnqsvwx]]'
gropt.2 ='  -A <n>   print <n>um lines After  every matching line'
gropt.3 ='  -B <n>   print <n>um lines Before every matching line'
gropt.4 ='  -<n>     print <n>um lines of context on each side'
gropt.5 ='  -h       No filenames preceding match'
gropt.6 ='  -i       ignore case difference when comparing strings'
gropt.7 ='  -n       number of line preceding match'
gropt.8 ='  -v       only lines containing no matches'
gropt.9 ='  -w       only lines where the match is a complete word'
gropt.10=''
gropt.11='   Leave tEdit now with F2 or F4  and start this Batch!'
gropt.12='   Later Epm will show Results while this Batch works!'
gropt.13='         Then get a zipped File in Epm with Cursor upon'
gropt.14='         an "unzip-Line" and "DoLines" in Epm-CommandLine.'
gropt.15=''
gropt.0 =15
parse arg searchText
   if subBOOL then if rxretok('subDirectories? ') then subBOOL=1; else subBOOL=0
   if subBOOL =1 then sftOpt  ='FSO'; else sftOpt ='FO'
   hlp.0=9; anzfiles=0; previewBOOL=1
   if FileDir='' then FileDir ='D:\'
   if searchText='' then do
      screeny=strip(SysTextScreenRead(1,0),'T')
      parse source . . thisRexx;  'Tedit.exe 'thisRexx
      call SysCurPos 0,0; call charout,screeny; say
      EXIT 1
   end
   if pos( searchText||'_' , "/?_/H_-?_/h_" )>0 then do     /* -?/H abfangen */
      do i=1 to hlp.0; say sourceline(i); end
      EXIT 2
   end
   if pos('"', searchText)>0 then do
      say '  No " !'
      EXIT 3
   end
   do while queued()>0; pull some; end
   if rxfuncquery('SysLoadFuncs')=1 then do;call RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs";call SysLoadFuncs;end
   FileDir = strip(FileDir,'T','\')||'\'
   fundFILE = SysTempFileName( FileDir||'found???.txt')
   cmdFILE  = SysTempFileName( FileDir||'findT???.cmd')
   escpos =pos('^',searchText)  /* doubble EscapeChar because of cmd */
   if escpos>0 then searchText =insert('^',searchText,escpos)

   call lineout cmdFILE,'setlocal'
   call lineout cmdFILE,'set RUNBOOL=1'
   call lineout cmdFILE,'if "%RUNBOOL%"=="0" (EXIT)'
   call lineout cmdFILE,'set EPMBOOL=1'
   if subBOOL then call lineout cmdFILE,'set SUBBOOL=1'
   if ZipBOOL then call lineout cmdFILE,'set ZIPBOOL=1'; else call lineout cmdFILE,'set ZIPBOOL=0'
   if DelBOOL then call lineout cmdFILE,'set DELBOOL=1'; else call lineout cmdFILE,'set DELBOOL=0'
   call lineout cmdFILE,'set FOUND_TXT='||fundFILE
   call lineout cmdFILE,'set S_TEXT='searchText
   call lineout cmdFILE,'set GREPOPT='GrepOpt
   do p=1 to gropt.0
      call lineout cmdFILE, 'REM    'gropt.p
   end
   call lineout cmdFILE,'echo 'date()'   'time()'   %GREPOPT% -e "%S_TEXT%">> %FOUND_TXT%'
   call lineout cmdFILE,'echo. 'copies('-',78)'>>%FOUND_TXT%'
   call lineout cmdFILE,'echo. >>%FOUND_TXT%'

   if subBOOL then do
      CALL SYSFILETREE  '*' , 'fund.', 'FO'
      AnzCurrDirFiles = fund.0
   end
   CALL SYSFILETREE  '*' , 'fund.', sftOpt
   do r=1 to fund.0
      EXT=right(translate(fund.r),4)||'_'
      if pos( EXT, notTextFiles)>0 then NOP
      else if EXT<>".ZIP_" then do
         anzfiles=anzfiles+1
         call lineout cmdFILE ,'((%GREPOPT% -e "%S_TEXT%" 'fund.r' >>%FOUND_TXT%)&&(( echo. >>%FOUND_TXT%)&(echo 'fund.r' >>%FOUND_TXT%)&(echo 'copies('-',78)' >>%FOUND_TXT%)&(echo. >>%FOUND_TXT%)))'
      end
      else do                /* if EXT=".ZIP_"  */
         if ZipBOOL then do
            unziLIST fund.r' | rxqueue'
            key.0 = queued()
            do s=1 to key.0
               parse pull key.s
               extz = '_'||right(translate(key.s),4)||'_'
               if pos( extz, notTextFiles||'_.ZIP')>0 then NOP
               else do
                  if right(key.s,1) = '/' then NOP
                  else do
                     anzfiles=anzfiles+1
                     call lineout cmdFILE ,'if "%ZIPBOOL%"=="1" (('unziPIPE fund.r key.s' | %GREPOPT% -e "%S_TEXT%" >>%FOUND_TXT%)&&((echo. >>%FOUND_TXT%)&(echo MC #unzip -oqqaa 'fund.r key.s' -d 'FileDir' #EDIT 'FileDir||key.s' #L /%S_TEXT%/CG >>%FOUND_TXT%)&(echo 'copies('-',78)' >>%FOUND_TXT%)&(echo. >>%FOUND_TXT%)))'
                     if anzfiles=20 & previewBOOL then do
                        previewBOOL=0
                        call lineout cmdFILE ,'if "%EPMBOOL%"=="1" start epm.exe /R /I %FOUND_TXT%'
                     end
                  end
               end
            end
         end
      end
      if anzfiles=20 & previewBOOL then do
         previewBOOL=0
         call lineout cmdFILE ,'if "%EPMBOOL%"=="1" start epm.exe /R /I %FOUND_TXT%'
      end
      if subBOOL then do
         if AnzCurrDirFiles=r then do
            call lineout cmdFILE, 'if not "SUBBOOL"=="1" goto ENDGREPZ'
         end
      end
   end
   call lineout cmdFILE, ':ENDGREPZ'
   if previewBOOL then call lineout cmdFILE ,'if "%EPMBOOL%"=="1" start epm.exe /R /I %FOUND_TXT%'
   else                call lineout cmdFILE ,'if "%EPMBOOL%"=="1"'" start epm.exe /R /I 'EDIT /D %FOUND_TXT%'"
   if DelBOOL then call lineout cmdFILE, 'if "%DELBOOL%"=="1" del 'cmdFILE' & EXIT'
   call lineout cmdFILE
   screeny=strip(SysTextScreenRead(1,0),'T')
   'tedit.exe 'cmdFILE
   call SysCurPos 0,0; call charout,screeny; say
   say grepOpt' "'searchText'" >>'fundFILE
   say '           Number of Files: 'anzfiles
   startOpt cmdFILE
return 0


rxretok: procedure
   parse arg message
   call charout, '? Esc/Return   'message'  '
   k=SysGetKey('Noecho');   say
   if k = '0D'x then
return 1
   else
return 0
