/*     batchRx    OS2-Rexx       makes some RexxFuncs accessable for Batch   */
parse arg func fA fB some
if rxfuncquery('SysLoadFuncs')=1 then do ; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs" ; call SysLoadFuncs ; end
    func = translate(func)
    ret = 0
    if      func = 'FILEDATE'  then ret =fdate( fA, fB)
    else if func = 'FILETIME'  then ret =ftime( fA, fB)
    else if func = 'CURRDIR'   then call value 'currdir', directory(), 'OS2ENVIRONMENT'
    else if func = 'SLEEPY'    then call sleepy fA
    else if func = 'BEEPY'     then call beepy  fA, fB
    else if func = 'SPINNY'    then call spinny
    else if func = 'SCREENLOG' then call screenlog fA
    else if func = 'PMPRINTF'  then call pmprintf fA fB some
return ret

fdate:
    arg fileA, fileB, nichts
         datefileA = stream(fileA, 'C', 'query datetime')
    if fileB='' then do
         datefileB = datefileA
         datefileA = translate( date('U'), '-', '/') time()
    end
    else datefileB = stream(fileB, 'C', 'query datetime')
    parse var datefileA mon '-' tag '-' jahr std ':' min ':' sec
    datefileA = tag + ( mon * 31) + ( jahr * 377)
    parse var datefileB mon '-' tag '-' jahr std ':' min ':' sec
    datefileB = tag + ( mon * 31) + ( jahr * 377)
    diff = datefileA - datefileB
return diff

ftime:
    arg fileA, fileB, nichts
         datefileA = stream(fileA, 'C', 'query datetime')
    if fileB='' then do
         datefileB = datefileA
         datefileA = translate( date('U'), '-', '/') time()
    end
    else datefileB = stream(fileB, 'C', 'query datetime')
    parse var datefileA mon '-' tag '-' jahr std ':' min ':' sec
    tfileA = min + ( std * 60 )
    parse var datefileB mon '-' tag '-' jahr std ':' min ':' sec
    tfileB = min + ( std * 60 )
    diff = tfileA - tfileB
return diff

sleepy:
   arg pauseconds, nichts
   if pauSeconds='' then pauSeconds=1
   if rxfuncquery('SysLoadFuncs')=1 then do; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"; call SysLoadFuncs; end
   call SysSleep( pauseconds)
return 0

beepy:
/*
   call beep 660,2222 E
   call beep 880,2222 A'
   call beep 440,2222 A
return 0
 */
   arg x, y, nichts
   if datatype( x, 'W') <> 1 then  x= 1111
   if datatype( y, 'W') <> 1 then  y= 111
   call beep x,y
return 0

/* OS/2-RexxFunktion zur AblaufAnzeige  */
spinny:
      S = (substr(time('L'),8)*100)//4
   if S = 0 then spin = ""; else
   if S = 1 then spin = "\"; else
   if S = 2 then spin = "|"; else
                 spin = "/"
   call charout stderr,spin||'1B'x||'[1D'
return 0

screenlog:
arg file
parse value SysTextScreenSize() with zeil spalt
screeny = SysTextScreenRead(0,0)
do while screeny <> ''
   parse var screeny liny +(spalt) screeny
   liny = strip( liny, 'T')
   call lineout file, liny
end
return 0

pmprintf:
parse arg a b c
   if rxfuncquery('rxuinit')=1 then do; call rxfuncadd 'rxuinit','rxu','rxuinit'; call rxuinit; end
   rety = SysSetObjectData( "f:\gtool\pmprintf.exe", "OPEN=DEFAULT")
   bytes =  RxPmPrintf(, a b c)
   if bytes = 0 then do
      call SysSleep 1
      bytes =  RxPmPrintf(, a b c)
   end
return bytes

