@ECHO OFF
CLS
ECHO *********************************************************************
ECHO * UPDATE.BAT - Updates to latest version of ADSKERN.NLM             *
ECHO * This batch file installs a new version of ADSKERN.NLM             *
ECHO * that fix the problems listed in README.TXT.                       *
ECHO * This batch file should be in a temporary directory where you also *
ECHO * have your licensed copy of ADSKERN.NLM                            *
ECHO * Your present copy of ADSKERN.NLM will be backed up to ADSKERN.BAK *
ECHO * You also need to attrib the LANtastic Dedicated Server files in   *
ECHO * the system directory so that the new files can be copied to the   *
ECHO * server.  Perform the following command from the drive that is     *
ECHO * directed to the servers system directory before copying the files *
ECHO * to the server:                                                    *
ECHO *     D:                                                            *
ECHO *     ATTRIB -R ADS*.NLM                                            *
ECHO * After copying the files the following command can be run to set   *
ECHO * the attributes back to read only:                                 *
ECHO *     D:                                                            *
ECHO *     ATTRIB +R ADS*.NLM                                            *
ECHO * NOTE: where D: is the C-DRIVE\SYSTEM directory on the server.     *
ECHO * Press CTRL-C now to abort running this patch.                     *
ECHO * Hit any key to continue.                                          *
ECHO *********************************************************************
PAUSE

IF NOT EXIST ADSKERN.NLM GOTO ERR1KERN
IF NOT EXIST NEWKERN.EXE GOTO ERR4KERN
IF EXIST ADSKERN.BAK GOTO ERR2KERN

:INSTALLKERN
ECHO.
ECHO Copying old ADSKERN to ADSKERN.bak ..
COPY ADSKERN.NLM ADSKERN.BAK
ECHO.

ECHO Installing new ADSKERN ...
NEWKERN INFILE=ADSKERN.NLM OUTFILE=_KERN_.NLM
IF ERRORLEVEL 1 GOTO     ERR3KERN

COPY _KERN_.NLM ADSKERN.NLM
DEL _KERN_.NLM
GOTO DONEKERN

:ERR1KERN
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO ADSKERN.NLM not found in this directory - please copy this batch file
ECHO to the directory where ADSKERN.NLM resides and run UPDATE again.
ECHO.
GOTO EXIT

:ERR2KERN
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO ADSKERN.BAK already exists ! it will be overwritten.
ECHO Press CTRL-C to abort
ECHO.
PAUSE
GOTO INSTALLKERN

:ERR3KERN
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO Operation unsuccessful. Repeat UPDATE in a directory containing only
ECHO original ADSKERN.NLM program.
GOTO EXIT

:ERR4KERN
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO NEWKERN.EXE not found in this directory - please copy this file
ECHO to the directory where ADSKERN.NLM resides and run UPDATE again.
GOTO EXIT

:DONEKERN
ECHO                * ADSKERN successfully patched *

:EXIT
