#ifndef __WINDOW_MANAGER_H_
#define __WINDOW_MANAGER_H_

#include "visible.h"
#include "pcx.h"
#include "output.h"

#define DELTA 20

class WindowManager
    {
    protected:
        int step;               // 1.pcx, 100.pcx, 200.pcx ...
        Visible** stack;         // Windows that are on screen.
	int s_used;             // 0 - to number of windows - 1.
	int s_size;             // Allocated.

    public:
        WindowManager(int stp)
	    {
	    stack = new Visible*[DELTA];
	    s_used = -1;
	    s_size = DELTA;
            step = stp;
	    }
        virtual ~WindowManager();

        void show_window(Visible* object);  // Show stacked or popup window.
        void hide_window();                 // Hide window.
        void redraw_window(rect new_coords);// Resize upper window in stack.

        void add(Visible* object);          // Add to the end of stack.
        void moveTo(Visible* object);       // Move object to the stack top.
        void shift();                       // Rotate stack;
        void remove();                      // Remove object from stack top.

        char* get_file_name(Visible* object, char* str);  // Unique name.
        int get_number(Visible* object);       // Number of object in stack.
        int* get_cells();                      // Get cells to redraw.
        int overlapped(Visible* object);
    };

#endif __WINDOW_MANAGER_H_