// See Vector.h
#include "vector.h"   // Vector class
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "global.h"   // Global variables
#include <dos.h>

enum { SAVE = 1, DONT_SAVE };  // picture status

enum { FILE_NEW = 30, FILE_OPEN, FILE_SAVE, FILE_SAVE_AS_PCX,
       FILE_SAVE_AS_PCX_BW,
       SCRIPT_PLAY, SCRIPT_RECORD, SCRIPT_END, MACROS_KEEP, TEXT_EDIT };

/////////////////////////////////////////////////////////////////////////////
//------> The following part is common for programs with SCRIPTS <---------\\
void file_refresh()             // Used to get previous script name from stack
    {                           // Scripts and macroses could (with some
    scriptMode = GO;            // Limitations) be nested.
    delete scriptFileName;
    scriptFileName = NULL;
    mac_status mac = macros_pop();         // Obtain previous status
    delete mac.file;
    }
//------>    The above part is common for programs with SCRIPTS    <-------\\
/////////////////////////////////////////////////////////////////////////////
void Vector::to_buffer()
    {
    int maxx = getmaxx();
    int maxy = getmaxy() - 16;
    int x_screens = setup->w % maxx
	? setup->w / maxx + 1 : setup->w / maxx;
    int y_screens = setup->h % maxy
	? setup->h / maxy + 1 : setup->h / maxy;
    int width = x_screens * maxx + 20;
    int height = y_screens * maxy + 20;

    buffer = new GrafBuffer(loc(width, height), "_work.buf",
	rect(0, 0, maxx, maxy + 15));
    buffer->b_open();
    buffer->clear();

    int shift_x = 0;
    int shift_y = 0;                            //    loc buf_dim = buffer->get_dim();
    for(int i = 0; i < x_screens && !vector->get_error(); i++)
	{
	for(int j = 0; j < y_screens && !vector->get_error(); j++)
	    {
	    if(i || j)
		vector->show();
	    buffer->screen_buffer();   // Copy visible part of screen
	    shift_y += (long)maxy;// * 100 / vector->get_add_zoom().Y;
	    vector->set_add_scroll(shift_x, shift_y);

	    buffer->scroll(maxy, UP, 0);
	    }
	buffer->scroll(maxy * (j - 1), DN, 0);
	shift_y = 0;
	shift_x += (long)maxx / 8 * 8;// * 100 / vector->get_add_zoom().X;
	vector->set_add_scroll(shift_x, shift_y);
	buffer->scroll(maxx / 8 * 8, LEFT, 0);
	}

    vector->set_add_scroll(0, 0);
    }
///////////////////////////
void Vector::reload()
    {
    while(vector->play_used != 0)
	delete vector->playpop();

    delete vector->program;

    vector->error = 0;
    vector->set_program(vector->load_program(editor->getFileName()));
    }
///////////////////////////
// Prepare file system. Not necessary but strongly reckomended.
void Vector::prepare_files()
    {
    delete global[1]; delete global[2];
    global[1] = strdup("work"); global[2] = strdup("");
    (file_sys->file_system)->setItems();
    }
/////////////////////////////////////////////////////////////////////////////
// Board (window with PCX in it) is displayed and the simple movie is
// runned in it. Icons with few fazes of demo are showed one after another.
void about()
    {
    Board* board = new Board(rect(5, 5, 65, 20), "about.pcz",
              "about.pcy", "A B O U T", 8, 0, 16);
    board->show_window();

    Icon i(loc(1, 1), 2, LARGE_ICON, SHOW_BORDER);
    char* file = i.icon_open();

    FILE *stream;
    if((stream = fopen(file, "r+b")) == NULL)
	return;
    loc size = icon_size(LARGE_ICON);
    int i_size = ((size.X + 1 + 7) >> 3 << 2) * (size.Y + 1) + sizeof(imageP);
    imageP image = (imageP)malloc(i_size + 10);
    while(1)
        {
        for(int j = 1; j < 17; j++)
            {
            get_image(stream, j, image, i_size);
            putimage(screenXL(8), screenYT(10), image, COPY_PUT);
            delay(20);
            if(eventavail(KEYEVENT | MOUSEEVENT,
	    	   MCleftDn | MCrightDn))
                break;
            }
        if(eventavail(KEYEVENT | MOUSEEVENT,
	    	   MCleftDn | MCrightDn))
		break;
        }
    get_event();
    fclose(stream);
    delete image;
    board->hide();
    delete board;
    }
/////////////////////////////////////////////////////////////////////////////
// User-defined functions. It is good idea to write all functions, even
// it they do nothing but only passes the control from one menu to another.
// To know more about this topic see discussion about Simplified User
// Interface in KNOW_HOW.TXT.

int Vector::application(int n)
    {
    rect r = vector->user_screen(); // If Block_KH_OOPic used, use
                                    // (vector->vector->)user_screen()
    loc mspos = e.where();          // Mouse position

    sound(100); delay(100); nosound();     // I want some beeps

    switch(n)
	{
//	case AC_MOVE:                  // We do not support MOVE and RESIZE
//	    global_i[0] = AC_MOVE;     // in this simple application.
//	    return 0;                  // But it is not difficult to do.
//	case AC_RESIZE:                // Use KNOW-HOW.DRAW as the example.
//	    global_i[0] = AC_RESIZE;
//	    return 0;

	case AC_FILE_MENU:       // Go from line menu to the corresponding
	case AC_SCRIPT_MENU:     // objects. We only pass the control here.
	    return 2;            // Call the next menu.
	case AC_BUFFER_MENU:     // Call for Options menu
            return 2;

        case AC_BUFFER:
            return 1;
	case AC_PRINT_MENU:      // Pass the control to the Printer setup
	    return 2;            // form.

	case AC_PRINT:           // Print to printer. To be changed.
	    editor->swap();
	    reload();
	    WindowManager::hide_window();        // Print form
	    rect tmp = vector->bound();
	    moveTo(get(vector));
	    //vector->set_add_zoom(1);
	    vector->set_add_scroll(0, 0);
	    WindowManager::redraw_window(rect(0, 0, getmaxx(),
			getmaxy()));

	    if(!vector->get_error())
		{
		to_buffer();
		print->set_type(form->p_t);
		print->set_density(form->d);
		print->set_pass(form->pas);
		print->set_comp(form->m_x, form->m_y, form->d_x, form->d_y);
		print->set_left(form->l);
		print->set_paper(form->pap);
		for(int cop = 0; cop < form->cop && !vector->get_error();
		    cop++)
                    {
		    print->draw_pages(buffer, "_work1.buf");
		    if(form->pap && getch() == 27) // Wait for char - you could
		        break;                     // insert new paper
                    }
	        buffer->b_close();
                delete buffer;
                buffer = NULL;
                }
            WindowManager::redraw_window(tmp);

            moveTo(1);
	    menu->show();
  	    return 0;

	case AC_NEW:             // Load empty program file.
            editor->unload_file();
            editor->set_swap("noname.vec");
            editor->set_header("noname.vec");
	    editor->show();
	    return 1;            // Hide menu.
	case AC_OPEN:
	    prepare_files();
	    (file_sys->edit)->put_string("*.vec");
	    DATA_FILE = FILE_OPEN;
	    return 2;
	case AC_SAVE:
	    prepare_files();
	    (file_sys->edit)->put_string("*.vec");
	    DATA_FILE = FILE_SAVE;
	    return 2;
	case AC_SAVE_AS_PCX:
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_SAVE_AS_PCX;
	    return 2;
	case AC_SAVE_AS_PCX_BW:
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_SAVE_AS_PCX_BW;
	    return 2;
	case AC_ABOUT:
	    about();
	    return 1;

	case AC_SCRIPT_PLAY:
	    DATA_FILE = SCRIPT_PLAY;
	    prepare_files();
	    (file_sys->edit)->put_string("*.sc");  // set mask for file system
	    return 2;
	case AC_SCRIPT_RECORD:                          // recording of script
	    prepare_files();
	    DATA_FILE = SCRIPT_RECORD;
	    (file_sys->edit)->put_string("*.sc");
	    return 2;
	case AC_SCRIPT_END:                        // end of script recording.
	    DATA_FILE = SCRIPT_END;
	    file_refresh();
	    return 1;
	case AC_MACROS_KEEP:
	    DATA_FILE = MACROS_KEEP;

	    if(scriptMode == PLAY)
		{
		scriptMode = GO;
		return 1;
		}

	    file_refresh();
	    prepare_files();
	    (file_sys->edit)->put_string("*.sc");

	    return 2;

	case AC_PROGRAM_EDIT:
	    return 2;
	case AC_PROGRAM_SAVE_AND_RUN:
	    editor->swap();
	    reload();
	    vector->show();
	    sound(100); delay(100); nosound();     // I want some beeps
	    return 0;

	case AC_PROGRAM_RUN:
            reload();
	    vector->show();
	    sound(100); delay(100); nosound();     // I want some beeps
	    return 0;

// Exit program.
	case AC_ASK_EXIT:
	    return ask_exit();

	case AC_FILE:
	    switch(DATA_FILE)
                {
                case SCRIPT_PLAY:                          // PLAY mode
                    WindowManager::hide_window();   // Hide file_sys
                    WindowManager::hide_window();   // Hide file_menu

		    mac_status mac;              // remember old file executed
		    mac.file = scriptFileName
			? strdup(scriptFileName) : NULL;
		    mac.ptr = scriptPtr;
		    mac.mode = scriptMode;

		    fpos_t reserv_pos;
		    fgetpos(scriptPtr, &reserv_pos);
		    mac.pos = reserv_pos;

		    macros_push(mac);        // keep it in the stack

		    delete scriptFileName;
		    scriptFileName = global[global_i[1]]      // if file name
			? strdup(global[global_i[1]]) : NULL; // is set

		    fclose(scriptPtr);
		    fclose(macrosPtr);

		    scriptPtr = fopen(scriptFileName, "r");
		    macrosPtr = fopen(macrosFileName, "r");

		    scriptMode = PLAY;
		    moveTo(1);
		    return 0;
		case SCRIPT_RECORD:                              // RECORD
                    WindowManager::hide_window();   // Hide file_sys
                    WindowManager::hide_window();   // Hide file_menu

		    delete scriptFileName;
		    scriptFileName = global[global_i[1]]
			? strdup(global[global_i[1]]) : NULL;
		    scriptPtr = fopen(scriptFileName, "w+");
		    scriptMode = RECORD;
		    moveTo(1);
		    return 0;
		case SCRIPT_END:
                    WindowManager::hide_window();   // Hide file_sys
                    WindowManager::hide_window();   // Hide file_menu

		    scriptMode = GO;
		    fclose(scriptPtr);
                    moveTo(1);
		    return 0;

		case MACROS_KEEP:                   // KEEP SCRIPT AS MACROS
                    WindowManager::hide_window();   // Hide file_sys
                    WindowManager::hide_window();   // Hide file_menu

		    int hot_result = ask_hot_key();  // (and end record before)

		    if(!hot_result)             // ESC or mouse button pressed
			return 0;

		    scriptFileName = global[global_i[1]]
			? strdup(global[global_i[1]]) : NULL;

		    fclose(scriptPtr);
		    fclose(macrosPtr);

		    scriptPtr = fopen(scriptFileName, "r");
		    macrosPtr = fopen(macrosFileName, "r");

		    FILE* tempPtr = fopen("temp.sc", "w");  // temp file for
							    // duplication
		    char command[22];
		    get_command(command);   // transfer e.key, set by ask_hot_key to command
		    add_macros(command, tempPtr);  // add the macros

		    fclose(tempPtr);
		    fclose(macrosPtr);

		    unlink(macrosFileName);                  // new macros file
		    rename("temp.sc", macrosFileName);
		    macrosPtr = fopen(macrosFileName, "r");

		    init_macros();     // rebuild table of macroses

		    delete scriptFileName;
		    scriptFileName = NULL;
		    moveTo(1);
		    return 0;

		case FILE_OPEN:
		    editor->unload_file();
		    editor->set_swap(global[global_i[1]]);
		    editor->set_header(global[global_i[1]]);
		    WindowManager::hide_window();   // Hide file_sys
		    WindowManager::hide_window();   // Hide file_menu
		    editor->show();
		    moveTo(get(editor));
		    return 0;
		case FILE_SAVE:
		    editor->set_swap(global[global_i[1]]);
		    editor->set_header(global[global_i[1]]);
		    WindowManager::hide_window();   // Hide file_sys
		    WindowManager::hide_window();   // Hide file_menu
		    editor->swap();
		    editor->show();
		    moveTo(1);
		    return 0;
		case FILE_SAVE_AS_PCX:
		case FILE_SAVE_AS_PCX_BW:
		    editor->swap();
		    reload();
		    WindowManager::hide_window();   // Hide file_sys
		    WindowManager::hide_window();   // Hide file_menu

		    rect tmp = vector->user_screen();

		    moveTo(get(vector));
//		    vector->set_add_zoom(loc(1, 1));
		    vector->set_add_scroll(0, 0);
		    WindowManager::redraw_window(rect(0, 0, getmaxx(),
			getmaxy()));

		    if(setup->w <= getmaxx() && setup->h <= getmaxy())
			{
			if(DATA_FILE == FILE_SAVE_AS_PCX)
			    pcx_scr_file(vector->user_screen(),
				global[global_i[1]], 1);
			else
			    {
			    pcx_scr_file(vector->user_screen(),
				"tmp_0000.pcx", 1);
			    pcx_col_to_bw("tmp_0000.pcx", global[global_i[1]]);
			    unlink("tmp_0000.pcx");
			    }
			}
		    else
			{
			if(!vector->get_error())
			    {
			    to_buffer();
			    if(DATA_FILE == FILE_SAVE_AS_PCX)
				{
				buffer->pcx_buffer_file(rect(0, 0,
				    (buffer->buf_dim.X - 1) / 8 * 8 - 1,
				    buffer->buf_dim.Y - 1),
				    global[global_i[1]]);

				buffer->b_close();
				}
			    else
				{
				buffer->pcx_buffer_file(rect(0, 0,
				    (buffer->buf_dim.X - 1) / 8 * 8 - 1,
				    buffer->buf_dim.Y - 1),
				"tmp_0000.pcx");

				buffer->b_close();
				pcx_col_to_bw("tmp_0000.pcx", global[global_i[1]]);
				unlink("tmp_0000.pcx");
				}
			    delete buffer;
			    buffer = NULL;
			    }
			}
		    WindowManager::redraw_window(tmp);

		    moveTo(1);
		    return 0;
		default:
		    return 0;
		}

	default:
	    return 0;
	}
    }
//////////////////////

