#include "text_buf.h"
#include <string.h>

TextPage::TextPage()
    {
    page = (uchar**)malloc(sizeof(uchar*) * PAGE_HEIGHT);
    for(int i = 0; i < PAGE_HEIGHT; i++)
	{
	page[i] = (uchar*)malloc(sizeof(uchar) * PAGE_WIDTH);
	memset(page[i], ' ', PAGE_WIDTH);
	page[i][PAGE_WIDTH] = '\0';
	}
    }
//////////////////////////////
TextPage::~TextPage()
    {
    for(int i = 0; i < PAGE_HEIGHT; i++)
	delete page[i];
    delete page;
    }
//////////////////////////////
int TextPage::draw_bar(rect r, char c)
    {
    char str[PAGE_WIDTH];
    memset(str, c, r.width());
    str[r.width() - 1] = '\0';
    int ret;
    for(int j = r.origin.Y; j < r.corner.Y; j++)
	{
	ret = putText(loc(r.origin.X, j), str);
	if(PAGE_HEIGHT < ret)
	    return ret;
	}
    return 0;
    }
///////////////////////////////
int TextPage::putText(loc pos, uchar* txt)
    {
    int i = 0;
    int height = 0;
    loc curr = pos;
    while(txt[i] != '\0')
	{
	switch(txt[i])
	    {
	    case '\r':   i++; break;
	    case '\n':
		curr.X = pos.X;
		curr.Y++;
		i++;
		height++;
		if(curr.Y > PAGE_HEIGHT)
		    return height;
		break;
	    default:
		if(curr.X > PAGE_WIDTH)
		    {
		    i++;
		    continue;
		    }
		page[curr.Y][curr.X] = txt[i];
		i++;
		curr.X++;
		break;
	    }
	}
    char* tmp = page[curr.Y];
    return height;
    }
