#ifndef __TABLE_H_
#define __TABLE_H_

enum { PRINT = 1, INPUT, IF, THEN, FOR, NEXT, TO, GOTO, EOL,
       FINISHED, GOSUB, LABEL, PLAYEX, RETURN, END, REMARK,
       REMARK_BLOCK, PAUSE,
       SIN, COS, TAN, ASIN, ACOS, ATAN, ABS, EXP, LOG, LG,

       USER, // All functions after this are user-defined in Slang childs

       LINE, LINETO, ELLIPSE, RECTANGLE, POLY, TXT, MOVETO,
       SETCOLOR, SETFILLSTYLE, SETTEXTJUSTIFY, SETTEXTSTYLE, SETFILL,
       ZOOM, ADDZOOM, SCROLL, ADDSCROLL, ROTATE, SETLINE, MIRROR,
       ROTATE_ON, ROTATE_OFF, ENDROTATE

     };

struct commands
    {
    char command[20];
    char tok;
    };


static commands TABLE[] =  {
	    { "print",  PRINT    },
	    { "input",  INPUT    },
	    { "if",     IF       },
	    { "then",   THEN     },
	    { "for",    FOR      },
	    { "next",   NEXT     },
	    { "to",     TO       },
	    { "@",      GOSUB    },
	    { "goto",   GOTO     },
	    { "!",      LABEL    },
	    { "return", RETURN   },
	    { "end",    END      },
	    { "&", REMARK   },
	    { "/*", REMARK_BLOCK },
	    { "pause", PAUSE     },
	    { "play",   PLAYEX     },

	    { "sin",    SIN      },
	    { "cos",    COS      },
	    { "lg",     LG       },

// Next block consists of user-defined functions
	    { "line",   LINE },
	    { "lineto", LINETO },
	    { "ellipse", ELLIPSE},
	    { "rectangle", RECTANGLE },
	    { "poly", POLY },
	    { "text", TXT },
            { "moveto", MOVETO },
            { "setline", SETLINE },

            { "zoom", ZOOM },
            { "addzoom", ADDZOOM },
            { "scroll", SCROLL },

            { "setcolor", SETCOLOR },
            { "setfillstyle", SETFILLSTYLE },
	    { "settextjustify", SETTEXTJUSTIFY },
	    { "settextstyle", SETTEXTSTYLE },
	    { "setfill", SETFILL },
	    { "rotate", ROTATE },
	    { "mirror", MIRROR },
	    { "rotate_on", ROTATE_ON },
	    { "rotate_off", ROTATE_OFF },
	    { "endrotate", ENDROTATE },
///////////////////////////////////////////////////
	    { "",       END      }     // apep oa a
	    };

#endif __TABLE_H_