#ifndef __PX_TABLE_H_
#define __PX_TABLE_H_

#include "pxfield.h"

//enum KH_SETMODE    { INSERT, REPLACE, APPEND    };
/*
This class incapsulates the Paradox Table data and operations.
Table is initiated with file name and used through handle.
We use one-PC (no net support) in this version.
We intend to use PXTable not as standing-alone class, but as the child
class in scope of this class functions. So we don't need functions for
the access to class data. We also don't need to define the table access
functions - they may be called as func(tblHandle) and so on (no need to
use ClassName.func(ClassName.tblHandle), data and functions are available).
*/

class AskManager;
class ReportManager;

class KH_PXTable
    {
    protected:
	char* fileName;                        // Table file name
	TABLEHANDLE tblHandle;                 // Table handle
	RECORDHANDLE recHandle;                // Record handle
	FIELDHANDLE fldHandle;                 // Field handle
	RECORDNUMBER current;                  // Current record
	RECORDNUMBER nRecords;                 // Total number of records
	int nFlds;                             // Number of fields
/*
KH_SHARE flag is initiated as 1 (one process uses the table).
       If table is on screen and we call AskManager (querry to table),
       then, after querry AskManager will close all tables, exept of
       those, which was on screen before querry. When calling AskManager,
       we increase KH_SHARE, and after the querrying, decrease it, and
       if its value becomes zero, close the table. Not used in this version.
*/
	int KH_SHARE;                          // Is it possible to delete
					       // Not used in ver. 1.0
    public:
// Create new or open existing table
	KH_PXTable(char* fName,        // Table name
		int idx = 0,           // Index governs table
// Use last 3 arguments for creating new table.
		int fNo = 0,           // Number of fields in table
		char** fields = NULL,  // Fields names array
		char** types = NULL);  // Fields types array

	~KH_PXTable();  // Close table and free memory. Does not remove file.

        int set_file(char* fName);
	TABLEHANDLE getTblHandle() { return tblHandle; }
	RECORDHANDLE getRecHandle() { return recHandle; }
	FIELDHANDLE getFldHandle() { return fldHandle; }
// Class data - not table operations.
	void setFld(int f) { fldHandle = f; }     // Attention!!! No verif.
	void setRec(RECORDHANDLE rec) { recHandle = rec; }
        void setNRecords(int sh) { nRecords += sh; current += sh; }
// Functions to operate on RECORDHANDLE.
	int getField(KH_PXFLD* ret);
	int putField(KH_PXFLD* f);
// Test, if this record and this querry are compatible. 0 (FALSE), 1 (TRUE).
	int testQuerry(char** shablon);
// Get field as string. You can use it for output.
	KH_FIELD_TYPE TranslateField(char* buf);
/* Find function works as simple (one-table) ASK procedure. It uses
shablon - array of strings, containing conditions. Comparison of strings
processed with strcpy functions. Dates are compared as long.
Numbers are compared using simple arithmetic operators.
We use three virtual functions Compare() for comparison operations. The
reason is that in child class could be defined some language, which
permits complex conditions. For example, using Slang class for basic-like
language, we got:
querry:   "< FIELD * 3"
realization:
int Compare(char* shab, double field)
    {
    slang.assign(FIELD, GetField()); // Create Slang variable for field
    slang.process("F =" + shab);     // Run program
    return slang.GetVariable("F") - field;  // 0, +, or -
    }
return 1 (success, not the end of table) or 0 (EOT), or 2 (EOT and success).
In this class only simple conditions (equial / not equial) are realized.
*/
	int Find(char** shablon);
// Condition checkers.
	virtual int Compare(char* shab, char* field);    // Strings
	virtual int Compare(char* shab, double field);   // Numbers
	virtual int Compare(char* shab, long field);     // Date and Long
	virtual int Compare(char* shab, short field);    // Short

/* AskManager class operates with multitables querries.
If there are more than 1 tables in querry, special "Example" variable(s)
should be set. Each call to AskManager builds new table "Answer".
*/
    friend class KH_AskManager;

/* The ReportManager class incapsulates reports output. It uses the
text file containing report formating strings. Not used in ver. 1.0
*/
    friend class ReportManager;
    };

#endif __PX_TABLE_H_

