#include "pxtable.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

KH_PXTable::KH_PXTable(char* fName, int idx,
		       int fNo, char** fields, char** types)
    {
    int exist;                              // Open or create new ?
    pxErr = PXTblExist(fName, &exist);
    if(pxErr != PXSUCCESS)                  // Invalid file name
	return;                             //     Constructor fails
    if(exist)                               // If table already exists
	{                                   //     Is it possible to open
	if((pxErr = PXTblOpen(fName, &tblHandle, idx, 0)) != PXSUCCESS)
	    exit(1);
	}
    else
	{                                   // No such table - create new
	if((pxErr = PXTblCreate(fName, fNo, fields, types)) != PXSUCCESS)
	    exit(1);                         // And open it
	if((pxErr = PXTblOpen(fName, &tblHandle, 0, 0)) != PXSUCCESS)
	    exit(1);
	}
    if((pxErr = PXRecBufOpen(tblHandle, &recHandle)) != PXSUCCESS)
	{
	exit(1);
        }
    current = 1;                            // Current is the 1-st record
    pxErr = PXTblNRecs(tblHandle, &nRecords);       // Determine total table size
    pxErr = PXRecNFlds(tblHandle, &nFlds);          // Number of fields in record

    pxErr = PXRecFirst(tblHandle);          // Dummy reposition
    fileName = strdup(fName);
    KH_SHARE = 1;                           // SHARE not used in ver. 1.0
    }
///////////////////////////////////
KH_PXTable::~KH_PXTable()
    {
    delete fileName;
    pxErr = PXTblClose(tblHandle);
    }
///////////////////////////////////
int KH_PXTable::set_file(char* fName)
    {
    int exist;                              // Open or create new ?
    pxErr = PXTblExist(fName, &exist);
    if(pxErr != PXSUCCESS)                  // Invalid file name
	exit(1);
    if(!exist)
	return 0;

    delete fileName;
    pxErr = PXTblClose(tblHandle);

    if((pxErr = PXTblOpen(fName, &tblHandle, 0, 0)) != PXSUCCESS)
	exit(1);
    if((pxErr = PXRecBufOpen(tblHandle, &recHandle)) != PXSUCCESS)
	{
	exit(1);
        }
    current = 1;                            // Current is the 1-st record
    pxErr = PXRecFirst(tblHandle);          // Dummy reposition
    fileName = strdup(fName);
    return 1;
    }
///////////////////////////////////
KH_FIELD_TYPE KH_PXTable::TranslateField(char* buf)
    {
    char fieldType[10];
    short sh;
    long date;
    double n;
    int m, d, y, l;
    PXFldType(tblHandle, fldHandle, 255, fieldType);
    int isBlank;
    pxErr = PXFldBlank(recHandle, fldHandle, &isBlank);

    switch(fieldType[0])
	{
	case 'A':
	    PXGetAlpha(recHandle, fldHandle, 255, buf);
	    return KH_STRING;
	case 'D':         // Read in format DD.MM.YY
	    if(isBlank)
		buf[0] = '\0';
	    else
		{
		char tmp[10];
		strset(buf, '0');
		PXGetDate(recHandle, fldHandle, &date);
		PXDateDecode(date, &m, &d, &y);
		itoa(d, tmp, 10);
		strcpy(buf + 2 - strlen(tmp), tmp);
		buf[2] = '.';
		itoa(m, tmp, 10);
		strcpy(buf + 5 - strlen(tmp), tmp);
		buf[5] = '.';
		itoa(y, tmp, 10);
		strcpy(buf + 6, tmp);
		}
	    return KH_DATE;
	case 'S':
	    if(isBlank)
		buf[0] = '\0';
	    else
		{
		PXGetShort(recHandle, fldHandle, &sh);
		sprintf(buf, "%d", sh);
		}
	    return KH_SHORT;
	case 'N':
	    if(isBlank)
		buf[0] = '\0';
	    else
		{
		PXGetDoub(recHandle, fldHandle, &n);
		sprintf(buf, "%f", n);
		}
	    return KH_NUMBER;
	default:
	    buf[0] = '\0';
	    return KH_BLOB;
	}
    }
//////////////////////////////////
int KH_PXTable::testQuerry(char** shablon)
    {
    char s[255];
    double d;
    long l;
    short sh;
    int result = 1;
    char fldType[6];
    for(int i = 1; i <= nFlds; i++)
	{
	if(!shablon[i - 1][0])
	    continue;
	PXFldType(tblHandle, i, 6, fldType);
	switch(fldType[0])
	    {
	    case 'A':
		PXGetAlpha(recHandle, i, 255, s);
		result = Compare(shablon[i - 1], s);
		break;
	    case 'N':
	    case '$':
		PXGetDoub(recHandle, i, &d);
		result = Compare(shablon[i - 1], d);
		break;
	    case 'S':
		PXGetShort(recHandle, i, &sh);
		result = Compare(shablon[i - 1], sh);
		break;
	    case 'D':
		PXGetDate(recHandle, i, &l);
		result = Compare(shablon[i - 1], d);
		break;
	    default:
		result = 1;           // No verification on BLOBs
		break;
	    }
	if(!result)
	    break;
	}
    return result;
    }
/////////////////////////////////
int KH_PXTable::Find(char** shablon)
    {
    int eot = 0;
    int first = 1;
    while(1)
	{
	pxErr = PXRecGet(tblHandle, recHandle);
	if((pxErr = PXRecNext(tblHandle)) != PXSUCCESS)
	    {
	    eot = 1;
	    if(first)
		return 0;
	    first = 0;
	    }

	int result = testQuerry(shablon);

	if(result && !eot)
	    return 1;
	if(result && eot)
	    return 2;
	if(eot)
	    return 0;
	}
    }
/////////////////////////////////
int KH_PXTable::Compare(char* shab, char* field)
    {
    if(!shab[0])
	return 1;
    return !strcmp(shab, field);
    }
/////////////////////////////////
int KH_PXTable::Compare(char* shab, double field)
    {
    if(!shab[0])
	return 1;
    return strtod(shab, NULL) == field;
    }
/////////////////////////////////
int KH_PXTable::Compare(char* shab, long field)
    {
    if(!shab[0])
	return 1;
    return strtol(shab, NULL, 10) == field;
    }
/////////////////////////////////////
int KH_PXTable::Compare(char* shab, short field)
    {
    if(!shab[0])
	return 1;
    return atoi(shab) == field;
    }
/////////////////////////////////////
int KH_PXTable::putField(KH_PXFLD* f)
    {
    switch(f->type)
	{
	case KH_NUMBER:
	case KH_MONEY:
	    if((pxErr = PXPutDoub(recHandle, fldHandle, f->n))
		!= PXSUCCESS)
		return 0;
	    break;
	case KH_STRING:
	    if((pxErr = PXPutAlpha(recHandle, fldHandle, f->str))
		!= PXSUCCESS)
		return 0;
	    break;
	case KH_DATE:
	    if((pxErr = PXPutDate(recHandle, fldHandle, f->date))
		!= PXSUCCESS)
		return 0;
	    break;
	case KH_SHORT:
	    if((pxErr = PXPutShort(recHandle, fldHandle, f->sh))
		!= PXSUCCESS)
		return 0;
	    break;
	default:         // BLOB put operations are supplied in ASK MANAGER
	    break;
	}
    return 1;
    }
/////////////////////////////////////
int KH_PXTable::getField(KH_PXFLD* ret)
    {
    char buf[10];
    PXFldType(tblHandle, fldHandle, 10, buf);
    switch(buf[0])
	{
	case 'N':
	case '$':
	    double d;
	    if((pxErr = PXGetDoub(recHandle, fldHandle,	&d))
		!= PXSUCCESS)
		return 0;
	    ret->type = KH_NUMBER;
	    ret->n = d;
	    break;
	case 'A':
	    if((pxErr = PXGetAlpha(recHandle, fldHandle, 255, ret->str))
		!= PXSUCCESS)
		return 0;
	    ret->type = KH_STRING;
	    break;
	case 'D':
	    long l;
	    if((pxErr = PXGetDate(recHandle, fldHandle, &l))
		!= PXSUCCESS)
		return 0;
	    ret->type = KH_DATE;
	    ret->date = l;
	    break;
	case 'S':
	    short sh;
	    if((pxErr = PXGetShort(recHandle, fldHandle, &sh))
		!= PXSUCCESS)
		return 0;
	    ret->type = KH_SHORT;
	    ret->sh = sh;
	    break;
	default:
	    if(strlen(buf) > 2)           // Not "M", but Mnnn (leader).
		{
		int blbSize;
		pxErr = PXBlobQuickGet(recHandle, fldHandle, 255,
		    (char*)ret->str, &blbSize);
		ret->sh = blbSize;
		}
	    else
		ret->str[0] = '\0';
	    ret->type = KH_BLOB;
	    break;
	}
    return 1;
    }
/////////////////////////////////////
/*
#include <iostream.h>
#include <dos.h>

/////////////////////
void main()
    {
    if(PXInit() != PXSUCCESS)
	return;

    KH_PXTable table("demo.db");

    char* shablon[] = { "", "", "", "", "", "", "", "", "", "", "" };
    char buf[255];
    int eot;
    while(table.Find(shablon) == 1)
	{
	for(int i = 1; i < 2; i++)
	    {
	    table.setFld(i);
	    table.TranslateField(buf);
	    cout << buf;
	    }
	cout << "\n";
	}
    PXExit();
    }
*/