#ifndef __PRINT_PAGE_H_
#define __PRINT_PAGE_H_

/* Page have the following areas:

All information included here is printed once - as Report header.
PAGEBAND -------------------------------------------------------------------
All information included here is printed on every page - as page header.
    TABLEBAND --------------------------------------------------------------
    Information here is repeated for every Record in table.
	RECORDBAND ---------------------------------------------------------
	ADDINFO ...,  FIELD...

	RECORDBAND ---------------------------------------------------------
    Information here is repeated for every Record in table.
    TABLEBAND --------------------------------------------------------------
    All information included here is printed on every page - as page footer.
PAGEBAND -------------------------------------------------------------------
All information included here is printed once - as Report footer.

*/

#include "prn_rec.h"

struct PAGE_LAYOUT
    {
    int page_band_top;          // Layout of Page elements
    int page_band_bottom;
    int table_band_top;
    int table_band_bottom;
    int record_band_top;
    int record_band_bottom;

    ADD_LIST* pg_top_info;      // Band specific information.
    ADD_LIST* pg_bottom_info;   // Coordinates of elements are given relative
    ADD_LIST* tb_top_info;      // to the corresponding band position, which
    ADD_LIST* tb_bottom_info;   // in turn, could depend on situation.
    ADD_LIST* rc_top_info;      // We do not use rc_... info for label mode
    ADD_LIST* rc_bottom_info;   // Reports.

    RECORD_LAYOUT* record;      // Record have not left-top pos. data - it
				// always printed on current position.

    PAGE_LAYOUT(int p_band_top, int p_band_bottom, int t_band_top,
	int t_band_bottom, int r_band_top, int r_band_bottom,
	ADD_LIST* p_top_info, ADD_LIST* p_bottom_info, ADD_LIST* t_top_info,
	ADD_LIST* t_bottom_info, ADD_LIST* r_top_info,
	ADD_LIST* r_bottom_info,
	RECORD_LAYOUT* rec);
    };

#endif __PRINT_PAGE_H_