#include "h_v_axes.h"

HV_Axes::HV_Axes(int l, double start, double end, int tick_no, int* t,
	    int s_tick_no, int* s, char** lab)
 : Axe(l, start, end, tick_no, t, s_tick_no, s,
		 lab)
                 {}
//////////////////////
void HV_Axes::show_labels(loc lt)
    {
    int hor_j = CENTER_TEXT;
    int ver_j = TOP_TEXT;

    if(dir == VERT_AXE)
	{
	if(type == NORMAL_AXE)
	    hor_j = RIGHT_TEXT;
	else
	    hor_j = LEFT_TEXT;
	ver_j = CENTER_TEXT;
	}
    else
	{
	if(type == REVERSE_AXE)
	    ver_j = BOTTOM_TEXT;
	}

    drawTool->load("litt.chr");

    drawTool->settextjustify(hor_j, ver_j);

    for(int i = 0; i < ticks_no; i++)
	{
	loc pos = get_label_pos(lt, i);
	if((dir == HORIZ_AXE && pos.X > len_scr + lt.X)
	    || (dir == VERT_AXE && pos.Y > len_scr + lt.Y))
	    break;

	if(!text_dir)
	    ;//pos.Y += drawTool->getheight();
	else
	    pos.Y += drawTool->gettextwidth(labels[i])/2;

//	drawTool->center = pos;

	drawTool->outtextxy(pos.X, pos.Y, labels[i], text_dir);
	}
    }
//////////////////////
void HV_Axes::set_type(int t, int d, int td)
    {
    type = t;
    dir = d;
    text_dir = td;
    }
///////////////////////////
loc HV_Axes::get_label_pos(loc lt, int n)
    {
    loc pos;
    int sh = type == NORMAL_AXE ? 1 : -1;
    if(dir == HORIZ_AXE)
	{
	pos.X = lt.X + (long)ticks[n] * len_scr / 10000;
	pos.Y = lt.Y + drawTool->getheight() * sh;
	}
    else
	{
	pos.Y = lt.Y + len_scr - (long)ticks[n] * len_scr / 10000;
	pos.X = lt.X - drawTool->getheight() * sh;
	}

    return pos;
    }
//////////////////////////////////////
void HV_Axes::show_axe(loc lt, int ax_col)
    {
    drawTool->setlinestyle(1, SOLID_LINE);
    drawTool->setcolor(ax_col);

    int sx = 0;
    int sy = 0;
    if(dir == HORIZ_AXE)
	sx = 1;
    else
        sy = 1;
    drawTool->line(lt.X, lt.Y, lt.X + sx * len_scr, lt.Y + sy * len_scr);
    if(dir == HORIZ_AXE)
	{
	for(int i = 0; i < ticks_no; i++)
	    drawTool->line(lt.X + (long)ticks[i] * len_scr / 10000, //ticks[ticks_no - 1],
		 lt.Y + 4,
		 lt.X + (long)ticks[i] * len_scr / 10000, //ticks[ticks_no - 1],
		 lt.Y - 4);
	for(i = 0; i < sub_ticks_no; i++)
	    drawTool->line(lt.X + (long)sub_ticks[i] * len_scr / 10000, //sub_ticks[sub_ticks_no - 1],
		 lt.Y + 2,
		 lt.X + (long)sub_ticks[i] * len_scr / 10000, //sub_ticks[sub_ticks_no - 1],
		 lt.Y - 2);
	}
    else
	{
	for(int i = 0; i < ticks_no; i++)
	    drawTool->line(lt.X - 4,
		 lt.Y + len_scr - (long)ticks[i] * len_scr / 10000, //ticks[ticks_no - 1],
		 lt.X + 4,
		 lt.Y + len_scr - (long)ticks[i] * len_scr / 10000); //ticks[ticks_no - 1]);
	for(i = 0; i < sub_ticks_no; i++)
	    drawTool->line(lt.X - 2,
		lt.Y + len_scr - (long)sub_ticks[i]
		    * len_scr / 10000, //sub_ticks[sub_ticks_no - 1],
		 lt.X + 2,
		 lt.Y + len_scr - (long)sub_ticks[i]
		    * len_scr / 10000); //sub_ticks[sub_ticks_no - 1]);
	}
    }

/*
void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    drawTool = new KH_Paint();   // See KHPAINT.H
    drawTool->rotate(loc(320, 240), 15);

    HV_Axes a(300, -20, 80);
    a.set_type(NORMAL_AXE, HORIZ_AXE);
    a.draw_axe(loc(40, 320), LIGHTBLUE, YELLOW);

    a.set_type(REVERSE_AXE, HORIZ_AXE);
    a.draw_axe(loc(40, 20), LIGHTBLUE, YELLOW);

    a.set_type(NORMAL_AXE, VERT_AXE);
    a.draw_axe(loc(40, 20), LIGHTBLUE, YELLOW);

    a.set_type(REVERSE_AXE, VERT_AXE);
    a.draw_axe(loc(340, 20), LIGHTBLUE, YELLOW);

    HV_Axes a2(200, -25, 80);
    a2.set_type(NORMAL_AXE, HORIZ_AXE);
    a2.draw_axe(loc(420, 20), LIGHTBLUE, YELLOW);

    HV_Axes a3(200, -122, 83);
    a3.set_type(NORMAL_AXE, HORIZ_AXE, VERT_DIR);
    a3.draw_axe(loc(420, 60), LIGHTBLUE, YELLOW);

    HV_Axes a4(200, -5635, -3558);
    a4.set_type(NORMAL_AXE, HORIZ_AXE, VERT_DIR);
    a4.draw_axe(loc(420, 140), LIGHTBLUE, YELLOW);


    HV_Axes a5(200, 0, 1180);
    a5.set_type(NORMAL_AXE, HORIZ_AXE, VERT_DIR);
    a5.draw_axe(loc(420, 240), LIGHTBLUE, YELLOW);

    int t[] = { 0, 5000, 10000 };
    int s[] = { 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000 };
    char* lab[] = { "First", "Second", "Third" };

    HV_Axes a1(200, 0, 0, 3, t, 9, s, lab);

    a1.set_type(NORMAL_AXE, HORIZ_AXE);
    a1.draw_axe(loc(60, 300), LIGHTGREEN, LIGHTRED);

    a1.set_type(REVERSE_AXE, HORIZ_AXE);
    a1.draw_axe(loc(60, 270), LIGHTGREEN, LIGHTRED);

    a1.set_type(NORMAL_AXE, VERT_AXE);
    a1.draw_axe(loc(100, 40), LIGHTGREEN, LIGHTRED);

    a1.set_type(REVERSE_AXE, VERT_AXE);
    a1.draw_axe(loc(120, 40), LIGHTGREEN, LIGHTRED);

    delete drawTool;   // See KHPAINT.H
    closegraph();
    }
*/


