#include "hypview.h"

HypertextView::HypertextView(rect coord, char* vName, char* fName,
	       int res, int interv,
	       BORDERS b_type, int s, char* h, int bak, int attr,
	       int p_height)
       : Block(coord, fName, h, s,
	       res, b_type, b_type, 0, 16, 16)
    {
    rect r = rect(textRect(w1->user_screen()));
    r.origin += loc(2, 1);
    r.corner -= loc(2, 1);
    int sx = textX(s);
    int sy = textY(s);

    view_win =
	new OutputWindow(r, vName,
	       b_type, 0, bak, attr, interv, p_height);

    home_element = new Element(loc(coord.origin.X + 4 + sx,
                                   coord.corner.Y - 2 - sy), HOME_ELEMENT);
    end_element = new Element(loc(coord.corner.X - 6 - sx, coord.corner.Y - 2 - sy),
					 END_ELEMENT);
    add(home_element); add(end_element);

    view_win->set_ret(1);

    insert(view_win, 1);

    assign(view_win, left_element, AC_LEFT);
    assign(view_win, right_element, AC_RIGHT);
    assign(view_win, up_element, AC_UP);
    assign(view_win, dn_element, AC_DOWN);
    assign(view_win, cancel_element, AC_CANCEL);
    assign(view_win, pg_up_element, AC_PG_UP);
    assign(view_win, pg_dn_element, AC_PG_DN);
    assign(view_win, home_element, AC_HOME);
    assign(view_win, end_element, AC_END);

    }
/////////////////////////////////
void HypertextView::rearrange()
    {
    Block::rearrange();
    rect coord = textRect(w1->user_screen());
    coord.corner.Y -= 1; coord.origin.Y += 1;
    int sx = textX(w1->get_shadow());
    int sy = textY(w1->get_shadow());

    list[1]->repose(coord);
    coord = textRect(w1->bound());

    home_element->repose(rect(coord.origin.X + 4 + sy,
        coord.corner.Y - 2 - sy,
	coord.origin.X + 6 + sy, coord.corner.Y - 1 - sy));
    end_element->repose(rect(coord.corner.X - 6 - sx, coord.corner.Y - 2 - sy,
	coord.corner.X - 4 - sx, coord.corner.Y - 1 - sy));
    }