#include "blkwrite.h"

BlockWrite::BlockWrite(rect coord, char* fname, char* fileName,
	    char* h, int s, int res, BORDERS b_type, BORDERS write_border,
	    BORDERS hdr_b_type, int pat, int write_pat, int hdr_pat,
	    int elem_pat)
    : Block(coord, fname, h, s, res, b_type, hdr_b_type, pat, hdr_pat,
            elem_pat)
    {
    rect r = textRect(w1->bound());
    r.origin.Y += 2;
    r.corner.Y -= (1 + textY(s));
    r.origin.X += 3;
    r.corner.X -= (3 + textX(s));

    write = new Write(r, fileName, /*fName*/ "", /*h*/ "",
	       /* s */ 0, write_border, NO_BORDER,
	       write_pat, /*hdr_pat*/ 0);
    write->set_ret(1);
    insert(write, 1);

    assign(write, left_element, AC_LEFT);
    assign(write, right_element, AC_RIGHT);
    assign(write, up_element, AC_UP);
    assign(write, dn_element, AC_DOWN);
    assign(write, cancel_element, AC_CANCEL);
    assign(write, pg_up_element, AC_PG_UP);
    assign(write, pg_dn_element, AC_PG_DN);
    }
/////////////////////////
void BlockWrite::rearrange()
    {
    Block::rearrange();
    rect r = textRect(w1->bound());
    int s = w1->get_shadow();
    r.origin.Y += 2;
    r.corner.Y -= (1 + textY(s));
    r.origin.X += 3;
    r.corner.X -= (3 + textX(s));
    write->repose(r);
    }
/////////////////////////
void BlockWrite::hide()
    {
    write->hide();
    w1->hide();
    }
///////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    BlockWrite s(rect(10, 0, 60, 24), "window.pcy", "work.txt",
	    "EDITOR", 6, MOVE | RESIZE, SHOW_BORDER, SHOW_BORDER,
	    SHOW_BORDER, 0, 0, 0, 12);

    s.show_window();
    s.exe();
    s.hide();

    close_KNOW_HOW();
    closegraph();
    }
*/