/* The global container, includes all objects of program. Manages mouse
   and keyboard events, calls objects and application functions of program.
*/

#ifndef __APPLICATION_KIT
#define __APPLICATION_KIT

#include "objkit.h"
#include "global.h"
#include "wmanager.h"

extern int application(int);

class ApplicationKit : public ObjectKit, public WindowManager
    {
    protected:
        loc minsize;                   // Used with RESIZE, cells
	int applExit;                  // Function from application to call before exit
				       // f.e.: SAVE? (Y / N)
    public:
	ApplicationKit(int stp, loc minsz = loc(10, 10));
        virtual int application(int n) { return ::application(n); } // To overload

	void set_exit(int n) { applExit = n; }
	void set_call(Visible* s, Visible* t)
	    { s->set_call(get(t)); }
	void set_point(Visible* s, Visible* t)
	    { s->set_point(get(t)); }

	int moveTo(int number);                // Make object active
	int shift();  // go to the next object
	Visible* remove(int number);    // remove from list but doesn't delete
        void add(Visible* object);
        void background(Visible* object); // Add 0-th object
	void insert(Visible* object, int number); // add to the current position
				     // and shift objects with largest numbers

	virtual void exe(int act = 0);
	void F10_shift();
	int mouse_shift(loc pos);
	void F6_shift();
    };

#endif __APPLICATION_KIT