/*  Project gdi_demo
    
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    gdi_demo.exe Application
    FILE:         gd_dmwnd.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of gdi_demoWindow (TWindow).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "gd_dmapp.h"

#include "gd_dmwnd.h"

#include <stdio.h>
#include <math.h>

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(gdi_demoWindow, TWindow)
//{{gdi_demoWindowRSP_TBL_BEGIN}}
//{{gdi_demoWindowRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{gdi_demoWindow Implementation}}


//////////////////////////////////////////////////////////
// gdi_demoWindow
// ==========
// Construction/Destruction handling.
gdi_demoWindow::gdi_demoWindow (TWindow* parent, const char far* title, TModule* module)
	 : TWindow(parent, title, module)
{
	 // INSERT>> Your constructor code here.

}


gdi_demoWindow::~gdi_demoWindow ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.

}
//////////////////////// DEMO //////////////////////////////////////
//#include <stdlib.h>
#include "kh_graf\graf.h"

class Demo : public Graf
	 {
	 public:
	void graf_demo();  // Not optimized !!!
	void draw_stacked(double* xar, double* bar, double* car, rect r);
	};
///////////////////
// The following code was developed using SLANG and only after testing
// translated to C++
void Demo::graf_demo()
	 {
	 rotate(0, 0, 0);
	 setfillstyle(SOLID_FILL, BLACK);
	 set_fill(ON);
	 rectangle(0, 0, 1000, 1000);


//	 drawTool = (KH_Paint*)this;   // See KHPAINT.H

	 int shifts[20]; // We suppose to use this array for bar grafs shists
	 memset(shifts, 0, 20 * sizeof(int));
	 double xar[5];
	 double yar[5];
	 double dar[5];
	 int tar[6];

	 for(int i = 1; i < 6; i++)
	{
	xar[i - 1] = i;
	yar[i - 1] = (double)i * i - 10;
	dar[i - 1] = (double)i * i / 2;
	tar[i - 1] = log10((double)i) * 200;      // Tick, Manual
	}
    tar[5] = log10(6) * 200;

    set_graf_clip(30, 10, 200, 200);               // Set area on screen
	 set_marker_size(8);  // Do it before calc_scale() in the case of bar graf
// double* ar, int axe (X-0, Y-1), int is_first, int n, int num);
    calc_scale(xar, 0, 1, 5, -1);
    calc_scale(dar, 1, 1, 5, -1);          // y-scale, first, resize
    calc_scale(yar, 1, 0, 5, -1);          // y-scale, not first, resize
    calc_scale(yar, 1, 0, 5, 1);	   // and fit to nice-looking scale
// I do not use symbolic names for colors to show that it is translation
// from SLANG. This method is much more effective than direct C++ programming
    setcolor(12); setfillstyle(1, 3);
//  Manual axe setup:
//  void set_axe(int which_axe, int axe_len,
//	    double start = 0, double end = 0,
//	    int tick_no = 0, int* ticks_on_axe = NULL,
//	    int s_tick_no = 0, int* sub_ticks_on_axe = NULL,
//	    char** legends_on_axe = NULL, int text_direction = HORIZ_AXE);
// Axes numeration: HORIZ1 = 1, VERT1 = 2, HORIZ2 = 4, VERT2 = 8
// xmin == xmax => manual axe scaling
	 char* s[] = { "One", "Two", "Three", "Four", "Five", "Six" };
	 set_axe(HORIZ1, clip.width(), 0, 0, 6, tar, 5, tar, s, 1);
//Auto setup for Y:
    set_axe(VERT1, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);

// void show_axes(int ax_color, int legends_color,
//    int grid_style, int grid_color, int width, int ticks_width, int set);
    show_axes(14, 9, 1, 2, 3, 1, HORIZ1 + VERT1);

    setcolor(14); setfillstyle(5, 11);
	 cross();                       // Draw beginning of axes (0,0)

    plot_data(xar, dar, 5, BAR_GRAF, 1, shifts);
    setcolor(15); setfillstyle(6, 14);
    plot_data(xar, yar, 5, BAR_GRAF, 1, shifts);   // Plot second dataset
    set_marker_size(4);
    setcolor(9); setfillstyle(1, 7);
    plot_data(xar, yar, 5, COMBINED_GRAF, 1, shifts);
    set_marker_size(8);
///////////////////////////////////////////////////////////////////////////
    for(i = 0; i < 20; i++)
	shifts[i] = 0;
	 for(i = 1; i < 6; i++)
	{
	yar[i - 1] = (double)i * i - 10;
	dar[i - 1] = (double)i * i / 2 - 5;
	}

    set_graf_clip(230, 20, 380, 210);       // Rectangle on screen
    calc_scale(xar, 0, 1, 5, 0);
    calc_scale(dar, 1, 1, 5, -1);           // y-scale, first, resize
    calc_scale(yar, 1, 0, 5, -1);           // y-scale, not first, resize
    calc_scale(yar, 1, 0, 5, 1);
    calc_scale(xar, 0, 0, 5, 1);

	 set_axe(HORIZ1, clip.width(), xmin, xmax, -1, NULL, 2, NULL, NULL, 0);
    set_axe(VERT1, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
    set_axe(HORIZ2, clip.width(), xmin, xmax, -1, NULL, 5, NULL, NULL, 0);
    set_axe(VERT2, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
//Axes numeration: HORIZ1 = 1, VERT1 = 2, HORIZ2 = 4, VERT2 = 8
// void show_axes(int ax_color, int legends_color,
//    int grid_style, int grid_color, int width, int ticks_width, int set);
    show_axes(14, 12, 0, 7, 3, 1, 1 + 2 + 4 + 8);
    setcolor(11); setfillstyle(1, 3);
    cross();
    set_fill(ON);
    plot_data(xar, yar, 5, BAR_3D_GRAF, 1, shifts);
    setcolor(8); setfillstyle(1, 2);
    plot_data(xar, dar, 5, BAR_3D_GRAF, 1, shifts);
    for(i = 0; i < 20; i++)
	shifts[i] = 0;
/////////////////////////////////////////////////////////////////////////////
    double rar[100];
	 double sar[100];
	 for(i = 1; i < 101; i++)
	{
	rar[i - 1] = i;
	sar[i - 1] = (double)sin(3.6 * i) / 1000;  // sin() overloaded!
	}
    set_graf_clip(420, 20, 600, 210);
    set_graf_scale(0, -1, 100, 2);                 // Manual scale ajustment

	 set_axe(HORIZ1, clip.width(), xmin, xmax, -1, NULL, 2, NULL, NULL, 0);
    set_axe(VERT1, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
    set_axe(HORIZ2, clip.width(), xmin, xmax, -1, NULL, 2, NULL, NULL, 0);
    set_axe(VERT2, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
    show_axes(14, 12, 3, 7, 3, 1, 1 + 2 + 4 + 8);
    cross();
    setcolor(10); setfillstyle(1, 2); To_Paint::setlinestyle(3, 0);
    plot_data(rar, sar, 100, LINE_GRAF, 1, shifts);
    To_Paint::setlinestyle(1, 1);
//''''''''''''''''''''''''''''''''' Add small graph at the corner of big one
//'''''''''''''''''''''''''''''''''
    for(i = 1; i < 101; i++)
	sar[i - 1] = 100 * sar[i - 1];

    set_graf_clip(510, 35, 595, 90);
    setfillstyle(1, 0);
    rectangle(480, 20, 600, 120);
    calc_scale(rar, 0, 1, 100, 0);
	 calc_scale(sar, 1, 1, 100, 0);

    set_axe(HORIZ1, clip.width(), xmin, xmax, -1, NULL, 2, NULL, NULL, 1);
    set_axe(VERT1, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
    show_axes(14, 12, -1, 7, 3, 1, 1 + 2);
    cross();
    setcolor(10); setfillstyle(1, 2); To_Paint::setlinestyle(3, 0);
    plot_data(rar, sar, 100, LINE_GRAF, 1, shifts);
/////////////////////////////////////////////////////////////////////////////
	 set_marker_size(16);
    double zar[20];
//                We set zar[] manually. The rules are:
//                zar[4*i] keep ystart < 0;
//		 zar[4*i+1] keep ystart >= 0;
//		 zar[4*i+2] keep yend < 0;
//		 zar[4*i+3] keep yend >= 0;
zar[0] = 0; zar[1] = 0; zar[2] = 0; zar[3] = 10;
zar[4] = 0; zar[5] = 0; zar[6] = 0; zar[7] = 24;
zar[8] = 0; zar[9] = 0; zar[10] = 0; zar[11] = 15;
zar[12] = 0; zar[13] = 0; zar[14] = 0; zar[15] = 10;
zar[16] = 0; zar[17] = 0; zar[18] = 0; zar[19] = 5;

    double aar[20];

aar[0] = 0;    aar[1] = 10; aar[2] = 0;     aar[3] = 12;
aar[4] = 0;    aar[5] = 24; aar[8] = 0;     aar[7] = 25;
aar[8] = 0;    aar[9] = 15; aar[10] = 0;    aar[11] = 25;
aar[12] = 0;   aar[13] = 10; aar[14] = 0;   aar[15] = 15;
aar[16] = 0;   aar[17] = 5; aar[18] = 0;    aar[19] = 7;

    set_graf_clip(20, 230, 240, 400);
    calc_scale(xar, 0, 1, 5, 0);
    calc_scale(zar, 1, 1, 20, 0);
    calc_scale(aar, 1, 0, 20, -1);

    set_graf_scale(xmin, ymin * 1.2, xmax, ymax * 1.2);
	 calc_scale(xar, 0, 0, 5, 1);

    set_axe(HORIZ1, clip.width(), xmin, xmax, -1, NULL, 5, NULL, NULL, 0);
    set_axe(VERT1, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
    set_axe(HORIZ2, clip.width(), xmin, xmax, -1, NULL, 5, NULL, NULL, 0);
    set_axe(VERT2, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);

    show_axes(14, 12, 0, 7, 3, 1, 1 + 2 + 4 + 8);
    setcolor(8); setfillstyle(1, 2);
    cross();
    plot_data(xar, zar, 5, STACKED_BAR_GRAF, 3);
    setcolor(14); setfillstyle(1, 9);
    plot_data(xar, aar, 5, STACKED_BAR_GRAF, 3);
////////////////////////////////////////////////////////////////////////////
// Now we combine manual and automatic approaches: first two arrays are
// composed manually, third is added with call to get_stacked()
double bar[20];
bar[0] = 0;      bar[1] = 0;      bar[2] = -10;    bar[3] = 10;
bar[4] = 0;      bar[5] = 0;      bar[6] = -20;    bar[7] = 10;
bar[8] = 0;      bar[9] = 0;     bar[10] = 0;     bar[11] = 10;
bar[12] = 0;     bar[13] = 0;     bar[14] = 0;     bar[15] = 20;
bar[16] = 0;     bar[17] = 0;     bar[18] = 0;     bar[19] = 2;

double car[20];
car[0] = -10;   car[1] = 10;    car[2] = -15;   car[3] = 20;
car[4] = -20;   car[5] = 10;    car[6] = -25;   car[7] = 15;
car[8] = 0;     car[9] = 10;    car[10] = 0;    car[11] = 17;
car[12] = 0;    car[13] = 20;   car[14] = 0;    car[15] = 22;
car[16] = 0;    car[17] = 2;    car[18] = 0;    car[19] = 12;

setcolor(9); setfillstyle(1, 1);

// We suppose to draw the same (almost) graf with and without rotation
draw_stacked(xar, bar, car, rect(310, 250, 550, 450));
// Preparations
rotate(250, 250, 45);
set_marker_size(8);

setfillstyle(SOLID_FILL, BLACK);
KH_Paint::rectangle(120, 120, 330, 330);

draw_stacked(xar, bar, car, rect(150, 150, 300, 300));
	 }

void Demo::draw_stacked(double* xar, double* bar, double* car, rect r)
	 {
double ear[20];
for(int i = 0; i < 20; i++)
    ear[i] = car[i];

set_graf_clip(r.origin.X, r.origin.Y, r.corner.X, r.corner.Y);
calc_scale(xar, 0, 1, 5, 0);
get_stacked(xar, ear, 5);                // ear scale is enought
calc_scale(ear, 1, 1, 20, -1);             // y-scale, first, resize
// We have xmin, xmax, ymin, ymax. Now we want change scale.
set_graf_scale(xmin, ymin * 1.2, xmax, ymax * 1.2);
calc_scale(xar, 0, 0, 5, 1);              // Fit to "nice-looking" numbers
calc_scale(ear, 1, 0, 20, 1);             // Fit to "nice-looking" numbers
// Axes numeration: HORIZ1 = 1, VERT1 = 2, HORIZ2 = 4, VERT2 = 8
set_axe(HORIZ1, clip.width(), xmin, xmax, -1, NULL, 5, NULL, NULL, 0);
set_axe(VERT1, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);
set_axe(HORIZ2, clip.width(), xmin, xmax, -1, NULL, 5, NULL, NULL, 0);
set_axe(VERT2, clip.height(), ymin, ymax, -1, NULL, 2, NULL, NULL, 0);

show_axes(14, 12, 0, 7, 3, 1, 1 + 2 + 4 + 8);
cross();
setcolor(9); setfillstyle(1, 1);
plot_data(xar, bar, 5, STACKED_BAR_GRAF, 3);
setcolor(11); setfillstyle(1, 6);
plot_data(xar, car, 5, STACKED_BAR_GRAF, 3);
setcolor(10); setfillstyle(1, 12);
plot_data(xar, ear, 5, STACKED_BAR_GRAF, 3);
	 }
//////////////////////////////////////////////////////////////
void gdi_demoWindow::Paint (TDC& dc, bool erase, TRect& rect)
{
	 TWindow::Paint(dc, erase, rect);

	 // INSERT>> Your code here.
	 Demo* demo = new Demo();
	 demo->DC = dc;
	 demo->graf_demo();
	 delete demo;

}


