#if !defined(__gd_dmapp_h)              // Sentry, use file only if it's not already included.
#define __gd_dmapp_h

/*  Project gdi_demo
    
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    gdi_demo.exe Application
    FILE:         gd_dmapp.h
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Class definition for gdi_demoApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "gd_dmapp.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = SDIDecFrame}}
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection = false, TModule *module = 0);
    ~SDIDecFrame ();
};    //{{SDIDecFrame}}


//{{TApplication = gdi_demoApp}}
class gdi_demoApp : public TApplication {
private:

    void SetupSpeedBar (TDecoratedFrame *frame);

public:
    gdi_demoApp ();
    virtual ~gdi_demoApp ();

    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
    void OpenFile (const char *fileName = 0);
//{{gdi_demoAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
//{{gdi_demoAppVIRTUAL_END}}

//{{gdi_demoAppRSP_TBL_BEGIN}}
protected:
    void CmFileNew ();
    void CmFileOpen ();
    void CmHelpAbout ();
//{{gdi_demoAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(gdi_demoApp);
};    //{{gdi_demoApp}}


#endif                                      // __gd_dmapp_h sentry.
