@echo off
c:
REM Main BBS batch file for CITADEL K2NE           
cd\
cls
set jmodem=shutup
cd k2ne
REM next line generates USERLOG.IDX for the Citadel Profiler
clog >userlog.idx
:loop
c:
cd \
cd k2ne
REM next 3 lines control auto setting of time limits if desired
REM code has no effect if files are missing and can be left in 'as is'
if exist 90.sys set b=90
if exist 60.sys set b=60
if exist ?0.sys del ?0.sys
cls
REM next section appends doorstat to doorlog in sysarea directory
cd \k2ne\door
doorstat
copy doorlog.sys+doorstat.sys tempfile.txt >nul
cd \k2ne\system
copy \k2ne\door\tempfile.txt >nul
copy tempfile.txt doorlog.sys >nul
del tempfile.txt
REM and also to the HELParea along with our new SHUTTLE.LOG file
cd \k2ne\helparea
copy \k2ne\door\doorstat.sys doorsums.hlp >nul
REM activate next line if you have SHUTTLE DOOR set up
REM copy \k2ne\door\shuttle\shuttle.log shut-log.hlp >nul
cd \k2ne
REM next line actually calls the bbs program
REM after the 'ctdl' BLANKER=1 to activate screen blanker
REM following 1 minute of inactivity - '1' is 1 min - use your own for more
REM time
ctdl logtry=3 ansi coltb=2,1,4,5,2 +netlog dead=15,2 noluck=3,7 doormin=%dr% %1
REM next 4 lines are different variations on previous line as examples
REM ctdl lock color=31,66 +netlog dead=15,2 noluck=3,7 doormin=%dr% %1
REM ctdl logtry=3 color=31,66 coltb=2,1,4,5,2 +netlog dead=15,2 noluck=3,7 doormin=%dr% %1
REM ctdl logtry=3 ansi coltb=2,1,4,5,2 +netlog dead=15,2 noluck=3,7 %1
REM ctdl ansi coltb=10,9,12,13,2 +netlog dead=15,2 noluck=3,7 doormin=%dr% %1
REM series of ERRLEVELS control what happens when Citadel comes down
REM it is essential to put these in DECREASING ORDER by ERRLEVEL
if ERRORLEVEL 9 goto daystuff
if ERRORLEVEL 8 goto spaceboot
if ERRORLEVEL 7 goto spacewar
if ERRORLEVEL 6 goto timeout
if ERRORLEVEL 4 goto doors
if ERRORLEVEL 3 goto remote
if ERRORLEVEL 2 goto fixit
if ERRORLEVEL 0 goto done

REM example of what you can do on a remote sysop exit command
:remote
Echo Remote Sysop Termination executed.
echo Copying System Files...
cd \
copy \k2ne\ctdltabl.sys
copy \k2ne\system\netlog.sys
goto loop

REM example of a special way of handling doors to reboot your system
REM after a door that gives problems with the modem settings
:spaceboot
cd \
REM killit
if "%1" == "+doors" shift
if "%1" == "+noinit" shift
c:
cd \k2ne
if "%b%"=="90" copy timervar.sys 90.sys
if "%b%"=="60" copy timervar.sys 60.sys
REM next line calls util that does a reboot of the system
boot
REM next line probably not needed but always good to be 'safe'
goto loop

REM this is how to get to doors.  Citadel handles the rest
:doors
c:
cd \k2ne\door
dooropen.bat

:spacewar
REM To be used to go to BINKLEY TERM for FIDOnet
REM Nothing magic about the name 'spacewar.'  It is a carryover from
REM when I used this to do something else.
c:
cd \
REM I have my FIDO stuff on E drive so...
e:
cd \binkley
binkley
REM probably do not need next line but...
goto loop

REM another example of a special 'happening'
:daystuff
goto daysub
c:
cls
echo DAILY List of Historic Happenings UPDATE
cd \today
del daynotes.blb
del dayout.txt
today > daynotes.blb
shrtproc.exe
del daynotes.blb
copy dayout.txt daynotes.blb
cd \k2ne\helparea
copy \today\daynotes.blb logtext.001
cd \
:daysub
Echo Daily Horoscope Generator in progress....
c:
cd \zodiac
zodiac >logtext.003
cd \k2ne\helparea
copy \zodiac\logtext.003 zodiac.hlp
REM activate next line to show horoscope to user at login as logtext.003
REM copy zodiac.hlp logtext.003
del \zodiac\logtext.003
cls
goto skiptwars

REM The next few lines are skipped since I do not run TradeWars any longer
REM but here they are to show you how to handle something like this.
Echo TradeWars-1000 Daily Maintenance in progress....
c:
cd \
cd \k2ne\door\twars
twmaint.exe
REM end of TradeWars Daily Maintenance section

:skiptwars
REM This section handles nightly updating of the FIDO conferences
REM If you are doing this you MUST study your FIDO stuff!
cls
Echo MATRIX Conferences -- Echo Conference Maintenance in progress....
cd \
e:
cd \binkley
REM del binkley.log
Renum -D 15 -N 1 150 -R f:\binkley\BIKES
Renum -D 15 -N 1 100 -R f:\binkley\MESSAGES
Renum -D  5 -N 1 150 -R f:\binkley\JOBS
Renum -D 30 -N 1 450 -R f:\binkley\JOBS-NOW
Renum -D  2 -N 1 150 -R f:\binkley\UFO
Renum -D  5 -N 1 150 -R f:\binkley\UNIX
Renum -D  3 -N 1 250 -R f:\binkley\FOR-SALE
Renum -D  5 -N 1 100 -R f:\binkley\CD_ECHO
Renum -D  5 -N 1 350 -R f:\binkley\HAM
Renum -D 15 -N 1 200 -R f:\binkley\HAMFEST
Renum -D  5 -N 1 100 -R f:\binkley\HDCONF
Renum -D  5 -N 1 100 -R f:\binkley\HDSALE
Renum -D  3 -N 1 250 -R f:\binkley\MUSIC
Renum -D  5 -N 1 100 -R f:\binkley\PACKET
Renum -D  5 -N 1  50 -R f:\binkley\PHYSICS
Renum -D 10 -N 1 100 -R f:\binkley\STOCK
Renum -D 15 -N 1  50 -R f:\binkley\WARNINGS
Renum -D 15 -N 1  50 -R f:\binkley\BAD_MSGS
Renum -D  3 -N 1  50 -R f:\binkley\NJ-NET
Renum -D  3 -N 1  50 -R f:\binkley\NJ-SYS
Renum -D  3 -N 1  50 -R f:\binkley\RBBSBITS
Renum -D  3 -N 1  50 -R f:\binkley\RBBS-DEV
Renum -D  3 -N 1  50 -R f:\binkley\RBBS-SYS
Renum -D  3 -N 1  50 -R f:\binkley\RBBS-SD
Renum -D  5 -N 1 150 -R f:\binkley\CFORSALE
Renum -D  5 -N 1 150 -R f:\binkley\DOORWARE
Renum -D  3 -N 1 200 -R f:\binkley\SWL
Renum -D  2 -N 1  50 -R f:\binkley\ZMODEM
Renum -D  3 -N 1  50 -R f:\binkley\51STATE
Renum -D  3 -N 1 100 -R f:\binkley\SYSOP266
Smlindex.exe
ReplyLnk -F echolist.txt

REM reset the Citadel message and caller counter
c:
cd \k2ne
REM 'ctdlstat.exe' digests the Citadel session/net/message data
REM from the 'param file' amd outputs it to 'reporter.out'.
REM we use sysdata.bak because we run this just before change of date
REM a few minutes before midnight.
ctdlstat sysdata.usr
REM now we stick it on the end of the call-log file
REM so let's move to the directory containing the log file 'calllog.sys'.
cd sys
copy ..\reporter.out
copy calllog.sys+reporter.out tempfile.sys
copy tempfile.sys calllog.sys
del tempfile.sys
del reporter.out
REM now let's back it up with archive
copy archive.log+calllog.bak archive.log
copy calllog.sys calllog.bak
del calllog.sys
REM now let's restart the network log
del netlog.bak
copy netlog.sys netlog.bak
del netlog.sys
REM when we bring citadel back up the logs should restart themselves
cd \k2ne\helparea
REM next line generates user report for login bulletin
copy \k2ne\reporter.out logtext.006
REM next line does running reporter in helpArea directory
copy records.hlp+logtext.006 records.hlp
REM now we are done all this fishiness.
cd \k2ne
del reporter.out
goto loop
REM enable next line to go to BINKLEYTERM from here.
REM goto binkend

:fixit
c:
cd \k2ne
REM now we are in the Citadel 'home' directory
confg n
clog >userlog.idx
REM ctdl lock +recover color=31,66 +archlog +netlog dead=15,2 noluck=3,7 doormin=%dr% %1
ctdl logtry=3 ansi coltb=2,1,4,5,2 +netlog dead=15,2 noluck=3,7 +recover doormin=%dr% %1
REM ctdl logtry=3 ansi coltb=2,1,4,5,2 +netlog dead=15,2 noluck=3,7 +recover %1
REM '+recover' is only there to trigger a crash message in Aide>
if ERRORLEVEL 9 goto daystuff
if ERRORLEVEL 8 goto spaceboot
if ERRORLEVEL 7 goto spacewar
if ERRORLEVEL 6 goto timeout
if ERRORLEVEL 4 goto doors
if ERRORLEVEL 3 goto remote
if ERRORLEVEL 2 goto fixit
if ERRORLEVEL 0 goto done

:timeout
c:
cd \k2ne\system\back
pkzip -a bbs ..\c*.sys
b:
cd \
copy c:bbs.zip
c:
del bbs.zip
cd \
REM next two lines handle flipping online time limits at 2am and 2pm
if "%b%"=="60" goto long
if "%b%"=="90" goto short
:long
set b=90
goto skip
:short
set b=60
:skip
REM now we check to see if we have to process any FIDOnet conferences
e:
cd \binkley\inbound
if exist worktodo.sys goto specialCase
REM if no FIDO stuff to do then back to Citadel we go
cd ..
c:
delay 3
goto loop

:specialCase
REM del worktodo.sys
cd ..
binkley special

:done
cd\
echo off
cls
REM echo Copying System Files...
REM copy \k2ne\ctdltabl.sys
REM copy \k2ne\system\netlog.sys
REM sleep
REM everything shut down...back to console menu
cls
if "%1" == "bink" goto binkend
REM type menu.txt
goto realend

REM following lines return us to Binkley front-end
:binkend
cd \batch
REM killit
e:
cd \binkley
binkley

:realend
type menu.txt
