; Schema for  the Library System

#schema LIBRARY

; Data Elements Dictionary

#dictionary
    BOOK_ID,            I, 5
    BOOK_INFO,          C, 30
    MEMBER_PIC,         H, 100
    MEMBER_ID,          I, 5
    MEMBER_INFO,        C, 30
    LOAN_DATE,          D, 10
#end dictionary


; File Specifications

#file MEMBERS
    MEMBER_PIC,		B
    MEMBER_ID,		B
    MEMBER_INFO,	B
#end file

#file BOOKS
    BOOK_ID,		C
    BOOK_INFO,		B
#end file

#file LOANS
    BOOK_ID,		C
    MEMBER_ID,		B
    LOAN_DATE,		B
#end file


; Index Specifications

#key BOOKS          BOOK_ID
#key MEMBERS        MEMBER_ID
#key LOANS          BOOK_ID, MEMBER_ID
#key LOANS          LOAN_DATE

; Users Specifications
#users
    host1.library.edu,        A
    host2.library.edu,        A
    OTHERS,                   R
#end users
#lifetime                     20

; Max number of records listed
; in the same HTML table

#max-records			3

; Allow the dump of raw data from the data base

#allow-raw-data-dump		|


; Specify the separator to be used between label(s) and
; and input field(s)

;#label-separator        <BR>


; Web Master, Path name, CGI-URL, Help, Background, Header and Footer

#web-master webmaster@swwings.com
; Settings for decibel
;#jdbc-driver-name jdbc:decibel
;#data-source c:\swwings\jWWWData\library
;#jdbc-driver-class ncsa.sql.driver.Driver
;#jdbc-user ignore
;#jdbc-password ignore
;#jdbc-no-col-values
;Settings for MS-Access + Jdbc:Odbc
#jdbc-driver-name jdbc:odbc:
#data-source  Library
#jdbc-driver-class sun.jdbc.odbc.JdbcOdbcDriver
#jdbc-user fred
#jdbc-password Fred123
#schema-path c:\swwings\jWWWData\library
#cgi-url http://webserver.library.edu/cgi-bin/library-cgi.bat
#help /usr/home/swwings/www/jWWWData/jwwwgtw.htm
#background BACKGROUND="http://www.swwings.com/images/backgr.gif"
#header header.txt
#footer footer.txt


#end schema LIBRARY


