/****************************************************************************/
/*   FILE JMODEM.H                                                          */
/*   Created 11-JAN-1990                Richard B. Johnson                  */
/*                                      405 Broughton Drive                 */
/*                                      Beverly, Massachusetts 01915        */
/*                                      BBS (508) 922-3166                  */
/*                                                                          */
/*    This program requires about 67k of free RAM to execute properly.      */
/*    If you have 66k or less, it will execute, but the screens will        */
/*    not be written or replaced properly. If you have only 64k, the        */
/*    program will exit with an error message.                              */
/*                                                                          */
/*    Revision History:                                                     */
/*    V3.00   Beta test                  11-FEB-1990   Richard B. Johnson   */
/*    V3.01   First release              18-FEB-1990   Richard B. Johnson   */
/*    V3.02   Revised                    19-FEB-1990   Richard B. Johnson   */
/*                                                                          */
/*      (1)   A bug in MicroSoft _calloc()  allocates overlapping           */
/*            buffers so data files were getting corrupted. I had           */
/*            used both _calloc() and _malloc() at the same time and        */
/*            they didn't like it. I changed the memory allocation          */
/*            to _malloc() only and it seems to work okay.                  */
/*                                                                          */
/*      (2)   While debugging, I found some structures I didn't need and    */
/*            removed them. Changed some code to accommodate.               */
/*                                                                          */
/*      (3)   Added a file-size during downloads.                           */
/*                                                                          */
/*      (4)   Changed code in the data encoding (compression) routine       */
/*            in an attempt to speed it up.                                 */
/*                                                                          */
/*    V3.03   Revised                   20-FEB-1990  Richard B. Johnson     */
/*                                                                          */
/*      (5)   Fixed bug in compression routine where the loop wasn't        */
/*            terminating properly, adding random characters. Bug was       */
/*            created during V3.02 change.                                  */
/*                                                                          */
/*    V3.04   Revised                   27-FEB-1990  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Modified the block-size routine and the receive-block         */
/*            routine in an attempt to improve the noise immunity.          */
/*            Does not abort even if you whistle into the telephone         */
/*            during uploads and downloads. Waits 5 seconds to clear        */
/*            the interrupt buffer when a bad block-size is received.       */
/*                                                                          */
/*      (2)   Added a 1/2 second wait for modem status when opening         */
/*            channel. This might accommodate slow modems response to       */
/*            RTS.                                                          */
/*                                                                          */
/*    V3.05   Revised                   22-MAR-1990  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Removed _sprintf() runtime library calls to shorten           */
/*            the code. Saved about 4k.                                     */
/*                                                                          */
/*      (2)   Removed extra spaces in the signon-logo to shorten            */
/*            the program size.                                             */
/*                                                                          */
/*      (3)   Changed the method of creating a fixed-length string          */
/*            for both the block size and cps numbers which saved about     */
/*            800 bytes of program size.                                    */
/*                                                                          */
/*      (4)   Changed numerous array indexes in JMODEM_F.C to pointers      */
/*            to reduce code size. Saved a few hundred bytes and should     */
/*            improve speed of screen output.                               */
/*                                                                          */
/*      (5)   Created a local _puts() routine which saved over 6k from the  */
/*            MicroSoft C runtime library version. (JMODEM_F.C)             */
/*                                                                          */
/*    V3.06   Revised                   07-APR-1990  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Put the filename text into the syst structure as a pointer    */
/*            to char. This allowed me to save 56 bytes of code and now     */
/*            only two parameters are passed to the _screen() function.     */
/*                                                                          */
/*      (2)   Modified the syst structure and supporting code.              */
/*                                                                          */
/*      (3)   Moved all external data and functions to the JMODEM.H file.   */
/*                                                                          */
/*      (4)   Moved _disp() "usage" module to JMODEM_F.C                    */
/*                                                                          */
/*      (5)   Changed arrays in JMODEM_B.C to pointers to reduce code-      */
/*            size. Eliminated _strcpy() from the command-line parsing      */
/*            routines. Brought the code-size to less than 12,000 bytes.    */
/*                                                                          */
/*      (6)   Reduced the code-size in the _encode(), _decode(), and        */
/*            _crc() routines in JMODEM_D.C. Removed shifts to improve      */
/*            speed and replaced the shifts with pointers for altering      */
/*            portions of the strings.                                      */
/*                                                                          */
/*      (7)   Made a _cancel() routine in JMODEM_A.C to send ^Xes upon      */
/*            abort.                                                        */
/*                                                                          */
/*      (8)   Removed the bit being set "OUT 1" via the modem-control       */
/*            register in the "open" routine in JMODEM_E.C. This was        */
/*            causing some internal modems to lock up as they use this      */
/*            bit for something. "OUT 2" is used to enable IRQ on most      */
/*            clone RS-232 boards and modems. The Heathkit HZ-100 boards    */
/*            will probably not work anymore because they use "OUT 1".      */
/*                                                                          */
/*    V3.07   Revised                   03-MAY-1990  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Rewrote code to remove the requirement for a file buffer.     */
/*            This means that this buffer does not need to be allocated,    */
/*            saving about 8k of RAM at run-time.  ( JMODEM_A.C )           */
/*                                                                          */
/*            Program now only requires 52k of free RAM to execute okay.    */
/*                                                                          */
/*      (2)   Changed the header file, JMODEM.H, and function calling       */
/*            procedures to file_io() and screen() to allow variable-       */
/*            length parameter-lists. This eliminates the requirement       */
/*            to pass a NULL as a place-holder on procedures that don't     */
/*            always require all possible parameters to be passed. This     */
/*            saved about 50 bytes of code.                                 */
/*                                                                          */
/*      (3)   Changed the "Usage" prompt and code to reduce program size.   */
/*            Saved about 60 bytes.                                         */
/*                                                                          */
/*      (4)   Changed keyboard break interrupt in JMODEM_E.C so it sets     */
/*            the global timer to zero as well as setting the abort flag.   */
/*                                                                          */
/*    V3.08   Revised                   01-DEC-1990  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Changed the code to compile without warning errors when       */
/*            using Microsoft Version 6.0. They saw fit to change the       */
/*            ANSI standards for declaring objects passed to functions.     */
/*            The new "standards" were called to my attention by            */
/*            Jeff Jevnisek who provided modified source.                   */
/*                                                                          */
/*      (2)   Changed the method of determining a memory allocation         */
/*            failure. The code used to check for a NULL pointer returned   */
/*            from _malloc() if memory was not available. Microsoft does    */
/*            not allow NULL to be used for that anymore! Instead I have    */
/*            to either use a cast or check for (!ptr). I chose the latter. */
/*                                                                          */
/*    V3.09   Revised                   27-JUN-1991  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Changed a typo in the previous revision record that showed    */
/*            the date to be 01-DEC-1991 when it should be 01-DEC-1990      */
/*                                                                          */
/*      (2)   Changed the method of checking the interrupt buffer pointer   */
/*            in JMODEM_E.C so that only one compare and no arithmetic      */
/*            has to be done. JMODEM now works at 38,400 baud with a        */
/*            33 MHz '386 machine.                                          */
/*                                                                          */
/*      (3)   Added support for using any communications port address       */
/*            and IRQ.                                                      */
/*                                                                          */
/*            JMODEM R(3F8:4) filename.typ                                  */
/*            JMODEM R(2F8:3) filename.typ                                  */
/*            JMODEM S(3F8:4) filename.typ                                  */
/*            JMODEM S(2F8:3) filename.typ                                  */
/*            JMODEM S(20E:7) filename.typ  ... etc.                        */
/*                                                                          */
/*    V3.10   Revised                   19-NOV-1991  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Changed the memory allocation method. Used to allocate 4      */
/*            buffers with 4 calls to _malloc(). Now I allocate one large   */
/*            block and cut it up into 4 pieces. This is more efficient.    */
/*                                                                          */
/*      (2)   Called _malloc() directly without a separate allocate_mem()   */
/*            routine because machine differences can be handled with       */
/*            definitions for different compilers and platforms.            */
/*                                                                          */
/*      (3)   Moved the receive and timer interrupt service routines to     */
/*            assembly-language modules in JMODEM_G.ASM                     */
/*                                                                          */
/*    V3.11   Revised                   25-JAN-1992  Richard B. Johnson     */
/*                                                                          */
/*      (1)   Added variable "tries" to force a timeout should the user     */
/*            attempt to receive from a disconnected RS-232C line. This     */
/*            will time-out in about a minute.                              */
/*                                                                          */
/****************************************************************************/
/*                  Parameters that are specific to JMODEM                  */
/****************************************************************************/
#define VERS            "Version 3.11"      /* Version number               */
#define _8K             0x2000              /* 8192 bytes                   */
#define BLK_SIZ         0x200               /* Starting block size          */
#define OVRHD           0x06                /* Private, JMODEM overhead     */
#define DAT_LEN         (_8K + 0x400)       /* Data buffer length           */
#define DAT_MAX         _8K                 /* Max block length             */
#define ALC_MEM		(DAT_LEN * 4)       /* Four buffers to allocate     */
#define OPEN_READ       0x01                /* Private OPEN file function   */
#define CREATE          0x02                /* Private CREATE file function */
#define WRITE           0x03                /* Private WRITE file function  */
#define CLOSE           0x04                /* Private CLOSE file function  */
#define DELETE          0x05                /* Private DELETE file function */
#define READ            0x06                /* Private READ file function   */
#define GET_CRC         0x00                /* Private Get CRC function     */
#define SET_CRC         0x01                /* Private Set CRC function     */
#define NORM            0x01                /* Private, show normal data    */
#define COMP            0x02                /* Private, show compressed     */
#define EOF_            0x04                /* Private, show end of file    */
#define TIMOUT          0x5A                /* Timeout (ticks) for read     */
#define TRIES           0x10                /* Number of tries to sync      */
#define EOT             0x04                /* "D" - 64                     */
#define ACK             0x06                /* "F" - 64                     */
#define NAK             0x15                /* "U" - 64                     */
#define SYN             0x16                /* "V" - 64                     */
#define CAN             0x18                /* "X" - 64                     */
#define SCR_SGN         0x01                /* Signon screen                */
#define SCR_BOX         0x02                /* Write box on the screen      */
#define SCR_TXT         0x03                /* Write text to x/y address    */
#define SCR_STA         0x04                /* Write status box             */
#define SCR_FIL         0x05                /* Write open file box          */
#define SCR_FOK         0x06                /* File open okay               */
#define SCR_FNF         0x07                /* File not found               */
#define SCR_FCR         0x08                /* Can't create the file        */
#define SCR_FRN         0x09                /* Renamed the file             */
#define SCR_SYS         0x0A                /* Show system parameters       */
#define SCR_SYT         0x0B                /* Show trans synchronization   */
#define SCR_SYR         0x0C                /* Show Receive synchronization */
#define SCR_FLG         0x0D                /* Show status flag             */
#define SCR_END         0x0E                /* Exit all screens             */
#define JM_NRM          0x00                /* Normal exit                  */
#define JM_FNF          0x01                /* File not found               */
#define JM_REN          0x02                /* Can't rename the file        */
#define JM_CRE          0x03                /* Can't create the file        */
#define JM_MEM          0x04                /* No memory available          */
#define JM_CAR          0x05                /* Modem carrier failed         */
#define JM_SYN          0x06                /* Can't synchronize            */
#define JM_ABT          0x07                /* Aborted                      */
#define JM_CMD          0x08                /* Command-line error           */
#define JM_TIM          0x09                /* Time-out                     */
#define JM_FAT          0x0A                /* Fatal error                  */
#define JM_MAX          0xFFFF              /* Maximum buffer space exceeded*/
#define byte unsigned char                  /* Make code readable           */
#define word unsigned short int             /* Make code readable           */
#define ulong unsigned long int             /* Make code readable           */
/****************************************************************************/
/*                     Structures and templates                             */
/****************************************************************************/
typedef struct
        {                                   /* Structure for JMODEM status  */
        word  s_blk;                        /* Block being sent / received  */
        word  s_len;                        /* Length of the block          */
        ulong s_byt;                        /* Bytes so far                 */
        word  s_cps;                        /* Speed, characters / second   */
        byte  *s_sta;                       /* Pointer to current status    */
        byte  *s_txt;                       /* Pointer to information text  */
        } SYS;

typedef struct                             /* JMODEM block header structure */
        {
        word len;                          /* Block length                  */
        byte blk_typ;                      /* Kind of block EOF, COMP, etc  */
        byte blk_num;                      /* Block number (starts at 1 )   */
        byte blk_dat;                      /* First data character          */
        } JBUF;

/****************************************************************************/
/*                   External function prototypes                           */
/****************************************************************************/
#ifdef SCREEN
    extern void screen(short, SYS *);       /* Function (in SCREEN.H)       */
#else
    extern void screen(short,...);          /* Show variable length list    */
#endif

extern word open_chan(                      /* Open communications channel  */
                word);                      /* Communications port number   */
extern word close_chan(                     /* Close communications channel */
                word);                      /* Communications port number   */
extern word read_chan(                      /* Read communications channel  */
                word,                       /* Bytes to read                */
                byte *);                    /* Pointer to the buffer        */
extern word write_chan(                     /* Write communications channel */
                word,                       /* Bytes to write (send)        */
                byte *);                    /* Pointer to the buffer        */
extern word send_blk(                       /* Send JMODEM block            */
                word,                       /* Block length                 */
                SYS *,                      /* Pointer to status structure  */
                byte *);                    /* Pointer to the data buffer   */
extern word recv_blk(                       /* Receive JMODEM block         */
                word *,                     /* Pointer to the block length  */
                byte *);                    /* Pointer to the data buffer   */
extern word encode(                         /* Compress the data            */
                word,                       /* Length of the input data     */
                byte *,                     /* Pointer to the input buffer  */
                byte *);                    /* Pointer to the output buffer */
extern word decode(                         /* Expand compressed data       */
                word,                       /* Data length                  */
                byte *,                     /* Pointer to the input buffer  */
                byte *);                    /* Pointer to the output buffer */
extern word calc_crc(                       /* Calculate CRC                */
                word,                       /* Function, GET or SET         */
                word,                       /* Length of the data buffer    */
                byte *);                    /* Pointer to the data buffer   */

#ifdef FILE_IO
    extern word file_io(                    /* File I/O                     */
                word,                       /* Function code                */
                short *,                    /* Pointer to the file handle   */
                byte *,                     /* Pointer to the buffer        */
                word);                      /* Data buffer length           */
#else
    extern word file_io(                    /* File I/O                     */
                word,                       /* Function code                */
                short *,...);               /* Variable length param list   */
#endif

extern byte *get_inp(                       /* Get input file-name          */
                word,                       /* Number of arguments          */
                char *[]);                  /* Pointer to list of pointers  */
extern byte get_fun(                        /* Get function (S or R)        */
                word,                       /* Number of arguments          */
                char *[]);                  /* Pointer to command strings   */
extern word get_port(                       /* Get port (1 - 4)             */
                word,                       /* Number of arguments          */
                char *[]);                  /* Pointer to command strings   */
extern void disp(void);                     /* Display 'usage' message      */
extern void flush (void);                   /* Flush the interrupt buffer   */
extern void cancel(void);                   /* Send ^Xes to cancel transfer */
extern word tx_sync(void);                  /* Synchronize during transmit  */
extern word rx_sync(void);                  /* Synchronize during receive   */
/****************************************************************************/
/*                   Global variables and structures                        */
/****************************************************************************/
extern byte *int_buffer;                    /* pointer to interrupt buffer  */
extern word user_abort;                     /* User abort flag              */
extern word port;                           /* Port number                  */
extern word timer;                          /* Global timer                 */
extern byte abrt[];                         /* Six messages in JMODEM_F.C   */
extern byte okay[];
extern byte retry[];
extern byte done[];
extern byte flow[];
extern byte malfail[];
extern SYS syst;                            /* Structure in JMODEM_A.C      */
/****************************************************************************/
/*                         Preprocessor directives                          */
/****************************************************************************/
#pragma intrinsic (inp, outp)               /* Generate in-line code here   */
#pragma intrinsic (_disable, _enable)
#pragma intrinsic (memcpy, _rotl)
#pragma check_stack(off)                   /* No checking between functions */
/****************************************************************************/
/*********************** E N D  OF  M O D U L E *****************************/
