# Demonstration script for JACOsub video titling software.

# You might want to print out a hard copy of this script, and refer to it
# while you play the script in Step Mode.

# This script demonstrates the flexibility of the JACOsub file format,
# going through nearly all of the features available.  Don't be alarmed
# by the size; this script consists mostly of comments.  The running time
# is less than 90 seconds.

# Now let's begin.  All the directives and commands demonstrated in this
# script are shown in UPPERCASE the first time they are used, and in
# lowercase thereafter.

  # First, let's set up some defaults.  Time units default to SMPTE
  # (1/30 second) units.  We'll use 1/100 seconds because it's simpler to
  # understand for now.

#TIMERES 100

  # Note: All # commands may be specified by a single letter.  For example,
  # above we could have used #T instead of #TIMERES.

  # Next, suppose this script consisted of subtitles played against a
  # foreign film, and we noticed that the time events were drifting so that
  # by the end of the script, the subtitles were occurring 2.2 seconds too
  # soon.  This means we need to stretch the script's total running time
  # by 2.2 seconds to correct the drift.  The #Ramp command does this.  The
  # number past the decimal point is time units (in 1/100 seconds as
  # specified by the #T command above), not fractions of a second.  The
  # ramp correction may be positive or negative, and you can adjust it on
  # the fly, while the script is playing.

#RAMP 2.20

  # Set font 3 for using near the end of this script, where we demonstrate
  # outlining and shadowing of mono-color fonts.  JACOsub.font 18 is a
  # mono-color mono-spaced font.  (This font is the one normally used for
  # displaying JACOsub's running clock.)

#FONT 3 JACOsub.font 18

  # Let's change some default colors while we're at it....

#P1  0 14 14     (set "slow text" color 1 of primary palette to cyan)
#p3  d  0  0  1  (set color 3 of palette 1 to red, using hex notation)

  # Now we will start with the list of timed lines.  Each timed line has
  # the format
  # <start time> <stop time> <directive> <text>

  # Let's load in a graphic file to serve as a backdrop for the first few
  # titles, for the first 9 seconds.  We use the RLB directive for this
  # (meaning "aRgument directive, Load Background graphic").

0:00:00.00 0:00.09.00 RLB JACO.bbm 0 0 {0 0 centers logo on the screen}

  # Now, show an introductory title centered on the screen for 4 seconds.
  # This title demonstrates the newline escape character, or manual
  # wordwrap.  The new substrings created will also be word-wrapped
  # automatically if they don't fit within the default width limits.
  # You can also turn a title's wordwrapping off, with the W0 directive.

  # Notice also that the concatenation escape code (the \ at the end of
  # each line) is NOT the same as a newline in your text.  The ending \
  # character means, "assume that the next line continues where this line
  # leaves off."  It works even if you split a word into two pieces, as
  # shown below with the word "capabilities."
  # Concatenation ignores all space after the \ and all space before the
  # first non-space character on the line following the \.

0:00:00.00 0:00:04.00 VM JACOsub\n\nThis script demonstrates \
                         some of the capa\
                         bilities of JACOsub.

  # The next 3 lines demonstrate vertical positioning and overlapping time
  # ranges.  Notice how the times for each of the lines are set.  All three
  # lines are present on the screen only between times 6.00 and 6.50.

0:00:04.00 0:00:06.50 VT Text may be positioned at the top,
0:00:05.00 0:00:07.10 vm middle,
0:00:06.00 0:00:07.70 VB or bottom of the screen.

  # The next title shows how you can insert comments inside the text.
  # This is useful for making notes about translations and character names
  # when subtitling foreign films.  Here we also demonstrate how Italics
  # (\I) and Normal (\N) escape codes can be embedded in the title text.

0:00:08.00 0:00:11.00 vm {this is a comment} (And, you just saw, {another \
                         comment} timing ranges for different lines of \
                         text \Iand\N graphics may overlap.)

  # Here we demonstrate that graphics time ranges can overlap text time
  # ranges.

0:00:9.00 0:00:12.60 rlb JACO.bbm 25 25   {place logo at lower right}

  # Now we demonstrate left/right/center justification.

0:00:11.00 0:00:13.50 JL Within margin constraints\n\
                         that you set, text may be\nleft justified,
0:00:13.50 0:00:14.75 JC {the JC is redundant - it's the default}\
                         center\njustified,
0:00:14.75 0:00:16.00 JR and also\nright justified.

  # Here we show what you can do with margin settings.  The first line
  # sets the right margin to 33% of the screen (left margin is at 1%), and
  # the second line sets the left margin at 40% of the screen (right
  # margin is at 99%).  We also demonstrate two fonts on the same screen,
  # and full justification using the JF:L directive.

0:00:15.60 0:00:22.00 vtHR33   It's possible, for example, to set margins \
               so that text is confined to the left 1/3 of the screen.
0:00:17.50 0:00:22.00 vbHL40F1JF:L And you can place other text elsewhere \
         (with a different font, if desired) by setting different \
         margins for it.  As you can see here, the left and right edges \
         of a text block can be aligned automatically, also.

  # Now we demonstrate different text styles and colors.  Notice here we
  # use the VL directive to position the text on different lines.  The
  # position of the "line number" after the VL depends on font height.

0:00:22.30 0:00:27.80 VL3 Text may appear in different styles\n(Normal, \
                          \BBold\N, \IItalic\N)
0:00:22.30 0:00:27.80 vl5 and different \C1colors
                      # Notice here the default text color has been
                      # changed to 1 and restored to 3 inside the text.
0:00:24.00 0:00:27.80 CF1vl7 all \B\I\C3mixed\b \C1together\N.

  # On the same screen, demonstrate loading in a different color palette
  # so that another color appears (color 3=red as defined in Palette 1).

0:00:25.00 0:00:27.80 CP1vl8 (even with different palettes.)

  # Before this screen disappears, let's demonstrate the palette fade
  # effect using a dummy blank titles.  The next title will fade the
  # current palette (1 from the previous title) to 0 in 60 video fields
  # (about 1 second on NTSC displays).

0:00:25.50 0:00:27.80 EP0:60  {fade back to palette 0} ~

  # Demonstrate the JF:U directive (Unconditional Full Justification)
  # by displaying some examples of movie credits.  The credits are
  # written to be approximately the right length, and the JF:U directive
  # does the rest of the work, adjusting the spaces so the left and
  # right edges are flush with the current margins.
  # Note also that the VM directive would normally center the block of
  # credits on the screen, but here we use VM1 to shift the centered
  # block down 1 line.

0:00:27.80 0:00:32.00 vtcf1 {description} ``Unconditional'' justification is useful for credits:
0:00:27.80 0:00:32.00 vm1f1JF:U {show credits in various styles}\
      Clint Eastwood . . . . . . . Dirty Harry\n\
      Michael J. Fox . . . . . . Clint Eastwood\n\n\
      Madonna - - - - - - - - - - - Herself\n\
      Eddie Murphy - - - - - - - - Axel Foley\n\n\
      George Lucas -------------------- Director

  # Here's a trick.  We will rapidly cycle through some blank screens
  # so that the current display will "catch up" to the background display
  # buffer being generated.  We use color 1 text here, which is slow.
  # The title directive doesn't matter for these rapid blanks, so we
  # will use the program default (D) here.  The default typically
  # positions a title at the bottom center of the display, using margins
  # at the left and right edges (1% and 99%), auto-wordwrap, font 0,
  # color 3, etc.  You may change the default behavior with the #D or
  # #D0 command.

0:00:32.00 0:00:32.02 D ~
0:00:32.02 0:00:32.04 d ~
0:00:32.04 0:00:32.06 d ~
0:00:32.06 0:00:32.08 d ~

  # But before we show catching up to the generating buffer, just for
  # fun, let's define directive D2 as CF1VM to use in the next line, for
  # "Color Fontface 1, Vertical position Middle."  We'll also name this
  # default directive to middle_altcolor.  This way, we can use either
  # designation D2 or [middle_altcolor] in the title's directive string.

#D2 CF1VM middle_altcolor

0:00:32.10 0:00:36.00 [middle_altcolor] Here the display was \
         intentionally ``caught up'' to the background generation, \
         to show how slowly color 1 text is generated in the background.

  # In the next title, lots of things happen at once.  We demonstrate
  # Three things: block justification with word justification, the vertical
  # continuation directive, and background shading.

  # The first title after this comment demonstrates the JB (Justify Block)
  # directive.  Text is left-justified, but it is not positioned flush with
  # the left margin - the block of text is centered on the screen (JBC) but
  # the first character of each line are flush left.  In other words, the
  # JL means "left justify" but JBC means "center the block of text."

  # The next title demonstrates the VU directive to show how you can
  # continue a long line of text underneath previous ones.
  # Here we also demonstrates background shading -- a semi-transparent
  # rectangle will appear behind the text, 8 pixels larger than the text
  # all around, using the directive CS8.

0:00:36.30 0:00:45.00 [middle_altcolor]jlJBC \
   You will see that sort of foreground generation if you use a lot of \
   ``slow'' color 1 text.\n\C3(Color 3 text is very fast.)
0:00:36.30 0:00:45.00 VUcf1CS8 \n\n\Plan your timings so the display won't catch up to the view being generated in the background.

  # Demonstrate backgrounds that are opaque to the genlock, by specifying
  # a background color.  This will clear the whole screen to that color
  # before any text is drawn on it, and before any IFF files are overlaid
  # onto it.

0:00:45.00 0:00:51.00 CB1vm You can change the screen background color, too.\
\n\nThis is useful if you want to make an opaque screen when using a genlock.

  # Now we demonstrate some of the transition effects.  We will use
  # the VU directive to stack the lines so that they are all treated
  # as a single block having the VM directive of the first line.

0:00:51.00 0:01:00.00 EIO10vm {iris open} A variety of transition effects
0:00:51.80 0:01:00.00 EWLvu   {wipe left} includes wipes in any direction
0:00:52.60 0:01:00.00 ED32vu  {dissolve} pseudo-dissolves,
0:00:56.00 0:01:00.00 ERD4vu  {medium roll down} and scrolling effects.

  # Demonstrate the #Include command.
  # The VH (vertical height) and CSL (background shade line) directives
  # are demonstrated in the #included script.

#I 0:01:00.00 idemo  # include another script, offset by 60 seconds

  # Outlining and shadowing.  The first and second lines show outlining
  # a mono-color font.  The third line demonstrates font shadow generation.
  # The shadow extends to the southwest (lower left).  The fourth line
  # demonstrates both outlining and shadowing (to the southeast).  We use
  # font 3 for all these four lines (font 3 was set to JACOsub.font 18 in
  # the beginning of this script).

0:01:08.00 0:01:15.00 FO2f3vm JACOsub can also generate outlines of any thickness around normal mono-colored fonts,
0:01:08.00 0:01:15.00 fo3f3vu as you can see here.
0:01:08.00 0:01:15.00 FSSW4f3vu    \nAlso, dropshadows in any of 8 directions are possible,
0:01:08.00 0:01:15.00 fsSE3fo2f3vu \nand outlines and shadows may be combined.

  # Demonstrate clock pausing.  This is useful for creating
  # a single script to handle multiple sides of a laserdisc.

  # At the same time, we'll decorate the screen with some colored
  # rectangles.  We'll do the rectangles first, so the text will appear
  # on top of them.  The rectangles themselves overlap, so the order in
  # which we specify them is also important.

0:01:15.00 0:01:16.00 cf1RDB 20 20 80 80 {big color 1 rectangle}
0:01:15.00 0:01:16.00 cf2rdb 25 25 75 75 {medium color 2 rectangle}
0:01:15.00 0:01:16.00 cf3rdb 30 30 70 70 {small color 3 rectangle}
0:01:15.00 0:01:16.00 cf0rdb 35 35 65 65 {smaller color 0 rectangle}
0:01:15.00 0:01:16.00 vm Right now the clock is paused (you can see this \
                         if you play the script using the clock display).\n
0:01:15.00 0:01:16.00 vuf1cf1 Press any key to continue playing, or ESC to abort.
#CLOCKPAUSE 0:01:15.00

  # Show the last screen.  We'll use the alternate frame-count format for
  # the start and stop times.  For this script, there are 100 counts per
  # second.  Normally this format would be used when the time resolution
  # is 30 per second (which would have been the default if #T100 wasn't
  # specified at the beginning of the script).
  # The times below correspond to 0:01:16.00 and 0:01:21.00.

  # One last vertical directive to demonstrate: VA.  This is the opposite
  # of VU.  It causes a title to appear immediately Above the previous
  # title.  In the case below, the second title will appear above the
  # first.  The same effect can be achieved by reversing the order of the
  # lines, and using VM for the first directive and VU for the second.

@0007600 @0008100 vm \n\nAt that time, you may press any key to return to the Editor.
@0007600 @0008100 VA OK, this script will be finished when the screen goes blank.

# You probably noticed that most of the lines above used the VM (Vertical
# Middle) directive.  We could have made this the default, by specifying
# the global command #DVM near the beginning of the file.  Then we
# wouldn't have had to specify VM on each line, but we would have had to
# specify VB (the former default) for those lines positioned at the bottom
# of the screen.

# One last note:  If you encounter a problem in the way JACOsub behaves,
# see if you can duplicate the problem in this demo script, and send me
# a report (matulich_a@seaa.navsea.navy.mil).  I use the demo script for
# debugging purposes, because it does nearly everything JACOsub can do.
