/* IRC setup procedure 

This can be run separately, or is automatically called by irc.cmd
if irc2.ini doesn't exist.

Copyright 1994-95 V. Phaniraj -- phaniraj@badlands.nodak.edu

*/

This_ircsetup_version ='2.0'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs' 
call SysLoadFuncs                                         

esc='1B'x
'@ansi on > nul'
say esc'[37;40;1m'

Call SysCls


  irc_location=SysSearchPath('PATH','irc.cmd')
  x=pos('irc.cmd',irc_location)
  irc_inifile=substr(irc_location,1,x-1)'irc2.ini'

  rc = SysFileSearch('DEVICE',irc_inifile,'file')
  if rc = 0 then do
      rc=SysIni(irc_inifile,'irc/2','ALL:','names')
       do i = 1 to names.0
         val=SysIni(irc_inifile,'irc/2',names.i)
         interpret names.i '= val'
       end
  end


if Def_Nick = "DEF_NICK" then do 
 Answer=''
   Do While Answer = ''
     Say 'Enter the nickname you will use on irc'
     Parse Pull Answer .

     Answer = STRIP(Answer)
   End
 IrcNick=Answer
 end
else do
   Say 'Enter the nickname you will use on irc, default is' Def_Nick
   Parse Pull Answer .

   Answer = STRIP(Answer)
   if Answer <> '' then IrcNick=Answer
                   else IrcNick=Def_Nick
end

if Def_User = "DEF_USER" then do 
 Answer=''
  Do While Answer = ''
   Say 'Enter the username you will use on irc'
   Parse Pull Answer .

   Answer = STRIP(Answer)
  End
  User=Answer
 end
else do
   Say 'Enter the username you will use on irc, default is' Def_User
   Parse Pull Answer .

   Answer = STRIP(Answer)
   if Answer <> '' then User=Answer
                   else User=Def_User
end

if Def_Home="DEF_HOME" then Home=directory()
                       else Home=Def_Home
  Say 'Enter the home directory for irc/2 ( default is' Home ')'
  Parse Pull Answer .

Answer = STRIP(Answer)
if Answer <> '' then Home=Answer
IrcLib=Home
Path='.;'Home';'Home'\irc;'Irclib';'irclib'\script'

if Def_Name="DEF_NAME" then IrcName = 'User of IRC/2'
                       else IrcName = Def_Name
  Say 'Enter the IRC Name for irc/2 ( default is' IrcName ' )'
  Parse Pull Answer

Answer = STRIP(Answer)
if Answer <> '' then IrcName=Answer

if Def_parms='DEF_PARMS' then Def_Parms='no startup parameters'
if Def_parms=' ' then Def_Parms='no startup parameters'

Say 'Enter startup parameters for irc/2 ( for example -c #os/2 automatically'
Say 'joins the os/2 channel. Default is' Def_Parms
Parse Pull New_Parms

if New_Parms = '' & Def_Parms='no startup parameters'
           then Def_Parms=' '

else if New_Parms = '' & Def_Parms<>'no startup parameters'
           then Def_Parms=Def_Parms

else if New_Parms <>'' then Def_Parms=New_parms

if IRC2_LINES='IRC2_LINES' then IRC2_LINES=25
Say 'Enter the number of lines IRC/2 should use [' IRC2_LINES 'default]'
Parse Pull Answer .

Answer = STRIP(Answer)
if Answer <> '' then  IRC2_LINES=Answer

if IRC2_COLUMNS='IRC2_COLUMNS' then IRC2_COLUMNS=80

Say 'Enter the number of columns IRC/2 should use [' IRC2_COLUMNS 'default]'
Parse Pull Answer .

Answer = STRIP(Answer)
if Answer <> '' then  IRC2_COLUMNS=Answer

if IRC2_FSCREEN='IRC2_FSCREEN' then IRC2_FSCREEN='n'
Say 'Should IRC/2 run in Full Screen mode [y/n] ?, default is' IRC2_FSCREEN
Parse Pull Answer .

Answer = STRIP(Answer)
if Answer ='y' | Answer = 'Y' Then IRC2_FSCREEN='y'

colors.1='Default, grey text on black background, with red underline'
Scheme.1 = '07,0F,70,74,7C,47,07'
colors.2='White text on a dark blue background, with grey underline'
Scheme.2 = '1F,0F,70,74,7C,47,1E'
colors.3='Cyan text on blue background, red underline, yellow on blue nicks'
Scheme.3 = '13,1B,31,74,7C,47,1E'
colors.4='Yellow text on cyan background, red underline, white on green nicks'
Scheme.4 = '3E,3F,63,74,7C,47,5F'
colors.5='Grey text on black background, yellow on black nicknames'
Scheme.5 = '07,0F,70,0C,05,03,0E'
colors.6='Green text on brown background, light green on blue nicknames'
Scheme.6 = '65,0F,70,74,7C,47,1D'
colors.7='Blue text on grey background, red nicknames'
Scheme.7 = '71,7F,17,74,7C,79,7C'
colors.8='Configure Color Scheme Manually'
Scheme.8 = Def_Colour
colors.0=8


   j = 1
   Call SysCls
   do j = 1 to colors.0 
     tempstr='('j')' Left(Strip(Right(colors.j,79)),63)
     say tempstr
   end

if DEF_COLOUR <>'DEF_COLOUR' then Old_Colour=Def_Colour

if DEF_COLOUR='DEF_COLOUR' then DEF_COLOUR=1
 else
   do
   do i = 1 to colors.0
     if Scheme.i = Def_Colour then DEF_COLOUR=i
   end
   end


   Say 'Enter your choice of color scheme, default is Number' Def_COLOUR
   Parse Pull Answer .

   Answer = STRIP(Answer)
   if Answer <> '' then IRCCOLOUR=Scheme.Answer
                   else IRCCOLOUR=Scheme.Def_COLOUR
   if Answer = '' then Answer=Def_Colour
   CAnswer=Answer

if Answer = 8 Then
Do
Say ' normal text ,bold text ,inverse text ,underlined text '
Say ' bold underlined text, inverse underlined text , and nickname'

choices.1='Normal Text'
choices.2='Bold Text'
choices.3='Inverse Text'
choices.4='Underlined Text'
choices.5='Bold Underlined Text'
choices.6='Inverse Underlined Text'
choices.7='Nickname'
choices.0=7

 rc=Say_Colors()
 rc=SysSleep(4)
 Def_Colour = Old_Colour
 If Def_Colour='OLD_COLOUR' Then Def_Colour='07,0F,70,74,7C,47,07'
 parse var def_colour colour.1 ',' colour.2 ',' colour.3 ',' colour.4 ',' colour.5 ',' colour.6 ',' colour.7 
   
 Do j = 1 to choices.0
  Call SysCls
  rc=Colour_choices()
  Say 'Enter the color for ' choices.j ', default is ' colour.j
   Parse Pull Answer .
   if Answer <> '' then colour.j=Answer
 End
 Canswer=8
 Scheme.Canswer = colour.1','colour.2','colour.3','colour.4','colour.5','colour.6','colour.7 
End

server.1='irc.colorado.edu:6667'
server.2='alfred1.u.washington.edu'
server.3='poe.acc.virginia.edu' 
server.4='irc.colorado.edu:6666'
server.5='irc-2.mit.edu:6665'
server.6='csz.bu.edu'
server.7='omega.tamu.edu'    
server.8='irc.math.ufl.edu' 
server.9='irc.texas.net' 
server.10='irc.uiuc.edu'
server.11='copper.ucs.indiana.edu:6667'
server.12='irc.math.byu.edu:6667'
server.13='dewey.cc.utexas.edu'
server.14='irc.escape.com'
server.15='irc.funet.fi'
server.16='jello.qabc.uq.oz.au'
server.17='irc.informatik.rwth-aachen.de'
server.18='noc.belwue.de'
server.19='cuisund.unige.ch'
server.20='biscuit.mmws.astem.or.jp'
server.21='irc.cs.hut.fi'
server.22='irc.nada.kth.se'
server.23='irc.interactive.net'
server.24='Select another server'
server.0=24


nserv=server.0
if DEF_SERVER='DEF_SERVER' then DEF_SERVER=1
 else
   do
   servf=0
   do i = 1 to server.0
     if Server.i = Def_Server then do
         DEF_Server=i
         servf=1
   end
   end
   end

if servf=0 then servf=server.0
            else servf=def_server
say servf
   init_row = (servf-1)%2
   init_col = ((servf-1)// 2)*39

   i = 1	
   j = 1
   Call SysCls
   do j = 1 to server.0 by 2
     k = j + 1
     tempstr='('j')' Left(Strip(Right(server.j,79)),33)
if k <= server.0 & j <=10 then tempstr='('j')' Left(Strip(Right(server.j,79)),33) '('k')' Left(Strip(Right(server.k,79)),33)
if k <= server.0 & j > 10 then tempstr='('j')' Left(Strip(Right(server.j,79)),32) '('k')' Left(Strip(Right(server.k,79)),33)
     say tempstr
   end
say ' '
say 'Move the cursor to the desired server and hit return'

/*   pos = SysCurPos(0,0) */
   pos = SysCurPos(init_row,init_col)
   rowmax=(server.0+1)/2 -1

    Do Forever
	inkey = 0
	parse value SysCurPos() with row col
	Do While inkey=224 | inkey=0      /* Throw away modIfier key */
	    Parse Value SysGetKey('NOECHO') With key
	    inkey = c2d(key)
	End
	select
	    When inkey=72 | inkey=75 | inkey=77 | inkey =80 |inkey =9
		Then Do
			If inkey = 72 then row = row - 1
			If inkey = 75 then col = col - 39
			If inkey = 77 then col = col + 39
			If inkey = 80 then row = row + 1
			If inkey = 9  then col = col + 39
			if row < 0 then row = 0
			if row > rowmax then row = 0
			if col < 0 then col = 40
			if col > 50 then col = 0
			pos=sysCurPos(row,col)
		End
	    When inkey=13                          /* CR */
		Then
		Do
		    found=1
		    pos=syscurpos(row,col)
		    i = row*2 + 1
		    if col > 10 then i = i + 1
		    Leave
		End
               Otherwise
	End
End

Answer=i


If Answer = Server.0 then do
pos=SysCurPos(row+3,0)

if def_server='1' Then
 Do
 Answer=''
   Do While Answer = ''
    Say 'Enter the name of the server'
    Parse Pull Answer .

    Answer = STRIP(Answer)
   End
 IrcServer=Answer
 End
 Else 
  Do
     Say 'Enter the name of the server, default is ' Def_server
     Parse Pull Answer .
     if Answer <> '' then IrcServer=Answer
                     else IrcServer=Def_Server
  End
 end

else do
 pos=SysCurPos(4+Server.0/2,0)
 IrcServer=Server.Answer
end


Say 'The Irc Nickname selected is:    ' IrcNick
Say 'The Irc Username selected is:    ' User
Say 'The Irc Name     selected is:    ' IrcName
Say 'The Irc Server   selected is:    ' IrcServer
Say 'The home directory for irc/2 is: ' Home
Say 'The startup parameters for irc/2 are: ' Def_Parms
Say 'The number of lines in the window is: ' IRC2_COLUMNS ' x '  IRC2_LINES
Say 'The color scheme chosen is: ' Colors.Canswer

irc_location=SysSearchPath('PATH','irc.cmd') 
x=pos('irc.cmd',irc_location)
irc_inifile=substr(irc_location,1,x-1)'irc2.ini'

rc = SysIni(irc_inifile,'irc/2','Ircsetup_version',This_ircsetup_version)
rc = SysIni(irc_inifile,'irc/2','Def_Nick',IrcNick)
rc = SysIni(irc_inifile,'irc/2','Def_Server',IrcServer)
rc = SysIni(irc_inifile,'irc/2','Def_Name',IrcName)
rc = SysIni(irc_inifile,'irc/2','Def_User',User)
rc = SysIni(irc_inifile,'irc/2','Def_Home',Home)
rc = SysIni(irc_inifile,'irc/2','Def_Lib',Home)
rc = SysIni(irc_inifile,'irc/2','Def_Path',Path)
rc = SysIni(irc_inifile,'irc/2','Def_Parms',Def_Parms)
rc = SysIni(irc_inifile,'irc/2','Def_Colour',Scheme.Canswer)
rc = SysIni(irc_inifile,'irc/2','IRC2_LINES',IRC2_LINES)
rc = SysIni(irc_inifile,'irc/2','IRC2_COLUMNS',IRC2_COLUMNS)
rc = SysIni(irc_inifile,'irc/2','IRC2_FSCREEN',IRC2_FSCREEN)

Def_Home=Home
rc=Create_Icon();

'@eautil /s  ircsetup.cmd nul'
'@eautil /s  irc.cmd nul'
exit

Say_Colors: Procedure
 Call SysCls
esc='1B'x

Say ' The color choice is made by entering 7 pairs of colors, one pair for '
Say ' each of the 7 settings in IRC/2. The first number in a pair is the '
Say ' Background color for that setting, the 2nd number is the foreground color'
Say ' The Color Codes  are '
Say ' '

rc=Colour_choices()

Say ' The 7 configurable settings are '
Say ' normal text ,bold text ,inverse text ,underlined text '
Say ' bold underlined text, inverse underlined text , and nickname'
Say ' So if you entered  07,0F,70,74,7C,47,07, it would correspond to '
Say ' normal  text of ' esc'[37;40;0m07 =' esc'[37;40;1mgray  text on black background'
Say ' bold    text of ' esc'[37;40;1m0F =' esc'[37;40;1mwhite text on black background'
Say ' inverse text of ' esc'[30;47;1m70 =' esc'[37;40;1mblack text on gray  background'
Say ' etc. You will now enter your color choices, one by one'

say 

return 1

Colour_choices: Procedure

esc='1B'x

say esc'[37;40;1m'

Say '    Foregound or Background:         Foreground Only Colors'
Say ' '
Say '     ' esc'[37;40;0m0 - ' esc'[30;mblack                          ' esc'[37;40;1m8 - ' esc'[30;mdark grey'
Say '     ' esc'[37;40;0m1 - ' esc'[34;mblue                           ' esc'[37;40;1m9 - ' esc'[34;mlight blue  '
Say '     ' esc'[37;40;0m2 - ' esc'[32;mgreen                          ' esc'[37;40;1mA - ' esc'[32;mlight green' 
Say '     ' esc'[37;40;0m3 - ' esc'[36;mcyan                           ' esc'[37;40;1mB - ' esc'[36;mlight cyan'  
Say '     ' esc'[37;40;0m4 - ' esc'[31;mred                            ' esc'[37;40;1mC - ' esc'[31;mlight red'   
Say '     ' esc'[37;40;0m5 - ' esc'[35;mmagenta                        ' esc'[37;40;1mD - ' esc'[35;mlight purple'
Say '     ' esc'[37;40;0m6 - ' esc'[33;myellow                         ' esc'[37;40;1mE - ' esc'[33;myellow'
Say '     ' esc'[37;40;0m7 - ' esc'[37;mgray                           ' esc'[37;40;1mF - ' esc'[37;mwhite '
Say ' '
Say ' The 1st number is the Background color, the 2nd number is the foreground color'
Say ' '

return 1

Create_Icon: Procedure Expose IRC2_FSCREEN Def_Home

If SysSetObjectData("<WP_Irc2>"," ")=0 Then DO
      Say ' Icon created on the desktop'
      setup='objectid=<WP_Irc2>'
      rc=  SysCreateObject('WPProgram','Irc','<WP_DESKTOP>',Setup)
End

      setup='ICONFILE='directory()'\irc.ico'
      rc=  SysSetObjectData('<WP_Irc2>',Setup)
      setup='EXENAME='Def_Home'\irc.cmd'
      rc=  SysSetObjectData('<WP_Irc2>',Setup)
      setup='startupdir='Def_Home ''
      rc=  SysSetObjectData('<WP_Irc2>',Setup)
      setup='PROGTYPE=FULLSCREEN'
      if IRC2_FSCREEN='y' Then rc = SysSetObjectData('<WP_Irc2>',Setup)

return rc;
