/* IRC 2 startup file. Assumes Rexx is installed.
   Copyright 1994-95 V. Phaniraj -- phaniraj@badlands.nodak.edu

   This is the startup file for Irc2.exe for OS/2. It requires IBM TCP/IP 
   and OS/2 Version 2.0 and above. Various options can be setup using
   ircsetup.cmd ; some can be set by editing this file. The values in this
   file are over-ridden by command line parameters, if specified.

   C:\> IRC Nickname Server Your_name

   All parameters are optional but if omitted must be specified as 
   a dot (.). The Def_* Values above will be taken for missing or 
   specified by a dot (.) parameters. By example, if I want to
   enter irc under nickname "Try", I would type:

   C:\> IRC Try

   If I want the Default nickname but want to connect to an other server 
   I would type:

   C:\> IRC . another.server.edu

   If I want every default but my IRCNAME set to "I am God" I would type:

   C:\> IRC . . I am God  

   Change values below to suit your taste  ; others are set using 
   ircsetup.cmd. These control the colors and size of the window.
*/



/*
If you want to override the choice in ircsetup.cmd, move the
appropriate def_colour line to outside the comments

This is the default white on black color scheme
Def_Colour = '07,0F,70,74,7C,47,07'   

This will do white text on blue background
Def_Colour = '1F,0F,70,74,7C,47,1E'
*/

/*
'@mode co80,43'

 move the line above outside the commensts
 if you want irc to start in 43 lines mode.
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs

/* 
 IRCNICK   is the nickname of the user that will be used in irc
 IRCSERVER is the startup server used for irc. Find the one closest
           to you. Some examples are irc.colorado.edu, csz.bu.edu,
           irc.uiuc.edu and alfred.u.washington.edu. You can put a
           port number and passwd (if needed) on the end of the server
           by using colons as follows:
           server:port:passwd:nick
 IRCNAME   is the irc name of the user that will be shown in irc
           This information will be displayed after the username.
 USER      is the userid of the user that will be shown in irc.
 HOME      specifies the directory where the ircrc file (initialization script)
           is located.
 IRCCOLOUR this specfiies the colours used, as documented in irc2.doc
           For example changingd Def_Colour to '1F,0F,70,74,7C,47,07,07'
           would have white text on a blue background. 
 IRCLIB    this sets the location of the help, script, translation and
           ircserv.txt files.  It's calculated from the run directory of
           IRC/2 if not set.
*/

Parse source with . ThisProg .
ThisPath = left(ThisProg,Lastpos('\',ThisProg)-1)
irc_inifile = ThisPath || '\irc2.ini'

rc = stream(irc_inifile,'c','query exists')
if rc = '' Then Call 'ircsetup' irc_inifile

rc=SysIni(irc_inifile,'irc/2','ALL:','names')
do i = 1 to names.0
   val=SysIni(irc_inifile,'irc/2',names.i)
   interpret names.i '= val'
end

/* pick up values from the environment if they exist */

if Value('IRCNICK',,'OS2ENVIRONMENT') <> '' Then,
   Def_Nick = Value('IRCNICK',,'OS2ENVIRONMENT')

if Value('IRCSERVER',,'OS2ENVIRONMENT') <> '' Then,
   Def_Server = Value('IRCSERVER',,'OS2ENVIRONMENT')

if Value('IRCNAME',,'OS2ENVIRONMENT') <> '' Then,
   Def_Name = Value('IRCNAME',,'OS2ENVIRONMENT')

if Value('IRCLIB',,'OS2ENVIRONMENT') <> '' Then,
   Def_Lib = Value('IRCLIB',,'OS2ENVIRONMENT')

if Value('IRCPATH',,'OS2ENVIRONMENT') <> '' Then,
   Def_Path = Value('IRCPATH',,'OS2ENVIRONMENT')

if Value('IRCCOLOUR',,'OS2ENVIRONMENT') <> '' Then,
   Def_Colour = Value('IRCCOLOUR',,'OS2ENVIRONMENT')

Parse Arg Nick Server Name

if Nick   = '.' | Nick   = ' '  Then nick   = Def_Nick
if Server = '.' | Server = ' '  Then Server = Def_Server
if Name   = '.' | Name   = ' '  Then Name   = Def_Name

/*  Load Values into the environment */

call value 'IRCNICK',Nick,'OS2ENVIRONMENT'
call value 'IRCSERVER',Server,'OS2ENVIRONMENT'
call value 'IRCNAME',Name,'OS2ENVIRONMENT'
call value 'USER',Def_User,'OS2ENVIRONMENT'
call value 'HOME',Def_Home,'OS2ENVIRONMENT'
call value 'IRCLIB',Def_Lib,'OS2ENVIRONMENT'
call value 'IRCPATH',Def_Path,'OS2ENVIRONMENT'
call value 'IRCCOLOUR',Def_Colour,'OS2ENVIRONMENT'

irc_exe_file = ThisPath || '\irc2.exe'

'@'irc_exe_file Def_Parms

 errfilesize = stream("irc2.err",C,'query size')
 if errfilesize <> 0 Then 
 Do
   '@echo. >> tempmail.txt'
    fname=stream("rawlog.txt",'C','Q EXISTS')
    If fname<>'' Then                        
     Do
       rc=stream("rawlog.txt",'c','open read')
       rc=stream("rawlog.txt",'c','seek <4096')
       k=0;
       do forever
          yy=linein("rawlog.txt")
          if yy = '' then
             leave

          k = k + 1
          lines.k = yy
       end 

       i = k - 9
       if i < 0 then
          i = 1

       Do j = i to k
        rc = lineout("tempmail.txt",lines.j)
       End

       rc=stream("tempmail.txt",'c','close');
     End
   '@echo. >> tempmail.txt'
   '@type irc2.err >> tempmail.txt'
   '@sendmail -t irc2bugs@invlogic.com <' tempmail.txt
   '@del tempmail.txt'
 End
Exit 0
