/* IRC 2 startup file. Assumes Rexx is installed.

   This is the startup file for Irc2.exe for OS/2. It requires IBM TCP/IP 
   and OS/2 Version 2.0 and above. The following environment variables can
   be set, USER, HOME,IRCNAME, IRCNICK and IRCSERVER.
   A new option IRCCOLOR has been added. It is documented in irc.doc.

   Set your default values below. The Nick, Server and Name can be
   overriden when invoking this script. There are 3 positional parameters.

   The general Syntax of this command is: 

   C:\> IRC Nickname Server Your_name

   All parameters are optional but if omitted must be specified as 
   a dot (.). The Def_* Values above will be taken for missing or 
   specified by a dot (.) parameters. By example, if I want to
   enter irc under nickname "Try", I would type:

   C:\> IRC Try

   If I want the Default nickname but want to connect to an other server 
   I would type:

   C:\> IRC . an.other.server.com

   If I want every default but my IRCNAME set to "I am God" I would type:

   C:\> IRC . . I am God 
  
*/

/* Change values below to suit your taste */

/*
'mode co80,43'
add the line above if you want irc to start in 43 lines mode.
*/

Def_Nick   = 'OS2User'
Def_Server = 'irc.uiuc.edu'
Def_Name   = 'User of IRC/2'
Def_User   = 'OS2User'
Def_Home   = 'C:\APPS\IRC'
Def_Colour = '07,0F,70,74,7C,47,07'
Def_Parms  = '-c #os/2'

/* 
 IRCNICK   is the nickname of the user that will be used in irc
 IRCSERVER is the startup server used for irc. Find the one closest
           to you. Some examples are irc.colorado.edu, csz.bu.edu,
           irc.uiuc.edu and alfred.u.washington.edu. You can put a
           port number and passwd (if needed) on the end of the server
           by using colons as follows:
           server:port:passwd:nick
 IRCNAME   is the irc name of the user that will be shown in irc
           This information will be displayed after the username.
 USER      is the userid of the user that will be shown in irc.
 HOME      specifies the directory where the ircrc file (initialization script)
           is located.
 IRCCOLOUR this specfiies the colours used, as documented in irc2.doc
           For example changingd Def_Colour to '1F,0F,70,74,7C,47,07,07'
           would have white text on a blue background. 
 IRCLIB    this sets the location of the help, script, translation and
           ircserv.txt files.  It's calculated from the run directory of
           IRC/2 if not set.
*/


if Value('IRCNICK',,'OS2ENVIRONMENT') <> '' Then,
   Def_Nick = Value('IRCNICK',,'OS2ENVIRONMENT')

if Value('IRCSERVER',,'OS2ENVIRONMENT') <> '' Then,
   Def_Server = Value('IRCSERVER',,'OS2ENVIRONMENT')

if Value('IRCNAME',,'OS2ENVIRONMENT') <> '' Then,
   Def_Name = Value('IRCNAME',,'OS2ENVIRONMENT')

if Value('IRCCOLOUR',,'OS2ENVIRONMENT') <> '' Then,
   Def_Colour = Value('IRCCOLOUR',,'OS2ENVIRONMENT')


Parse Arg Nick Server Name

if Nick   = '.' | Nick   = ' '  Then nick   = Def_Nick
if Server = '.' | Server = ' '  Then Server = Def_Server
if Name   = '.' | Name   = ' '  Then Name   = Def_Name


call value 'IRCNICK',Nick,'OS2ENVIRONMENT'
call value 'IRCSERVER',Server,'OS2ENVIRONMENT'
call value 'IRCNAME',Name,'OS2ENVIRONMENT'
call value 'USER',Def_User,'OS2ENVIRONMENT'
call value 'HOME',Def_Home,'OS2ENVIRONMENT'
call value 'IRCCOLOUR',Def_Colour,'OS2ENVIRONMENT'

'@irc2.exe' Def_Parms

/* 
Irc2.exe must be in the path for this to work as shown.
The -c <channel> option picks a startup channel
*/

