/**
***  IPDial     Script program for initializing a SLIP connection
***  Copyright  (C)   1994    Jochen Wiedmann
***
***  This program is free software; you can redistribute it and/or modify
***  it under the terms of the GNU General Public License as published by
***  the Free Software Foundation; either version 2 of the License, or
***  (at your option) any later version.
***
***  This program is distributed in the hope that it will be useful,
***  but WITHOUT ANY WARRANTY; without even the implied warranty of
***  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
***  GNU General Public License for more details.
***
***  You should have received a copy of the GNU General Public License
***  along with this program; if not, write to the Free Software
***  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***
***
***  This is the main include file.
***
***
***  Computer: Amiga 1200                       Compiler: Dice 3.01
***
***  Author:    Jochen Wiedmann
***             Am Eisteich 9
***             72555 Metzingen
***             Germany
***
***             Phone: (+0049) 7123 / 14881
***             Internet: wiedmann@neckar-alb.de
**/
#ifndef IPDIAL_H
#define IPDIAL_H




/**
***  Include files
**/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <exec/types.h>

#if defined(_DCC)  ||  defined(__SASC)  ||  defined(__GNUC__)
#include <proto/exec.h>
#include <proto/dos.h>
#else
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#endif

#if defined(__GNUC__)
#define stricmp strcasecmp
#define strnicmp strncasecmp
#endif




/*** Prototypes
**/

/**
***  IPDial.c
**/
extern ULONG EchoMode;
extern ULONG VerboseMode;


/**
***  DeviceIO.c
**/
extern BYTE DeviceIOWait(APTR);
extern VOID DeviceIOAbort(APTR);
extern VOID DeviceIOSend(APTR, UWORD);
extern BYTE DeviceIODo(APTR, UWORD);

extern ULONG DeviceIOSignal(APTR);
extern struct IORequest *DeviceIOReq(APTR);

extern APTR DeviceIOCreate(ULONG);
extern VOID DeviceIODelete(APTR);
extern BYTE DeviceIOOpen(STRPTR, ULONG, APTR, ULONG);


/**
***  Serial.c
**/
extern VOID SerialCleanup(VOID);
extern ULONG SerialOpen(STRPTR, STRPTR, ULONG);
extern VOID SerialSend(STRPTR, ULONG);
extern LONG SerialWait(STRPTR *, LONG);
extern VOID SerialShowParms(VOID);
extern VOID SerialSetBaud(ULONG);
extern VOID SerialSetDataBits(UBYTE);
extern VOID SerialSetStopBits(UBYTE);
extern VOID SerialSetBufSize(ULONG);
extern ULONG SerialSetParity(STRPTR);
extern ULONG SerialSetProtocol(STRPTR);
extern VOID SerialTerminal(STRPTR, ULONG, ULONG);
extern STRPTR SerialWaitBuffer(VOID);


/**
***  Buffer.c
**/
extern APTR BufferCreate(VOID);
extern VOID BufferClear(APTR);
extern VOID BufferExtend(APTR, const UBYTE*, ULONG);
extern LONG BufferCheck(APTR, STRPTR *);
extern STRPTR BufferBuffer(APTR);


/**
***  StrReadArgs.c
**/
extern ULONG StrReadArgs(STRPTR, LONG *, STRPTR);
extern VOID StrReadArgsFree(VOID);


/**
***  vsscanf.c
**/
extern LONG Vsscanf(STRPTR, STRPTR, ULONG);


/**
***  setvar.c
**/
extern ULONG setvar(STRPTR, STRPTR, ULONG);
/**/

#endif
