/**
***  IPDial	Script program for initializing a SLIP connection
***  Copyright	(C)   1994    Jochen Wiedmann
***
***  This program is free software; you can redistribute it and/or modify
***  it under the terms of the GNU General Public License as published by
***  the Free Software Foundation; either version 2 of the License, or
***  (at your option) any later version.
***
***  This program is distributed in the hope that it will be useful,
***  but WITHOUT ANY WARRANTY; without even the implied warranty of
***  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
***  GNU General Public License for more details.
***
***  You should have received a copy of the GNU General Public License
***  along with this program; if not, write to the Free Software
***  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***
***
***
***  This file implements a version of ReadArgs(), which parses strings
***  instead of the command line. However, its data is static, you must
***  not use it twice at the same time.
***
***
***  Computer: Amiga 1200			Compiler: Dice 3.01
***
***  Author:	Jochen Wiedmann
***		Am Eisteich 9
***		72555 Metzingen
***		Germany
***
***		Phone: (+0049) 7123 / 14881
***		Internet: wiedmann@uni-tuebingen.de
**/





/**
***  Include files
**/
#ifndef IPDIAL_H
#include "IPDial.h"
#endif
#include <dos/rdargs.h>




/**
***  Local variables
**/
STATIC struct RDArgs *StrRDArgs     = NULL;





VOID StrReadArgsFree(VOID)

{ if (StrRDArgs)
  { FreeArgs(StrRDArgs);
    StrRDArgs = NULL;
  }
}





ULONG StrReadArgs(STRPTR str, LONG *args, STRPTR template)

{ STATIC struct RDArgs rdargs;

  StrReadArgsFree();

  rdargs.RDA_Source.CS_Buffer = str;
  rdargs.RDA_Source.CS_Length = strlen((char *) str);
  rdargs.RDA_Source.CS_CurChr = 0;
  rdargs.RDA_DAList = 0;
  rdargs.RDA_Buffer = NULL;
  rdargs.RDA_BufSiz = 0;
  rdargs.RDA_ExtHelp = NULL;
  rdargs.RDA_Flags = RDAF_NOPROMPT;

  StrRDArgs = ReadArgs(template, args, &rdargs);
  return((ULONG) (StrRDArgs ? TRUE : FALSE));
}
