/**
***  IPDial	Script program for initializing a SLIP connection
***  Copyright	(C)   1994    Jochen Wiedmann
***
***  This program is free software; you can redistribute it and/or modify
***  it under the terms of the GNU General Public License as published by
***  the Free Software Foundation; either version 2 of the License, or
***  (at your option) any later version.
***
***  This program is distributed in the hope that it will be useful,
***  but WITHOUT ANY WARRANTY; without even the implied warranty of
***  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
***  GNU General Public License for more details.
***
***  You should have received a copy of the GNU General Public License
***  along with this program; if not, write to the Free Software
***  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***
***
***
***  This file implements dynamically growing buffers.
***
***
***  Computer: Amiga 1200			Compiler: Dice 3.01
***
***  Author:	Jochen Wiedmann
***		Am Eisteich 9
***		72555 Metzingen
***		Germany
***
***		Phone: (+0049) 7123 / 14881
***		Internet: wiedmann@uni-tuebingen.de
**/





/**
***  Include files
**/
#ifndef IPDIAL_H
#include "IPDial.h"
#endif
#include <ctype.h>


#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif





/**
***  Type definitions
**/
typedef struct
{ STRPTR buf;
  ULONG size;
  ULONG filled;
} Buffer;





/*** BufferCreate() function
***
***  Creates a new buffer.
**/
APTR BufferCreate(VOID)

{ Buffer *buf;

  if ((buf = malloc(sizeof(*buf))))
  { if ((buf->buf = malloc(2048)))
    { buf->size = 2048;
      BufferClear(buf);
    }
    else
    { free(buf);
      buf = NULL;
    }
  }
  return(buf);
}





/*** BufferClear() function
***
***  This function clears a buffer.
**/
VOID BufferClear(APTR buf)

{ ((Buffer *) buf)->filled = 0;
  ((Buffer *) buf)->buf[0] = '\0';
}





/**
***  This function adds the given number of bytes to a buffer.
**/
VOID BufferExtend(APTR buffer, STRPTR addbuffer, ULONG addsize)

{ Buffer *buf = buffer;
  ULONG newfilled = buf->filled + addsize;
  extern ULONG EchoMode;

  /**
  ***  Allocate a new buffer, if needed.
  **/
  if (newfilled+1 > buf->size)
  { buf->size = MAX(newfilled+1, buf->size)*2;

    if (!(buf->buf = realloc(buf->buf, buf->size)))
    { perror("malloc");
      exit(10);
    }
  }

  /**
  ***  We are now guaranteed, that the buffer is big enough.
  ***  Copy data and ensure, that we get a valid C string.
  **/
  memcpy(buf->buf + buf->filled, addbuffer, addsize);
  buf->filled += addsize;
  buf->buf[buf->filled] = '\0';
}





/*** BufferCheck() function
***
***  Checks, if a buffer contains one of the given strings.
***  If this is the case, the strings number (beginning with
***  0) will be returned, -1 otherwise.
**/
LONG BufferCheck(APTR buffer, STRPTR *args)

{ Buffer *buf = buffer;
  LONG i;

  if (buf->filled)
  { for (i = 0;  *args;  ++i, ++args)
    { if (strstr((char *) buf->buf, (char *)  *args))
      { return(i);
      }
    }
  }
  return(-1);
}





/*** BufferBuffer() function
***
***  Returns the string associated to a buffer.
**/
STRPTR BufferBuffer(APTR buf)

{ return(((Buffer *) buf)->buf);
}


/*** BufferExpand() function
***
***  Replaces patterns like $Var or ${Var} with the value
***  of the environment variable Var.
***
***  Uses an internal buffer; this is static and must not
***  be used after the next call to BufferExpand.
**/
STRPTR BufferExpand(STRPTR str, ULONG len)

{ STATIC Buffer *expandBuf = NULL;

  /**
  ***  Be sure, that the buffer is valid.
  **/
  if (!expandBuf  &&  !(expandBuf = BufferCreate()))
  { perror("malloc");
    exit(10);
  }
  BufferClear(expandBuf);

  /**
  ***  Parse the string.
  **/
  while(len)
  { STRPTR ptr = str;

    while (len  &&  *ptr != '$')
    { --len;
      ++ptr;
    }
    BufferExtend(expandBuf, str, ptr-str);
    str = ptr;

    if (len)    /*  Found '$'   */
    { --len;	/*  Skip it	*/
      ++str;

      if (len)
      { if (*str == '$')    /*  Replace "$$" with "$"   */
	{ BufferExtend(expandBuf, "$", 1);
	  --len;
	  ++str;
	}
	else
	{ int varNameLen;
	  char *varName;
	  char *varVal;

	  if (*str == '{')  /*  Replace "${Var}" with value of  */
	  { --len;	    /*	of environment variable Var.	*/
	    ++str;
	    varName = str;
	    while (len  &&  *str != '}')
	    { --len;
	      ++str;
	    }
	    varNameLen = (char *) str - varName;
	    if (len)    /*  Skip '}'    */
	    { --len;
	      ++str;
	    }
	  }
	  else		    /*	Replace "$Var" with value of    */
	  { varName = str;  /*	environment variable Var.	*/
	    while (len  &&  isalpha(*str))
	    { --len;
	      ++str;
	    }
	    varNameLen = (char *) str - varName;
	  }

	  if (!(ptr = malloc(varNameLen+1)))
	  { perror("malloc");
	    exit(10);
	  }
	  strncpy(ptr, varName, varNameLen);
	  ptr[varNameLen] = '\0';
	  if ((varVal = getenv(ptr)))
	  { BufferExtend(expandBuf, varVal, strlen(varVal));
	  }
	  free(ptr);
	}
      }
    }
  }

  return(BufferBuffer(expandBuf));
}
