/*--------------------------------------------------------------------------*/
/* [SL/IP & PPP] Redial and Connection Script (with multinumber cycle)      */
/*               For: Internex Online (io.org) - SLIP, CSLIP and PPP        */
/*                By: Rob Hunter <mslasher@io.org>                          */
/*                                                                          */
/*             Notes: If using PPP you must make changes to the end of this */
/*                    file.                                                 */
/*--------------------------------------------------------------------------*/
parse arg interface , comport , username password
/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code		    */
/*     Determine static values and prompt for any missing information.      */
/*    (read them from command line or simply supply them in the script)     */
/*--------------------------------------------------------------------------*/
                                       /*                                   */
username  = "Susername"                /* Login name (P=PPP/C=CSLIP/S=SLIP) */
password  = "password"                 /*       Your private login password */
                                       /*                                   */
modeminit = "ATZ"                      /* Modem's init string, usually ATZ. */
                                       /* Example in: /tcpip/etc/modems.lst */
                                       /*                                   */
connectbeep = 1                        /* Beep when connected?   0=NO/1=YES */
pausetime   = 2                        /* Time (in secs) between each dial. */
waittime    = 45                       /* Time (in sec) to wait for CONNECT */
                                       /*                                   */
dialcmd.1 = "ATDT416-363-4151"         /* Dial Prefix and Telephone Number1 */
dialcmd.2 = "ATDT416-363-4621"         /* Dial Prefix and Telephone Number2 */
                                       /* Sequentially name all wanted nums */
                                       /* ie: dialcmd.3, dialcmd.4, etc ... */
                                       /*                                   */
dynamic   = 1                          /* 0 = Static IP#  / 1 = Dynamic IP# */
                                       /* (NOTE: You can use 1 even if you  */
                                       /*        have a static IP address)  */
                                       /*                                   */
                                       /* Static IP#: SLIP and CSLIP Only!: */
                                       /* (Ignored with Dynamic IP or PPP.) */
                                       /* --------------------------------- */
local_address  = 199.166.190.114       /*   Your static internet IP address */
remote_address = 198.133.36.254        /*     Remote static gateway address */
netmask        = 255.255.255.0         /*                      Network mask */
                                       /*                                   */
                                       /* --------------------------------- */
                                       /* If you are using PPP,  go to  the */
                                       /* end of this file to make changes! */
/*--------------------------------------------------------------------------*/
slip=1 ; if (left(username,1)="P") then slip=0
pausetime=max(1,pausetime)
/*--------------------------------------------------------------------------*/

call lineout , 'info   : Interface:' interface

cr='0d'x
crlf='0d0a'x

call lineout , ''
call lineout , '[SL/IP & PPP] Server Connection Script (io.org)'

if dialcmd.1 = '' then do
   call charout , 'Dial Command: '
   parse pull dialcmd.1
end

if username = '' | username = '*' then do
   call charout , 'User Name: '
   parse pull username
end
else do
   call lineout , 'User:' username
end

if password = '' | password = '*' then do
   call charout , 'Password: '
   password = readpass()
end

dialcount  =0
dialattempt=0

/*--------------------------------------------------------------------------*/
/* Modem initialization on first and cycle dial attempts.                   */
/*--------------------------------------------------------------------------*/

redialit:
call flush_receive
call charout , 'Resetting modem...'
call flush_receive
call send modeminit || cr
call waitfor 'OK', 10 ; call flush_receive

 if RC = 1 then do
    call lineout , 'Modem not resetting... Trying again.'
    call send '+++'           ; call waitfor crlf, 5 ; call flush_receive
    call send modeminit || cr ; call waitfor 'OK', 5 ; call flush_receive
    call send modeminit || cr ; call waitfor 'OK', 5 ; call flush_receive
  end

/*--------------------------------------------------------------------------*/
/* Cycle dialer, dial and wait for modem response.                          */
/*--------------------------------------------------------------------------*/

dialattempt=dialattempt+1
dialcount  =dialcount+1

if (dialcmd.dialcount = 'DIALCMD.'dialcount) then dialcount=1

call lineout , ''
call lineout , '('dialattempt') Dial ['dialcount']:' dialcmd.dialcount
call send dialcmd.dialcount || cr
call waitfor 'CONNECT',waittime,'BUSY','NO CARRIER','VOICE'

if RC > 0 then do
     if curpos > 1 then call lineout , ''
     call lineout , 'Connect failed, trying again in' pausetime 'seconds ...'
     call syssleep pausetime
     signal redialit
end

call waitfor crlf , 5

/*--------------------------------------------------------------------------*/
/* Response login.  Wait for strings, flush unwanted and send information.  */
/*--------------------------------------------------------------------------*/

call waitfor 'ogin:', 20, 'NO CARRIER'
     if rc > 0 then signal redialit
call flush_receive ; call send username || cr
call waitfor 'assword:' ; call flush_receive ; call send password || cr

if slip then call waitfor 'SL/IP session', 45, 'NO CARRIER', 'Invalid Login'
        else call waitfor 'PPP session',   45, 'NO CARRIER', 'Invalid Login'

        if rc > 0 then do
           call flush_receive
           call lineout , ''
           call lineout , 'Bad Connection ...'
           signal redialit
        end

if slip then do

   if dynamic then do
      parse var remain_buffer . ' from (' a '.' b '.' c '.' d ')' .
      parse var remain_buffer .    ' to ' e '.' f '.' g '.' h ' b' .
      remote_address = a||'.'||b||'.'||c||'.'||d
      local_address  = e||'.'||f||'.'||g||'.'||h
   end

call flush_receive
call lineout , ' established (' time() ')'
call lineout , 'Configuring local address =' local_address
call lineout , 'Configuring remote address =' remote_address

'ifconfig sl0' local_address remote_address 'netmask ' netmask
'route add default' remote_address '1'

end
else do

call flush_receive
call lineout , ' established (' time() ')'

end

if connectbeep then do
   call beep 200, 250 ; call beep 300, 250 ; call beep 400, 250
end

exit 0

/*--------------------------------------------------------------------------*/
/* Script exit - Procedures to follow.                                      */
/*--------------------------------------------------------------------------*/

/*==========================================================================*/

/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*--------------------------------------------------------------------------*/
/* Routine to send a character string off to the modem.                     */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call procedure.2 interface , sendstring
   return

/*--------------------------------------------------------------------------*/
/* waitfor ( string.0, [timeout, string.1, string.2, string.3, string.4] )  */
/*--------------------------------------------------------------------------*/
/* Waits for the supplied string(s) to show up in the COM input.  All input */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.		    */
/*									    */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).					    */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg string.0 , timeout , string.1 , string.2 , string.3 , string.4

   if timeout = '' then timeout = 5000
   waitfor_buffer = '' ; done = -1 ; curpos = 1
   call time 'E'

   if (remain_buffer = 'REMAIN_BUFFER') then remain_buffer = ''

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
      end
      else do
         call procedure.3 interface,10
         line=result.3
      end

      waitfor_buffer = waitfor_buffer || line

      do i = 0 to 4
         index.i = pos(string.i,waitfor_buffer)
         if (index.i > 0) then do
             remain_buffer  = substr(waitfor_buffer,index.i+length(string.i))
             waitfor_buffer = delstr(waitfor_buffer,index.i+length(string.i))
             done=i
         end
      end

      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (time('E')>timeout)) then do
        call send modeminit || cr
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC

/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*--------------------------------------------------------------------------*/
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    call procedure.1
    key = result.1
    if key \= cr then answer = answer || key
  end
  say ''
  return answer

/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*--------------------------------------------------------------------------*/
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 250ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   do until line = ''
      call procedure.3 interface , 250
      line=result.3
     if echo \= '' then call charout , line
   end

return
/*--------------------------------------------------------------------------*/
procedure.1:                                               /* If using PPP: */
result.1=slip_getch()                                      /* ------------- */
                                                           /*               */
/******* ^^^^^^^^^^^^ *************************************** MAKE A CHANGE */
/******* slip_getch() for SLIP ******************************     HERE!     */
/******* ppp_getch() for PPP ******************************** ------------- */
                                                           /*               */
return result.1                                            /*               */
procedure.2:                                               /*               */
parse arg x , y                                            /*               */
call slip_com_output x , y                                 /*               */
                                                           /*               */
/*** ^^^^^^^^^^^^^^^ **************************************** MAKE A CHANGE */
/*** slip_com_output for SLIP *******************************     HERE!     */
/*** ppp_com_output for PPP ********************************* ------------- */
                                                           /*               */
return                                                     /*               */
procedure.3:                                               /*               */
parse arg a,b                                              /*               */
result.3=slip_com_input(a,,b)                              /*               */
                                                           /*               */
/******* ^^^^^^^^^^^^^^ ************************************* MAKE A CHANGE */
/******** slip_com_input for SLIP ***************************     HERE      */
/******** ppp_com_input for PPP ***************************** ------------- */
                                                           /*               */
return result.3                                            /*               */
                                                           /*               */
/*-------------------------------------------------------------------<EOF>--*/
