/*
 * File......: CINT86.H
 * Author....: Ted Means
 * Date......: $Date:   15 Aug 1991 23:09:00  $
 * Revision..: $Revision:   1.1  $
 * Log file..: $Logfile:   E:/nanfor/src/cint86.h_v  $
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/cint86.h_v  $
 * 
 *    Rev 1.1   15 Aug 1991 23:09:00   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.0   27 May 1991 13:22:46   GLENN
 * Initial revision.
 *
 */



//  This is the header file for CINT86X.C

typedef unsigned int UINT;
typedef unsigned char BYTE;

typedef union
{
   void far * Address;
   struct
   {
      UINT Offset;
      UINT Segment;
   } Pointer;
} FARPTR;

typedef struct
{
    UINT BX;
    UINT CX;
    UINT DX;
    UINT AX;
} WORDREGS;

typedef struct
{
    BYTE BL, BH;
    BYTE CL, CH;
    BYTE DL, DH;
    BYTE AL, AH;
} BYTEREGS;

typedef union
{
    WORDREGS w;
    BYTEREGS b;
} REGS;

typedef union
{
   UINT registers[ 10 ];
   struct
   {
      UINT DS;
      UINT ES;
      UINT DI;
      UINT SI;
      UINT BP;
      UINT SP;
      REGS regs;
   } CPURegs;
} REGISTERS;

void _bcopy( void far * pDest, void far * pSrc, UINT nBytes );

UINT ExoRMInterrupt( UINT nInt, REGISTERS far * inregs, REGISTERS far * outregs );

FARPTR _xalloclow( UINT nSize );

void _xfreelow( FARPTR * pPma );

FARPTR ExoRealPtr( FARPTR pPma );

