/*  INI File Test Program

    This program test the "ini" file library.
    Author:     Sam Saprunoff
    Date:       01/23/95

    The user is free to use the libraries and this demo as he/she sees fit.

*/

#include<stdio.h>

#include"ini.h"                         // Include return values


main()
{

 // The ini lib will return a character string from the ini file.  So ensure
 //  the the passed string is large enough to accomodate your parameter.

 char ret_string[100];
 int add = 0;


 printf("\n\nINI File Parse Test");
 printf("\nFilename: Test.ini");

 // The format to call the function is:
 //     read_ini( "filename", "square bracket name", "value name", char buffer);
 //     i.e. file will have:
 //          [header]
 //          value=12
 //


 // The first sample is to use a switch statement //
 // Here the returned data is in the character buffer //

 printf("\n\nTest1: Find [header] a =");

 switch( read_ini("test.ini", "header1","a", ret_string ) )
   {
      case INI_FOUND:
	printf("\nFound Data: %s", ret_string);
	break;

      case INI_NOT_FOUND:
	printf("\nData NOT Found");
	break;

      case INI_FILE_ERROR:
	printf("\nINI File Error");
	break;
   }

 // The second sample is done via an if statement.  Here we actually want the
 //  returned data to be a numeric value.  To do this use sscanf and read
 //  the data from the character buffer into a numeric variable


 printf("\n\n\nTest2: Find [header2] address=");

 if ( read_ini("test.ini", "header2","address", ret_string ) == INI_FOUND )
   {
    sscanf( ret_string, "%x", &add);
    printf("\nAddress = %x", add);
   }
 else
   printf("\naddress not found");


 // The third sample demonstrates that if the first column contains a ";" then
 // the line is ignored

 printf("\n\n\nTest3: Find [header3] d =");

 if ( read_ini("test.ini", "header3","d", ret_string ) == INI_FOUND )
   {
    sscanf( ret_string, "%u", &add);
    printf("\nd = %u", add);
   }
 else
   printf("\nd not found");


 // The fourth sample demonstrates that if the "value name" is under a
 //  different "bracketed name" the system will not find it

 printf("\n\n\nTest4: Find [header2] c =");

 if ( read_ini("test.ini", "header2","c", ret_string ) == INI_FOUND )
   {
    printf("\nc = %s", ret_string);
   }
 else
   printf("\nc not found");



 // The fifth sample demonstrates the updating of data

 printf("\n\n\nTest5: Update [header1] a = 9");

 if ( write_ini("test.ini", "header1","a", "9" ) == INI_UPDATE_SUCCESS )
   {
    printf("\nUpdate Successful");
   }
 else
   printf("\nUpdate Not Successful");






 printf("\n\n");

} // End of Main
